/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import { EuiTabbedContent } from '../../../tabs';
import { EuiText } from '../../../text';
import { EuiButton } from '../../../button';
import { EuiAbsoluteTab } from './absolute_tab';
import { EuiRelativeTab } from './relative_tab';
import { getDateMode, DATE_MODES, toAbsoluteString, toRelativeString } from '../date_modes';
export var EuiDatePopoverContent = function EuiDatePopoverContent(_ref) {
  var value = _ref.value,
      _ref$roundUp = _ref.roundUp,
      roundUp = _ref$roundUp === void 0 ? false : _ref$roundUp,
      onChange = _ref.onChange,
      dateFormat = _ref.dateFormat,
      timeFormat = _ref.timeFormat,
      locale = _ref.locale,
      position = _ref.position,
      utcOffset = _ref.utcOffset;

  var onTabClick = function onTabClick(selectedTab) {
    switch (selectedTab.id) {
      case DATE_MODES.ABSOLUTE:
        onChange(toAbsoluteString(value, roundUp));
        break;

      case DATE_MODES.RELATIVE:
        onChange(toRelativeString(value));
        break;
    }
  };

  var ariaLabel = "".concat(position === 'start' ? 'Start' : 'End', " date:");
  var renderTabs = [{
    id: DATE_MODES.ABSOLUTE,
    name: 'Absolute',
    content: /*#__PURE__*/React.createElement(EuiAbsoluteTab, {
      dateFormat: dateFormat,
      timeFormat: timeFormat,
      locale: locale,
      value: value,
      onChange: onChange,
      roundUp: roundUp,
      position: position,
      utcOffset: utcOffset
    }),
    'data-test-subj': 'superDatePickerAbsoluteTab',
    'aria-label': "".concat(ariaLabel, " Absolute")
  }, {
    id: DATE_MODES.RELATIVE,
    name: 'Relative',
    content: /*#__PURE__*/React.createElement(EuiRelativeTab, {
      dateFormat: dateFormat,
      locale: locale,
      value: toAbsoluteString(value, roundUp),
      onChange: onChange,
      roundUp: roundUp,
      position: position
    }),
    'data-test-subj': 'superDatePickerRelativeTab',
    'aria-label': "".concat(ariaLabel, " Relative")
  }, {
    id: DATE_MODES.NOW,
    name: 'Now',
    content: /*#__PURE__*/React.createElement(EuiText, {
      size: "s",
      color: "subdued",
      className: "euiDatePopoverContent__padded--large"
    }, /*#__PURE__*/React.createElement("p", null, "Setting the time to \"now\" means that on every refresh this time will be set to the time of the refresh."), /*#__PURE__*/React.createElement(EuiButton, {
      "data-test-subj": "superDatePickerNowButton",
      onClick: function onClick() {
        onChange('now');
      },
      fullWidth: true,
      size: "s",
      fill: true
    }, "Set ", position, " date and time to now")),
    'data-test-subj': 'superDatePickerNowTab',
    'aria-label': "".concat(ariaLabel, " Now")
  }];
  var initialSelectedTab = renderTabs.find(function (tab) {
    return tab.id === getDateMode(value);
  });
  return /*#__PURE__*/React.createElement(EuiTabbedContent, {
    className: "euiDatePopoverContent",
    tabs: renderTabs,
    autoFocus: "selected",
    initialSelectedTab: initialSelectedTab,
    onTabClick: onTabClick,
    size: "s",
    expand: true
  });
};
EuiDatePopoverContent.propTypes = {
  value: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired,
  roundUp: PropTypes.bool,
  dateFormat: PropTypes.string.isRequired,
  timeFormat: PropTypes.string.isRequired,
  locale: PropTypes.any,
  position: PropTypes.oneOf(["start", "end"]).isRequired,
  utcOffset: PropTypes.number
};
EuiDatePopoverContent.displayName = 'EuiDatePopoverContent';