"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateReportState = void 0;

var _uiToBackend = require("../utils/converters/uiToBackend");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// The only thing can be updated of a report instance is its "state"
const updateReportState = async (reportId, opensearchReportsClient, state) => {
  //Build request body
  const reqBody = {
    reportInstanceId: reportId,
    status: (0, _uiToBackend.getBackendReportState)(state)
  };
  const opensearchResp = await opensearchReportsClient.callAsInternalUser( // @ts-ignore
  'opensearch_reports.updateReportInstanceStatus', {
    reportInstanceId: reportId,
    body: reqBody
  });
  return opensearchResp;
};

exports.updateReportState = updateReportState;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInVwZGF0ZVJlcG9ydFN0YXRlLnRzIl0sIm5hbWVzIjpbInVwZGF0ZVJlcG9ydFN0YXRlIiwicmVwb3J0SWQiLCJvcGVuc2VhcmNoUmVwb3J0c0NsaWVudCIsInN0YXRlIiwicmVxQm9keSIsInJlcG9ydEluc3RhbmNlSWQiLCJzdGF0dXMiLCJvcGVuc2VhcmNoUmVzcCIsImNhbGxBc0ludGVybmFsVXNlciIsImJvZHkiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFVQTs7QUFWQTtBQUNBO0FBQ0E7QUFDQTtBQVNBO0FBQ08sTUFBTUEsaUJBQWlCLEdBQUcsT0FDL0JDLFFBRCtCLEVBRS9CQyx1QkFGK0IsRUFHL0JDLEtBSCtCLEtBSTVCO0FBQ0g7QUFDQSxRQUFNQyxPQUFPLEdBQUc7QUFDZEMsSUFBQUEsZ0JBQWdCLEVBQUVKLFFBREo7QUFFZEssSUFBQUEsTUFBTSxFQUFFLHdDQUFzQkgsS0FBdEI7QUFGTSxHQUFoQjtBQUtBLFFBQU1JLGNBQWMsR0FBRyxNQUFNTCx1QkFBdUIsQ0FBQ00sa0JBQXhCLEVBQzNCO0FBQ0EsaURBRjJCLEVBRzNCO0FBQ0VILElBQUFBLGdCQUFnQixFQUFFSixRQURwQjtBQUVFUSxJQUFBQSxJQUFJLEVBQUVMO0FBRlIsR0FIMkIsQ0FBN0I7QUFTQSxTQUFPRyxjQUFQO0FBQ0QsQ0FyQk0iLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7XG4gIElMZWdhY3lDbHVzdGVyQ2xpZW50LFxuICBJTGVnYWN5U2NvcGVkQ2x1c3RlckNsaWVudCxcbn0gZnJvbSAnLi4vLi4vLi4vLi4vLi4vc3JjL2NvcmUvc2VydmVyJztcbmltcG9ydCB7IFJFUE9SVF9TVEFURSB9IGZyb20gJy4uL3V0aWxzL2NvbnN0YW50cyc7XG5pbXBvcnQgeyBnZXRCYWNrZW5kUmVwb3J0U3RhdGUgfSBmcm9tICcuLi91dGlscy9jb252ZXJ0ZXJzL3VpVG9CYWNrZW5kJztcblxuLy8gVGhlIG9ubHkgdGhpbmcgY2FuIGJlIHVwZGF0ZWQgb2YgYSByZXBvcnQgaW5zdGFuY2UgaXMgaXRzIFwic3RhdGVcIlxuZXhwb3J0IGNvbnN0IHVwZGF0ZVJlcG9ydFN0YXRlID0gYXN5bmMgKFxuICByZXBvcnRJZDogc3RyaW5nLFxuICBvcGVuc2VhcmNoUmVwb3J0c0NsaWVudDogSUxlZ2FjeUNsdXN0ZXJDbGllbnQgfCBJTGVnYWN5U2NvcGVkQ2x1c3RlckNsaWVudCxcbiAgc3RhdGU6IFJFUE9SVF9TVEFURVxuKSA9PiB7XG4gIC8vQnVpbGQgcmVxdWVzdCBib2R5XG4gIGNvbnN0IHJlcUJvZHkgPSB7XG4gICAgcmVwb3J0SW5zdGFuY2VJZDogcmVwb3J0SWQsXG4gICAgc3RhdHVzOiBnZXRCYWNrZW5kUmVwb3J0U3RhdGUoc3RhdGUpLFxuICB9O1xuXG4gIGNvbnN0IG9wZW5zZWFyY2hSZXNwID0gYXdhaXQgb3BlbnNlYXJjaFJlcG9ydHNDbGllbnQuY2FsbEFzSW50ZXJuYWxVc2VyKFxuICAgIC8vIEB0cy1pZ25vcmVcbiAgICAnb3BlbnNlYXJjaF9yZXBvcnRzLnVwZGF0ZVJlcG9ydEluc3RhbmNlU3RhdHVzJyxcbiAgICB7XG4gICAgICByZXBvcnRJbnN0YW5jZUlkOiByZXBvcnRJZCxcbiAgICAgIGJvZHk6IHJlcUJvZHksXG4gICAgfVxuICApO1xuXG4gIHJldHVybiBvcGVuc2VhcmNoUmVzcDtcbn07XG4iXX0=