# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.cluster.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class ApiCertificate(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.cluster.api_certificate'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ApiCertificateStub)
        self._VAPI_OPERATION_IDS = {}


    def clearclustercertificate(self,
                                certificate_id,
                                ):
        """
        Clears the certificate used for the MP cluster. This does not affect
        the certificate itself. This API is deprecated. Instead use the
        /api/v1/cluster/api-certificate?action=set_cluster_certificate API to
        set the cluster certificate to a different one. It just means that from
        now on, individual certificates will be used on each MP node. This
        affects all nodes in the cluster.

        .. deprecated:: unknown

        :type  certificate_id: :class:`str`
        :param certificate_id: Certificate ID (required)
        :rtype: :class:`com.vmware.nsx.model_client.ClusterCertificateId`
        :return: com.vmware.nsx.model.ClusterCertificateId
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx.cluster.ApiCertificate.clearclustercertificate is deprecated.', DeprecationWarning)
        return self._invoke('clearclustercertificate',
                            {
                            'certificate_id': certificate_id,
                            })

    def get(self):
        """
        Returns the ID of the certificate that is used as the cluster
        certificate for MP


        :rtype: :class:`com.vmware.nsx.model_client.ClusterCertificateId`
        :return: com.vmware.nsx.model.ClusterCertificateId
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get', None)

    def setclustercertificate(self,
                              certificate_id,
                              ):
        """
        

        .. deprecated:: unknown

        :type  certificate_id: :class:`str`
        :param certificate_id: Certificate ID (required)
        :rtype: :class:`com.vmware.nsx.model_client.ClusterCertificateId`
        :return: com.vmware.nsx.model.ClusterCertificateId
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx.cluster.ApiCertificate.setclustercertificate is deprecated.', DeprecationWarning)
        return self._invoke('setclustercertificate',
                            {
                            'certificate_id': certificate_id,
                            })
class ApiService(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.cluster.api_service'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ApiServiceStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self):
        """
        Read the configuration of the NSX API service.


        :rtype: :class:`com.vmware.nsx.model_client.ApiServiceConfig`
        :return: com.vmware.nsx.model.ApiServiceConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get', None)

    def update(self,
               api_service_config,
               ):
        """
        Read the configuration of the NSX API service. Changes are applied to
        all nodes in the cluster. The API service on each node will restart
        after it is updated using this API. There may be a delay of up to a
        minute or so between the time this API call completes and when the new
        configuration goes into effect.

        :type  api_service_config: :class:`com.vmware.nsx.model_client.ApiServiceConfig`
        :param api_service_config: (required)
        :rtype: :class:`com.vmware.nsx.model_client.ApiServiceConfig`
        :return: com.vmware.nsx.model.ApiServiceConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('update',
                            {
                            'api_service_config': api_service_config,
                            })
class ApiVirtualIp(VapiInterface):
    """
    
    """
    SETVIRTUALIP_FORCE_TRUE = "true"
    """
    Possible value for ``force`` of method :func:`ApiVirtualIp.setvirtualip`.

    """
    SETVIRTUALIP_FORCE_FALSE = "false"
    """
    Possible value for ``force`` of method :func:`ApiVirtualIp.setvirtualip`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.cluster.api_virtual_ip'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ApiVirtualIpStub)
        self._VAPI_OPERATION_IDS = {}


    def clearvirtualip(self):
        """
        


        :rtype: :class:`com.vmware.nsx.model_client.ClusterVirtualIpProperties`
        :return: com.vmware.nsx.model.ClusterVirtualIpProperties
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('clearvirtualip', None)

    def clearvirtualip6(self):
        """
        


        :rtype: :class:`com.vmware.nsx.model_client.ClusterVirtualIpProperties`
        :return: com.vmware.nsx.model.ClusterVirtualIpProperties
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('clearvirtualip6', None)

    def get(self):
        """
        Returns the configured cluster virtual IPv4 and IPv6 address or null if
        not configured.


        :rtype: :class:`com.vmware.nsx.model_client.ClusterVirtualIpProperties`
        :return: com.vmware.nsx.model.ClusterVirtualIpProperties
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get', None)

    def setvirtualip(self,
                     force=None,
                     ip6_address=None,
                     ip_address=None,
                     ):
        """
        

        :type  force: :class:`str` or ``None``
        :param force: On enable it ignores duplicate address detection and DNS lookup
            validation check (optional, default to false)
        :type  ip6_address: :class:`str` or ``None``
        :param ip6_address: Virtual IPv6 address, :: if not configured (optional)
        :type  ip_address: :class:`str` or ``None``
        :param ip_address: Virtual IP address, 0.0.0.0 if not configured (optional)
        :rtype: :class:`com.vmware.nsx.model_client.ClusterVirtualIpProperties`
        :return: com.vmware.nsx.model.ClusterVirtualIpProperties
        :raise: :class:`com.vmware.vapi.std.errors_client.ConcurrentChange` 
             Conflict
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('setvirtualip',
                            {
                            'force': force,
                            'ip6_address': ip6_address,
                            'ip_address': ip_address,
                            })
class Backups(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.cluster.backups'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _BackupsStub)
        self._VAPI_OPERATION_IDS = {}


    def retrievesshfingerprint(self,
                               remote_server_fingerprint_request,
                               ):
        """
        Get SHA256 fingerprint of ECDSA key of remote server. The caller should
        independently verify that the key is trusted.

        :type  remote_server_fingerprint_request: :class:`com.vmware.nsx.model_client.RemoteServerFingerprintRequest`
        :param remote_server_fingerprint_request: (required)
        :rtype: :class:`com.vmware.nsx.model_client.RemoteServerFingerprint`
        :return: com.vmware.nsx.model.RemoteServerFingerprint
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('retrievesshfingerprint',
                            {
                            'remote_server_fingerprint_request': remote_server_fingerprint_request,
                            })
class Node(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.cluster.node'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _NodeStub)
        self._VAPI_OPERATION_IDS = {}


    def reposync(self):
        """
        Attempts to synchronize the repository partition on nsx manager.
        Repository partition contains packages required for the install and
        upgrade of nsx components.Normally there is no need to call this API
        explicitely by the user.


        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('reposync', None)
class Nodes(VapiInterface):
    """
    
    """
    CREATE_ACTION_NODE = "add_cluster_node"
    """
    Possible value for ``action`` of method :func:`Nodes.create`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.cluster.nodes'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _NodesStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               add_cluster_node_spec,
               action,
               ):
        """
        Add a new controller to the NSX cluster. The controller comes with the
        new node. 
        Deprecated. Use POST /cluster?action=join_cluster to join a node to
        cluster.

        .. deprecated:: unknown

        :type  add_cluster_node_spec: :class:`com.vmware.nsx.model_client.AddClusterNodeSpec`
        :param add_cluster_node_spec: (required)
        :type  action: :class:`str`
        :param action: (required)
        :rtype: :class:`com.vmware.nsx.model_client.ClusterNodeConfig`
        :return: com.vmware.nsx.model.ClusterNodeConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx.cluster.Nodes.create is deprecated.', DeprecationWarning)
        return self._invoke('create',
                            {
                            'add_cluster_node_spec': add_cluster_node_spec,
                            'action': action,
                            })

    def delete(self,
               node_id,
               ):
        """
        Removes the specified controller from the NSX cluster. Before you can
        remove a controller from the cluster, you must shut down the controller
        service with the \"stop service controller\" command. 
        Use POST /cluster/<node-id>?action=remove_node to detach a node from
        cluster. The controller is removed with the node.

        .. deprecated:: unknown

        :type  node_id: :class:`str`
        :param node_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx.cluster.Nodes.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'node_id': node_id,
                            })

    def get(self,
            node_id,
            ):
        """
        Returns information about the specified NSX cluster node. 
        Deprecated. Use GET /cluster/<node-id> to get cluster node
        configuration.

        .. deprecated:: unknown

        :type  node_id: :class:`str`
        :param node_id: (required)
        :rtype: :class:`com.vmware.nsx.model_client.ClusterNodeConfig`
        :return: com.vmware.nsx.model.ClusterNodeConfig
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        warn('com.vmware.nsx.cluster.Nodes.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'node_id': node_id,
                            })

    def list(self,
             cursor=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Returns information about all NSX cluster nodes.

        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx.model_client.ClusterNodeConfigListResult`
        :return: com.vmware.nsx.model.ClusterNodeConfigListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('list',
                            {
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })
class Restore(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.cluster.restore'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _RestoreStub)
        self._VAPI_OPERATION_IDS = {}


    def advance(self,
                advance_cluster_restore_request,
                ):
        """
        Advance any currently suspended restore operation. The operation might
        have been suspended because (1) the user had suspended it previously,
        or (2) the operation is waiting for user input, to be provided as a
        part of the POST request body. This operation is only valid when a GET
        cluster/restore/status returns a status with value SUSPENDED.
        Otherwise, a 409 response is returned.

        :type  advance_cluster_restore_request: :class:`com.vmware.nsx.model_client.AdvanceClusterRestoreRequest`
        :param advance_cluster_restore_request: (required)
        :rtype: :class:`com.vmware.nsx.model_client.ClusterRestoreStatus`
        :return: com.vmware.nsx.model.ClusterRestoreStatus
        :raise: :class:`com.vmware.vapi.std.errors_client.ConcurrentChange` 
             Conflict
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('advance',
                            {
                            'advance_cluster_restore_request': advance_cluster_restore_request,
                            })

    def cancel(self):
        """
        This operation is only valid when a restore is in suspended state. The
        UI user can cancel any restore operation when the restore is suspended
        either due to an error, or for a user input. The API user would need to
        monitor the progression of a restore by calling periodically
        \"/api/v1/cluster/restore/status\" API. The response object
        (ClusterRestoreStatus), contains a field \"endpoints\". The API user
        can cancel the restore process if 'cancel' action is shown in the
        endpoint field. This operation is only valid when a GET
        cluster/restore/status returns a status with value SUSPENDED.


        :rtype: :class:`com.vmware.nsx.model_client.ClusterRestoreStatus`
        :return: com.vmware.nsx.model.ClusterRestoreStatus
        :raise: :class:`com.vmware.vapi.std.errors_client.ConcurrentChange` 
             Conflict
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('cancel', None)

    def retry(self):
        """
        Retry any currently in-progress, failed restore operation. Only the
        last step of the multi-step restore operation would have failed,and
        only that step is retried. This operation is only valid when a GET
        cluster/restore/status returns a status with value FAILED. Otherwise, a
        409 response is returned.


        :rtype: :class:`com.vmware.nsx.model_client.ClusterRestoreStatus`
        :return: com.vmware.nsx.model.ClusterRestoreStatus
        :raise: :class:`com.vmware.vapi.std.errors_client.ConcurrentChange` 
             Conflict
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('retry', None)

    def start(self,
              initiate_cluster_restore_request,
              ):
        """
        Start the restore of an NSX cluster, from some previously backed-up
        configuration. This operation is only valid when a GET
        cluster/restore/status returns a status with value NOT_STARTED.
        Otherwise, a 409 response is returned.

        :type  initiate_cluster_restore_request: :class:`com.vmware.nsx.model_client.InitiateClusterRestoreRequest`
        :param initiate_cluster_restore_request: (required)
        :rtype: :class:`com.vmware.nsx.model_client.ClusterRestoreStatus`
        :return: com.vmware.nsx.model.ClusterRestoreStatus
        :raise: :class:`com.vmware.vapi.std.errors_client.ConcurrentChange` 
             Conflict
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('start',
                            {
                            'initiate_cluster_restore_request': initiate_cluster_restore_request,
                            })

    def suspend(self):
        """
        Suspend any currently running restore operation. The restore operation
        is made up of a number of steps. When this call is issued, any
        currently running step is allowed to finish (successfully or with
        errors), and the next step (and therefore the entire restore operation)
        is suspended until a subsequent resume or cancel call is issued. This
        operation is only valid when a GET cluster/restore/status returns a
        status with value RUNNING. Otherwise, a 409 response is returned.


        :rtype: :class:`com.vmware.nsx.model_client.ClusterRestoreStatus`
        :return: com.vmware.nsx.model.ClusterRestoreStatus
        :raise: :class:`com.vmware.vapi.std.errors_client.ConcurrentChange` 
             Conflict
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('suspend', None)
class Status(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.cluster.status'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _StatusStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self):
        """
        Returns status information for the NSX cluster control role and
        management role.


        :rtype: :class:`com.vmware.nsx.model_client.ClusterStatus`
        :return: com.vmware.nsx.model.ClusterStatus
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get', None)
class _ApiCertificateStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for clearclustercertificate operation
        clearclustercertificate_input_type = type.StructType('operation-input', {
            'certificate_id': type.StringType(),
        })
        clearclustercertificate_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        clearclustercertificate_input_value_validator_list = [
        ]
        clearclustercertificate_output_validator_list = [
        ]
        clearclustercertificate_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/cluster/api-certificate?action=clear_cluster_certificate',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
                'certificate_id': 'certificate_id',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {})
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/cluster/api-certificate',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for setclustercertificate operation
        setclustercertificate_input_type = type.StructType('operation-input', {
            'certificate_id': type.StringType(),
        })
        setclustercertificate_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        setclustercertificate_input_value_validator_list = [
        ]
        setclustercertificate_output_validator_list = [
        ]
        setclustercertificate_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/cluster/api-certificate?action=set_cluster_certificate',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
                'certificate_id': 'certificate_id',
            },
            content_type='application/json'
        )

        operations = {
            'clearclustercertificate': {
                'input_type': clearclustercertificate_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterCertificateId'),
                'errors': clearclustercertificate_error_dict,
                'input_value_validator_list': clearclustercertificate_input_value_validator_list,
                'output_validator_list': clearclustercertificate_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterCertificateId'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'setclustercertificate': {
                'input_type': setclustercertificate_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterCertificateId'),
                'errors': setclustercertificate_error_dict,
                'input_value_validator_list': setclustercertificate_input_value_validator_list,
                'output_validator_list': setclustercertificate_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'clearclustercertificate': clearclustercertificate_rest_metadata,
            'get': get_rest_metadata,
            'setclustercertificate': setclustercertificate_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.cluster.api_certificate',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _ApiServiceStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {})
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/cluster/api-service',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'api_service_config': type.ReferenceType('com.vmware.nsx.model_client', 'ApiServiceConfig'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
        ]
        update_output_validator_list = [
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/api/v1/cluster/api-service',
            request_body_parameter='api_service_config',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ApiServiceConfig'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ApiServiceConfig'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.cluster.api_service',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _ApiVirtualIpStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for clearvirtualip operation
        clearvirtualip_input_type = type.StructType('operation-input', {})
        clearvirtualip_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        clearvirtualip_input_value_validator_list = [
        ]
        clearvirtualip_output_validator_list = [
        ]
        clearvirtualip_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/cluster/api-virtual-ip?action=clear_virtual_ip',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for clearvirtualip6 operation
        clearvirtualip6_input_type = type.StructType('operation-input', {})
        clearvirtualip6_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        clearvirtualip6_input_value_validator_list = [
        ]
        clearvirtualip6_output_validator_list = [
        ]
        clearvirtualip6_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/cluster/api-virtual-ip?action=clear_virtual_ip6',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {})
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/cluster/api-virtual-ip',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for setvirtualip operation
        setvirtualip_input_type = type.StructType('operation-input', {
            'force': type.OptionalType(type.StringType()),
            'ip6_address': type.OptionalType(type.StringType()),
            'ip_address': type.OptionalType(type.StringType()),
        })
        setvirtualip_error_dict = {
            'com.vmware.vapi.std.errors.concurrent_change':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ConcurrentChange'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        setvirtualip_input_value_validator_list = [
        ]
        setvirtualip_output_validator_list = [
        ]
        setvirtualip_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/cluster/api-virtual-ip?action=set_virtual_ip',
            path_variables={
            },
             header_parameters={
                   },
            query_parameters={
                'force': 'force',
                'ip6_address': 'ip6_address',
                'ip_address': 'ip_address',
            },
            content_type='application/json'
        )

        operations = {
            'clearvirtualip': {
                'input_type': clearvirtualip_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterVirtualIpProperties'),
                'errors': clearvirtualip_error_dict,
                'input_value_validator_list': clearvirtualip_input_value_validator_list,
                'output_validator_list': clearvirtualip_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'clearvirtualip6': {
                'input_type': clearvirtualip6_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterVirtualIpProperties'),
                'errors': clearvirtualip6_error_dict,
                'input_value_validator_list': clearvirtualip6_input_value_validator_list,
                'output_validator_list': clearvirtualip6_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterVirtualIpProperties'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'setvirtualip': {
                'input_type': setvirtualip_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterVirtualIpProperties'),
                'errors': setvirtualip_error_dict,
                'input_value_validator_list': setvirtualip_input_value_validator_list,
                'output_validator_list': setvirtualip_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'clearvirtualip': clearvirtualip_rest_metadata,
            'clearvirtualip6': clearvirtualip6_rest_metadata,
            'get': get_rest_metadata,
            'setvirtualip': setvirtualip_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.cluster.api_virtual_ip',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _BackupsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for retrievesshfingerprint operation
        retrievesshfingerprint_input_type = type.StructType('operation-input', {
            'remote_server_fingerprint_request': type.ReferenceType('com.vmware.nsx.model_client', 'RemoteServerFingerprintRequest'),
        })
        retrievesshfingerprint_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        retrievesshfingerprint_input_value_validator_list = [
        ]
        retrievesshfingerprint_output_validator_list = [
        ]
        retrievesshfingerprint_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/cluster/backups?action=retrieve_ssh_fingerprint',
            request_body_parameter='remote_server_fingerprint_request',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'retrievesshfingerprint': {
                'input_type': retrievesshfingerprint_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'RemoteServerFingerprint'),
                'errors': retrievesshfingerprint_error_dict,
                'input_value_validator_list': retrievesshfingerprint_input_value_validator_list,
                'output_validator_list': retrievesshfingerprint_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'retrievesshfingerprint': retrievesshfingerprint_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.cluster.backups',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _NodeStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for reposync operation
        reposync_input_type = type.StructType('operation-input', {})
        reposync_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        reposync_input_value_validator_list = [
        ]
        reposync_output_validator_list = [
        ]
        reposync_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/cluster/node?action=repo_sync',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'reposync': {
                'input_type': reposync_input_type,
                'output_type': type.VoidType(),
                'errors': reposync_error_dict,
                'input_value_validator_list': reposync_input_value_validator_list,
                'output_validator_list': reposync_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'reposync': reposync_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.cluster.node',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _NodesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'add_cluster_node_spec': type.ReferenceType('com.vmware.nsx.model_client', 'AddClusterNodeSpec'),
            'action': type.StringType(),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/cluster/nodes',
            request_body_parameter='add_cluster_node_spec',
            path_variables={
            },
             header_parameters={
                 },
            query_parameters={
                'action': 'action',
            },
            content_type='application/json'
        )

        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'node_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/api/v1/cluster/nodes/{node-id}',
            path_variables={
                'node_id': 'node-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'node_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/cluster/nodes/{node-id}',
            path_variables={
                'node_id': 'node-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'cursor': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/cluster/nodes',
            path_variables={
            },
             header_parameters={
                       },
            query_parameters={
                'cursor': 'cursor',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterNodeConfig'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterNodeConfig'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterNodeConfigListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.cluster.nodes',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _RestoreStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for advance operation
        advance_input_type = type.StructType('operation-input', {
            'advance_cluster_restore_request': type.ReferenceType('com.vmware.nsx.model_client', 'AdvanceClusterRestoreRequest'),
        })
        advance_error_dict = {
            'com.vmware.vapi.std.errors.concurrent_change':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ConcurrentChange'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        advance_input_value_validator_list = [
        ]
        advance_output_validator_list = [
        ]
        advance_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/cluster/restore?action=advance',
            request_body_parameter='advance_cluster_restore_request',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for cancel operation
        cancel_input_type = type.StructType('operation-input', {})
        cancel_error_dict = {
            'com.vmware.vapi.std.errors.concurrent_change':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ConcurrentChange'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        cancel_input_value_validator_list = [
        ]
        cancel_output_validator_list = [
        ]
        cancel_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/cluster/restore?action=cancel',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for retry operation
        retry_input_type = type.StructType('operation-input', {})
        retry_error_dict = {
            'com.vmware.vapi.std.errors.concurrent_change':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ConcurrentChange'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        retry_input_value_validator_list = [
        ]
        retry_output_validator_list = [
        ]
        retry_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/cluster/restore?action=retry',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for start operation
        start_input_type = type.StructType('operation-input', {
            'initiate_cluster_restore_request': type.ReferenceType('com.vmware.nsx.model_client', 'InitiateClusterRestoreRequest'),
        })
        start_error_dict = {
            'com.vmware.vapi.std.errors.concurrent_change':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ConcurrentChange'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        start_input_value_validator_list = [
        ]
        start_output_validator_list = [
        ]
        start_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/cluster/restore?action=start',
            request_body_parameter='initiate_cluster_restore_request',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for suspend operation
        suspend_input_type = type.StructType('operation-input', {})
        suspend_error_dict = {
            'com.vmware.vapi.std.errors.concurrent_change':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ConcurrentChange'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        suspend_input_value_validator_list = [
        ]
        suspend_output_validator_list = [
        ]
        suspend_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/cluster/restore?action=suspend',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'advance': {
                'input_type': advance_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterRestoreStatus'),
                'errors': advance_error_dict,
                'input_value_validator_list': advance_input_value_validator_list,
                'output_validator_list': advance_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'cancel': {
                'input_type': cancel_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterRestoreStatus'),
                'errors': cancel_error_dict,
                'input_value_validator_list': cancel_input_value_validator_list,
                'output_validator_list': cancel_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'retry': {
                'input_type': retry_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterRestoreStatus'),
                'errors': retry_error_dict,
                'input_value_validator_list': retry_input_value_validator_list,
                'output_validator_list': retry_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'start': {
                'input_type': start_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterRestoreStatus'),
                'errors': start_error_dict,
                'input_value_validator_list': start_input_value_validator_list,
                'output_validator_list': start_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'suspend': {
                'input_type': suspend_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterRestoreStatus'),
                'errors': suspend_error_dict,
                'input_value_validator_list': suspend_input_value_validator_list,
                'output_validator_list': suspend_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'advance': advance_rest_metadata,
            'cancel': cancel_rest_metadata,
            'retry': retry_rest_metadata,
            'start': start_rest_metadata,
            'suspend': suspend_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.cluster.restore',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _StatusStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {})
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/cluster/status',
            path_variables={
            },
             header_parameters={
             },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'ClusterStatus'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.cluster.status',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'ApiCertificate': ApiCertificate,
        'ApiService': ApiService,
        'ApiVirtualIp': ApiVirtualIp,
        'Backups': Backups,
        'Node': Node,
        'Nodes': Nodes,
        'Restore': Restore,
        'Status': Status,
        'backups': 'com.vmware.nsx.cluster.backups_client.StubFactory',
        'nodes': 'com.vmware.nsx.cluster.nodes_client.StubFactory',
        'restore': 'com.vmware.nsx.cluster.restore_client.StubFactory',
    }

