# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.repository.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Bundles(VapiInterface):
    """
    
    """
    CANCELUPLOAD_PRODUCT_SAMPLE = "SAMPLE"
    """
    Possible value for ``product`` of method :func:`Bundles.cancelupload`.

    """
    CANCELUPLOAD_PRODUCT_ALB_CONTROLLER = "ALB_CONTROLLER"
    """
    Possible value for ``product`` of method :func:`Bundles.cancelupload`.

    """
    CANCELUPLOAD_PRODUCT_INTELLIGENCE = "INTELLIGENCE"
    """
    Possible value for ``product`` of method :func:`Bundles.cancelupload`.

    """
    CREATE_FILE_TYPE_OVA = "OVA"
    """
    Possible value for ``fileType`` of method :func:`Bundles.create`.

    """
    CREATE_PRODUCT_SAMPLE = "SAMPLE"
    """
    Possible value for ``product`` of method :func:`Bundles.create`.

    """
    CREATE_PRODUCT_ALB_CONTROLLER = "ALB_CONTROLLER"
    """
    Possible value for ``product`` of method :func:`Bundles.create`.

    """
    CREATE_PRODUCT_INTELLIGENCE = "INTELLIGENCE"
    """
    Possible value for ``product`` of method :func:`Bundles.create`.

    """
    GET_FILE_TYPE_OVA = "OVA"
    """
    Possible value for ``fileType`` of method :func:`Bundles.get`.

    """
    GET_PRODUCT_SAMPLE = "SAMPLE"
    """
    Possible value for ``product`` of method :func:`Bundles.get`.

    """
    GET_PRODUCT_ALB_CONTROLLER = "ALB_CONTROLLER"
    """
    Possible value for ``product`` of method :func:`Bundles.get`.

    """
    GET_PRODUCT_INTELLIGENCE = "INTELLIGENCE"
    """
    Possible value for ``product`` of method :func:`Bundles.get`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.repository.bundles'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _BundlesStub)
        self._VAPI_OPERATION_IDS = {}


    def cancelupload(self,
                     bundle_id,
                     product,
                     ):
        """
        Cancel upload of bundle. This API works only when bundle upload is
        in-progress and will not work during post-processing of bundle. If
        bundle upload is in-progress, then the API call returns http OK
        response after cancelling the upload and deleting partially uploaded
        bundle.

        :type  bundle_id: :class:`str`
        :param bundle_id: (required)
        :type  product: :class:`str`
        :param product: Name of the appliance (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('cancelupload',
                            {
                            'bundle_id': bundle_id,
                            'product': product,
                            })

    def create(self,
               remote_bundle_url,
               file_type,
               product,
               ):
        """
        Upload the bundle from remote bundle URL. The call returns after fetch
        is initiated. Check status by periodically retrieving bundle upload
        status using GET /repository/bundles/<bundle-id>/upload-status. The
        upload is complete when the status is SUCCESS.

        :type  remote_bundle_url: :class:`com.vmware.nsx.model_client.RemoteBundleUrl`
        :param remote_bundle_url: (required)
        :type  file_type: :class:`str`
        :param file_type: Type of file (required)
        :type  product: :class:`str`
        :param product: Name of the appliance (required)
        :rtype: :class:`com.vmware.nsx.model_client.BundleId`
        :return: com.vmware.nsx.model.BundleId
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
             Unauthorized
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('create',
                            {
                            'remote_bundle_url': remote_bundle_url,
                            'file_type': file_type,
                            'product': product,
                            })

    def get(self,
            file_type,
            product,
            ):
        """
        Get list of bundle-ids which are available in repository or in-progress

        :type  file_type: :class:`str`
        :param file_type: Type of file (required)
        :type  product: :class:`str`
        :param product: Name of the appliance (required)
        :rtype: :class:`com.vmware.nsx.model_client.BundleIds`
        :return: com.vmware.nsx.model.BundleIds
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
             Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
             Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
             Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
             Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
             Not Found
        """
        return self._invoke('get',
                            {
                            'file_type': file_type,
                            'product': product,
                            })
class _BundlesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for cancelupload operation
        cancelupload_input_type = type.StructType('operation-input', {
            'bundle_id': type.StringType(),
            'product': type.StringType(),
        })
        cancelupload_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        cancelupload_input_value_validator_list = [
        ]
        cancelupload_output_validator_list = [
        ]
        cancelupload_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/repository/bundles/{bundle-id}?action=cancel_upload',
            path_variables={
                'bundle_id': 'bundle-id',
            },
             header_parameters={
                 },
            query_parameters={
                'product': 'product',
            },
            content_type='application/json'
        )

        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'remote_bundle_url': type.ReferenceType('com.vmware.nsx.model_client', 'RemoteBundleUrl'),
            'file_type': type.StringType(),
            'product': type.StringType(),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/repository/bundles',
            request_body_parameter='remote_bundle_url',
            path_variables={
            },
             header_parameters={
                   },
            query_parameters={
                'file_type': 'file_type',
                'product': 'product',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'file_type': type.StringType(),
            'product': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/repository/bundles',
            path_variables={
            },
             header_parameters={
                 },
            query_parameters={
                'file_type': 'file_type',
                'product': 'product',
            },
            content_type='application/json'
        )

        operations = {
            'cancelupload': {
                'input_type': cancelupload_input_type,
                'output_type': type.VoidType(),
                'errors': cancelupload_error_dict,
                'input_value_validator_list': cancelupload_input_value_validator_list,
                'output_validator_list': cancelupload_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'BundleId'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'BundleIds'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'cancelupload': cancelupload_rest_metadata,
            'create': create_rest_metadata,
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.repository.bundles',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Bundles': Bundles,
        'bundles': 'com.vmware.nsx.repository.bundles_client.StubFactory',
    }

