/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.bundles.Bundle;
import org.jetbrains.plugins.textmate.bundles.BundleType;
import org.jetbrains.plugins.textmate.plist.JsonPlistReader;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;

@Deprecated
public class VSCBundle
extends Bundle {
    private final Map<String, Collection<String>> grammarToExtensions;
    private final Map<String, Collection<String>> configToScopes;
    private final List<String> snippetPaths;

    public VSCBundle(@NotNull String name, @NotNull String bundle) {
        if (name == null) {
            VSCBundle.$$$reportNull$$$0(0);
        }
        if (bundle == null) {
            VSCBundle.$$$reportNull$$$0(1);
        }
        super(name, bundle, BundleType.VSCODE);
        this.grammarToExtensions = new LinkedHashMap<String, Collection<String>>();
        this.configToScopes = new HashMap<String, Collection<String>>();
        this.snippetPaths = new ArrayList<String>();
    }

    @Override
    @NotNull
    public Collection<File> getGrammarFiles() {
        this.loadExtensions();
        Collection collection = this.grammarToExtensions.keySet().stream().map(path -> new File(this.bundleFile, (String)path)).collect(Collectors.toList());
        if (collection == null) {
            VSCBundle.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Override
    public Collection<String> getExtensions(@NotNull File file, @NotNull Plist plist2) {
        if (file == null) {
            VSCBundle.$$$reportNull$$$0(3);
        }
        if (plist2 == null) {
            VSCBundle.$$$reportNull$$$0(4);
        }
        HashSet<String> result = new HashSet<String>(super.getExtensions(file, plist2));
        this.loadExtensions();
        result.addAll(this.grammarToExtensions.getOrDefault(FileUtilRt.toSystemIndependentName((String)Objects.requireNonNull(FileUtilRt.getRelativePath((File)this.bundleFile, (File)file))), Collections.emptyList()));
        return result;
    }

    @Override
    @NotNull
    public Collection<File> getSnippetFiles() {
        this.loadExtensions();
        Collection collection = this.snippetPaths.stream().map(path -> new File(this.bundleFile, (String)path)).collect(Collectors.toList());
        if (collection == null) {
            VSCBundle.$$$reportNull$$$0(5);
        }
        return collection;
    }

    private void loadExtensions() {
        if (!this.grammarToExtensions.isEmpty()) {
            return;
        }
        File packageJson = new File(this.bundleFile, "package.json");
        try {
            Object contributes;
            Object json = JsonPlistReader.createJsonReader().readValue((Reader)new FileReader(packageJson, StandardCharsets.UTF_8), Object.class);
            if (json instanceof Map && (contributes = ((Map)json).get("contributes")) instanceof Map) {
                Object languages2 = ((Map)contributes).get("languages");
                Object grammars = ((Map)contributes).get("grammars");
                Object snippets = ((Map)contributes).get("snippets");
                if (languages2 instanceof ArrayList && grammars instanceof ArrayList) {
                    HashMap<String, Collection> idToExtension = new HashMap<String, Collection>();
                    HashMap<String, String> idToConfig = new HashMap<String, String>();
                    for (Object language : (ArrayList)languages2) {
                        Object configuration;
                        Object filenames;
                        Object id;
                        if (!(language instanceof Map) || !((id = ((Map)language).get("id")) instanceof String)) continue;
                        Object extensions = ((Map)language).get("extensions");
                        if (extensions instanceof ArrayList) {
                            Stream<Object> stream = ((ArrayList)extensions).stream().map(ext -> Strings.trimStart((String)((String)ext), (String)"."));
                            idToExtension.computeIfAbsent((String)id, key -> new HashSet()).addAll(stream.toList());
                        }
                        if ((filenames = ((Map)language).get("filenames")) instanceof ArrayList) {
                            idToExtension.computeIfAbsent((String)id, key -> new HashSet()).addAll((ArrayList)filenames);
                        }
                        if (!((configuration = ((Map)language).get("configuration")) instanceof String)) continue;
                        idToConfig.put((String)id, FileUtilRt.toSystemIndependentName((String)((String)configuration)));
                    }
                    if (snippets instanceof ArrayList) {
                        for (Object snippet : (ArrayList)snippets) {
                            Object path;
                            if (!(snippet instanceof Map) || !((path = ((Map)snippet).get("path")) instanceof String)) continue;
                            this.snippetPaths.add((String)path);
                        }
                    }
                    LinkedHashMap<String, Collection> grammarExtensions = new LinkedHashMap<String, Collection>();
                    HashMap<String, Collection> scopeConfig = new HashMap<String, Collection>();
                    for (Object grammar : (ArrayList)grammars) {
                        Object embedded;
                        if (!(grammar instanceof Map)) continue;
                        Object path = ((Map)grammar).get("path");
                        Object language = ((Map)grammar).get("language");
                        Collection extensions = idToExtension.getOrDefault(language, Collections.emptyList());
                        if (path instanceof String) {
                            grammarExtensions.put((String)path, extensions);
                        }
                        Object scopeName = ((Map)grammar).get("scopeName");
                        String config = (String)idToConfig.get(language);
                        if (scopeName instanceof String && config != null) {
                            scopeConfig.computeIfAbsent(config, key -> new ArrayList()).add((String)scopeName);
                        }
                        if (!((embedded = ((Map)grammar).get("embeddedLanguages")) instanceof Map)) continue;
                        for (Object embeddedScope : ((Map)embedded).keySet()) {
                            String embeddedConfig;
                            Object embeddedLanguage = ((Map)embedded).get(embeddedScope);
                            if (!(embeddedScope instanceof String) || !(embeddedLanguage instanceof String) || (embeddedConfig = (String)idToConfig.get(embeddedLanguage)) == null) continue;
                            scopeConfig.computeIfAbsent(embeddedConfig, key -> new ArrayList()).add((String)embeddedScope);
                        }
                    }
                    this.grammarToExtensions.putAll(grammarExtensions);
                    this.configToScopes.putAll(scopeConfig);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public Collection<File> getPreferenceFiles() {
        this.loadExtensions();
        Collection collection = this.configToScopes.keySet().stream().map(config -> new File(this.bundleFile, (String)config)).collect(Collectors.toList());
        if (collection == null) {
            VSCBundle.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Override
    public List<Map.Entry<String, Plist>> loadPreferenceFile(@NotNull File file, @NotNull PlistReader plistReader) throws IOException {
        if (file == null) {
            VSCBundle.$$$reportNull$$$0(7);
        }
        if (plistReader == null) {
            VSCBundle.$$$reportNull$$$0(8);
        }
        Plist fromJson = VSCBundle.loadLanguageConfig(file);
        return this.configToScopes.get(FileUtilRt.toSystemIndependentName((String)Objects.requireNonNull(FileUtilRt.getRelativePath((File)this.bundleFile, (File)file)))).stream().map(scope -> Map.entry(scope, fromJson)).collect(Collectors.toList());
    }

    @NotNull
    private static Plist loadLanguageConfig(File languageConfig) throws IOException {
        Plist plist2;
        try {
            Object json = JsonPlistReader.createJsonReader().readValue((Reader)new FileReader(languageConfig, StandardCharsets.UTF_8), Object.class);
            Plist settings = new Plist();
            if (json instanceof Map) {
                settings.setEntry("highlightingPairs", VSCBundle.loadBrackets((Map)json, "brackets"));
                settings.setEntry("smartTypingPairs", VSCBundle.loadBrackets((Map)json, "surroundingPairs"));
                settings.setEntry("shellVariables", PListValue.array(VSCBundle.loadComments((Map)json)));
                settings.setEntry("indentationRules", PListValue.dict(VSCBundle.loadIndentationRules((Map)json)));
            }
            plist2 = settings;
        }
        catch (FileNotFoundException e) {
            Plist plist3 = Plist.EMPTY_PLIST;
            if (plist3 == null) {
                VSCBundle.$$$reportNull$$$0(10);
            }
            return plist3;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (plist2 == null) {
            VSCBundle.$$$reportNull$$$0(9);
        }
        return plist2;
    }

    private static PListValue loadBrackets(Map json, String key) {
        Object brackets = json.get(key);
        if (!(brackets instanceof ArrayList)) {
            return null;
        }
        ArrayList<PListValue> pairs = new ArrayList<PListValue>();
        for (Object bracket : (ArrayList)brackets) {
            if (!(bracket instanceof ArrayList) || ((ArrayList)bracket).size() != 2) continue;
            pairs.add(PListValue.array(PListValue.string(((ArrayList)bracket).get(0).toString()), PListValue.string(((ArrayList)bracket).get(1).toString())));
        }
        return PListValue.array(pairs);
    }

    private static List<PListValue> loadComments(Map json) {
        ArrayList<PListValue> variables = new ArrayList<PListValue>();
        Object comments = json.get("comments");
        if (comments instanceof Map) {
            Object block;
            Object line = ((Map)comments).get("lineComment");
            boolean hasLine = line instanceof String;
            if (hasLine) {
                variables.add(VSCBundle.variable("TM_COMMENT_START", ((String)line).trim() + " "));
            }
            if ((block = ((Map)comments).get("blockComment")) instanceof ArrayList && ((ArrayList)block).size() == 2) {
                String suffix = hasLine ? "_2" : "";
                variables.add(VSCBundle.variable("TM_COMMENT_START" + suffix, ((ArrayList)block).get(0).toString().trim() + " "));
                variables.add(VSCBundle.variable("TM_COMMENT_END" + suffix, " " + ((ArrayList)block).get(1).toString().trim()));
            }
        }
        return variables;
    }

    private static Plist loadIndentationRules(Map json) {
        Plist patterns = new Plist();
        Object rules = json.get("indentationRules");
        if (rules instanceof Map) {
            VSCBundle.loadIndentationPattern(patterns, rules, "increaseIndentPattern", "increaseIndentPattern");
            VSCBundle.loadIndentationPattern(patterns, rules, "decreaseIndentPattern", "decreaseIndentPattern");
            VSCBundle.loadIndentationPattern(patterns, rules, "indentNextLinePattern", "indentNextLinePattern");
            VSCBundle.loadIndentationPattern(patterns, rules, "unIndentedLinePattern", "unIndentedLinePattern");
        }
        return patterns;
    }

    private static void loadIndentationPattern(Plist patterns, Object rules, String name, String key) {
        Object value = ((Map)rules).get(key);
        if (value instanceof String) {
            patterns.setEntry(name, PListValue.string((String)value));
        }
    }

    private static PListValue variable(String name, String value) {
        Plist variable = new Plist();
        variable.setEntry("name", PListValue.string(name));
        variable.setEntry("value", PListValue.string(value));
        return PListValue.dict(variable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/bundles/VSCBundle";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plistReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/bundles/VSCBundle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrammarFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnippetFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferenceFiles";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLanguageConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadPreferenceFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 9, 10 -> new IllegalStateException(string);
        };
    }
}

