/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnExceptionWrapper;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.ChangeList;
import org.jetbrains.idea.svn.status.Entry;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.jetbrains.idea.svn.status.StatusRoot;
import org.jetbrains.idea.svn.status.StatusTarget;
import org.jetbrains.idea.svn.status.StatusType;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a>\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a@\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u00a8\u0006\u0016"}, d2={"parseResult", "", "base", "Ljava/io/File;", "infoBase", "Lorg/jetbrains/idea/svn/info/Info;", "infoProvider", "Lcom/intellij/util/containers/Convertor;", "result", "", "handler", "Lorg/jetbrains/idea/svn/status/StatusConsumer;", "putParameters", "", "parameters", "", "path", "depth", "Lorg/jetbrains/idea/svn/api/Depth;", "remote", "reportAll", "includeIgnored", "intellij.vcs.svn"})
@SourceDebugExtension(value={"SMAP\nCmdStatusClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CmdStatusClient.kt\norg/jetbrains/idea/svn/status/CmdStatusClientKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,294:1\n1855#2,2:295\n1855#2,2:297\n*S KotlinDebug\n*F\n+ 1 CmdStatusClient.kt\norg/jetbrains/idea/svn/status/CmdStatusClientKt\n*L\n77#1:295,2\n83#1:297,2\n*E\n"})
public final class CmdStatusClientKt {
    private static final void putParameters(List<String> parameters, File path, Depth depth, boolean remote, boolean reportAll, boolean includeIgnored) {
        CommandUtil.put(parameters, path);
        CommandUtil.put(parameters, depth);
        CommandUtil.put(parameters, remote, "-u");
        CommandUtil.put(parameters, reportAll, "--verbose");
        CommandUtil.put(parameters, includeIgnored, "--no-ignore");
        parameters.add("--xml");
    }

    private static final boolean parseResult(File base, Info infoBase, Convertor<File, Info> infoProvider, String result, StatusConsumer handler) {
        Map externalsMap = new LinkedHashMap();
        Ref.BooleanRef hasEntries = new Ref.BooleanRef();
        StatusRoot statusRoot = CommandUtil.parse(result, StatusRoot.class);
        if (statusRoot != null) {
            Status.Builder builder;
            Entry entry;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Object object = statusRoot.getTarget();
            if (object != null && (object = ((StatusTarget)object).getEntries()) != null) {
                $this$forEach$iv = (Iterable)object;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    entry = (Entry)element$iv;
                    boolean bl = false;
                    builder = entry.toBuilder(base);
                    CmdStatusClientKt.parseResult$setUrlAndNotifyHandler(externalsMap, base, infoBase, hasEntries, handler, infoProvider, builder);
                }
            }
            for (ChangeList changeList : statusRoot.getChangeLists()) {
                $this$forEach$iv = changeList.getEntries();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    entry = (Entry)element$iv;
                    boolean bl = false;
                    builder = entry.toBuilder(base);
                    builder.setChangeListName(changeList.getName());
                    CmdStatusClientKt.parseResult$setUrlAndNotifyHandler(externalsMap, base, infoBase, hasEntries, handler, infoProvider, builder);
                }
            }
        }
        return hasEntries.element;
    }

    private static final Info parseResult$setUrlAndNotifyHandler$lambda$0(Convertor $infoProvider, Status.Builder $builder) {
        Intrinsics.checkNotNullParameter((Object)$infoProvider, (String)"$infoProvider");
        Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
        return (Info)$infoProvider.convert((Object)$builder.getFile());
    }

    private static final boolean parseResult$setUrlAndNotifyHandler$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void parseResult$setUrlAndNotifyHandler(Map<File, Info> externalsMap, File $base, Info $infoBase, Ref.BooleanRef hasEntries, StatusConsumer $handler, Convertor<File, Info> $infoProvider, Status.Builder builder) {
        Object object;
        Status status;
        Info baseInfo;
        builder.setInfoProvider(() -> CmdStatusClientKt.parseResult$setUrlAndNotifyHandler$lambda$0($infoProvider, builder));
        File file = builder.getFile();
        File externalsBase2 = (File)ContainerUtil.find((Iterable)externalsMap.keySet(), arg_0 -> CmdStatusClientKt.parseResult$setUrlAndNotifyHandler$lambda$1((Function1)new Function1<File, Boolean>(file){
            final /* synthetic */ File $file;
            {
                this.$file = $file;
                super(1);
            }

            @NotNull
            public final Boolean invoke(File it) {
                return FileUtil.isAncestor((File)it, (File)this.$file, (boolean)false);
            }
        }, arg_0));
        File file2 = externalsBase2;
        if (file2 == null) {
            file2 = $base;
        }
        File baseFile = file2;
        File file3 = externalsBase2;
        Info info2 = baseInfo = file3 != null ? externalsMap.get(file3) : $infoBase;
        if (baseInfo != null) {
            Url url = baseInfo.getUrl();
            Intrinsics.checkNotNull((Object)url);
            String string = FileUtil.getRelativePath((File)baseFile, (File)file);
            Intrinsics.checkNotNull((Object)string);
            builder.setUrl(SvnUtil.append(url, FileUtil.toSystemIndependentName((String)string)));
        }
        if ((status = builder.build()).is((StatusType[])(object = new StatusType[]{StatusType.STATUS_EXTERNAL}))) {
            Info info3;
            object = externalsMap;
            File file4 = status.getFile();
            try {
                info3 = status.getInfo();
            }
            catch (SvnExceptionWrapper e) {
                throw new SvnBindException(e.getCause());
            }
            object.put(file4, info3);
        }
        hasEntries.element = true;
        $handler.consume(status);
    }

    public static final /* synthetic */ void access$putParameters(List parameters, File path, Depth depth, boolean remote, boolean reportAll, boolean includeIgnored) {
        CmdStatusClientKt.putParameters(parameters, path, depth, remote, reportAll, includeIgnored);
    }

    public static final /* synthetic */ boolean access$parseResult(File base, Info infoBase, Convertor infoProvider, String result, StatusConsumer handler) {
        return CmdStatusClientKt.parseResult(base, infoBase, (Convertor<File, Info>)infoProvider, result, handler);
    }
}

