/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.report;

import com.intellij.rt.coverage.data.BranchData;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.instructions.ClassInstructions;
import com.intellij.rt.coverage.data.instructions.LineInstructions;
import com.intellij.rt.coverage.report.XMLProjectData;
import com.intellij.rt.coverage.util.ArrayUtil;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.gnu.trove.TIntObjectProcedure;

public class XMLCoverageReport {
    private static final String LINE_COUNTER = "LINE";
    private static final String BRANCH_COUNTER = "BRANCH";
    private static final String METHOD_COUNTER = "METHOD";
    private static final String CLASS_COUNTER = "CLASS";
    private static final String INSTRUCTION_COUNTER = "INSTRUCTION";
    private static final int LINE_MASK = 1;
    private static final int BRANCH_MASK = 2;
    private static final int METHOD_MASK = 4;
    private static final int CLASS_MASK = 8;
    private static final int INSTRUCTION_MASK = 16;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String REPORT_TAG = "report";
    private static final String NAME_TAG = "name";
    private static final String IJ_REPORT_NAME = "Intellij Coverage Report";
    public static final String PACKAGE_TAG = "package";
    public static final String SOURCEFILE_TAG = "sourcefile";
    public static final String CLASS_TAG = "class";
    public static final String METHOD_TAG = "method";
    public static final String DESC_TAG = "desc";
    public static final String LINE_TAG = "line";
    public static final String LINE_NUMBER_TAG = "nr";
    public static final String MISSED_INSTRUCTIONS_TAG = "mi";
    public static final String COVERED_INSTRUCTIONS_TAG = "ci";
    public static final String MISSED_BRANCHES_TAG = "mb";
    public static final String COVERED_BRANCHES_TAG = "cb";
    public static final String COUNTER_TAG = "counter";
    public static final String TYPE_TAG = "type";
    public static final String MISSED_TAG = "missed";
    public static final String COVERED_TAG = "covered";
    private static final String SOURCEFILE_NAME_TAG = "sourcefilename";
    private final Map<String, List<LineData>> myFiles = new HashMap<String, List<LineData>>();
    private XMLStreamWriter myOut;
    private XMLStreamReader myIn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canReadFile(File file) {
        block18: {
            block17: {
                is = null;
                in = null;
                try {
                    factory = XMLInputFactory.newInstance();
                    is = new BufferedInputStream(new FileInputStream(file));
                    in = factory.createXMLStreamReader(is);
lbl7:
                    // 3 sources

                    while (in.hasNext()) {
                        if (in.next() != 1) continue;
                        if (!"report".equals(in.getLocalName())) {
                            var4_7 = false;
                            break block17;
                        }
                        ** GOTO lbl-1000
                    }
                    break block18;
                }
                catch (Throwable var3_5) {
                    CoverageIOUtil.close(is);
                    if (in == null) return false;
                    try {
                        in.close();
                        return false;
                    }
                    catch (XMLStreamException var3_6) {
                        return false;
                    }
                }
                catch (Throwable var6_11) {
                    CoverageIOUtil.close(is);
                    if (in == null) throw var6_11;
                    try {
                        in.close();
                        throw var6_11;
                    }
                    catch (XMLStreamException var7_12) {
                        // empty catch block
                    }
                    throw var6_11;
                }
            }
            CoverageIOUtil.close(is);
            if (in == null) return var4_7;
            try {
                in.close();
                return var4_7;
            }
            catch (XMLStreamException var5_9) {
                // empty catch block
            }
            return var4_7;
lbl-1000:
            // 2 sources

            {
                while (in.hasNext()) {
                    if (in.next() != 1 || !"package".equals(in.getLocalName()) || in.getAttributeCount() < 1 || !"name".equals(in.getAttributeLocalName(0))) continue;
                    var4_8 = true;
                }
                ** GOTO lbl7
            }
            {
                CoverageIOUtil.close(is);
                if (in == null) return var4_8;
                try {
                    in.close();
                    return var4_8;
                }
                catch (XMLStreamException var5_10) {
                    // empty catch block
                }
                return var4_8;
                break;
            }
        }
        CoverageIOUtil.close(is);
        if (in == null) return false;
        try {
            in.close();
            return false;
        }
        catch (XMLStreamException var3_4) {
            return false;
        }
    }

    public XMLProjectData read(InputStream fIn) throws IOException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLProjectData report = new XMLProjectData();
        try {
            this.myIn = factory.createXMLStreamReader(new BufferedInputStream(fIn));
            while (this.myIn.hasNext()) {
                String name;
                int event = this.myIn.next();
                if (event != 1 || !REPORT_TAG.equals(name = this.myIn.getLocalName())) continue;
                this.readProject(report);
            }
            XMLProjectData event = report;
            return event;
        }
        catch (XMLStreamException e) {
            throw this.wrapIOException(e);
        }
        finally {
            if (this.myIn != null) {
                try {
                    this.myIn.close();
                }
                catch (XMLStreamException xMLStreamException) {}
                this.myIn = null;
            }
            fIn.close();
        }
    }

    private void readProject(XMLProjectData report) throws XMLStreamException {
        while (this.myIn.hasNext()) {
            String name;
            int event = this.myIn.next();
            if (event != 1 || !PACKAGE_TAG.equals(name = this.myIn.getLocalName()) || this.myIn.getAttributeCount() < 1 || !NAME_TAG.equals(this.myIn.getAttributeLocalName(0))) continue;
            String packageName = this.myIn.getAttributeValue(0);
            this.readPackage(report, packageName);
        }
    }

    private void readPackage(XMLProjectData report, String packageName) throws XMLStreamException {
        while (this.myIn.hasNext()) {
            int event = this.myIn.next();
            if (event == 1) {
                String fileName;
                String name = this.myIn.getLocalName();
                if (CLASS_TAG.equals(name)) {
                    String className = this.getAttribute(NAME_TAG);
                    if (className == null) continue;
                    this.readClass(report, ClassNameUtil.convertToFQName(className), this.getAttribute(SOURCEFILE_NAME_TAG));
                    continue;
                }
                if (!SOURCEFILE_TAG.equals(name) || (fileName = this.getAttribute(NAME_TAG)) == null) continue;
                String path = packageName.isEmpty() ? fileName : packageName + "/" + fileName;
                this.readFile(report, path);
                continue;
            }
            if (event != 2 || !PACKAGE_TAG.equals(this.myIn.getLocalName())) continue;
            break;
        }
    }

    private void readFile(XMLProjectData report, String path) throws XMLStreamException {
        XMLProjectData.FileInfo file = new XMLProjectData.FileInfo(path);
        report.addFile(file);
        while (this.myIn.hasNext()) {
            int event = this.myIn.next();
            if (event == 1) {
                String name = this.myIn.getLocalName();
                if (!LINE_TAG.equals(name)) continue;
                int lineNumber = Integer.parseInt(this.getAttribute(LINE_NUMBER_TAG));
                int mi = Integer.parseInt(this.getAttribute(MISSED_INSTRUCTIONS_TAG));
                int ci = Integer.parseInt(this.getAttribute(COVERED_INSTRUCTIONS_TAG));
                int mb = Integer.parseInt(this.getAttribute(MISSED_BRANCHES_TAG));
                int cb = Integer.parseInt(this.getAttribute(COVERED_BRANCHES_TAG));
                XMLProjectData.LineInfo lineInfo = new XMLProjectData.LineInfo(lineNumber, mi, ci, mb, cb);
                file.lines.add(lineInfo);
                continue;
            }
            if (event != 2 || !SOURCEFILE_TAG.equals(this.myIn.getLocalName())) continue;
            break;
        }
    }

    private void readClass(XMLProjectData report, String className, String fileName) throws XMLStreamException {
        int mi = 0;
        int ci = 0;
        int mb = 0;
        int cb = 0;
        int mm = 0;
        int cm = 0;
        int ml = 0;
        int cl = 0;
        while (this.myIn.hasNext()) {
            int event = this.myIn.next();
            if (event == 1) {
                String name = this.myIn.getLocalName();
                if (METHOD_TAG.equals(name)) {
                    this.readMethod();
                    continue;
                }
                if (!COUNTER_TAG.equals(name)) continue;
                String type = this.getAttribute(TYPE_TAG);
                if (LINE_COUNTER.equals(type)) {
                    ml = Integer.parseInt(this.getAttribute(MISSED_TAG));
                    cl = Integer.parseInt(this.getAttribute(COVERED_TAG));
                    continue;
                }
                if (INSTRUCTION_COUNTER.equals(type)) {
                    mi = Integer.parseInt(this.getAttribute(MISSED_TAG));
                    ci = Integer.parseInt(this.getAttribute(COVERED_TAG));
                    continue;
                }
                if (METHOD_COUNTER.equals(type)) {
                    mm = Integer.parseInt(this.getAttribute(MISSED_TAG));
                    cm = Integer.parseInt(this.getAttribute(COVERED_TAG));
                    continue;
                }
                if (!BRANCH_COUNTER.equals(type)) continue;
                mb = Integer.parseInt(this.getAttribute(MISSED_TAG));
                cb = Integer.parseInt(this.getAttribute(COVERED_TAG));
                continue;
            }
            if (event != 2 || !CLASS_TAG.equals(this.myIn.getLocalName())) continue;
            break;
        }
        XMLProjectData.ClassInfo classInfo = new XMLProjectData.ClassInfo(className, fileName, ml, cl, mi, ci, mb, cb, mm, cm);
        report.addClass(classInfo);
    }

    private void readMethod() throws XMLStreamException {
        int event;
        while (this.myIn.hasNext() && ((event = this.myIn.next()) != 2 || !METHOD_TAG.equals(this.myIn.getLocalName()))) {
        }
    }

    private String getAttribute(String attributeName) {
        String value = null;
        for (int i = 0; i < this.myIn.getAttributeCount(); ++i) {
            if (!attributeName.equals(this.myIn.getAttributeLocalName(i))) continue;
            value = this.myIn.getAttributeValue(i);
            break;
        }
        return value;
    }

    public void write(FileOutputStream fOut, ProjectData project) throws IOException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            this.myOut = factory.createXMLStreamWriter(new BufferedOutputStream(fOut));
            this.myFiles.clear();
            this.writeProject(project);
        }
        catch (XMLStreamException e) {
            throw this.wrapIOException(e);
        }
        finally {
            try {
                if (this.myOut != null) {
                    this.myOut.flush();
                    this.myOut.close();
                    this.myOut = null;
                }
                fOut.close();
            }
            catch (XMLStreamException e) {
                ErrorReporter.reportError("Error closing file.", e);
            }
        }
    }

    private void newLine() throws XMLStreamException {
        this.myOut.writeCharacters(NEW_LINE);
    }

    private void writeProject(ProjectData project) throws XMLStreamException {
        this.myOut.writeStartDocument();
        this.newLine();
        this.myOut.writeStartElement(REPORT_TAG);
        this.myOut.writeAttribute(NAME_TAG, IJ_REPORT_NAME);
        this.newLine();
        HashMap<String, List<ClassData>> packages = XMLCoverageReport.mapClassesToPackages(project, true);
        Counter counter = new Counter();
        for (Map.Entry<String, List<ClassData>> packageEntry : packages.entrySet()) {
            String packageName = packageEntry.getKey();
            List<ClassData> classes = packageEntry.getValue();
            Counter packageCounter = this.writePackage(project, packageName, classes);
            counter.add(packageCounter);
        }
        this.writeCounter(counter, 31);
        this.myOut.writeEndElement();
        this.newLine();
        this.myOut.writeEndDocument();
    }

    private Counter writePackage(ProjectData project, String packageName, List<ClassData> classes) throws XMLStreamException {
        this.myOut.writeStartElement(PACKAGE_TAG);
        this.myOut.writeAttribute(NAME_TAG, ClassNameUtil.convertToInternalName(packageName));
        this.newLine();
        this.myFiles.clear();
        Counter counter = new Counter();
        HashMap<LineData, Counter> lineCounters = new HashMap<LineData, Counter>();
        for (ClassData classData : classes) {
            Counter classCounter = this.writeClass(project, classData, lineCounters);
            counter.add(classCounter);
        }
        for (Map.Entry entry : this.myFiles.entrySet()) {
            this.writeFile((String)entry.getKey(), (List)entry.getValue(), lineCounters);
        }
        this.writeCounter(counter, 31);
        this.myOut.writeEndElement();
        this.newLine();
        return counter;
    }

    private void writeFile(String fileName, List<LineData> lines, Map<LineData, Counter> lineCounters) throws XMLStreamException {
        this.myOut.writeStartElement(SOURCEFILE_TAG);
        this.myOut.writeAttribute(NAME_TAG, fileName);
        this.newLine();
        TIntObjectHashMap<Counter> groupedLines = new TIntObjectHashMap<Counter>();
        for (LineData lineData : lines) {
            Counter counter;
            if (lineData == null) continue;
            int lineNumber = lineData.getLineNumber();
            Object lineCounter = (Counter)groupedLines.get(lineNumber);
            if (lineCounter == null) {
                lineCounter = new Counter();
                groupedLines.put(lineNumber, (Counter)lineCounter);
            }
            if ((counter = lineCounters.get(lineData)) == null) continue;
            ((Counter)lineCounter).add(counter);
        }
        final ArrayList groupedLinesList = new ArrayList();
        groupedLines.forEachEntry(new TIntObjectProcedure<Counter>(){

            @Override
            public boolean execute(int lineNumber, Counter counter) {
                groupedLinesList.add(new LineCounter(lineNumber, counter));
                return true;
            }
        });
        Collections.sort(groupedLinesList, new Comparator<LineCounter>(){

            @Override
            public int compare(LineCounter o1, LineCounter o2) {
                return o1.line - o2.line;
            }
        });
        Counter counter = new Counter();
        for (Object lineCounter : groupedLinesList) {
            this.writeLine(((LineCounter)lineCounter).counter, ((LineCounter)lineCounter).line);
            counter.add(((LineCounter)lineCounter).counter);
        }
        this.writeCounter(counter, 19);
        this.myOut.writeEndElement();
        this.newLine();
    }

    private Counter writeClass(ProjectData project, ClassData classData, Map<LineData, Counter> lineCounters) throws XMLStreamException {
        ClassInstructions classInstructions = project.getInstructions().get(classData.getName());
        this.myOut.writeStartElement(CLASS_TAG);
        String className = ClassNameUtil.convertToInternalName(classData.getName());
        this.myOut.writeAttribute(NAME_TAG, className);
        String sourceName = classData.getSource();
        if (sourceName != null && !sourceName.isEmpty()) {
            LineData[] linesArray;
            this.myOut.writeAttribute(SOURCEFILE_NAME_TAG, sourceName);
            this.newLine();
            List<LineData> lines = this.myFiles.get(sourceName);
            if (lines == null) {
                lines = new ArrayList<LineData>();
                this.myFiles.put(sourceName, lines);
            }
            if ((linesArray = (LineData[])classData.getLines()) != null) {
                for (LineData line : linesArray) {
                    if (line == null) continue;
                    lines.add(line);
                }
            }
        } else {
            this.newLine();
        }
        Counter counter = new Counter();
        Map<String, List<LineData>> methods = classData.mapLinesToMethods();
        for (Map.Entry<String, List<LineData>> methodEntry : methods.entrySet()) {
            Counter methodCounter = this.writeMethod(classInstructions, methodEntry.getKey(), methodEntry.getValue(), lineCounters);
            counter.add(methodCounter);
        }
        counter.totalClasses = 1;
        if (counter.coveredMethods > 0) {
            counter.coveredClasses = 1;
        }
        this.writeCounter(counter, 23);
        this.myOut.writeEndElement();
        this.newLine();
        return counter;
    }

    private Counter writeMethod(ClassInstructions classInstructions, String signature, List<LineData> lines, Map<LineData, Counter> lineCounters) throws XMLStreamException {
        this.myOut.writeStartElement(METHOD_TAG);
        int nameIndex = signature.indexOf(40);
        String name = signature.substring(0, nameIndex);
        String descriptor = signature.substring(nameIndex);
        this.myOut.writeAttribute(NAME_TAG, name);
        this.myOut.writeAttribute(DESC_TAG, descriptor);
        this.newLine();
        Counter counter = new Counter();
        LineInstructions[] instructions = classInstructions == null ? null : classInstructions.getlines();
        for (LineData lineData : lines) {
            if (lineData == null) continue;
            LineInstructions lineInstructions = ArrayUtil.safeLoad(instructions, lineData.getLineNumber());
            Counter lineCounter = this.getLineCounter(lineInstructions, lineData);
            lineCounters.put(lineData, lineCounter);
            counter.add(lineCounter);
        }
        counter.totalMethods = 1;
        if (counter.coveredLines > 0) {
            counter.coveredMethods = 1;
        }
        this.writeCounter(counter, 19);
        this.myOut.writeEndElement();
        this.newLine();
        return counter;
    }

    private void writeLine(Counter counter, int lineNumber) throws XMLStreamException {
        this.myOut.writeEmptyElement(LINE_TAG);
        this.myOut.writeAttribute(LINE_NUMBER_TAG, Integer.toString(lineNumber));
        this.myOut.writeAttribute(MISSED_INSTRUCTIONS_TAG, Integer.toString(counter.totalInstructions - counter.coveredInstructions));
        this.myOut.writeAttribute(COVERED_INSTRUCTIONS_TAG, Integer.toString(counter.coveredInstructions));
        this.myOut.writeAttribute(MISSED_BRANCHES_TAG, Integer.toString(counter.totalBranches - counter.coveredBranches));
        this.myOut.writeAttribute(COVERED_BRANCHES_TAG, Integer.toString(counter.coveredBranches));
        this.newLine();
    }

    private Counter getLineCounter(LineInstructions lineInstructions, LineData lineData) {
        Counter counter = new Counter();
        counter.totalLines = 1;
        counter.coveredLines = lineData.getHits() > 0 ? 1 : 0;
        BranchData branchData = lineData.getBranchData();
        counter.totalBranches = branchData == null ? 0 : branchData.getTotalBranches();
        int n = counter.coveredBranches = branchData == null ? 0 : branchData.getCoveredBranches();
        if (lineInstructions != null) {
            BranchData instructionsData = lineInstructions.getInstructionsData(lineData);
            counter.totalInstructions = instructionsData.getTotalBranches();
            counter.coveredInstructions = instructionsData.getCoveredBranches();
        } else {
            counter.totalInstructions = 1;
            counter.coveredInstructions = counter.coveredLines;
        }
        return counter;
    }

    private void writeCounter(Counter counter, int mask) throws XMLStreamException {
        if ((mask & 0x10) != 0) {
            this.writeCounter(INSTRUCTION_COUNTER, counter.totalInstructions, counter.coveredInstructions);
        }
        if ((mask & 2) != 0) {
            this.writeCounter(BRANCH_COUNTER, counter.totalBranches, counter.coveredBranches);
        }
        if ((mask & 1) != 0) {
            this.writeCounter(LINE_COUNTER, counter.totalLines, counter.coveredLines);
        }
        if ((mask & 4) != 0) {
            this.writeCounter(METHOD_COUNTER, counter.totalMethods, counter.coveredMethods);
        }
        if ((mask & 8) != 0) {
            this.writeCounter(CLASS_COUNTER, counter.totalClasses, counter.coveredClasses);
        }
    }

    private void writeCounter(String type, int total, int covered) throws XMLStreamException {
        this.myOut.writeEmptyElement(COUNTER_TAG);
        this.myOut.writeAttribute(TYPE_TAG, type);
        this.myOut.writeAttribute(MISSED_TAG, Integer.toString(total - covered));
        this.myOut.writeAttribute(COVERED_TAG, Integer.toString(covered));
        this.newLine();
    }

    private static boolean shouldIncludeClass(ClassData classData) {
        Object[] lines = classData.getLines();
        if (lines == null) {
            return false;
        }
        for (Object line : lines) {
            if (line == null) continue;
            return true;
        }
        return false;
    }

    public static HashMap<String, List<ClassData>> mapClassesToPackages(ProjectData project, boolean useClassNameIfEmpty) {
        HashMap<String, List<ClassData>> packages = new HashMap<String, List<ClassData>>();
        ArrayList<ClassData> classes = new ArrayList<ClassData>(project.getClassesCollection());
        Collections.sort(classes, new Comparator<ClassData>(){

            @Override
            public int compare(ClassData o1, ClassData o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (ClassData classData : classes) {
            if (!XMLCoverageReport.shouldIncludeClass(classData)) continue;
            String className = classData.getName();
            int indexOfName = className.lastIndexOf(46);
            String packageName = indexOfName < 0 ? (useClassNameIfEmpty ? className : "") : className.substring(0, indexOfName);
            List<ClassData> packageClasses = packages.get(packageName);
            if (!packages.containsKey(packageName)) {
                packageClasses = new ArrayList<ClassData>();
                packages.put(packageName, packageClasses);
            }
            packageClasses.add(classData);
        }
        return packages;
    }

    private IOException wrapIOException(Throwable t) {
        IOException e = new IOException(t.getClass().getSimpleName() + ": " + t.getMessage());
        e.setStackTrace(t.getStackTrace());
        return e;
    }

    private static class LineCounter {
        private final int line;
        private final Counter counter;

        private LineCounter(int line, Counter counter) {
            this.line = line;
            this.counter = counter;
        }
    }

    private static class Counter {
        public int totalClasses;
        public int coveredClasses;
        public int totalMethods;
        public int coveredMethods;
        public int totalLines;
        public int coveredLines;
        public int totalInstructions;
        public int coveredInstructions;
        public int coveredBranches;
        public int totalBranches;

        private Counter() {
        }

        public void add(Counter other) {
            this.totalClasses += other.totalClasses;
            this.coveredClasses += other.coveredClasses;
            this.totalMethods += other.totalMethods;
            this.coveredMethods += other.coveredMethods;
            this.totalLines += other.totalLines;
            this.coveredLines += other.coveredLines;
            this.totalBranches += other.totalBranches;
            this.coveredBranches += other.coveredBranches;
            this.totalInstructions += other.totalInstructions;
            this.coveredInstructions += other.coveredInstructions;
        }
    }
}

