/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.testFramework.io;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.AssumptionViolatedException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/testFramework/io/ExternalResourcesChecker;", "", "()V", "reportUnavailability", "T", "resourceName", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)Ljava/lang/Object;", "ExternalResourceNotAvailableException", "intellij.platform.testFramework"})
public final class ExternalResourcesChecker {
    @NotNull
    public static final ExternalResourcesChecker INSTANCE = new ExternalResourcesChecker();

    private ExternalResourcesChecker() {
    }

    @JvmStatic
    @Contract(value="_, _ -> fail")
    public static final <T> T reportUnavailability(@NotNull String resourceName, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        String message = "Resource '" + resourceName + "' is not available";
        if (cause != null) {
            throw new ExternalResourceNotAvailableException(message, cause);
        }
        throw new ExternalResourceNotAvailableException(message);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/testFramework/io/ExternalResourcesChecker$ExternalResourceNotAvailableException;", "Lorg/junit/AssumptionViolatedException;", "message", "", "(Ljava/lang/String;)V", "t", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "intellij.platform.testFramework"})
    private static final class ExternalResourceNotAvailableException
    extends AssumptionViolatedException {
        public ExternalResourceNotAvailableException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }

        public ExternalResourceNotAvailableException(@NotNull String message, @NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            super(message, t);
        }
    }
}

