/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security;

import io.ktor.client.HttpClient;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.HttpRequestKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpStatement;
import io.ktor.client.utils.EmptyContent;
import io.ktor.http.ContentType;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMessagePropertiesKt;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.HttpStatusCodeKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.TypesJVMKt;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.ClientData;
import org.jetbrains.security.HttpUtilKt;
import org.jetbrains.security.RemoteConfig;
import org.jetbrains.security.ResourceUrl;
import org.jetbrains.security.VulnerabilitiesRepository;
import org.jetbrains.security.VulnerabilitiesRepositoryServer;
import org.jetbrains.security.VulnerablePackage;
import org.jetbrains.security.dto.FalsePositiveReport;
import org.jetbrains.security.dto.HashesDto;
import org.jetbrains.security.dto.RequestDto;
import org.jetbrains.security.dto.VulnerablePackageDto;
import org.jetbrains.security.exceptions.AnalysisException;
import org.jetbrains.security.exceptions.AnalysisExceptionScope;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.problems.vulnerabilities.Vulnerability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001BI\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J%\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\u0006\u0010\u001e\u001a\u00020\u0014H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ!\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006&"}, d2={"Lorg/jetbrains/security/VulnerabilitiesRepositoryServer;", "Lorg/jetbrains/security/VulnerabilitiesRepository;", "httpClient", "Lio/ktor/client/HttpClient;", "dbBaseUrl", "Lorg/jetbrains/security/ResourceUrl;", "packagesUrlString", "", "falsePositiveUrl", "userAgent", "attemptsToCheck", "", "clientData", "Lorg/jetbrains/security/ClientData;", "(Lio/ktor/client/HttpClient;Lorg/jetbrains/security/ResourceUrl;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILorg/jetbrains/security/ClientData;)V", "chunkSize", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createRequestDto", "Lorg/jetbrains/security/dto/RequestDto;", "packageChunk", "", "Lorg/jetbrains/security/package/Package;", "getVulnerabilities", "Lorg/jetbrains/security/VulnerablePackage;", "pkgs", "", "(Ljava/lang/Iterable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getVulnerabilitiesFromServer", "requestData", "(Lorg/jetbrains/security/dto/RequestDto;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reportFalsePositive", "", "pkg", "vulnerability", "Lorg/jetbrains/security/problems/vulnerabilities/Vulnerability;", "(Lorg/jetbrains/security/package/Package;Lorg/jetbrains/security/problems/vulnerabilities/Vulnerability;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "client"})
public class VulnerabilitiesRepositoryServer
implements VulnerabilitiesRepository {
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final ResourceUrl dbBaseUrl;
    @NotNull
    private final String packagesUrlString;
    @NotNull
    private final String falsePositiveUrl;
    @NotNull
    private final String userAgent;
    private final int attemptsToCheck;
    @NotNull
    private final ClientData clientData;
    private final int chunkSize;
    private final Logger logger;

    public VulnerabilitiesRepositoryServer(@NotNull HttpClient httpClient2, @NotNull ResourceUrl dbBaseUrl, @NotNull String packagesUrlString, @NotNull String falsePositiveUrl, @NotNull String userAgent, int attemptsToCheck, @NotNull ClientData clientData) {
        Intrinsics.checkNotNullParameter((Object)httpClient2, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)dbBaseUrl, (String)"dbBaseUrl");
        Intrinsics.checkNotNullParameter((Object)packagesUrlString, (String)"packagesUrlString");
        Intrinsics.checkNotNullParameter((Object)falsePositiveUrl, (String)"falsePositiveUrl");
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        Intrinsics.checkNotNullParameter((Object)clientData, (String)"clientData");
        this.httpClient = httpClient2;
        this.dbBaseUrl = dbBaseUrl;
        this.packagesUrlString = packagesUrlString;
        this.falsePositiveUrl = falsePositiveUrl;
        this.userAgent = userAgent;
        this.attemptsToCheck = attemptsToCheck;
        this.clientData = clientData;
        this.chunkSize = 4096;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public /* synthetic */ VulnerabilitiesRepositoryServer(HttpClient httpClient2, ResourceUrl resourceUrl, String string, String string2, String string3, int n, ClientData clientData, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            httpClient2 = HttpUtilKt.ktorHttpClient();
        }
        if ((n2 & 2) != 0) {
            resourceUrl = RemoteConfig.INSTANCE.getDefaultDbUrl();
        }
        if ((n2 & 4) != 0) {
            string = "/api/v3/vulnerabilities/cx";
        }
        if ((n2 & 8) != 0) {
            string2 = "/report";
        }
        if ((n2 & 0x10) != 0) {
            string3 = "JetBrains Vulnerability Scanner";
        }
        if ((n2 & 0x20) != 0) {
            n = 3;
        }
        this(httpClient2, resourceUrl, string, string2, string3, n, clientData);
    }

    @Override
    @Nullable
    public Object getVulnerabilities(@NotNull Iterable<Package> pkgs2, @NotNull Continuation<? super List<VulnerablePackage>> $completion) {
        return VulnerabilitiesRepositoryServer.getVulnerabilities$suspendImpl(this, pkgs2, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object getVulnerabilities$suspendImpl(VulnerabilitiesRepositoryServer var0, Iterable var1_1, Continuation var2_2) {
        block19: {
            block18: {
                if (!(var2_2 instanceof getVulnerabilities.1)) ** GOTO lbl-1000
                var17_3 = var2_2;
                if ((var17_3.label & -2147483648) != 0) {
                    var17_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(var0, (Continuation<? super getVulnerabilities.1>)var2_2){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        int I$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ VulnerabilitiesRepositoryServer this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return VulnerabilitiesRepositoryServer.getVulnerabilities$suspendImpl(this.this$0, null, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block2 : switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = var3_6 = this.attemptsToCheck > 0;
                        if (!var3_6) {
                            var4_8 = false;
                            var4_9 = "Failed requirement.";
                            throw new IllegalArgumentException(var4_9.toString());
                        }
                        $this$flatMap$iv = CollectionsKt.chunked((Iterable)pkgs, (int)this.chunkSize);
                        $i$f$flatMap = false;
                        var5_11 = $this$flatMap$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$flatMapTo = false;
                        var8_14 = $this$flatMapTo$iv$iv.iterator();
lbl23:
                        // 2 sources

                        while (var8_14.hasNext()) {
                            element$iv$iv = var8_14.next();
                            pkgChunk = (List)element$iv$iv;
                            $i$a$-flatMap-VulnerabilitiesRepositoryServer$getVulnerabilities$2 = false;
                            attempt = 0;
                            exception = null;
lbl29:
                            // 3 sources

                            while (attempt <= this.attemptsToCheck) {
                                ++attempt;
                                if (pkgChunk.isEmpty()) {
                                    v1 = CollectionsKt.emptyList();
                                    break block18;
                                }
                                $continuation.L$0 = this;
                                $continuation.L$1 = destination$iv$iv;
                                $continuation.L$2 = var8_14;
                                $continuation.L$3 = pkgChunk;
                                $continuation.L$4 = null;
                                $continuation.I$0 = attempt;
                                $continuation.label = 1;
                                v2 = this.getVulnerabilitiesFromServer(this.createRequestDto(pkgChunk), (Continuation<? super List<VulnerablePackage>>)$continuation);
                                ** if (v2 != var18_5) goto lbl46
lbl45:
                                // 1 sources

                                return var18_5;
lbl46:
                                // 1 sources

                                ** GOTO lbl62
                            }
                            break block2;
                        }
                        break block19;
                    }
                    case 1: {
                        $i$f$flatMap = false;
                        $i$f$flatMapTo = false;
                        $i$a$-flatMap-VulnerabilitiesRepositoryServer$getVulnerabilities$2 = false;
                        var12_18 = $continuation.I$0;
                        pkgChunk = (List)$continuation.L$3;
                        var8_14 = (Iterator<T>)$continuation.L$2;
                        var6_12 = (Collection)$continuation.L$1;
                        var0 = (VulnerabilitiesRepositoryServer)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl62:
                            // 2 sources

                            v1 = (List)v2;
                            break block18;
                        }
                        catch (IOException io) {
                            var0.logger.warn(Intrinsics.stringPlus((String)"Failed to check dependencies on server : ", (Object)var0.dbBaseUrl.getUrl()), (Throwable)io);
                            var15_24 = io.getMessage();
                            exception = new AnalysisException("Fail to check dependencies on server", AnalysisExceptionScope.USER, var15_24 == null ? "IOException" : var15_24);
                        }
                        catch (IllegalArgumentException ia) {
                            var0.logger.warn(Intrinsics.stringPlus((String)"Failed to check dependencies on server : ", (Object)var0.dbBaseUrl.getUrl()), (Throwable)ia);
                            var15_24 = ia.getMessage();
                            exception = new AnalysisException(Intrinsics.stringPlus((String)"Failed to check dependencies on server : ", (Object)var0.dbBaseUrl.getUrl()), AnalysisExceptionScope.USER, var15_24 == null ? "IllegalArgumentException" : var15_24);
                        }
                        catch (AnalysisException e) {
                            var0.logger.error("SERVER failed with exception");
                            exception = e;
                        }
                        $continuation.L$0 = var0;
                        $continuation.L$1 = var6_12;
                        $continuation.L$2 = var8_14;
                        $continuation.L$3 = pkgChunk;
                        $continuation.L$4 = exception;
                        $continuation.I$0 = var12_18;
                        $continuation.label = 2;
                        v3 = DelayKt.delay((long)(var12_18 * 200), (Continuation)$continuation);
                        if (v3 != var18_5) ** GOTO lbl29
                        return var18_5;
                    }
                    case 2: {
                        $i$f$flatMap = false;
                        $i$f$flatMapTo = false;
                        $i$a$-flatMap-VulnerabilitiesRepositoryServer$getVulnerabilities$2 = false;
                        var12_18 = $continuation.I$0;
                        var13_19 = (AnalysisException)$continuation.L$4;
                        pkgChunk = (List)$continuation.L$3;
                        var8_14 = (Iterator)$continuation.L$2;
                        var6_12 = (Collection)$continuation.L$1;
                        var0 = (VulnerabilitiesRepositoryServer)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        ** GOTO lbl29
                    }
                }
                if (var13_19 != null) {
                    var0.logger.error(var13_19.getStackTrace().toString());
                    var0.httpClient.close();
                    throw var13_19;
                }
                var0.httpClient.close();
                v1 = CollectionsKt.emptyList();
            }
            list$iv$iv = v1;
            CollectionsKt.addAll((Collection)var6_12, (Iterable)list$iv$iv);
            ** GOTO lbl23
        }
        return (List)var6_12;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public RequestDto createRequestDto(@NotNull List<Package> packageChunk) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(packageChunk, (String)"packageChunk");
        Iterable $this$map$iv = packageChunk;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Package package_ = (Package)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getSearchKey();
            collection.add(string);
        }
        List packageDtos = (List)destination$iv$iv;
        return new HashesDto(packageDtos, this.clientData.getAnonymousToken(), this.clientData.getApplicationMode());
    }

    @Override
    @Nullable
    public Object reportFalsePositive(@NotNull Package pkg, @NotNull Vulnerability vulnerability, @NotNull Continuation<? super Unit> $completion) {
        return VulnerabilitiesRepositoryServer.reportFalsePositive$suspendImpl(this, pkg, vulnerability, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object reportFalsePositive$suspendImpl(VulnerabilitiesRepositoryServer var0, Package var1_1, Vulnerability var2_2, Continuation var3_3) {
        if (!(var3_3 instanceof reportFalsePositive.1)) ** GOTO lbl-1000
        var27_4 = var3_3;
        if ((var27_4.label & -2147483648) != 0) {
            var27_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, (Continuation<? super reportFalsePositive.1>)var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ VulnerabilitiesRepositoryServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VulnerabilitiesRepositoryServer.reportFalsePositive$suspendImpl(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var28_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                falsePositiveReport = new FalsePositiveReport(vulnerability.getCve(), pkg.getSearchKey(), this.clientData.getAnonymousToken());
                var6_8 = this.httpClient;
                urlString$iv = Intrinsics.stringPlus((String)this.dbBaseUrl.getUrl(), (Object)this.falsePositiveUrl);
                $i$f$post = false;
                $this$post$iv$iv = $this$post$iv;
                $i$f$post = false;
                var11_15 = $this$post$iv$iv;
                $this$post_u24lambda_u2d5$iv = var12_16 = new HttpRequestBuilder();
                $i$a$-post-BuildersKt$post$5$iv = false;
                HttpRequestKt.url((HttpRequestBuilder)$this$post_u24lambda_u2d5$iv, (String)urlString$iv);
                $this$reportFalsePositive_u24lambda_u2d2 = $this$post_u24lambda_u2d5$iv;
                $i$a$-post-VulnerabilitiesRepositoryServer$reportFalsePositive$response$1 = false;
                $this$setBody$iv = $this$reportFalsePositive_u24lambda_u2d2;
                $i$f$setBody = false;
                var19_23 = falsePositiveReport;
                if (var19_23 instanceof OutgoingContent) {
                    $this$setBody$iv.setBody((Object)falsePositiveReport);
                    $this$setBody$iv.setBodyType(null);
                } else {
                    $this$setBody$iv.setBody((Object)falsePositiveReport);
                    $i$f$typeInfo = false;
                    kType$iv$iv = Reflection.typeOf(FalsePositiveReport.class);
                    reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                    $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(FalsePositiveReport.class), (KType)kType$iv$iv));
                }
                HttpMessagePropertiesKt.userAgent((HttpMessageBuilder)((HttpMessageBuilder)$this$reportFalsePositive_u24lambda_u2d2), (String)this.userAgent);
                HttpMessagePropertiesKt.contentType((HttpMessageBuilder)((HttpMessageBuilder)$this$reportFalsePositive_u24lambda_u2d2), (ContentType)ContentType.Application.INSTANCE.getJson());
                builder$iv$iv$iv = var12_16;
                $i$f$post = false;
                builder$iv$iv$iv.setMethod(HttpMethod.Companion.getPost());
                $this$request$iv$iv$iv$iv = $this$post$iv$iv$iv;
                $i$f$request = false;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)$continuation);
                if (v0 == var28_6) {
                    return var28_6;
                }
                ** GOTO lbl61
            }
            case 1: {
                $i$f$post = false;
                $i$f$post = false;
                $i$f$post = false;
                $i$f$request = false;
                var0 = (VulnerabilitiesRepositoryServer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl61:
                // 2 sources

                response = (HttpResponse)v0;
                if (!HttpStatusCodeKt.isSuccess((HttpStatusCode)response.getStatus())) {
                    var0.logger.warn(Intrinsics.stringPlus((String)"error during reporting FP, errorCode: ", (Object)response.getStatus()));
                }
                var0.httpClient.close();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object getVulnerabilitiesFromServer(RequestDto var1_1, Continuation<? super List<VulnerablePackage>> var2_2) {
        if (!(var2_2 instanceof getVulnerabilitiesFromServer.1)) ** GOTO lbl-1000
        var27_3 = var2_2;
        if ((var27_3.label & -2147483648) != 0) {
            var27_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ VulnerabilitiesRepositoryServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VulnerabilitiesRepositoryServer.access$getVulnerabilitiesFromServer(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var28_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_6 = this.httpClient;
                urlString$iv = Intrinsics.stringPlus((String)this.dbBaseUrl.getUrl(), (Object)this.packagesUrlString);
                $i$f$post = false;
                $this$post$iv$iv = $this$post$iv;
                $i$f$post = false;
                var9_16 = $this$post$iv$iv;
                $this$post_u24lambda_u2d5$iv /* !! */  = var10_17 = new HttpRequestBuilder();
                $i$a$-post-BuildersKt$post$5$iv = false;
                HttpRequestKt.url((HttpRequestBuilder)$this$post_u24lambda_u2d5$iv /* !! */ , (String)urlString$iv);
                $this$getVulnerabilitiesFromServer_u24lambda_u2d3 = $this$post_u24lambda_u2d5$iv /* !! */ ;
                $i$a$-post-VulnerabilitiesRepositoryServer$getVulnerabilitiesFromServer$dtos$1 = false;
                $this$setBody$iv = $this$getVulnerabilitiesFromServer_u24lambda_u2d3;
                $i$f$setBody = false;
                var17_24 = requestData;
                if (var17_24 == null) {
                    $this$setBody$iv.setBody((Object)EmptyContent.INSTANCE);
                    $this$setBody$iv.setBodyType(null);
                } else if (var17_24 instanceof OutgoingContent) {
                    $this$setBody$iv.setBody((Object)requestData);
                    $this$setBody$iv.setBodyType(null);
                } else {
                    $this$setBody$iv.setBody((Object)requestData);
                    $i$f$typeInfo = false;
                    kType$iv$iv = Reflection.typeOf(RequestDto.class);
                    reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                    $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(RequestDto.class), (KType)kType$iv$iv));
                }
                HttpMessagePropertiesKt.userAgent((HttpMessageBuilder)((HttpMessageBuilder)$this$getVulnerabilitiesFromServer_u24lambda_u2d3), (String)this.userAgent);
                HttpMessagePropertiesKt.contentType((HttpMessageBuilder)((HttpMessageBuilder)$this$getVulnerabilitiesFromServer_u24lambda_u2d3), (ContentType)ContentType.Application.INSTANCE.getJson());
                HttpRequestKt.headers((HttpMessageBuilder)((HttpMessageBuilder)$this$getVulnerabilitiesFromServer_u24lambda_u2d3), (Function1)((Function1)new Function1<HeadersBuilder, Unit>(this){
                    final /* synthetic */ VulnerabilitiesRepositoryServer this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull HeadersBuilder $this$headers) {
                        Intrinsics.checkNotNullParameter((Object)$this$headers, (String)"$this$headers");
                        String string = VulnerabilitiesRepositoryServer.access$getClientData$p(this.this$0).getJbaUserId();
                        $this$headers.append("uid", string == null ? VulnerabilitiesRepositoryServer.access$getClientData$p(this.this$0).getAnonymousToken() : string);
                    }
                }));
                builder$iv$iv$iv = var10_17;
                $i$f$post = false;
                builder$iv$iv$iv.setMethod(HttpMethod.Companion.getPost());
                $this$request$iv$iv$iv$iv = $this$post$iv$iv$iv;
                $i$f$request = false;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = new HttpStatement(builder$iv$iv$iv, (HttpClient)$this$request$iv$iv$iv$iv).execute((Continuation)$continuation);
                ** if (v0 != var28_5) goto lbl57
lbl56:
                // 1 sources

                return var28_5;
lbl57:
                // 1 sources

                ** GOTO lbl70
            }
            case 1: {
                $i$f$post = false;
                $i$f$post = false;
                $i$f$post = false;
                $i$f$request = false;
                this = (VulnerabilitiesRepositoryServer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl70:
                // 2 sources

                $this$body$iv = (HttpResponse)v0;
                $i$f$body = false;
                $i$f$typeInfo = false;
                kType$iv$iv = Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(VulnerablePackageDto.class)));
                reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                $continuation.L$0 = this;
                $continuation.label = 2;
                v1 = $this$body$iv.getCall().body(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(List.class), (KType)kType$iv$iv), (Continuation)$continuation);
                ** if (v1 != var28_5) goto lbl80
lbl79:
                // 1 sources

                return var28_5;
lbl80:
                // 1 sources

                ** GOTO lbl88
            }
            case 2: {
                $i$f$body = false;
                this = (VulnerabilitiesRepositoryServer)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl88:
                    // 2 sources

                    if (v1 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.security.dto.VulnerablePackageDto>");
                    }
                    dtos = (List)v1;
                    $this$map$iv = dtos;
                    $i$f$map = false;
                    $i$f$typeInfo = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        $this$post_u24lambda_u2d5$iv /* !! */  = (VulnerablePackageDto)item$iv$iv;
                        var24_32 = destination$iv$iv;
                        $i$a$-map-VulnerabilitiesRepositoryServer$getVulnerabilitiesFromServer$2 = false;
                        var25_33 = it.toVulnerablePackage();
                        var24_32.add(var25_33);
                    }
                    var3_31 = (List)destination$iv$iv;
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected server error", (Throwable)e);
                    throw new AnalysisException("Fail to check packages on server", AnalysisExceptionScope.USER, null, 4, null);
                }
                return var3_31;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$getVulnerabilitiesFromServer(VulnerabilitiesRepositoryServer $this, RequestDto requestData, Continuation $completion) {
        return $this.getVulnerabilitiesFromServer(requestData, (Continuation<? super List<VulnerablePackage>>)$completion);
    }

    public static final /* synthetic */ ClientData access$getClientData$p(VulnerabilitiesRepositoryServer $this) {
        return $this.clientData;
    }
}

