/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.ui.visualization;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.ui.visualization.HidingMouseListener;
import org.jetbrains.plugins.notebooks.ui.visualization.JupyterCellBorderButton;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J!\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010 R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/notebooks/ui/visualization/NotebookAboveCellDelimiterPanel;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)V", "actions", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lkotlin/collections/ArrayList;", "getActions", "()Ljava/util/ArrayList;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "isCodeCell", "", "()Z", "setCodeCell", "(Z)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/Nullable;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createCellDelimiterPanel", "backgroundColor", "Ljava/awt/Color;", "cellRoofColor", "getHeight", "", "initialize", "", "", "([Lcom/intellij/openapi/actionSystem/AnAction;Z)V", "intellij.notebooks.ui"})
@SourceDebugExtension(value={"SMAP\nNotebookAboveCellDelimiterPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookAboveCellDelimiterPanel.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookAboveCellDelimiterPanel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,98:1\n1282#2,2:99\n1#3:101\n37#4,2:102\n*S KotlinDebug\n*F\n+ 1 NotebookAboveCellDelimiterPanel.kt\norg/jetbrains/plugins/notebooks/ui/visualization/NotebookAboveCellDelimiterPanel\n*L\n64#1:99,2\n65#1:102,2\n*E\n"})
public final class NotebookAboveCellDelimiterPanel
extends JPanel {
    @NotNull
    private final Editor editor;
    @NotNull
    private final ArrayList<AnAction> actions;
    private boolean isCodeCell;

    public NotebookAboveCellDelimiterPanel(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(new GridBagLayout());
        this.editor = editor;
        this.actions = new ArrayList();
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final ArrayList<AnAction> getActions() {
        return this.actions;
    }

    public final boolean isCodeCell() {
        return this.isCodeCell;
    }

    public final void setCodeCell(boolean bl) {
        this.isCodeCell = bl;
    }

    public final void initialize(@NotNull AnAction[] actions2, boolean isCodeCell) {
        Object object;
        List buttons;
        block6: {
            Color color;
            Intrinsics.checkNotNullParameter((Object)actions2, (String)"actions");
            CollectionsKt.addAll((Collection)this.actions, (Object[])actions2);
            this.isCodeCell = isCodeCell;
            Color color2 = this.editor.getColorsScheme().getDefaultBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"editor.colorsScheme.defaultBackground");
            Color backgroundColor = color2;
            if (isCodeCell) {
                NotebookEditorAppearance notebookEditorAppearance = NotebookUtilKt.getNotebookAppearance(this.editor);
                EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
                Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
                color = notebookEditorAppearance.getCodeCellBackground(editorColorsScheme);
            } else {
                color = backgroundColor;
            }
            Color cellRoofColor = color;
            JPanel leftPanel = this.createCellDelimiterPanel(backgroundColor, cellRoofColor);
            JPanel rightPanel = this.createCellDelimiterPanel(backgroundColor, cellRoofColor);
            JLayeredPane centerPanel = new JLayeredPane();
            JPanel delimiterPanel = new JPanel();
            delimiterPanel.setBackground(backgroundColor);
            centerPanel.add(delimiterPanel);
            JPanel codeRoofPanel = new JPanel();
            codeRoofPanel.setBackground(cellRoofColor);
            centerPanel.add(codeRoofPanel);
            int xOffset = 0;
            buttons = new ArrayList();
            for (AnAction action2 : actions2) {
                Editor editor = this.editor;
                Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
                JupyterCellBorderButton button = new JupyterCellBorderButton((EditorEx)editor, action2);
                button.initialize();
                int width = button.getPreferredSize().width;
                button.setBounds(xOffset, 0, width, NotebookUtilKt.getNotebookAppearance(this.editor).getCELL_BORDER_HEIGHT());
                xOffset += width;
                Component component = button;
                Integer n = JLayeredPane.DEFAULT_LAYER;
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"DEFAULT_LAYER");
                centerPanel.add(component, ((Number)n).intValue());
                buttons.add(button);
            }
            centerPanel.setPreferredSize(new Dimension(xOffset, NotebookUtilKt.getNotebookAppearance(this.editor).getCELL_BORDER_HEIGHT()));
            delimiterPanel.setBounds(0, 0, xOffset, NotebookUtilKt.getNotebookAppearance(this.editor).getCELL_BORDER_HEIGHT() / 2);
            codeRoofPanel.setBounds(0, NotebookUtilKt.getNotebookAppearance(this.editor).getCELL_BORDER_HEIGHT() / 2, xOffset, NotebookUtilKt.getNotebookAppearance(this.editor).getCELL_BORDER_HEIGHT() / 2);
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.fill = 2;
            this.add((Component)leftPanel, c);
            c.weightx = 0.0;
            c.gridx = 1;
            this.add((Component)centerPanel, c);
            c.gridx = 2;
            c.weightx = 1.0;
            this.add((Component)rightPanel, c);
            MouseListener[] mouseListenerArray = this.getMouseListeners();
            Intrinsics.checkNotNullExpressionValue((Object)mouseListenerArray, (String)"mouseListeners");
            Object[] $this$firstOrNull$iv = mouseListenerArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MouseListener it = (MouseListener)element$iv;
                boolean bl = false;
                if (!(it instanceof HidingMouseListener)) continue;
                object = element$iv;
                break block6;
            }
            object = null;
        }
        MouseListener mouseListener2 = (MouseListener)object;
        if (mouseListener2 != null) {
            MouseListener p0 = mouseListener2;
            boolean bl = false;
            this.removeMouseListener(p0);
        }
        Collection $this$toTypedArray$iv = buttons;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        JComponent[] jComponentArray = thisCollection$iv.toArray(new JComponent[0]);
        HidingMouseListener it = new HidingMouseListener(this, Arrays.copyOf(jComponentArray, jComponentArray.length));
        boolean bl = false;
        this.addMouseListener(it);
        for (JComponent button : buttons) {
            button.addMouseListener(it);
        }
    }

    private final JPanel createCellDelimiterPanel(Color backgroundColor, Color cellRoofColor) {
        JPanel result = new JPanel(new BorderLayout());
        JPanel delimiterPanel = new JPanel();
        delimiterPanel.setBackground(backgroundColor);
        delimiterPanel.setPreferredSize(new Dimension(1, 10));
        JPanel roofPanel = new JPanel();
        roofPanel.setBackground(cellRoofColor);
        roofPanel.setPreferredSize(new Dimension(1, 10));
        result.add((Component)delimiterPanel, "North");
        result.add((Component)roofPanel, "South");
        return result;
    }

    @Override
    public int getHeight() {
        return NotebookUtilKt.getNotebookAppearance(this.editor).getCELL_BORDER_HEIGHT();
    }

    @NotNull
    public final Project getProject() {
        Project project = this.editor.getProject();
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"editor.project ?: Projec\u2026Instance().defaultProject");
        return project;
    }
}

