/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProblemConsumer;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.qodana.sarif.model.ArtifactLocation;
import com.jetbrains.qodana.sarif.model.Fix;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.config.FixesStrategy;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.AsyncInspectionToolResultWriter;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.Problem;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaToolResultDatabase;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.XmlProblem;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.globalOutput.GlobalOutputConsumer;
import org.jetbrains.qodana.staticAnalysis.profile.NamedInspectionGroup;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaProfile;
import org.jetbrains.qodana.staticAnalysis.sarif.SarifKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u001c\u0010\u0018\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0012J#\u0010\u0018\u001a\u00020\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001a2\u0006\u0010\u001c\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u001fJ(\u0010\u0018\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010!\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\"H\u0016J\u0014\u0010#\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001aJ(\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaProblemConsumer;", "Lcom/intellij/codeInspection/ex/InspectionProblemConsumer;", "project", "Lcom/intellij/openapi/project/Project;", "database", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase;", "profileState", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$QodanaProfileState;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaToolResultDatabase;Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile$QodanaProfileState;)V", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "Lorg/jetbrains/annotations/NotNull;", "writer", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/AsyncInspectionToolResultWriter;", "buildFixes", "", "Lcom/jetbrains/qodana/sarif/model/Fix;", "fileUri", "", "descriptor", "Lcom/intellij/codeInspection/CommonProblemDescriptor;", "cancel", "", "close", "consume", "elements", "", "Lorg/jdom/Element;", "inspectionId", "problems", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/Problem;", "consume$intellij_qodana", "element", "toolWrapper", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "consumeGlobalOutput", "paths", "Ljava/nio/file/Path;", "getFixes", "location", "Lcom/jetbrains/qodana/sarif/model/ArtifactLocation;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaProblemConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaProblemConsumer.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaProblemConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1549#2:76\n1620#2,3:77\n*S KotlinDebug\n*F\n+ 1 QodanaProblemConsumer.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaProblemConsumer\n*L\n58#1:76\n58#1:77,3\n*E\n"})
public final class QodanaProblemConsumer
implements InspectionProblemConsumer {
    @NotNull
    private final Project project;
    @NotNull
    private final QodanaToolResultDatabase database;
    @NotNull
    private final QodanaProfile.QodanaProfileState profileState;
    @NotNull
    private final PathMacroManager macroManager;
    @NotNull
    private final AsyncInspectionToolResultWriter writer;

    public QodanaProblemConsumer(@NotNull Project project2, @NotNull QodanaToolResultDatabase database, @NotNull QodanaProfile.QodanaProfileState profileState) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)profileState, (String)"profileState");
        this.project = project2;
        this.database = database;
        this.profileState = profileState;
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.project));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(project)");
        this.macroManager = pathMacroManager;
        this.writer = new AsyncInspectionToolResultWriter(this.project, this.database, this.profileState, this.macroManager);
    }

    public void consume(@NotNull Element element2, @NotNull CommonProblemDescriptor descriptor, @NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(toolWrapper, (String)"toolWrapper");
        String fileUri = element2.getChildText("file");
        String string = this.macroManager.collapsePath(fileUri);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"macroManager.collapsePath(fileUri)");
        XmlProblem problem = new XmlProblem(element2, this.buildFixes(string, descriptor));
        List list2 = CollectionsKt.listOf((Object)problem);
        String string2 = toolWrapper.getShortName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toolWrapper.shortName");
        this.consume$intellij_qodana(list2, string2);
    }

    private final Set<Fix> buildFixes(String fileUri, CommonProblemDescriptor descriptor) {
        FixesStrategy fixesStrategy = this.profileState.getMainState().getContext().getConfig().getFixesStrategy();
        if (fixesStrategy == FixesStrategy.NONE || fixesStrategy == FixesStrategy.APPLY || fixesStrategy == FixesStrategy.CLEANUP) {
            return SetsKt.emptySet();
        }
        ArtifactLocation artifactLocation = SarifKt.getArtifactLocation(fileUri);
        if (artifactLocation == null) {
            return SetsKt.emptySet();
        }
        ArtifactLocation artifactLocation2 = artifactLocation;
        return this.getFixes(this.project, descriptor, artifactLocation2);
    }

    private final Set<Fix> getFixes(Project project2, CommonProblemDescriptor descriptor, ArtifactLocation location) {
        ProblemDescriptor problemDescriptor = descriptor instanceof ProblemDescriptor ? (ProblemDescriptor)descriptor : null;
        if (problemDescriptor == null) {
            return SetsKt.emptySet();
        }
        ProblemDescriptor problemDescriptor2 = problemDescriptor;
        return (Set)ActionsKt.runReadAction((Function0)((Function0)new Function0<Set<? extends Fix>>(problemDescriptor2, location, project2){
            final /* synthetic */ ProblemDescriptor $problemDescriptor;
            final /* synthetic */ ArtifactLocation $location;
            final /* synthetic */ Project $project;
            {
                this.$problemDescriptor = $problemDescriptor;
                this.$location = $location;
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final Set<Fix> invoke() {
                return SarifKt.constructFixes(this.$problemDescriptor, this.$location, this.$project);
            }
        }));
    }

    public final void consumeGlobalOutput(@NotNull List<? extends Path> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        GlobalOutputConsumer.Companion.runConsumers$intellij_qodana(this.profileState, paths, this.database, this.project, (Function2<? super List<? extends Problem>, ? super String, Unit>)((Function2)new Function2<List<? extends Problem>, String, Unit>((Object)this){

            public final void invoke(@NotNull List<? extends Problem> p0, @NotNull String p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((QodanaProblemConsumer)this.receiver).consume$intellij_qodana(p0, p1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void consume(@NotNull List<? extends Element> elements, @NotNull String inspectionId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
        Iterable iterable = elements;
        QodanaProblemConsumer qodanaProblemConsumer = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Element element2 = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new XmlProblem((Element)it, null, 2, null));
        }
        qodanaProblemConsumer.consume$intellij_qodana((List)destination$iv$iv, inspectionId);
    }

    public final void consume$intellij_qodana(@NotNull List<? extends Problem> problems2, @NotNull String inspectionId) {
        Intrinsics.checkNotNullParameter(problems2, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
        this.profileState.onReceive(inspectionId, problems2.size());
        NamedInspectionGroup.State state = this.profileState.getStateByInspectionId().get(inspectionId);
        if (state == null) {
            return;
        }
        NamedInspectionGroup.State profileGroupState = state;
        this.writer.batchConsume((Iterable<? extends Problem>)problems2, (Function1<? super Problem, Boolean>)((Function1)new Function1<Problem, Boolean>(profileGroupState, inspectionId){
            final /* synthetic */ NamedInspectionGroup.State $profileGroupState;
            final /* synthetic */ String $inspectionId;
            {
                this.$profileGroupState = $profileGroupState;
                this.$inspectionId = $inspectionId;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Problem problem) {
                Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
                String relativePath = problem.getFile();
                String module2 = problem.getModule();
                return this.$profileGroupState.onConsumeProblem(this.$inspectionId, relativePath, module2);
            }
        }));
    }

    public final void close() {
        this.writer.close();
    }

    public final void cancel() {
        this.writer.cancel();
    }
}

