/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui.problemsView.tree.model.impl;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.problem.SarifProblem;
import org.jetbrains.qodana.ui.problemsView.tree.model.FileNodesChildren;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeEvent;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeExcludeEvent;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeFileNode;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeNode;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreePath;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeProblemEvent;
import org.jetbrains.qodana.ui.problemsView.tree.model.impl.Compute_nodesKt;
import org.jetbrains.qodana.ui.problemsView.tree.model.impl.QodanaTreeFileNodeImpl;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u001dH\u0002R.\u0010\u000b\u001a\u001c\u0012\u0004\u0012\u00020\r\u0012\u0012\u0012\u0010\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000e0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R&\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e0\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/qodana/ui/problemsView/tree/model/impl/FileNodesChildrenImpl;", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/FileNodesChildren;", "parentPath", "Ljava/nio/file/Path;", "relativeFilePathsToNodes", "", "", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeFileNode;", "nodes", "", "(Ljava/nio/file/Path;Ljava/util/Map;Ljava/util/List;)V", "nodeByPrimaryDataFinder", "Lkotlin/Function1;", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeNode$PrimaryData;", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeNode;", "getNodeByPrimaryDataFinder", "()Lkotlin/jvm/functions/Function1;", "getNodes", "()Ljava/util/List;", "nodesSequence", "Lkotlin/sequences/Sequence;", "getNodesSequence", "()Lkotlin/sequences/Sequence;", "computeNewChildren", "event", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeEvent;", "pathBuilder", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreePath$Builder;", "computeNewNodeWithProblem", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeProblemEvent;", "Companion", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nFileNodesChildrenImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileNodesChildrenImpl.kt\norg/jetbrains/qodana/ui/problemsView/tree/model/impl/FileNodesChildrenImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1855#2,2:74\n*S KotlinDebug\n*F\n+ 1 FileNodesChildrenImpl.kt\norg/jetbrains/qodana/ui/problemsView/tree/model/impl/FileNodesChildrenImpl\n*L\n29#1:74,2\n*E\n"})
public final class FileNodesChildrenImpl
implements FileNodesChildren {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path parentPath;
    @NotNull
    private final Map<String, QodanaTreeFileNode> relativeFilePathsToNodes;
    @NotNull
    private final List<QodanaTreeFileNode> nodes;
    @NotNull
    private final Function1<QodanaTreeNode.PrimaryData, QodanaTreeNode<?, ?, ?>> nodeByPrimaryDataFinder;

    public FileNodesChildrenImpl(@NotNull Path parentPath, @NotNull Map<String, QodanaTreeFileNode> relativeFilePathsToNodes, @NotNull List<? extends QodanaTreeFileNode> nodes) {
        Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
        Intrinsics.checkNotNullParameter(relativeFilePathsToNodes, (String)"relativeFilePathsToNodes");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this.parentPath = parentPath;
        this.relativeFilePathsToNodes = relativeFilePathsToNodes;
        this.nodes = nodes;
        this.nodeByPrimaryDataFinder = new Function1<QodanaTreeNode.PrimaryData, QodanaTreeNode<?, ?, ?>>(this){
            final /* synthetic */ FileNodesChildrenImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final QodanaTreeNode<?, ?, ?> invoke(@NotNull QodanaTreeNode.PrimaryData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !(it instanceof QodanaTreeFileNode.PrimaryData) ? null : (QodanaTreeNode)FileNodesChildrenImpl.access$getRelativeFilePathsToNodes$p(this.this$0).get(PathsKt.getInvariantSeparatorsPathString((Path)((QodanaTreeFileNode.PrimaryData)it).getFile()));
            }
        };
    }

    @Override
    @NotNull
    public List<QodanaTreeFileNode> getNodes() {
        return this.nodes;
    }

    @Override
    @NotNull
    public Sequence<QodanaTreeNode<?, ?, ?>> getNodesSequence() {
        return CollectionsKt.asSequence((Iterable)this.getNodes());
    }

    @Override
    @NotNull
    public Function1<QodanaTreeNode.PrimaryData, QodanaTreeNode<?, ?, ?>> getNodeByPrimaryDataFinder() {
        return this.nodeByPrimaryDataFinder;
    }

    @Override
    @Nullable
    public FileNodesChildrenImpl computeNewChildren(@NotNull QodanaTreeEvent event, @NotNull QodanaTreePath.Builder pathBuilder) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)pathBuilder, (String)"pathBuilder");
        QodanaTreeEvent qodanaTreeEvent = event;
        if (qodanaTreeEvent instanceof QodanaTreeExcludeEvent) {
            List<QodanaTreeFileNode> list2 = Compute_nodesKt.computeNewQodanaChildrenNodes(event, pathBuilder, this.getNodes());
            if (list2 == null) {
                return null;
            }
            List<QodanaTreeFileNode> newNodes = list2;
            Iterable $this$forEach$iv = newNodes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                QodanaTreeFileNode it = (QodanaTreeFileNode)element$iv;
                boolean bl = false;
                this.relativeFilePathsToNodes.put(PathsKt.getInvariantSeparatorsPathString((Path)((QodanaTreeFileNode.PrimaryData)it.getPrimaryData()).getFile()), it);
            }
            return new FileNodesChildrenImpl(this.parentPath, this.relativeFilePathsToNodes, newNodes);
        }
        if (qodanaTreeEvent instanceof QodanaTreeProblemEvent) {
            ArrayDeque arrayDeque;
            boolean newNodeWithProblemWasUpdated;
            String string;
            SarifProblem sarifProblem = ((QodanaTreeProblemEvent)event).getSarifProblem();
            if (!Intrinsics.areEqual((Object)File.separator, (Object)"/")) {
                String string2 = sarifProblem.getRelativePathToFile();
                String string3 = File.separator;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"separator");
                string = StringsKt.replace$default((String)string2, (String)string3, (String)"/", (boolean)false, (int)4, null);
            } else {
                string = sarifProblem.getRelativePathToFile();
            }
            String relativeFilePath = string;
            QodanaTreeFileNode alreadyPresentNode = this.relativeFilePathsToNodes.get(relativeFilePath);
            if (alreadyPresentNode == null && ((QodanaTreeProblemEvent)event).isRemoveNodeEvent()) {
                return null;
            }
            QodanaTreeFileNode qodanaTreeFileNode = alreadyPresentNode;
            if (qodanaTreeFileNode == null && (qodanaTreeFileNode = this.computeNewNodeWithProblem((QodanaTreeProblemEvent)event)) == null) {
                return null;
            }
            QodanaTreeFileNode nodeToProcess = qodanaTreeFileNode;
            QodanaTreeFileNode updatedNode = (QodanaTreeFileNode)nodeToProcess.processTreeEvent(event, pathBuilder);
            if (nodeToProcess == updatedNode) {
                return null;
            }
            boolean bl = newNodeWithProblemWasUpdated = alreadyPresentNode != nodeToProcess;
            if (newNodeWithProblemWasUpdated) {
                pathBuilder.excludeNode(updatedNode);
            }
            ArrayDeque $this$computeNewChildren_u24lambda_u241 = arrayDeque = new ArrayDeque((Collection)this.getNodes());
            boolean bl2 = false;
            $this$computeNewChildren_u24lambda_u241.remove((Object)nodeToProcess);
            if (!((QodanaTreeFileNode.Children)updatedNode.getChildren()).getNodes().isEmpty()) {
                pathBuilder.addNode(updatedNode);
                this.relativeFilePathsToNodes.put(relativeFilePath, updatedNode);
                $this$computeNewChildren_u24lambda_u241.addFirst((Object)updatedNode);
            }
            ArrayDeque newNodes = arrayDeque;
            return new FileNodesChildrenImpl(this.parentPath, this.relativeFilePathsToNodes, (List)newNodes);
        }
        throw new NoWhenBranchMatchedException();
    }

    private final QodanaTreeFileNode computeNewNodeWithProblem(QodanaTreeProblemEvent event) {
        VirtualFile virtualFile2 = event.computeVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        return QodanaTreeFileNodeImpl.Companion.newEmpty(this.parentPath, event.getSarifProblem().getRelativeNioFile(), virtualFile3);
    }

    public static final /* synthetic */ Map access$getRelativeFilePathsToNodes$p(FileNodesChildrenImpl $this) {
        return $this.relativeFilePathsToNodes;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/qodana/ui/problemsView/tree/model/impl/FileNodesChildrenImpl$Companion;", "", "()V", "newEmpty", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/FileNodesChildren;", "parentPath", "Ljava/nio/file/Path;", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileNodesChildren newEmpty(@NotNull Path parentPath) {
            Intrinsics.checkNotNullParameter((Object)parentPath, (String)"parentPath");
            return new FileNodesChildrenImpl(parentPath, new LinkedHashMap(), CollectionsKt.emptyList());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

