/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui.problemsView.tree.model.impl;

import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.problem.SarifProblem;
import org.jetbrains.qodana.problem.SarifProblemProperties;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeEvent;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeExcludeEvent;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeExcludeInspectionEvent;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeExcludePathEvent;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeExcludePathForInspectionEvent;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeMarkExcludedEvent;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreePath;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeProblemEvent;
import org.jetbrains.qodana.ui.problemsView.tree.model.QodanaTreeProblemNode;
import org.jetbrains.qodana.ui.problemsView.tree.ui.QodanaUiTreeNode;
import org.jetbrains.qodana.ui.problemsView.tree.ui.QodanaUiTreeProblemNode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J$\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030!2\u000e\u0010\"\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030!H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lorg/jetbrains/qodana/ui/problemsView/tree/model/impl/QodanaTreeProblemNodeImpl;", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeProblemNode;", "primaryData", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeProblemNode$PrimaryData;", "sarifProblemProperties", "Lorg/jetbrains/qodana/problem/SarifProblemProperties;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "excluded", "", "(Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeProblemNode$PrimaryData;Lorg/jetbrains/qodana/problem/SarifProblemProperties;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "getExcluded", "()Z", "getPrimaryData", "()Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeProblemNode$PrimaryData;", "problemsCount", "", "getProblemsCount", "()I", "getSarifProblemProperties", "()Lorg/jetbrains/qodana/problem/SarifProblemProperties;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "isRelatedToEvent", "event", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreeEvent;", "isRelatedToProblem", "problem", "Lorg/jetbrains/qodana/problem/SarifProblem;", "processTreeEvent", "pathBuilder", "Lorg/jetbrains/qodana/ui/problemsView/tree/model/QodanaTreePath$Builder;", "toUiNode", "Lorg/jetbrains/qodana/ui/problemsView/tree/ui/QodanaUiTreeNode;", "parent", "intellij.qodana"})
public final class QodanaTreeProblemNodeImpl
implements QodanaTreeProblemNode {
    @NotNull
    private final QodanaTreeProblemNode.PrimaryData primaryData;
    @NotNull
    private final SarifProblemProperties sarifProblemProperties;
    @NotNull
    private final VirtualFile virtualFile;
    private final boolean excluded;

    public QodanaTreeProblemNodeImpl(@NotNull QodanaTreeProblemNode.PrimaryData primaryData, @NotNull SarifProblemProperties sarifProblemProperties, @NotNull VirtualFile virtualFile2, boolean excluded) {
        Intrinsics.checkNotNullParameter((Object)primaryData, (String)"primaryData");
        Intrinsics.checkNotNullParameter((Object)sarifProblemProperties, (String)"sarifProblemProperties");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        this.primaryData = primaryData;
        this.sarifProblemProperties = sarifProblemProperties;
        this.virtualFile = virtualFile2;
        this.excluded = excluded;
    }

    public /* synthetic */ QodanaTreeProblemNodeImpl(QodanaTreeProblemNode.PrimaryData primaryData, SarifProblemProperties sarifProblemProperties, VirtualFile virtualFile2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(primaryData, sarifProblemProperties, virtualFile2, bl);
    }

    @Override
    @NotNull
    public QodanaTreeProblemNode.PrimaryData getPrimaryData() {
        return this.primaryData;
    }

    @Override
    @NotNull
    public SarifProblemProperties getSarifProblemProperties() {
        return this.sarifProblemProperties;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @Override
    public boolean getExcluded() {
        return this.excluded;
    }

    @Override
    public int getProblemsCount() {
        return this.getSarifProblemProperties().isMissing() || this.getExcluded() ? 0 : 1;
    }

    @Override
    public boolean isRelatedToEvent(@NotNull QodanaTreeEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        QodanaTreeEvent qodanaTreeEvent = event;
        if (qodanaTreeEvent instanceof QodanaTreeProblemEvent) {
            bl = this.isRelatedToProblem(((QodanaTreeProblemEvent)event).getSarifProblem());
        } else if (qodanaTreeEvent instanceof QodanaTreeMarkExcludedEvent) {
            bl = true;
        } else if (qodanaTreeEvent instanceof QodanaTreeExcludePathEvent) {
            bl = ((QodanaTreeExcludePathEvent)event).isRelatedTo(this.getPrimaryData().getSarifProblem().getRelativeNioFile());
        } else if (qodanaTreeEvent instanceof QodanaTreeExcludePathForInspectionEvent) {
            bl = Intrinsics.areEqual((Object)this.getPrimaryData().getSarifProblem().getInspectionId(), (Object)((QodanaTreeExcludePathForInspectionEvent)event).getInspectionId()) && ((QodanaTreeExcludePathForInspectionEvent)event).isRelatedTo(this.getPrimaryData().getSarifProblem().getRelativeNioFile());
        } else if (qodanaTreeEvent instanceof QodanaTreeExcludeInspectionEvent) {
            bl = Intrinsics.areEqual((Object)((QodanaTreeExcludeInspectionEvent)event).getInspectionId(), (Object)this.getPrimaryData().getSarifProblem().getInspectionId());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public boolean isRelatedToProblem(@NotNull SarifProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        return Intrinsics.areEqual((Object)problem, (Object)this.getPrimaryData().getSarifProblem());
    }

    @Override
    @NotNull
    public QodanaTreeProblemNode processTreeEvent(@NotNull QodanaTreeEvent event, @NotNull QodanaTreePath.Builder pathBuilder) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)pathBuilder, (String)"pathBuilder");
        QodanaTreeEvent qodanaTreeEvent = event;
        if (qodanaTreeEvent instanceof QodanaTreeMarkExcludedEvent) {
            if (this.getExcluded()) {
                return this;
            }
            return new QodanaTreeProblemNodeImpl(this.getPrimaryData(), this.getSarifProblemProperties(), this.getVirtualFile(), true);
        }
        if (qodanaTreeEvent instanceof QodanaTreeExcludeEvent) {
            if (!this.isRelatedToEvent(event) || this.getExcluded()) {
                return this;
            }
            SarifProblemProperties newActualProperties = SarifProblemProperties.copy$default(this.getSarifProblemProperties(), false, false, 0, 0, 14, null);
            return new QodanaTreeProblemNodeImpl(this.getPrimaryData(), newActualProperties, this.getVirtualFile(), true);
        }
        if (qodanaTreeEvent instanceof QodanaTreeProblemEvent) {
            SarifProblemProperties newActualProperties = ((QodanaTreeProblemEvent)event).getProperties();
            if (Intrinsics.areEqual((Object)newActualProperties, (Object)this.getSarifProblemProperties())) {
                return this;
            }
            return new QodanaTreeProblemNodeImpl(this.getPrimaryData(), newActualProperties, this.getVirtualFile(), false, 8, null);
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    @NotNull
    public QodanaUiTreeNode<QodanaTreeProblemNode, QodanaTreeProblemNode.PrimaryData> toUiNode(@NotNull QodanaUiTreeNode<?, ?> parent) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        return new QodanaUiTreeProblemNode(parent, this.getPrimaryData());
    }
}

