/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.idea;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.PWindow;
import org.jetbrains.projector.awt.peer.base.PComponentPeerBase;
import org.jetbrains.projector.common.protocol.data.CommonRectangle;
import org.jetbrains.projector.common.protocol.toClient.ServerCaretInfoChangedEvent;
import org.jetbrains.projector.common.protocol.toClient.data.idea.CaretInfo;
import org.jetbrains.projector.server.idea.CaretInfoUpdater;
import org.jetbrains.projector.server.idea.ExtendedTextAttributes;
import org.jetbrains.projector.server.platform.CompatibilityKt;
import org.jetbrains.projector.server.platform.ContextKt;
import org.jetbrains.projector.server.util.FontCacher;
import org.jetbrains.projector.util.loading.UseProjectorLoader;
import org.jetbrains.projector.util.loading.state.IdeState;
import org.jetbrains.projector.util.loading.state.IdeStateUtilsKt;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;
import sun.awt.AWTAccessor;

@UseProjectorLoader
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 +2\u00020\u0001:\u0001+B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u0005J,\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00050\u0003H\u0002J,\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00050\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J>\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0015\u001a\u00020\u00162\u0016\b\u0002\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\"0\u00032\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\b0\u0003H\u0002J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010&\u001a\u00020\u0004H\u0002J\u0006\u0010'\u001a\u00020\u0005J\u0006\u0010(\u001a\u00020\u0005J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0004H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/projector/server/idea/CaretInfoUpdater;", "", "onCaretInfoChanged", "Lkotlin/Function1;", "Lorg/jetbrains/projector/common/protocol/toClient/ServerCaretInfoChangedEvent$CaretInfoChange;", "", "(Lkotlin/jvm/functions/Function1;)V", "errorOccurred", "", "lastCaretInfo", "myDataManager", "Lcom/intellij/ide/DataManager;", "kotlin.jvm.PlatformType", "getMyDataManager", "()Lcom/intellij/ide/DataManager;", "myDataManager$delegate", "Lkotlin/Lazy;", "thread", "Ljava/lang/Thread;", "createCaretInfoEvent", "getAttrsFromHighlighterIterator", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "caretOffset", "", "compareAndUpdate", "Lorg/jetbrains/projector/server/idea/ExtendedTextAttributes;", "getAttrsFromRangeHighlighters", "getBackgroundBeforeCaret", "getCurrentEditorImpl", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "getFontBeforeCaret", "Ljava/awt/Font;", "getTextAttributesBeforeCaret", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "mapper", "filter", "getTextColorBeforeCaret", "loadCaretInfo", "start", "stop", "updateCaretInfoIfNeeded", "newCaretInfo", "Companion", "projector-server-common"})
public final class CaretInfoUpdater {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<ServerCaretInfoChangedEvent.CaretInfoChange, Unit> onCaretInfoChanged;
    private Thread thread;
    @NotNull
    private final Lazy myDataManager$delegate;
    private boolean errorOccurred;
    @NotNull
    private ServerCaretInfoChangedEvent.CaretInfoChange lastCaretInfo;
    @NotNull
    private static final Logger logger;
    private static final int DATA_CONTEXT_QUERYING_TIMEOUT_MS = 1000;

    public CaretInfoUpdater(@NotNull Function1<? super ServerCaretInfoChangedEvent.CaretInfoChange, Unit> onCaretInfoChanged) {
        Intrinsics.checkNotNullParameter(onCaretInfoChanged, (String)"onCaretInfoChanged");
        this.onCaretInfoChanged = onCaretInfoChanged;
        this.myDataManager$delegate = LazyKt.lazy((Function0)myDataManager.2.INSTANCE);
        this.lastCaretInfo = ServerCaretInfoChangedEvent.CaretInfoChange.NoCarets.INSTANCE;
    }

    private final DataManager getMyDataManager() {
        Lazy lazy = this.myDataManager$delegate;
        return (DataManager)lazy.getValue();
    }

    private final void updateCaretInfoIfNeeded(ServerCaretInfoChangedEvent.CaretInfoChange newCaretInfo) {
        if (!Intrinsics.areEqual((Object)this.lastCaretInfo, (Object)newCaretInfo)) {
            this.lastCaretInfo = newCaretInfo;
            this.createCaretInfoEvent();
        }
    }

    public final void createCaretInfoEvent() {
        this.onCaretInfoChanged.invoke((Object)this.lastCaretInfo);
    }

    private final EditorImpl getCurrentEditorImpl() {
        DataContext dataContext;
        try {
            dataContext = (DataContext)this.getMyDataManager().getDataContextFromFocusAsync().blockingGet(1000);
        }
        catch (TimeoutException e) {
            dataContext = null;
        }
        DataContext dataContext2 = dataContext;
        if (dataContext2 == null) {
            return null;
        }
        DataContext dataContext3 = dataContext2;
        Object t = ContextKt.readAction((Function0)new Function0<Editor>(dataContext3){
            final /* synthetic */ DataContext $dataContext;
            {
                this.$dataContext = $dataContext;
                super(0);
            }

            @Nullable
            public final Editor invoke() {
                return (Editor)this.$dataContext.getData(CommonDataKeys.EDITOR);
            }
        });
        return t instanceof EditorImpl ? (EditorImpl)t : null;
    }

    /*
     * WARNING - void declaration
     */
    private final ServerCaretInfoChangedEvent.CaretInfoChange loadCaretInfo() {
        ServerCaretInfoChangedEvent.CaretInfoChange caretInfoChange;
        Component rootComponent;
        EditorImpl editorImpl = this.getCurrentEditorImpl();
        if (editorImpl == null) {
            return ServerCaretInfoChangedEvent.CaretInfoChange.NoCarets.INSTANCE;
        }
        EditorImpl focusedEditor = editorImpl;
        EditorComponentImpl editorComponentImpl = focusedEditor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"focusedEditor.contentComponent");
        EditorComponentImpl focusedEditorComponent = editorComponentImpl;
        if (!focusedEditorComponent.isShowing()) {
            return ServerCaretInfoChangedEvent.CaretInfoChange.NoCarets.INSTANCE;
        }
        Point componentLocation = focusedEditorComponent.getLocationOnScreen();
        JScrollPane jScrollPane = focusedEditor.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"focusedEditor.scrollPane");
        JScrollPane scrollPane = jScrollPane;
        Rectangle visibleEditorRect = scrollPane.getViewport().getViewRect();
        int lineHeight = focusedEditor.getLineHeight();
        int lineAscent = focusedEditor.getAscent();
        PWindow editorPWindow = null;
        for (rootComponent = (Component)focusedEditorComponent; rootComponent != null; rootComponent = (Component)rootComponent.getParent()) {
            Object peer = AWTAccessor.getComponentAccessor().getPeer(rootComponent);
            if (!(peer instanceof PComponentPeerBase)) continue;
            editorPWindow = ((PComponentPeerBase)peer).getPWindow();
            break;
        }
        if (editorPWindow == null) {
            caretInfoChange = ServerCaretInfoChangedEvent.CaretInfoChange.NoCarets.INSTANCE;
        } else {
            int n;
            boolean isVerticalScrollBarVisible;
            void $this$mapTo$iv$iv;
            Component component = rootComponent;
            Intrinsics.checkNotNull((Object)component);
            Point rootComponentLocation = component.getLocationOnScreen();
            int editorLocationInWindowX = componentLocation.x - rootComponentLocation.x;
            int editorLocationInWindowY = componentLocation.y - rootComponentLocation.y;
            List list = focusedEditor.getCaretModel().getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"focusedEditor.caretModel.allCarets");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Caret caret = (Caret)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Point>((Caret)it){
                    final /* synthetic */ Caret $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @NotNull
                    public final Point invoke() {
                        return this.$it.getEditor().visualPositionToXY(this.$it.getVisualPosition());
                    }
                }), (int)1, null);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n          val caretLoc\u2026aretInfo(point)\n        }");
                Point caretLocationInEditor2 = (Point)object;
                org.jetbrains.projector.common.protocol.data.Point point = new org.jetbrains.projector.common.protocol.data.Point(editorLocationInWindowX + caretLocationInEditor2.x, editorLocationInWindowY + caretLocationInEditor2.y);
                collection.add(new CaretInfo(point));
            }
            List points2 = (List)destination$iv$iv;
            boolean bl = isVerticalScrollBarVisible = visibleEditorRect.height < focusedEditorComponent.getHeight();
            if (isVerticalScrollBarVisible) {
                JScrollBar jScrollBar = scrollPane.getVerticalScrollBar();
                n = jScrollBar == null ? 0 : (destination$iv$iv = jScrollBar.getWidth());
            } else {
                n = 0;
            }
            int verticalScrollBarWidth = n;
            int textColor = this.getTextColorBeforeCaret((EditorEx)focusedEditor);
            Font editorFont = this.getFontBeforeCaret((EditorEx)focusedEditor);
            int backgroundColor = this.getBackgroundBeforeCaret((EditorEx)focusedEditor);
            caretInfoChange = new ServerCaretInfoChangedEvent.CaretInfoChange.Carets(points2, FontCacher.INSTANCE.getId(editorFont), editorFont.getSize(), editorPWindow.getId(), new CommonRectangle(componentLocation.getX() - (double)rootComponentLocation.x + (double)visibleEditorRect.x, componentLocation.getY() - (double)rootComponentLocation.y + (double)visibleEditorRect.y, visibleEditorRect.width, visibleEditorRect.height), lineHeight, lineAscent, verticalScrollBarWidth, textColor, backgroundColor);
        }
        return caretInfoChange;
    }

    private final int getTextColorBeforeCaret(EditorEx editor) {
        TextAttributes attrs2;
        TextAttributes textAttributes = attrs2 = CaretInfoUpdater.getTextAttributesBeforeCaret$default(this, editor, null, getTextColorBeforeCaret.attrs.1.INSTANCE, 2, null);
        Color color = textAttributes == null ? null : textAttributes.getForegroundColor();
        if (color == null) {
            Color color2 = editor.getColorsScheme().getDefaultForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"editor.colorsScheme.defaultForeground");
            color = color2;
        }
        Color color3 = color;
        return color3.getRGB();
    }

    private final Font getFontBeforeCaret(EditorEx editor) {
        EditorFontType editorFontType;
        Serializable serializable;
        TextAttributes attrs2;
        TextAttributes textAttributes = attrs2 = CaretInfoUpdater.getTextAttributesBeforeCaret$default(this, editor, null, getFontBeforeCaret.attrs.1.INSTANCE, 2, null);
        Integer n = serializable = textAttributes == null ? null : Integer.valueOf(textAttributes.getFontType());
        int n2 = 1;
        if (n != null && n == n2) {
            editorFontType = EditorFontType.BOLD;
        } else {
            Integer n3 = serializable;
            n2 = 2;
            if (n3 != null && n3 == n2) {
                editorFontType = EditorFontType.ITALIC;
            } else {
                Integer n4 = serializable;
                n2 = 3;
                editorFontType = n4 != null && n4 == n2 ? EditorFontType.BOLD_ITALIC : EditorFontType.PLAIN;
            }
        }
        EditorFontType editorFontType2 = editorFontType;
        serializable = editor.getColorsScheme().getFont(editorFontType2);
        Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"editor.colorsScheme.getFont(editorFontType)");
        return serializable;
    }

    private final int getBackgroundBeforeCaret(EditorEx editor) {
        TextAttributes attrs2;
        TextAttributes textAttributes = attrs2 = this.getTextAttributesBeforeCaret(editor, (Function1<? super ExtendedTextAttributes, ? extends TextAttributes>)((Function1)getBackgroundBeforeCaret.attrs.1.INSTANCE), (Function1<? super TextAttributes, Boolean>)((Function1)getBackgroundBeforeCaret.attrs.2.INSTANCE));
        Color color = textAttributes == null ? null : textAttributes.getBackgroundColor();
        if (color == null) {
            Color color2 = editor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR);
            if (color2 == null) {
                Color color3 = editor.getColorsScheme().getDefaultBackground();
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"editor.colorsScheme.defaultBackground");
                color = color3;
            } else {
                color = color2;
            }
        }
        Color color4 = color;
        return color4.getRGB();
    }

    private final TextAttributes getTextAttributesBeforeCaret(EditorEx editor, Function1<? super ExtendedTextAttributes, ? extends TextAttributes> mapper, Function1<? super TextAttributes, Boolean> filter) {
        TextAttributes textAttributes;
        int caretOffset2 = ((Number)ContextKt.readAction((Function0)new Function0<Integer>(editor){
            final /* synthetic */ EditorEx $editor;
            {
                this.$editor = $editor;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.$editor.getCaretModel().getOffset();
            }
        })).intValue();
        if (caretOffset2 <= 0) {
            return null;
        }
        Ref.ObjectRef bestFitAttributes = new Ref.ObjectRef();
        Function1 compareAndUpdate2 = (Function1)new Function1<ExtendedTextAttributes, Unit>(filter, (Ref.ObjectRef<ExtendedTextAttributes>)bestFitAttributes){
            final /* synthetic */ Function1<TextAttributes, Boolean> $filter;
            final /* synthetic */ Ref.ObjectRef<ExtendedTextAttributes> $bestFitAttributes;
            {
                this.$filter = $filter;
                this.$bestFitAttributes = $bestFitAttributes;
                super(1);
            }

            public final void invoke(@NotNull ExtendedTextAttributes extendedTextAttributes) {
                Intrinsics.checkNotNullParameter((Object)extendedTextAttributes, (String)"extendedTextAttributes");
                if (!((Boolean)this.$filter.invoke((Object)extendedTextAttributes.getAttrs())).booleanValue()) {
                    return;
                }
                this.$bestFitAttributes.element = ExtendedTextAttributes.Companion.topLayeredAttributes$projector_server_common(extendedTextAttributes, (ExtendedTextAttributes)this.$bestFitAttributes.element);
            }
        };
        Object[] objectArray = new KFunction[]{(KFunction)new Function3<EditorEx, Integer, Function1<? super ExtendedTextAttributes, ? extends Unit>, Unit>((Object)this){

            public final void invoke(@NotNull EditorEx p0, int p1, @NotNull Function1<? super ExtendedTextAttributes, Unit> p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                CaretInfoUpdater.access$getAttrsFromRangeHighlighters((CaretInfoUpdater)this.receiver, p0, p1, p2);
            }
        }, (KFunction)new Function3<EditorEx, Integer, Function1<? super ExtendedTextAttributes, ? extends Unit>, Unit>((Object)this){

            public final void invoke(@NotNull EditorEx p0, int p1, @NotNull Function1<? super ExtendedTextAttributes, Unit> p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                CaretInfoUpdater.access$getAttrsFromHighlighterIterator((CaretInfoUpdater)this.receiver, p0, p1, p2);
            }
        }};
        List highlightingProviders2 = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = highlightingProviders2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KFunction it = (KFunction)element$iv;
            boolean bl = false;
            ((Function3)it).invoke((Object)editor, (Object)caretOffset2, (Object)compareAndUpdate2);
        }
        ExtendedTextAttributes extendedTextAttributes = (ExtendedTextAttributes)bestFitAttributes.element;
        if (extendedTextAttributes == null) {
            textAttributes = null;
        } else {
            ExtendedTextAttributes extendedTextAttributes2 = extendedTextAttributes;
            textAttributes = (TextAttributes)mapper.invoke((Object)extendedTextAttributes2);
        }
        return textAttributes;
    }

    static /* synthetic */ TextAttributes getTextAttributesBeforeCaret$default(CaretInfoUpdater caretInfoUpdater2, EditorEx editorEx, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = getTextAttributesBeforeCaret.1.INSTANCE;
        }
        return caretInfoUpdater2.getTextAttributesBeforeCaret(editorEx, (Function1<? super ExtendedTextAttributes, ? extends TextAttributes>)function1, (Function1<? super TextAttributes, Boolean>)function12);
    }

    private final void getAttrsFromRangeHighlighters(EditorEx editor, int caretOffset2, Function1<? super ExtendedTextAttributes, Unit> compareAndUpdate2) {
        RangeHighlighter[] rangeHighlighters2 = (RangeHighlighter[])ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<RangeHighlighter[]>(editor){
            final /* synthetic */ EditorEx $editor;
            {
                this.$editor = $editor;
                super(0);
            }

            @NotNull
            public final RangeHighlighter[] invoke() {
                RangeHighlighter[] rangeHighlighterArray = this.$editor.getFilteredDocumentMarkupModel().getAllHighlighters();
                Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"editor.filteredDocumentMarkupModel.allHighlighters");
                Object[] objectArray = rangeHighlighterArray;
                rangeHighlighterArray = this.$editor.getMarkupModel().getAllHighlighters();
                Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"editor.markupModel.allHighlighters");
                return (RangeHighlighter[])ArraysKt.plus((Object[])objectArray, (Object[])rangeHighlighterArray);
            }
        }), (int)1, null);
        int startPos = caretOffset2 - 1;
        RangeHighlighter[] $this$forEach$iv = rangeHighlighters2;
        boolean $i$f$forEach = false;
        RangeHighlighter[] rangeHighlighterArray = $this$forEach$iv;
        int n = 0;
        int n2 = rangeHighlighterArray.length;
        while (n < n2) {
            TextAttributes textAttrs;
            RangeHighlighter element$iv = rangeHighlighterArray[n];
            ++n;
            RangeHighlighter it = element$iv;
            boolean bl = false;
            int start2 = it.getStartOffset();
            int end = it.getEndOffset();
            boolean bl2 = start2 <= startPos ? startPos < end : false;
            if (!bl2) continue;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
            if (CompatibilityKt.getTextAttributesCompat(it, editorColorsScheme) == null) continue;
            compareAndUpdate2.invoke((Object)new ExtendedTextAttributes(textAttrs, RangesKt.until((int)start2, (int)end), it.getLayer()));
        }
    }

    private final void getAttrsFromHighlighterIterator(EditorEx editor, int caretOffset2, Function1<? super ExtendedTextAttributes, Unit> compareAndUpdate2) {
        boolean bl;
        int startPos = caretOffset2 - 1;
        Object t = ContextKt.readAction((Function0)new Function0<HighlighterIterator>(editor, startPos){
            final /* synthetic */ EditorEx $editor;
            final /* synthetic */ int $startPos;
            {
                this.$editor = $editor;
                this.$startPos = $startPos;
                super(0);
            }

            @NotNull
            public final HighlighterIterator invoke() {
                return this.$editor.getHighlighter().createIterator(this.$startPos);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"editor: EditorEx,\n    ca\u2026reateIterator(startPos) }");
        HighlighterIterator highlightIterator2 = (HighlighterIterator)t;
        if (highlightIterator2.atEnd()) {
            return;
        }
        do {
            TextAttributes candidateAttrs = highlightIterator2.getTextAttributes();
            IntRange range = RangesKt.until((int)highlightIterator2.getStart(), (int)highlightIterator2.getEnd());
            Intrinsics.checkNotNullExpressionValue((Object)candidateAttrs, (String)"candidateAttrs");
            compareAndUpdate2.invoke((Object)new ExtendedTextAttributes(candidateAttrs, range, -1));
            highlightIterator2.advance();
            if (highlightIterator2.atEnd()) break;
            int n = highlightIterator2.getStart();
            if (startPos < highlightIterator2.getEnd()) {
                if (n <= startPos) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (bl);
    }

    public final void start() {
        IdeStateUtilsKt.whenOccurred(IdeState.COMPONENTS_LOADED, "search for editors", (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ CaretInfoUpdater this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                CaretInfoUpdater.access$setThread$p(this.this$0, ThreadsKt.thread$default((boolean)false, (boolean)true, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ CaretInfoUpdater this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        while (!Thread.currentThread().isInterrupted()) {
                            try {
                                block6: {
                                    try {
                                        ServerCaretInfoChangedEvent.CaretInfoChange newCaretInfo = CaretInfoUpdater.access$loadCaretInfo(this.this$0);
                                        CaretInfoUpdater.access$updateCaretInfoIfNeeded(this.this$0, newCaretInfo);
                                    }
                                    catch (NullPointerException npe) {
                                        CaretInfoUpdater.access$updateCaretInfoIfNeeded(this.this$0, ServerCaretInfoChangedEvent.CaretInfoChange.NoCarets.INSTANCE);
                                    }
                                    catch (Throwable t) {
                                        if (CaretInfoUpdater.access$getErrorOccurred$p(this.this$0)) break block6;
                                        CaretInfoUpdater.access$getLogger$cp().info(t, (Function0<String>)((Function0)start.1.INSTANCE));
                                        CaretInfoUpdater.access$setErrorOccurred$p(this.this$0, true);
                                    }
                                }
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                }), (int)29, null));
            }
        }));
    }

    public final void stop() {
        if (this.thread != null) {
            Thread thread = this.thread;
            if (thread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
                thread = null;
            }
            thread.interrupt();
        }
    }

    public static final /* synthetic */ void access$getAttrsFromRangeHighlighters(CaretInfoUpdater $this, EditorEx editor, int caretOffset2, Function1 compareAndUpdate2) {
        $this.getAttrsFromRangeHighlighters(editor, caretOffset2, (Function1<? super ExtendedTextAttributes, Unit>)compareAndUpdate2);
    }

    public static final /* synthetic */ void access$getAttrsFromHighlighterIterator(CaretInfoUpdater $this, EditorEx editor, int caretOffset2, Function1 compareAndUpdate2) {
        $this.getAttrsFromHighlighterIterator(editor, caretOffset2, (Function1<? super ExtendedTextAttributes, Unit>)compareAndUpdate2);
    }

    public static final /* synthetic */ void access$setThread$p(CaretInfoUpdater $this, Thread thread) {
        $this.thread = thread;
    }

    public static final /* synthetic */ ServerCaretInfoChangedEvent.CaretInfoChange access$loadCaretInfo(CaretInfoUpdater $this) {
        return $this.loadCaretInfo();
    }

    public static final /* synthetic */ void access$updateCaretInfoIfNeeded(CaretInfoUpdater $this, ServerCaretInfoChangedEvent.CaretInfoChange newCaretInfo) {
        $this.updateCaretInfoIfNeeded(newCaretInfo);
    }

    public static final /* synthetic */ boolean access$getErrorOccurred$p(CaretInfoUpdater $this) {
        return $this.errorOccurred;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$setErrorOccurred$p(CaretInfoUpdater $this, boolean bl) {
        $this.errorOccurred = bl;
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(CaretInfoUpdater.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger(string);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/projector/server/idea/CaretInfoUpdater$Companion;", "", "()V", "DATA_CONTEXT_QUERYING_TIMEOUT_MS", "", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "projector-server-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

