/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.pagecache;

import com.intellij.util.io.Bits;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.pagecache.Page;
import com.intellij.util.io.pagecache.PagedStorage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class PagedStorageWithPageUnalignedAccess
implements PagedStorage {
    @NotNull
    private final PagedStorage alignedAccessStorage;
    private final transient int pageSize;
    private static final ThreadLocal<byte[]> TL_BUFFER_FOR_PRIMITIVES = ThreadLocal.withInitial(() -> new byte[8]);

    public PagedStorageWithPageUnalignedAccess(@NotNull PagedStorage storage2) {
        if (storage2 == null) {
            PagedStorageWithPageUnalignedAccess.$$$reportNull$$$0(0);
        }
        this.alignedAccessStorage = storage2;
        this.pageSize = this.alignedAccessStorage.getPageSize();
    }

    private boolean isPageAligned(long offsetInFile, int valueLength) {
        int offsetInPage = (int)(offsetInFile % (long)this.pageSize);
        int remainsOnPage = this.pageSize - offsetInPage;
        return valueLength <= remainsOnPage;
    }

    private static byte[] threadLocalBufferForPrimitives() {
        return TL_BUFFER_FOR_PRIMITIVES.get();
    }

    @Override
    public void putInt(long offsetInFile, int value) throws IOException {
        if (this.isPageAligned(offsetInFile, 4)) {
            this.alignedAccessStorage.putInt(offsetInFile, value);
        } else {
            byte[] bufferForPrimitives = PagedStorageWithPageUnalignedAccess.threadLocalBufferForPrimitives();
            Bits.putInt(bufferForPrimitives, 0, value);
            this.put(offsetInFile, bufferForPrimitives, 0, 4);
        }
    }

    @Override
    public int getInt(long offsetInFile) throws IOException {
        if (this.isPageAligned(offsetInFile, 4)) {
            return this.alignedAccessStorage.getInt(offsetInFile);
        }
        byte[] bufferForPrimitives = PagedStorageWithPageUnalignedAccess.threadLocalBufferForPrimitives();
        this.get(offsetInFile, bufferForPrimitives, 0, 4);
        return Bits.getInt(bufferForPrimitives, 0);
    }

    @Override
    public void putLong(long offsetInFile, long value) throws IOException {
        if (this.isPageAligned(offsetInFile, 8)) {
            this.alignedAccessStorage.putLong(offsetInFile, value);
        } else {
            byte[] bufferForPrimitives = PagedStorageWithPageUnalignedAccess.threadLocalBufferForPrimitives();
            Bits.putLong(bufferForPrimitives, 0, value);
            this.put(offsetInFile, bufferForPrimitives, 0, 8);
        }
    }

    @Override
    public long getLong(long offsetInFile) throws IOException {
        if (this.isPageAligned(offsetInFile, 8)) {
            return this.alignedAccessStorage.getLong(offsetInFile);
        }
        byte[] bufferForPrimitives = PagedStorageWithPageUnalignedAccess.threadLocalBufferForPrimitives();
        this.get(offsetInFile, bufferForPrimitives, 0, 8);
        return Bits.getLong(bufferForPrimitives, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putBuffer(long offsetInFile, @NotNull ByteBuffer byteBuffer) throws IOException {
        void data2;
        if (byteBuffer == null) {
            PagedStorageWithPageUnalignedAccess.$$$reportNull$$$0(1);
        }
        if (!this.isPageAligned(offsetInFile, data2.remaining())) {
            throw new UnsupportedOperationException(".putBuffer() is not (yet?) implemented for unaligned storage");
        }
        this.alignedAccessStorage.putBuffer(offsetInFile, (ByteBuffer)data2);
    }

    @Override
    public byte get(long offsetInFile) throws IOException {
        return this.alignedAccessStorage.get(offsetInFile);
    }

    @Override
    public void put(long offsetInFile, byte value) throws IOException {
        this.alignedAccessStorage.put(offsetInFile, value);
    }

    @Override
    public void get(long offsetInFile, byte[] destination, int offsetInArray, int length) throws IOException {
        this.alignedAccessStorage.get(offsetInFile, destination, offsetInArray, length);
    }

    @Override
    public void put(long offsetInFile, byte[] src, int offsetInArray, int length) throws IOException {
        this.alignedAccessStorage.put(offsetInFile, src, offsetInArray, length);
    }

    @Override
    @NotNull
    public StorageLockContext getStorageLockContext() {
        StorageLockContext storageLockContext = this.alignedAccessStorage.getStorageLockContext();
        if (storageLockContext == null) {
            PagedStorageWithPageUnalignedAccess.$$$reportNull$$$0(2);
        }
        return storageLockContext;
    }

    @Override
    @NotNull
    public Path getFile() {
        Path path = this.alignedAccessStorage.getFile();
        if (path == null) {
            PagedStorageWithPageUnalignedAccess.$$$reportNull$$$0(3);
        }
        return path;
    }

    @Override
    public boolean isReadOnly() {
        return this.alignedAccessStorage.isReadOnly();
    }

    @Override
    public int getPageSize() {
        return this.alignedAccessStorage.getPageSize();
    }

    @Override
    public boolean isNativeBytesOrder() {
        return this.alignedAccessStorage.isNativeBytesOrder();
    }

    @Override
    public long length() {
        return this.alignedAccessStorage.length();
    }

    @Override
    public void clear() {
        this.alignedAccessStorage.clear();
    }

    @Override
    public boolean isDirty() {
        return this.alignedAccessStorage.isDirty();
    }

    @Override
    @NotNull
    public Page pageByOffset(long offsetInFile, boolean forModification) throws IOException {
        Page page = this.alignedAccessStorage.pageByOffset(offsetInFile, forModification);
        if (page == null) {
            PagedStorageWithPageUnalignedAccess.$$$reportNull$$$0(4);
        }
        return page;
    }

    @Override
    public int toOffsetInPage(long offsetInFile) {
        return this.alignedAccessStorage.toOffsetInPage(offsetInFile);
    }

    @Override
    public boolean isClosed() {
        return this.alignedAccessStorage.isClosed();
    }

    @Override
    public void force() throws IOException {
        this.alignedAccessStorage.force();
    }

    @Override
    public void close() throws IOException {
        this.alignedAccessStorage.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/pagecache/PagedStorageWithPageUnalignedAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/pagecache/PagedStorageWithPageUnalignedAccess";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageLockContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "pageByOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putBuffer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

