/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.path;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import com.jayway.jsonpath.internal.path.PathToken;
import com.jayway.jsonpath.internal.path.PredicateContextImpl;
import java.util.Collection;
import java.util.Collections;

public class PredicatePathToken
extends PathToken {
    private final Collection<Predicate> predicates;

    PredicatePathToken(Predicate filter) {
        this.predicates = Collections.singletonList(filter);
    }

    PredicatePathToken(Collection<Predicate> predicates) {
        this.predicates = predicates;
    }

    @Override
    public void evaluate(String currentPath, PathRef ref, Object model2, EvaluationContextImpl ctx) {
        if (ctx.jsonProvider().isMap(model2)) {
            if (this.accept(model2, ctx.rootDocument(), ctx.configuration(), ctx)) {
                PathRef op;
                PathRef pathRef = op = ctx.forUpdate() ? ref : PathRef.NO_OP;
                if (this.isLeaf()) {
                    ctx.addResult(currentPath, op, model2);
                } else {
                    this.next().evaluate(currentPath, op, model2, ctx);
                }
            }
        } else if (ctx.jsonProvider().isArray(model2)) {
            int idx = 0;
            Iterable<?> objects = ctx.jsonProvider().toIterable(model2);
            for (Object idxModel : objects) {
                if (this.accept(idxModel, ctx.rootDocument(), ctx.configuration(), ctx)) {
                    this.handleArrayIndex(idx, currentPath, model2, ctx);
                }
                ++idx;
            }
        } else if (this.isUpstreamDefinite()) {
            throw new InvalidPathException(String.format("Filter: %s can not be applied to primitives. Current context is: %s", this.toString(), model2));
        }
    }

    public boolean accept(Object obj, Object root, Configuration configuration, EvaluationContextImpl evaluationContext) {
        PredicateContextImpl ctx = new PredicateContextImpl(obj, root, configuration, evaluationContext.documentEvalCache());
        for (Predicate predicate : this.predicates) {
            try {
                if (predicate.apply(ctx)) continue;
                return false;
            }
            catch (InvalidPathException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getPathFragment() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.predicates.size(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean isTokenDefinite() {
        return false;
    }
}

