/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html2md.converter;

import com.vladsch.flexmark.html2md.converter.ExtensionConversion;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import com.vladsch.flexmark.html2md.converter.LinkConversion;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSetter;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.misc.Utils;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class HtmlConverterOptions
implements MutableDataSetter {
    public boolean listContentIndent;
    public boolean setextHeadings;
    public boolean outputUnknownTags;
    public boolean typographicQuotes;
    public boolean typographicSmarts;
    public boolean outputAttributesIdAttr;
    public boolean wrapAutoLinks;
    public boolean extractAutoLinks;
    public boolean renderComments;
    public boolean dotOnlyNumericLists;
    public boolean commentOriginalNonNumericListItem;
    public boolean preCodePreserveEmphasis;
    public boolean listsEndOnDoubleBlank;
    public boolean divAsParagraph;
    public boolean brAsParaBreaks;
    public boolean brAsExtraBlankLines;
    public boolean ignoreTableHeadingAfterRows;
    public boolean addTrailingEol;
    public boolean skipHeading1;
    public boolean skipHeading2;
    public boolean skipHeading3;
    public boolean skipHeading4;
    public boolean skipHeading5;
    public boolean skipHeading6;
    public boolean skipAttributes;
    public boolean skipFencedCode;
    public boolean skipCharEscape;
    public boolean divTableProcessing;
    public ExtensionConversion extInlineStrong;
    public ExtensionConversion extInlineEmphasis;
    public ExtensionConversion extInlineCode;
    public ExtensionConversion extInlineDel;
    public ExtensionConversion extInlineIns;
    public ExtensionConversion extInlineSub;
    public ExtensionConversion extInlineSup;
    public ExtensionConversion extMath;
    public LinkConversion extInlineLink;
    public LinkConversion extInlineImage;
    public char orderedListDelimiter;
    public char unorderedListDelimiter;
    public int definitionMarkerSpaces;
    public int minSetextHeadingMarkerLength;
    public int listItemIndent;
    public String codeIndent;
    public String eolInTitleAttribute;
    public String nbspText;
    public String thematicBreak;
    public String outputAttributesNamesRegex;
    public Pattern outputAttributesNamesRegexPattern;
    public String outputIdAttributeRegex;
    public Pattern outputIdAttributeRegexPattern;
    public Map<Object, CellAlignment> tableCellAlignmentMap;
    public TableFormatOptions tableOptions;
    public int formatFlags;
    public int maxBlankLines;
    public int maxTrailingBlankLines;
    public String[] unwrappedTags;
    public String[] wrappedTags;
    public String[] divTableRowClasses;
    public String[] divTableCellClasses;
    public String[] divTableHdrClasses;

    public HtmlConverterOptions() {
        this((DataHolder)null);
    }

    public HtmlConverterOptions(HtmlConverterOptions other) {
        this.listContentIndent = other.listContentIndent;
        this.setextHeadings = other.setextHeadings;
        this.outputUnknownTags = other.outputUnknownTags;
        this.typographicQuotes = other.typographicQuotes;
        this.typographicSmarts = other.typographicSmarts;
        this.outputAttributesIdAttr = other.outputAttributesIdAttr;
        this.wrapAutoLinks = other.wrapAutoLinks;
        this.extractAutoLinks = other.extractAutoLinks;
        this.renderComments = other.renderComments;
        this.dotOnlyNumericLists = other.dotOnlyNumericLists;
        this.commentOriginalNonNumericListItem = other.commentOriginalNonNumericListItem;
        this.preCodePreserveEmphasis = other.preCodePreserveEmphasis;
        this.listsEndOnDoubleBlank = other.listsEndOnDoubleBlank;
        this.divAsParagraph = other.divAsParagraph;
        this.brAsParaBreaks = other.brAsParaBreaks;
        this.brAsExtraBlankLines = other.brAsExtraBlankLines;
        this.ignoreTableHeadingAfterRows = other.ignoreTableHeadingAfterRows;
        this.addTrailingEol = other.addTrailingEol;
        this.skipHeading1 = other.skipHeading1;
        this.skipHeading2 = other.skipHeading2;
        this.skipHeading3 = other.skipHeading3;
        this.skipHeading4 = other.skipHeading4;
        this.skipHeading5 = other.skipHeading5;
        this.skipHeading6 = other.skipHeading6;
        this.skipAttributes = other.skipAttributes;
        this.skipFencedCode = other.skipFencedCode;
        this.skipCharEscape = other.skipCharEscape;
        this.divTableProcessing = other.divTableProcessing;
        this.extInlineStrong = other.extInlineStrong;
        this.extInlineEmphasis = other.extInlineEmphasis;
        this.extInlineCode = other.extInlineCode;
        this.extInlineDel = other.extInlineDel;
        this.extInlineIns = other.extInlineIns;
        this.extInlineSub = other.extInlineSub;
        this.extInlineSup = other.extInlineSup;
        this.orderedListDelimiter = other.orderedListDelimiter;
        this.unorderedListDelimiter = other.unorderedListDelimiter;
        this.definitionMarkerSpaces = other.definitionMarkerSpaces;
        this.minSetextHeadingMarkerLength = other.minSetextHeadingMarkerLength;
        this.listItemIndent = other.listItemIndent;
        this.codeIndent = other.codeIndent;
        this.eolInTitleAttribute = other.eolInTitleAttribute;
        this.nbspText = other.nbspText;
        this.thematicBreak = other.thematicBreak;
        this.outputAttributesNamesRegex = other.outputAttributesNamesRegex;
        this.outputAttributesNamesRegexPattern = other.outputAttributesNamesRegexPattern;
        this.tableCellAlignmentMap = other.tableCellAlignmentMap;
        this.tableOptions = other.tableOptions;
        this.outputIdAttributeRegex = other.outputIdAttributeRegex;
        this.outputIdAttributeRegexPattern = other.outputIdAttributeRegexPattern;
        this.extMath = other.extMath;
        this.extInlineLink = other.extInlineLink;
        this.extInlineImage = other.extInlineImage;
        this.formatFlags = other.formatFlags;
        this.maxBlankLines = other.maxBlankLines;
        this.maxTrailingBlankLines = other.maxTrailingBlankLines;
        this.unwrappedTags = other.unwrappedTags;
        this.wrappedTags = other.wrappedTags;
        this.divTableRowClasses = other.divTableRowClasses;
        this.divTableCellClasses = other.divTableCellClasses;
        this.divTableHdrClasses = other.divTableHdrClasses;
    }

    public HtmlConverterOptions(DataHolder options) {
        this.listContentIndent = FlexmarkHtmlConverter.LIST_CONTENT_INDENT.get(options);
        this.setextHeadings = FlexmarkHtmlConverter.SETEXT_HEADINGS.get(options);
        this.outputUnknownTags = FlexmarkHtmlConverter.OUTPUT_UNKNOWN_TAGS.get(options);
        this.typographicQuotes = FlexmarkHtmlConverter.TYPOGRAPHIC_QUOTES.get(options);
        this.typographicSmarts = FlexmarkHtmlConverter.TYPOGRAPHIC_SMARTS.get(options);
        this.outputAttributesIdAttr = FlexmarkHtmlConverter.OUTPUT_ATTRIBUTES_ID.get(options);
        this.wrapAutoLinks = FlexmarkHtmlConverter.WRAP_AUTO_LINKS.get(options);
        this.extractAutoLinks = FlexmarkHtmlConverter.EXTRACT_AUTO_LINKS.get(options);
        this.renderComments = FlexmarkHtmlConverter.RENDER_COMMENTS.get(options);
        this.dotOnlyNumericLists = FlexmarkHtmlConverter.DOT_ONLY_NUMERIC_LISTS.get(options);
        this.commentOriginalNonNumericListItem = FlexmarkHtmlConverter.COMMENT_ORIGINAL_NON_NUMERIC_LIST_ITEM.get(options);
        this.preCodePreserveEmphasis = FlexmarkHtmlConverter.PRE_CODE_PRESERVE_EMPHASIS.get(options);
        this.listsEndOnDoubleBlank = FlexmarkHtmlConverter.LISTS_END_ON_DOUBLE_BLANK.get(options);
        this.divAsParagraph = FlexmarkHtmlConverter.DIV_AS_PARAGRAPH.get(options);
        this.brAsParaBreaks = FlexmarkHtmlConverter.BR_AS_PARA_BREAKS.get(options);
        this.brAsExtraBlankLines = FlexmarkHtmlConverter.BR_AS_EXTRA_BLANK_LINES.get(options);
        this.ignoreTableHeadingAfterRows = FlexmarkHtmlConverter.IGNORE_TABLE_HEADING_AFTER_ROWS.get(options);
        this.addTrailingEol = FlexmarkHtmlConverter.ADD_TRAILING_EOL.get(options);
        this.skipHeading1 = FlexmarkHtmlConverter.SKIP_HEADING_1.get(options);
        this.skipHeading2 = FlexmarkHtmlConverter.SKIP_HEADING_2.get(options);
        this.skipHeading3 = FlexmarkHtmlConverter.SKIP_HEADING_3.get(options);
        this.skipHeading4 = FlexmarkHtmlConverter.SKIP_HEADING_4.get(options);
        this.skipHeading5 = FlexmarkHtmlConverter.SKIP_HEADING_5.get(options);
        this.skipHeading6 = FlexmarkHtmlConverter.SKIP_HEADING_6.get(options);
        this.skipAttributes = FlexmarkHtmlConverter.SKIP_ATTRIBUTES.get(options);
        this.skipFencedCode = FlexmarkHtmlConverter.SKIP_FENCED_CODE.get(options);
        this.skipCharEscape = FlexmarkHtmlConverter.SKIP_CHAR_ESCAPE.get(options);
        this.divTableProcessing = FlexmarkHtmlConverter.DIV_TABLE_PROCESSING.get(options);
        this.extInlineStrong = FlexmarkHtmlConverter.EXT_INLINE_STRONG.get(options);
        this.extInlineEmphasis = FlexmarkHtmlConverter.EXT_INLINE_EMPHASIS.get(options);
        this.extInlineCode = FlexmarkHtmlConverter.EXT_INLINE_CODE.get(options);
        this.extInlineDel = FlexmarkHtmlConverter.EXT_INLINE_DEL.get(options);
        this.extInlineIns = FlexmarkHtmlConverter.EXT_INLINE_INS.get(options);
        this.extInlineSub = FlexmarkHtmlConverter.EXT_INLINE_SUB.get(options);
        this.extInlineSup = FlexmarkHtmlConverter.EXT_INLINE_SUP.get(options);
        this.extMath = FlexmarkHtmlConverter.EXT_MATH.get(options);
        this.extInlineLink = FlexmarkHtmlConverter.EXT_INLINE_LINK.get(options);
        this.extInlineImage = FlexmarkHtmlConverter.EXT_INLINE_IMAGE.get(options);
        this.orderedListDelimiter = FlexmarkHtmlConverter.ORDERED_LIST_DELIMITER.get(options).charValue();
        this.unorderedListDelimiter = FlexmarkHtmlConverter.UNORDERED_LIST_DELIMITER.get(options).charValue();
        this.definitionMarkerSpaces = FlexmarkHtmlConverter.DEFINITION_MARKER_SPACES.get(options);
        this.minSetextHeadingMarkerLength = Utils.minLimit(FlexmarkHtmlConverter.MIN_SETEXT_HEADING_MARKER_LENGTH.get(options), 3);
        this.listItemIndent = FlexmarkHtmlConverter.LIST_ITEM_INDENT.get(options);
        this.codeIndent = FlexmarkHtmlConverter.CODE_INDENT.get(options);
        this.eolInTitleAttribute = FlexmarkHtmlConverter.EOL_IN_TITLE_ATTRIBUTE.get(options);
        this.nbspText = FlexmarkHtmlConverter.NBSP_TEXT.get(options);
        this.thematicBreak = FlexmarkHtmlConverter.THEMATIC_BREAK.get(options);
        this.outputAttributesNamesRegex = FlexmarkHtmlConverter.OUTPUT_ATTRIBUTES_NAMES_REGEX.get(options);
        this.outputAttributesNamesRegexPattern = Pattern.compile(this.outputAttributesNamesRegex);
        this.outputIdAttributeRegex = FlexmarkHtmlConverter.OUTPUT_ID_ATTRIBUTE_REGEX.get(options);
        this.outputIdAttributeRegexPattern = Pattern.compile(this.outputIdAttributeRegex);
        this.tableCellAlignmentMap = FlexmarkHtmlConverter.TABLE_CELL_ALIGNMENT_MAP.get(options);
        this.tableOptions = new TableFormatOptions(options);
        this.formatFlags = FlexmarkHtmlConverter.FORMAT_FLAGS.get(options);
        this.maxBlankLines = FlexmarkHtmlConverter.MAX_BLANK_LINES.get(options);
        this.maxTrailingBlankLines = FlexmarkHtmlConverter.MAX_TRAILING_BLANK_LINES.get(options);
        this.unwrappedTags = FlexmarkHtmlConverter.UNWRAPPED_TAGS.get(options);
        this.wrappedTags = FlexmarkHtmlConverter.WRAPPED_TAGS.get(options);
        this.divTableRowClasses = FlexmarkHtmlConverter.DIV_TABLE_ROW_CLASSES.get(options);
        this.divTableCellClasses = FlexmarkHtmlConverter.DIV_TABLE_CELL_CLASSES.get(options);
        this.divTableHdrClasses = FlexmarkHtmlConverter.DIV_TABLE_HDR_CLASSES.get(options);
    }

    @Override
    @NotNull
    public MutableDataHolder setIn(@NotNull MutableDataHolder dataHolder) {
        dataHolder.set(FlexmarkHtmlConverter.LIST_CONTENT_INDENT, Boolean.valueOf(this.listContentIndent));
        dataHolder.set(FlexmarkHtmlConverter.SETEXT_HEADINGS, Boolean.valueOf(this.setextHeadings));
        dataHolder.set(FlexmarkHtmlConverter.OUTPUT_UNKNOWN_TAGS, Boolean.valueOf(this.outputUnknownTags));
        dataHolder.set(FlexmarkHtmlConverter.TYPOGRAPHIC_QUOTES, Boolean.valueOf(this.typographicQuotes));
        dataHolder.set(FlexmarkHtmlConverter.TYPOGRAPHIC_SMARTS, Boolean.valueOf(this.typographicSmarts));
        dataHolder.set(FlexmarkHtmlConverter.OUTPUT_ATTRIBUTES_ID, Boolean.valueOf(this.outputAttributesIdAttr));
        dataHolder.set(FlexmarkHtmlConverter.WRAP_AUTO_LINKS, Boolean.valueOf(this.wrapAutoLinks));
        dataHolder.set(FlexmarkHtmlConverter.EXTRACT_AUTO_LINKS, Boolean.valueOf(this.extractAutoLinks));
        dataHolder.set(FlexmarkHtmlConverter.RENDER_COMMENTS, Boolean.valueOf(this.renderComments));
        dataHolder.set(FlexmarkHtmlConverter.DOT_ONLY_NUMERIC_LISTS, Boolean.valueOf(this.dotOnlyNumericLists));
        dataHolder.set(FlexmarkHtmlConverter.COMMENT_ORIGINAL_NON_NUMERIC_LIST_ITEM, Boolean.valueOf(this.commentOriginalNonNumericListItem));
        dataHolder.set(FlexmarkHtmlConverter.PRE_CODE_PRESERVE_EMPHASIS, Boolean.valueOf(this.preCodePreserveEmphasis));
        dataHolder.set(FlexmarkHtmlConverter.LISTS_END_ON_DOUBLE_BLANK, Boolean.valueOf(this.listsEndOnDoubleBlank));
        dataHolder.set(FlexmarkHtmlConverter.DIV_AS_PARAGRAPH, Boolean.valueOf(this.divAsParagraph));
        dataHolder.set(FlexmarkHtmlConverter.BR_AS_PARA_BREAKS, Boolean.valueOf(this.brAsParaBreaks));
        dataHolder.set(FlexmarkHtmlConverter.BR_AS_EXTRA_BLANK_LINES, Boolean.valueOf(this.brAsExtraBlankLines));
        dataHolder.set(FlexmarkHtmlConverter.IGNORE_TABLE_HEADING_AFTER_ROWS, Boolean.valueOf(this.ignoreTableHeadingAfterRows));
        dataHolder.set(FlexmarkHtmlConverter.ADD_TRAILING_EOL, Boolean.valueOf(this.addTrailingEol));
        dataHolder.set(FlexmarkHtmlConverter.SKIP_HEADING_1, Boolean.valueOf(this.skipHeading1));
        dataHolder.set(FlexmarkHtmlConverter.SKIP_HEADING_2, Boolean.valueOf(this.skipHeading2));
        dataHolder.set(FlexmarkHtmlConverter.SKIP_HEADING_3, Boolean.valueOf(this.skipHeading3));
        dataHolder.set(FlexmarkHtmlConverter.SKIP_HEADING_4, Boolean.valueOf(this.skipHeading4));
        dataHolder.set(FlexmarkHtmlConverter.SKIP_HEADING_5, Boolean.valueOf(this.skipHeading5));
        dataHolder.set(FlexmarkHtmlConverter.SKIP_HEADING_6, Boolean.valueOf(this.skipHeading6));
        dataHolder.set(FlexmarkHtmlConverter.SKIP_ATTRIBUTES, Boolean.valueOf(this.skipAttributes));
        dataHolder.set(FlexmarkHtmlConverter.SKIP_FENCED_CODE, Boolean.valueOf(this.skipFencedCode));
        dataHolder.set(FlexmarkHtmlConverter.SKIP_CHAR_ESCAPE, Boolean.valueOf(this.skipCharEscape));
        dataHolder.set(FlexmarkHtmlConverter.DIV_TABLE_PROCESSING, Boolean.valueOf(this.divTableProcessing));
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_STRONG, this.extInlineStrong);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_EMPHASIS, this.extInlineEmphasis);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_CODE, this.extInlineCode);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_DEL, this.extInlineDel);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_INS, this.extInlineIns);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_SUB, this.extInlineSub);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_SUP, this.extInlineSup);
        dataHolder.set(FlexmarkHtmlConverter.ORDERED_LIST_DELIMITER, Character.valueOf(this.orderedListDelimiter));
        dataHolder.set(FlexmarkHtmlConverter.UNORDERED_LIST_DELIMITER, Character.valueOf(this.unorderedListDelimiter));
        dataHolder.set(FlexmarkHtmlConverter.DEFINITION_MARKER_SPACES, Integer.valueOf(this.definitionMarkerSpaces));
        dataHolder.set(FlexmarkHtmlConverter.MIN_SETEXT_HEADING_MARKER_LENGTH, Integer.valueOf(this.minSetextHeadingMarkerLength));
        dataHolder.set(FlexmarkHtmlConverter.CODE_INDENT, this.codeIndent);
        dataHolder.set(FlexmarkHtmlConverter.EOL_IN_TITLE_ATTRIBUTE, this.eolInTitleAttribute);
        dataHolder.set(FlexmarkHtmlConverter.NBSP_TEXT, this.nbspText);
        dataHolder.set(FlexmarkHtmlConverter.THEMATIC_BREAK, this.thematicBreak);
        dataHolder.set(FlexmarkHtmlConverter.OUTPUT_ATTRIBUTES_NAMES_REGEX, this.outputAttributesNamesRegex);
        dataHolder.set(FlexmarkHtmlConverter.TABLE_CELL_ALIGNMENT_MAP, this.tableCellAlignmentMap);
        dataHolder.set(FlexmarkHtmlConverter.OUTPUT_ID_ATTRIBUTE_REGEX, this.outputIdAttributeRegex);
        dataHolder.set(FlexmarkHtmlConverter.EXT_MATH, this.extMath);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_LINK, this.extInlineLink);
        dataHolder.set(FlexmarkHtmlConverter.EXT_INLINE_IMAGE, this.extInlineImage);
        dataHolder.setFrom(this.tableOptions);
        dataHolder.set(FlexmarkHtmlConverter.FORMAT_FLAGS, Integer.valueOf(this.formatFlags));
        dataHolder.set(FlexmarkHtmlConverter.MAX_BLANK_LINES, Integer.valueOf(this.maxBlankLines));
        dataHolder.set(FlexmarkHtmlConverter.MAX_TRAILING_BLANK_LINES, Integer.valueOf(this.maxTrailingBlankLines));
        dataHolder.set(FlexmarkHtmlConverter.UNWRAPPED_TAGS, this.unwrappedTags);
        dataHolder.set(FlexmarkHtmlConverter.WRAPPED_TAGS, this.wrappedTags);
        dataHolder.set(FlexmarkHtmlConverter.DIV_TABLE_ROW_CLASSES, this.divTableRowClasses);
        dataHolder.set(FlexmarkHtmlConverter.DIV_TABLE_CELL_CLASSES, this.divTableCellClasses);
        dataHolder.set(FlexmarkHtmlConverter.DIV_TABLE_HDR_CLASSES, this.divTableHdrClasses);
        return dataHolder;
    }
}

