/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateUtil {
    public static final Resolver NULL_RESOLVER = groups -> null;

    public static String resolveRefs(CharSequence text, Pattern pattern, Resolver resolver2) {
        if (text == null) {
            return "";
        }
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            StringBuffer sb = new StringBuffer();
            do {
                String[] groups = new String[matcher.groupCount() + 1];
                for (int i = 0; i < groups.length; ++i) {
                    groups[i] = matcher.group(i);
                }
                String resolved = resolver2.resolve(groups);
                matcher.appendReplacement(sb, resolved == null ? "" : resolved.replace("\\", "\\\\").replace("$", "\\$"));
            } while (matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return text.toString();
    }

    public static interface Resolver {
        public String resolve(String[] var1);
    }

    public static class MappedResolver
    implements Resolver {
        protected final Map<String, String> resolved;

        public MappedResolver(Map<String, String> map) {
            this.resolved = map;
        }

        public MappedResolver() {
            this(new HashMap<String, String>());
        }

        public MappedResolver set(String name, String value) {
            this.resolved.put(name, value);
            return this;
        }

        public Map<String, String> getMMap() {
            return this.resolved;
        }

        @Override
        public String resolve(String[] groups) {
            return groups.length > 2 ? null : this.resolved.get(groups[1]);
        }
    }
}

