/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.model.psi.headers;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiCompletableReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.MarkdownIcons;
import org.intellij.plugins.markdown.lang.index.HeaderAnchorIndex;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.model.psi.MarkdownPsiSymbolReferenceBase;
import org.intellij.plugins.markdown.model.psi.headers.HeaderAnchorLinkDestinationReference;
import org.intellij.plugins.markdown.model.psi.headers.HeaderAnchorLinkDestinationReference$collectHtmlAnchorAttributesValues$;
import org.intellij.plugins.markdown.model.psi.headers.HeaderAnchorLinkDestinationReference$getCompletionVariants$;
import org.intellij.plugins.markdown.model.psi.headers.HeaderSymbol;
import org.intellij.plugins.markdown.model.psi.headers.html.HtmlAnchorSymbol;
import org.intellij.plugins.markdown.model.psi.headers.html.HtmlAnchorsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/model/psi/headers/HeaderAnchorLinkDestinationReference;", "Lorg/intellij/plugins/markdown/model/psi/MarkdownPsiSymbolReferenceBase;", "Lcom/intellij/model/psi/PsiCompletableReference;", "element", "Lcom/intellij/psi/PsiElement;", "anchorRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "anchorText", "", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;Lcom/intellij/psi/PsiFile;)V", "collectHtmlAnchorAttributesValues", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/xml/XmlAttributeValue;", "collectInjectedHtmlAnchors", "Lorg/intellij/plugins/markdown/model/psi/headers/html/HtmlAnchorSymbol;", "getCompletionVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "resolveReference", "Lcom/intellij/model/Symbol;", "intellij.markdown.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHeaderAnchorLinkDestinationReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderAnchorLinkDestinationReference.kt\norg/intellij/plugins/markdown/model/psi/headers/HeaderAnchorLinkDestinationReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 PsiUtils.kt\norg/intellij/plugins/markdown/lang/psi/util/PsiUtilsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,74:1\n1603#2,9:75\n1855#2:84\n1856#2:86\n1612#2:87\n1#3:85\n25#4:88\n473#5:89\n473#5:90\n*S KotlinDebug\n*F\n+ 1 HeaderAnchorLinkDestinationReference.kt\norg/intellij/plugins/markdown/model/psi/headers/HeaderAnchorLinkDestinationReference\n*L\n33#1:75,9\n33#1:84\n33#1:86\n33#1:87\n33#1:85\n45#1:88\n45#1:89\n70#1:90\n*E\n"})
public final class HeaderAnchorLinkDestinationReference
extends MarkdownPsiSymbolReferenceBase
implements PsiCompletableReference {
    @NotNull
    private final String anchorText;
    @NotNull
    private final PsiFile file;

    public HeaderAnchorLinkDestinationReference(@NotNull PsiElement element2, @NotNull TextRange anchorRangeInElement, @NotNull String anchorText, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)anchorRangeInElement, (String)"anchorRangeInElement");
        Intrinsics.checkNotNullParameter((Object)anchorText, (String)"anchorText");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(element2, anchorRangeInElement);
        this.anchorText = anchorText;
        this.file = file;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Symbol> resolveReference() {
        void $this$mapNotNullTo$iv$iv;
        Project project = this.getElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)this.file);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(file)");
        Collection<MarkdownHeader> headers2 = HeaderAnchorIndex.Companion.collectHeaders(project, globalSearchScope, this.anchorText);
        Iterable $this$mapNotNull$iv = headers2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            HeaderSymbol it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MarkdownHeader it = (MarkdownHeader)element$iv$iv;
            boolean bl2 = false;
            Pointer<HeaderSymbol> pointer = HeaderSymbol.Companion.createPointer(it);
            if ((pointer != null ? (HeaderSymbol)pointer.dereference() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List headerSymbols = (List)destination$iv$iv;
        Sequence<HtmlAnchorSymbol> injectedSymbols = this.collectInjectedHtmlAnchors();
        return CollectionsKt.plus((Collection)headerSymbols, injectedSymbols);
    }

    private final Sequence<HtmlAnchorSymbol> collectInjectedHtmlAnchors() {
        PsiFile psiFile = HtmlAnchorsKt.findInjectedHtmlFile(this.file);
        if (psiFile == null) {
            return SequencesKt.emptySequence();
        }
        PsiFile injectedFile = psiFile;
        Sequence htmlValues2 = SequencesKt.filter(this.collectHtmlAnchorAttributesValues(injectedFile), (Function1)((Function1)new Function1<XmlAttributeValue, Boolean>(this){
            final /* synthetic */ HeaderAnchorLinkDestinationReference this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull XmlAttributeValue it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getValue(), (Object)HeaderAnchorLinkDestinationReference.access$getAnchorText$p(this.this$0));
            }
        }));
        return SequencesKt.map((Sequence)htmlValues2, (Function1)((Function1)new Function1<XmlAttributeValue, HtmlAnchorSymbol>(this){
            final /* synthetic */ HeaderAnchorLinkDestinationReference this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final HtmlAnchorSymbol invoke(@NotNull XmlAttributeValue it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PsiFile psiFile = HeaderAnchorLinkDestinationReference.access$getFile$p(this.this$0);
                TextRange textRange = it.getValueTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"it.valueTextRange");
                return new HtmlAnchorSymbol(psiFile, textRange, HeaderAnchorLinkDestinationReference.access$getAnchorText$p(this.this$0));
            }
        }));
    }

    @NotNull
    public Collection<LookupElement> getCompletionVariants() {
        LookupElementBuilder lookup;
        PsiElement $this$childrenOfType$iv = (PsiElement)this.file;
        boolean $i$f$childrenOfType = false;
        Sequence<PsiElement> $this$filterIsInstance$iv$iv = PsiUtilsKt.children($this$childrenOfType$iv);
        boolean $i$f$filterIsInstance2 = false;
        Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv$iv, (Function1)getCompletionVariants$$inlined$childrenOfType$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence headers2 = sequence;
        Sequence anchors2 = SequencesKt.mapNotNull((Sequence)headers2, (Function1)getCompletionVariants.anchors.1.INSTANCE);
        ArrayList<LookupElementBuilder> result2 = new ArrayList<LookupElementBuilder>();
        for (Pair $i$f$filterIsInstance2 : anchors2) {
            String anchorText = (String)$i$f$filterIsInstance2.component1();
            int level = ((Number)$i$f$filterIsInstance2.component2()).intValue();
            Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)anchorText).withIcon(MarkdownIcons.EditorActions.Link).withTypeText("H" + level, true), (String)"create(anchorText)\n     \u2026TypeText(\"H$level\", true)");
            result2.add(lookup);
        }
        PsiFile injectedFile = HtmlAnchorsKt.findInjectedHtmlFile(this.file);
        if (injectedFile != null) {
            Sequence<XmlAttributeValue> values = this.collectHtmlAnchorAttributesValues(injectedFile);
            for (XmlAttributeValue value : values) {
                Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)value.getValue()).withIcon(PlatformIcons.XML_TAG_ICON).withTypeText("Anchor", true), (String)"create(value.value)\n    \u2026hTypeText(\"Anchor\", true)");
                result2.add(lookup);
            }
        }
        return result2;
    }

    private final Sequence<XmlAttributeValue> collectHtmlAnchorAttributesValues(PsiFile file) {
        Sequence traverser;
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file));
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"psiTraverser(file)");
        Sequence $this$filterIsInstance$iv = traverser = CollectionsKt.asSequence((Iterable)((Iterable)syntaxTraverser));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)collectHtmlAnchorAttributesValues$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence values = sequence;
        return SequencesKt.filter((Sequence)values, (Function1)collectHtmlAnchorAttributesValues.1.INSTANCE);
    }

    public static final /* synthetic */ String access$getAnchorText$p(HeaderAnchorLinkDestinationReference $this) {
        return $this.anchorText;
    }

    public static final /* synthetic */ PsiFile access$getFile$p(HeaderAnchorLinkDestinationReference $this) {
        return $this.file;
    }
}

