/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.profilers.async.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.system.CpuArch;
import com.jetbrains.performancePlugin.profilers.async.core.AsyncBundle;
import com.jetbrains.performancePlugin.profilers.async.core.AsyncProfilerHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import one.profiler.AsyncProfiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\b\u0010\f\u001a\u00020\rH\u0002\u001a\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "ourExtractedFile", "Ljava/io/File;", "ourLastModified", "", "checkWallEventAvailable", "", "profiler", "Lone/profiler/AsyncProfiler;", "getAsyncLibPath", "", "getAsyncProfilerInstance", "Ljava/util/concurrent/CompletableFuture;", "intellij.performanceTesting.async.core"})
@SourceDebugExtension(value={"SMAP\nAsyncProfilerHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncProfilerHandler.kt\ncom/jetbrains/performancePlugin/profilers/async/core/AsyncProfilerHandlerKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,346:1\n10#2:347\n*S KotlinDebug\n*F\n+ 1 AsyncProfilerHandler.kt\ncom/jetbrains/performancePlugin/profilers/async/core/AsyncProfilerHandlerKt\n*L\n50#1:347\n*E\n"})
public final class AsyncProfilerHandlerKt {
    @Nullable
    private static File ourExtractedFile;
    private static long ourLastModified;

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AsyncProfilerHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        return logger;
    }

    private static final CompletableFuture<AsyncProfiler> getAsyncProfilerInstance() throws IOException {
        CompletableFuture<AsyncProfiler> result = new CompletableFuture<AsyncProfiler>();
        String string = AsyncBundle.message("starting.async.profiler", new Object[0]);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(result, string){
            final /* synthetic */ CompletableFuture<AsyncProfiler> $result;
            {
                this.$result = $result;
                super(null, $super_call_param$1);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.$result.complete(AsyncProfiler.getInstance((String)AsyncProfilerHandlerKt.access$getAsyncLibPath()));
            }
        }, (ProgressIndicator)new EmptyProgressIndicator());
        return result;
    }

    private static final boolean checkWallEventAvailable(AsyncProfiler profiler) {
        try {
            String string = profiler.execute("check,event=wall");
            return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"OK", (boolean)false, (int)2, null) : true;
        }
        catch (IOException e) {
            AsyncProfilerHandlerKt.getLOG().warn((Throwable)e);
        }
        catch (IllegalStateException e) {
            AsyncProfilerHandlerKt.getLOG().warn((Throwable)e);
        }
        return false;
    }

    private static final String getAsyncLibPath() {
        File extractedFile = ourExtractedFile;
        if (extractedFile == null || !extractedFile.exists() || extractedFile.lastModified() != ourLastModified) {
            String string;
            boolean isWindows = SystemInfo.isWindows;
            String agentLib = isWindows ? "libasyncProfiler.dll" : (SystemInfo.isMac ? "libasyncProfiler.dylib" : "libasyncProfiler.so");
            Class<AsyncProfiler> aClass = AsyncProfiler.class;
            if (isWindows) {
                string = "windows";
            } else if (SystemInfo.isLinux && CpuArch.isIntel64()) {
                string = "linux";
            } else if (SystemInfo.isLinux && CpuArch.isArm64()) {
                string = "linux-aarch64";
            } else if (SystemInfo.isMac) {
                string = "macos";
            } else {
                throw new IllegalStateException("Unsupported platform: " + SystemInfo.OS_NAME + " " + CpuArch.CURRENT);
            }
            String dir = string;
            String path = "/binaries/" + dir + "/" + agentLib;
            InputStream inputStream = aClass.getResourceAsStream(path);
            if (inputStream == null) {
                throw new FileNotFoundException(path);
            }
            InputStream inputStream2 = inputStream;
            extractedFile = FileUtil.createTempFile((String)("extracted_" + agentLib), null, (boolean)true);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(inputStream2, extractedFile.toPath(), copyOptionArray);
            ourExtractedFile = extractedFile;
            ourLastModified = extractedFile.lastModified();
        }
        String string = extractedFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractedFile.absolutePath");
        return string;
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return AsyncProfilerHandlerKt.getLOG();
    }

    public static final /* synthetic */ String access$getAsyncLibPath() {
        return AsyncProfilerHandlerKt.getAsyncLibPath();
    }

    public static final /* synthetic */ boolean access$checkWallEventAvailable(AsyncProfiler profiler) {
        return AsyncProfilerHandlerKt.checkWallEventAvailable(profiler);
    }

    public static final /* synthetic */ CompletableFuture access$getAsyncProfilerInstance() {
        return AsyncProfilerHandlerKt.getAsyncProfilerInstance();
    }

    static {
        ourLastModified = -1L;
    }
}

