/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.branch.DvcsBranchPopup;
import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.BranchActionUtil;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.dvcs.ui.RootAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.branch.HgBranchPopupActions;
import org.zmlx.hg4idea.branch.HgCommonBranchActions;
import org.zmlx.hg4idea.branch.HgMultiRootBranchConfig;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public final class HgBranchPopup
extends DvcsBranchPopup<HgRepository> {
    private static final String DIMENSION_SERVICE_KEY = "Hg.Branch.Popup";
    static final String SHOW_ALL_BRANCHES_KEY = "Hg.Branch.Popup.ShowAllBranches";
    static final String SHOW_ALL_BOOKMARKS_KEY = "Hg.Branch.Popup.ShowAllBookmarks";
    static final String SHOW_ALL_REPOSITORIES = "Hg.Branch.Popup.ShowAllRepositories";

    public static HgBranchPopup getInstance(@NotNull Project project, @NotNull HgRepository currentRepository, @NotNull DataContext dataContext) {
        if (project == null) {
            HgBranchPopup.$$$reportNull$$$0(0);
        }
        if (currentRepository == null) {
            HgBranchPopup.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            HgBranchPopup.$$$reportNull$$$0(2);
        }
        HgRepositoryManager manager = HgUtil.getRepositoryManager(project);
        HgProjectSettings hgProjectSettings = (HgProjectSettings)project.getService(HgProjectSettings.class);
        HgMultiRootBranchConfig hgMultiRootBranchConfig = new HgMultiRootBranchConfig(manager.getRepositories());
        return new HgBranchPopup(currentRepository, manager, hgMultiRootBranchConfig, hgProjectSettings, (Condition<AnAction>)Conditions.alwaysFalse(), dataContext);
    }

    private HgBranchPopup(@NotNull HgRepository currentRepository, @NotNull HgRepositoryManager repositoryManager, @NotNull HgMultiRootBranchConfig hgMultiRootBranchConfig, @NotNull HgProjectSettings vcsSettings, @NotNull Condition<AnAction> preselectActionCondition, @NotNull DataContext dataContext) {
        if (currentRepository == null) {
            HgBranchPopup.$$$reportNull$$$0(3);
        }
        if (repositoryManager == null) {
            HgBranchPopup.$$$reportNull$$$0(4);
        }
        if (hgMultiRootBranchConfig == null) {
            HgBranchPopup.$$$reportNull$$$0(5);
        }
        if (vcsSettings == null) {
            HgBranchPopup.$$$reportNull$$$0(6);
        }
        if (preselectActionCondition == null) {
            HgBranchPopup.$$$reportNull$$$0(7);
        }
        if (dataContext == null) {
            HgBranchPopup.$$$reportNull$$$0(8);
        }
        super((Repository)currentRepository, (AbstractRepositoryManager)repositoryManager, (DvcsMultiRootBranchConfig)hgMultiRootBranchConfig, (DvcsSyncSettings)vcsSettings, preselectActionCondition, DIMENSION_SERVICE_KEY, dataContext);
    }

    protected void fillWithCommonRepositoryActions(@NotNull LightActionGroup popupGroup, @NotNull AbstractRepositoryManager<HgRepository> repositoryManager) {
        if (popupGroup == null) {
            HgBranchPopup.$$$reportNull$$$0(9);
        }
        if (repositoryManager == null) {
            HgBranchPopup.$$$reportNull$$$0(10);
        }
        List allRepositories = repositoryManager.getRepositories();
        popupGroup.add((AnAction)new HgBranchPopupActions.HgNewBranchAction(this.myProject, allRepositories, (HgRepository)this.myCurrentRepository));
        popupGroup.addAction((AnAction)new HgBranchPopupActions.HgNewBookmarkAction(allRepositories, (HgRepository)this.myCurrentRepository));
        popupGroup.addAction((AnAction)new HgBranchPopupActions.HgCloseBranchAction(allRepositories, (HgRepository)this.myCurrentRepository));
        popupGroup.addAction((AnAction)new HgBranchPopupActions.HgShowUnnamedHeadsForCurrentBranchAction((HgRepository)this.myCurrentRepository));
        popupGroup.addAll((ActionGroup)this.createRepositoriesActions());
        popupGroup.addSeparator(HgBundle.message("hg4idea.branch.common.branches.separator", new Object[0]));
        List branchActions = this.myMultiRootBranchConfig.getLocalBranchNames().stream().map(b -> this.createLocalBranchActions(allRepositories, (String)b, false)).filter(Objects::nonNull).sorted(BranchActionUtil.FAVORITE_BRANCH_COMPARATOR).collect(Collectors.toList());
        int topShownBranches = BranchActionUtil.getNumOfTopShownBranches(branchActions);
        String commonBranch = MultiRootBranches.getCommonName((Collection)this.myRepositoryManager.getRepositories(), Repository::getCurrentBranchName);
        if (commonBranch != null) {
            branchActions.add(0, new HgBranchPopupActions.CurrentBranch(this.myProject, allRepositories, commonBranch));
            ++topShownBranches;
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, branchActions, (int)topShownBranches, (String)SHOW_ALL_BRANCHES_KEY, (boolean)true);
        popupGroup.addSeparator(HgBundle.message("hg4idea.branch.common.bookmarks.separator", new Object[0]));
        List bookmarkActions = ((HgMultiRootBranchConfig)this.myMultiRootBranchConfig).getBookmarkNames().stream().map(bm -> this.createLocalBranchActions(allRepositories, (String)bm, true)).filter(Objects::nonNull).sorted(BranchActionUtil.FAVORITE_BRANCH_COMPARATOR).collect(Collectors.toList());
        int topShownBookmarks = BranchActionUtil.getNumOfTopShownBranches(bookmarkActions);
        String commonBookmark = MultiRootBranches.getCommonName((Collection)repositoryManager.getRepositories(), HgRepository::getCurrentBookmark);
        if (commonBookmark != null) {
            bookmarkActions.add(0, new HgBranchPopupActions.CurrentActiveBookmark(this.myProject, allRepositories, commonBookmark));
            ++topShownBookmarks;
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, bookmarkActions, (int)topShownBookmarks, (String)SHOW_ALL_BOOKMARKS_KEY, (boolean)true);
    }

    @Nullable
    private HgCommonBranchActions createLocalBranchActions(List<HgRepository> allRepositories, String name, boolean isBookmark) {
        List repositories = this.filterRepositoriesNotOnThisBranch(name, allRepositories);
        if (repositories.isEmpty()) {
            return null;
        }
        return isBookmark ? new HgBranchPopupActions.BookmarkActions(this.myProject, repositories, name) : new HgBranchPopupActions.BranchActions(this.myProject, repositories, name);
    }

    @NotNull
    protected LightActionGroup createRepositoriesActions() {
        LightActionGroup popupGroup = new LightActionGroup(false);
        popupGroup.addSeparator(HgBundle.message("repositories", new Object[0]));
        List rootActions = DvcsUtil.sortRepositories((Collection)this.myRepositoryManager.getRepositories()).stream().map(repo -> new RootAction((Repository)repo, new HgBranchPopupActions(repo.getProject(), (HgRepository)repo).createActions(), HgUtil.getDisplayableBranchOrBookmarkText(repo))).collect(Collectors.toList());
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, rootActions, (int)(rootActions.size() > 8 ? 5 : 8), (String)SHOW_ALL_REPOSITORIES);
        LightActionGroup lightActionGroup = popupGroup;
        if (lightActionGroup == null) {
            HgBranchPopup.$$$reportNull$$$0(11);
        }
        return lightActionGroup;
    }

    protected void fillPopupWithCurrentRepositoryActions(@NotNull LightActionGroup popupGroup, @Nullable LightActionGroup actions) {
        if (popupGroup == null) {
            HgBranchPopup.$$$reportNull$$$0(12);
        }
        popupGroup.addAll(new HgBranchPopupActions(this.myProject, (HgRepository)this.myCurrentRepository).createActions(actions, this.myInSpecificRepository ? (HgRepository)this.myCurrentRepository : null, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRepository";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hgMultiRootBranchConfig";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preselectActionCondition";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupGroup";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/branch/HgBranchPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopup";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createRepositoriesActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fillWithCommonRepositoryActions";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fillPopupWithCurrentRepositoryActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

