/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.settingsSync.CloudConfigServerCommunicator;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSnapshotKt;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncLocalSettings;
import com.intellij.settingsSync.SettingsSyncMain;
import com.intellij.settingsSync.SettingsSyncMainKt;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.SettingsSyncTroubleshootingAction;
import com.intellij.settingsSync.SettingsSyncTroubleshootingActionKt;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.ui.JBAccountInfoService;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.util.io.Compressor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.cloudconfig.CloudConfigFileClientV2;
import com.jetbrains.cloudconfig.FileVersionInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0004\u0017\u0018\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "collectFileStructure", "Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode$Root;", "remoteCommunicator", "Lcom/intellij/settingsSync/CloudConfigServerCommunicator;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getVersion", "Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$Version;", "filePath", "", "version", "Lcom/jetbrains/cloudconfig/FileVersionInfo;", "processFileOrDir", "Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode;", "path", "update", "Companion", "TreeNode", "TroubleshootingDialog", "Version", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nSettingsSyncTroubleshootingAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncTroubleshootingAction.kt\ncom/intellij/settingsSync/SettingsSyncTroubleshootingAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,433:1\n10#2:434\n*S KotlinDebug\n*F\n+ 1 SettingsSyncTroubleshootingAction.kt\ncom/intellij/settingsSync/SettingsSyncTroubleshootingAction\n*L\n394#1:434\n*E\n"})
public final class SettingsSyncTroubleshootingAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(SettingsSyncMainKt.isSettingsSyncEnabledByKey());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            SettingsSyncRemoteCommunicator remoteCommunicator = SettingsSyncMain.Companion.getInstance().getRemoteCommunicator$intellij_settingsSync();
            if (!(remoteCommunicator instanceof CloudConfigServerCommunicator)) {
                Object[] objectArray = new Object[]{Reflection.getOrCreateKotlinClass(remoteCommunicator.getClass())};
                Messages.showErrorDialog((Project)e.getProject(), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.error.wrong.configuration", objectArray), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.title", new Object[0]));
                return;
            }
            try {
                TreeNode.Root fileStructure = (TreeNode.Root)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> SettingsSyncTroubleshootingAction.actionPerformed$lambda$0(this, remoteCommunicator), SettingsSyncBundle.INSTANCE.message("troubleshooting.loading.info.progress.dialog.title", new Object[0]), false, e.getProject());
                Project project = e.getProject();
                CloudConfigServerCommunicator cloudConfigServerCommunicator = (CloudConfigServerCommunicator)remoteCommunicator;
                Intrinsics.checkNotNullExpressionValue((Object)fileStructure, (String)"fileStructure");
                new TroubleshootingDialog(project, cloudConfigServerCommunicator, fileStructure).show();
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
                if (Messages.showOkCancelDialog((Project)e.getProject(), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.error.check.log.file.for.errors", new Object[0]), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.error.loading.info.failed", new Object[0]), (String)ShowLogAction.getActionName(), (String)CommonBundle.getCancelButtonText(), null) != 0) break block3;
                ShowLogAction.showLog();
            }
        }
    }

    private final TreeNode.Root collectFileStructure(CloudConfigServerCommunicator remoteCommunicator) {
        TreeNode treeNode = this.processFileOrDir("/", remoteCommunicator);
        Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type com.intellij.settingsSync.SettingsSyncTroubleshootingAction.TreeNode.Root");
        return (TreeNode.Root)treeNode;
    }

    private final TreeNode processFileOrDir(String path, CloudConfigServerCommunicator remoteCommunicator) {
        CloudConfigFileClientV2 client = remoteCommunicator.getClient$intellij_settingsSync();
        try {
            List children = client.list(path);
            if (children.isEmpty()) {
                if (Intrinsics.areEqual((Object)path, (Object)"/")) {
                    return new TreeNode.Root(CollectionsKt.emptyList());
                }
                FileVersionInfo fileVersion = client.getLatestVersion(path);
                Intrinsics.checkNotNullExpressionValue((Object)fileVersion, (String)"fileVersion");
                Version version = this.getVersion(path, fileVersion, remoteCommunicator);
                return new TreeNode.Leaf(version);
            }
            List childNodes = new ArrayList();
            for (String child : children) {
                Object object;
                if (Intrinsics.areEqual((Object)path, (Object)"/")) {
                    object = child;
                } else {
                    char[] cArray = new char[]{'/'};
                    object = StringsKt.trim((String)path, (char[])cArray) + "/" + child;
                }
                String childPath = object;
                Collection collection = childNodes;
                Intrinsics.checkNotNullExpressionValue((Object)childPath, (String)"childPath");
                collection.add(this.processFileOrDir(childPath, remoteCommunicator));
            }
            return Intrinsics.areEqual((Object)path, (Object)"/") ? (TreeNode)new TreeNode.Root(childNodes) : (TreeNode)new TreeNode.Branch(childNodes);
        }
        catch (FileNotFoundException e) {
            FileVersionInfo fileVersion = client.getLatestVersion(path);
            Intrinsics.checkNotNullExpressionValue((Object)fileVersion, (String)"fileVersion");
            Version version = this.getVersion(path, fileVersion, remoteCommunicator);
            return new TreeNode.Leaf(version);
        }
    }

    private final Version getVersion(String filePath, FileVersionInfo version, CloudConfigServerCommunicator remoteCommunicator) {
        InputStream inputStream = remoteCommunicator.downloadSnapshot(filePath, version);
        Intrinsics.checkNotNull((Object)inputStream);
        InputStream stream2 = inputStream;
        if (StringsKt.endsWith$default((String)filePath, (String)".zip", (boolean)false, (int)2, null)) {
            return new Version(filePath, version, SettingsSyncTroubleshootingActionKt.access$extractSnapshotFromZipStream(stream2));
        }
        return new Version(filePath, version, null);
    }

    private static final TreeNode.Root actionPerformed$lambda$0(SettingsSyncTroubleshootingAction this$0, SettingsSyncRemoteCommunicator $remoteCommunicator) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$remoteCommunicator, (String)"$remoteCommunicator");
        return this$0.collectFileStructure((CloudConfigServerCommunicator)$remoteCommunicator);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncTroubleshootingAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode;", "", "()V", "Branch", "Leaf", "Root", "Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode$Branch;", "Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode$Leaf;", "intellij.settingsSync"})
    private static abstract class TreeNode {
        private TreeNode() {
        }

        public /* synthetic */ TreeNode(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode$Branch;", "Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode;", "children", "", "(Ljava/util/List;)V", "getChildren", "()Ljava/util/List;", "intellij.settingsSync"})
        public static class Branch
        extends TreeNode {
            @NotNull
            private final List<TreeNode> children;

            public Branch(@NotNull List<? extends TreeNode> children) {
                Intrinsics.checkNotNullParameter(children, (String)"children");
                super(null);
                this.children = children;
            }

            @NotNull
            public final List<TreeNode> getChildren() {
                return this.children;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode$Leaf;", "Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode;", "version", "Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$Version;", "(Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$Version;)V", "getVersion", "()Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$Version;", "intellij.settingsSync"})
        public static final class Leaf
        extends TreeNode {
            @NotNull
            private final Version version;

            public Leaf(@NotNull Version version) {
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                super(null);
                this.version = version;
            }

            @NotNull
            public final Version getVersion() {
                return this.version;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode$Root;", "Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode$Branch;", "children", "", "Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode;", "(Ljava/util/List;)V", "intellij.settingsSync"})
        public static final class Root
        extends Branch {
            public Root(@NotNull List<? extends TreeNode> children) {
                Intrinsics.checkNotNullParameter(children, (String)"children");
                super(children);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\"\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J0\u0010\u001d\u001a\u00020\u001a2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\u001cH\u0002J\u001a\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020 2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u001a\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\b\b\u0001\u0010,\u001a\u00020\u001cH\u0002J*\u0010-\u001a\u00020\u001a2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001cH\u0002J\f\u0010.\u001a\u00020\u001a*\u00020&H\u0002J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020100*\u0002022\n\b\u0001\u00103\u001a\u0004\u0018\u000104H\u0002J\u0016\u00105\u001a\u000202*\u00020&2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0016\u00106\u001a\u000202*\u00020&2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\f\u00107\u001a\u000202*\u00020&H\u0002J\u0011\u00108\u001a\u00070\u001c\u00a2\u0006\u0002\b9*\u00020\u001cH\u0002J\f\u0010:\u001a\u000202*\u00020&H\u0002J$\u0010;\u001a\u000202*\u00020&2\u0006\u0010#\u001a\u00020 2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006?"}, d2={"Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TroubleshootingDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "remoteCommunicator", "Lcom/intellij/settingsSync/CloudConfigServerCommunicator;", "rootNode", "Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode$Branch;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/settingsSync/CloudConfigServerCommunicator;Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode$Branch;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRemoteCommunicator", "()Lcom/intellij/settingsSync/CloudConfigServerCommunicator;", "getRootNode", "()Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode$Branch;", "userData", "Lcom/intellij/ui/JBAccountInfoService$JBAData;", "getUserData", "()Lcom/intellij/ui/JBAccountInfoService$JBAData;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "deleteFile", "", "filePath", "", "downloadFullHistory", "history", "", "Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$Version;", "loginName", "downloadVersion", "version", "generateFileSubTree", "panel", "Lcom/intellij/ui/dsl/builder/Panel;", "node", "Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TreeNode;", "showFileDownloadedMessage", "file", "Ljava/io/File;", "message", "showHistoryDialog", "appInfoRow", "copyableLabel", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBLabel;", "Lcom/intellij/ui/dsl/builder/Row;", "text", "", "emailRow", "loginNameRow", "serverUrlRow", "shorten", "Lorg/jetbrains/annotations/NotNull;", "statusRow", "versionRow", "showHistoryButton", "", "showDeleteButton", "intellij.settingsSync"})
    @SourceDebugExtension(value={"SMAP\nSettingsSyncTroubleshootingAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncTroubleshootingAction.kt\ncom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TroubleshootingDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,433:1\n1#2:434\n1559#3:435\n1590#3,4:436\n*S KotlinDebug\n*F\n+ 1 SettingsSyncTroubleshootingAction.kt\ncom/intellij/settingsSync/SettingsSyncTroubleshootingAction$TroubleshootingDialog\n*L\n307#1:435\n307#1:436,4\n*E\n"})
    private static final class TroubleshootingDialog
    extends DialogWrapper {
        @Nullable
        private final Project project;
        @NotNull
        private final CloudConfigServerCommunicator remoteCommunicator;
        @NotNull
        private final TreeNode.Branch rootNode;
        @Nullable
        private final JBAccountInfoService.JBAData userData;

        public TroubleshootingDialog(@Nullable Project project, @NotNull CloudConfigServerCommunicator remoteCommunicator, @NotNull TreeNode.Branch rootNode) {
            Intrinsics.checkNotNullParameter((Object)remoteCommunicator, (String)"remoteCommunicator");
            Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
            super(project, true);
            this.project = project;
            this.remoteCommunicator = remoteCommunicator;
            this.rootNode = rootNode;
            this.userData = SettingsSyncAuthService.Companion.getInstance().getUserData();
            this.setTitle(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.title", new Object[0]));
            this.init();
        }

        @Nullable
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final CloudConfigServerCommunicator getRemoteCommunicator() {
            return this.remoteCommunicator;
        }

        @NotNull
        public final TreeNode.Branch getRootNode() {
            return this.rootNode;
        }

        @Nullable
        public final JBAccountInfoService.JBAData getUserData() {
            return this.userData;
        }

        @NotNull
        protected Action[] createActions() {
            this.setCancelButtonText(CommonBundle.getCloseButtonText());
            this.getCancelAction().putValue("DefaultAction", true);
            Action[] actionArray = new Action[1];
            Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"cancelAction");
            return actionArray;
        }

        @NotNull
        protected JComponent createCenterPanel() {
            return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
                final /* synthetic */ TroubleshootingDialog this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Panel $this$panel) {
                    Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                    TroubleshootingDialog.access$statusRow(this.this$0, $this$panel);
                    TroubleshootingDialog.access$serverUrlRow(this.this$0, $this$panel);
                    TroubleshootingDialog.access$loginNameRow(this.this$0, $this$panel, this.this$0.getUserData());
                    TroubleshootingDialog.access$emailRow(this.this$0, $this$panel, this.this$0.getUserData());
                    TroubleshootingDialog.access$appInfoRow(this.this$0, $this$panel);
                    $this$panel.row(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.files", new Object[0]), (Function1)createCenterPanel.1.INSTANCE);
                    TroubleshootingDialog.access$generateFileSubTree(this.this$0, $this$panel, this.this$0.getRootNode());
                }
            }));
        }

        private final void generateFileSubTree(Panel panel, TreeNode node) {
            TreeNode treeNode = node;
            if (treeNode instanceof TreeNode.Root) {
                TroubleshootingDialog.generateFileSubTree$generateSubTreesForChildren(this, panel, (TreeNode.Branch)node);
            } else if (treeNode instanceof TreeNode.Branch) {
                panel.indent((Function1)new Function1<Panel, Unit>(node, this, panel){
                    final /* synthetic */ TreeNode $node;
                    final /* synthetic */ TroubleshootingDialog this$0;
                    final /* synthetic */ Panel $panel;
                    {
                        this.$node = $node;
                        this.this$0 = $receiver;
                        this.$panel = $panel;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$indent) {
                        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
                        TroubleshootingDialog.access$generateFileSubTree$generateSubTreesForChildren(this.this$0, this.$panel, (TreeNode.Branch)this.$node);
                    }
                });
            } else if (treeNode instanceof TreeNode.Leaf) {
                boolean itIsSettingsSnapshotFile = StringsKt.endsWith$default((String)((TreeNode.Leaf)node).getVersion().getFilePath(), (String)".zip", (boolean)false, (int)2, null);
                this.versionRow(panel, ((TreeNode.Leaf)node).getVersion(), itIsSettingsSnapshotFile, true);
            }
        }

        private final Row statusRow(Panel $this$statusRow) {
            return Panel.row$default((Panel)$this$statusRow, null, (Function1)statusRow.1.INSTANCE, (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        private final Row serverUrlRow(Panel $this$serverUrlRow) {
            return Panel.row$default((Panel)$this$serverUrlRow, null, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ TroubleshootingDialog this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                    $this$row.label(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.server.url.label", new Object[0]));
                    TroubleshootingDialog.access$copyableLabel(this.this$0, $this$row, CloudConfigServerCommunicator.Companion.getUrl$intellij_settingsSync());
                }
            }), (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        private final Row loginNameRow(Panel $this$loginNameRow, JBAccountInfoService.JBAData userData) {
            return Panel.row$default((Panel)$this$loginNameRow, null, (Function1)((Function1)new Function1<Row, Unit>(this, userData){
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ JBAccountInfoService.JBAData $userData;
                {
                    this.this$0 = $receiver;
                    this.$userData = $userData;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                    $this$row.label(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.login.label", new Object[0]));
                    JBAccountInfoService.JBAData jBAData = this.$userData;
                    TroubleshootingDialog.access$copyableLabel(this.this$0, $this$row, jBAData != null ? jBAData.loginName : null);
                }
            }), (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        private final Row emailRow(Panel $this$emailRow, JBAccountInfoService.JBAData userData) {
            return Panel.row$default((Panel)$this$emailRow, null, (Function1)((Function1)new Function1<Row, Unit>(this, userData){
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ JBAccountInfoService.JBAData $userData;
                {
                    this.this$0 = $receiver;
                    this.$userData = $userData;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                    $this$row.label(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.email.label", new Object[0]));
                    JBAccountInfoService.JBAData jBAData = this.$userData;
                    TroubleshootingDialog.access$copyableLabel(this.this$0, $this$row, jBAData != null ? jBAData.email : null);
                }
            }), (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        private final void appInfoRow(Panel $this$appInfoRow) {
            SettingsSnapshot.AppInfo appInfo = SettingsSnapshotKt.getLocalApplicationInfo();
            Panel.row$default((Panel)$this$appInfoRow, null, (Function1)((Function1)new Function1<Row, Unit>(this, appInfo){
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ SettingsSnapshot.AppInfo $appInfo;
                {
                    this.this$0 = $receiver;
                    this.$appInfo = $appInfo;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                    $this$row.label(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.applicationId.label", new Object[0]));
                    TroubleshootingDialog.access$copyableLabel(this.this$0, $this$row, this.$appInfo.getApplicationId());
                }
            }), (int)1, null).layout(RowLayout.PARENT_GRID);
            Panel.row$default((Panel)$this$appInfoRow, null, (Function1)((Function1)new Function1<Row, Unit>(this, appInfo){
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ SettingsSnapshot.AppInfo $appInfo;
                {
                    this.this$0 = $receiver;
                    this.$appInfo = $appInfo;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                    $this$row.label(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.username.label", new Object[0]));
                    TroubleshootingDialog.access$copyableLabel(this.this$0, $this$row, this.$appInfo.getUserName());
                }
            }), (int)1, null).layout(RowLayout.PARENT_GRID);
            Panel.row$default((Panel)$this$appInfoRow, null, (Function1)((Function1)new Function1<Row, Unit>(this, appInfo){
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ SettingsSnapshot.AppInfo $appInfo;
                {
                    this.this$0 = $receiver;
                    this.$appInfo = $appInfo;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                    $this$row.label(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.hostname.label", new Object[0]));
                    TroubleshootingDialog.access$copyableLabel(this.this$0, $this$row, this.$appInfo.getHostName());
                }
            }), (int)1, null).layout(RowLayout.PARENT_GRID);
            Panel.row$default((Panel)$this$appInfoRow, null, (Function1)((Function1)new Function1<Row, Unit>(this, appInfo){
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ SettingsSnapshot.AppInfo $appInfo;
                {
                    this.this$0 = $receiver;
                    this.$appInfo = $appInfo;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                    $this$row.label(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.configFolder.label", new Object[0]));
                    TroubleshootingDialog.access$copyableLabel(this.this$0, $this$row, this.$appInfo.getConfigFolder());
                }
            }), (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        private final String shorten(String $this$shorten) {
            String string = StringUtil.shortenTextWithEllipsis((String)$this$shorten, (int)12, (int)5, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(this, 12, 5, true)");
            return string;
        }

        private final Row versionRow(Panel $this$versionRow, Version version, boolean showHistoryButton, boolean showDeleteButton) {
            return Panel.row$default((Panel)$this$versionRow, null, (Function1)((Function1)new Function1<Row, Unit>(version, this, showHistoryButton, showDeleteButton){
                final /* synthetic */ Version $version;
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ boolean $showHistoryButton;
                final /* synthetic */ boolean $showDeleteButton;
                {
                    this.$version = $version;
                    this.this$0 = $receiver;
                    this.$showHistoryButton = $showHistoryButton;
                    this.$showDeleteButton = $showDeleteButton;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                    String[] stringArray = new String[]{"/"};
                    List split = StringsKt.split$default((CharSequence)this.$version.getFilePath(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    String $this$invoke_u24lambda_u240 = CollectionsKt.joinToString$default((Iterable)split.subList(0, split.size() - 1), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                    boolean bl = false;
                    Object folder = ((CharSequence)$this$invoke_u24lambda_u240).length() > 0 ? $this$invoke_u24lambda_u240 + "/" : "";
                    String file = (String)split.get(split.size() - 1);
                    $this$row.label("<html><b>" + (String)folder + "</b>" + file + "</html>");
                    Date date = this.$version.getFileVersion().getModifiedDate();
                    Intrinsics.checkNotNullExpressionValue((Object)date, (String)"version.fileVersion.modifiedDate");
                    TroubleshootingDialog.access$copyableLabel(this.this$0, $this$row, SettingsSyncTroubleshootingActionKt.access$formatDate(date));
                    String string = this.$version.getFileVersion().getVersionId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"version.fileVersion.versionId");
                    TroubleshootingDialog.access$copyableLabel(this.this$0, $this$row, TroubleshootingDialog.access$shorten(this.this$0, string));
                    SettingsSnapshot snapshot = this.$version.getSnapshot();
                    if (snapshot != null) {
                        Object object;
                        $this$row.label(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.machineInfo.label", new Object[0]));
                        SettingsSnapshot.AppInfo appInfo = snapshot.getMetaInfo().getAppInfo();
                        if (appInfo != null) {
                            UUID appId = appInfo.getApplicationId();
                            String thisOrThat = Intrinsics.areEqual((Object)appId, (Object)SettingsSyncLocalSettings.Companion.getInstance().getApplicationId()) ? "[this]  " : "[other]";
                            String string2 = appId.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"appId.toString()");
                            object = thisOrThat + " " + TroubleshootingDialog.access$shorten(this.this$0, string2) + " - " + appInfo.getUserName() + " - " + appInfo.getHostName() + " - " + appInfo.getConfigFolder();
                        } else {
                            object = "Unknown";
                        }
                        String text = object;
                        TroubleshootingDialog.access$copyableLabel(this.this$0, $this$row, text);
                    }
                    Icon icon = AllIcons.Actions.Download;
                    Row.actionButton$default((Row)$this$row, (AnAction)((AnAction)new DumbAwareAction(this.this$0, this.$version, icon){
                        final /* synthetic */ TroubleshootingDialog this$0;
                        final /* synthetic */ Version $version;
                        {
                            this.this$0 = $receiver;
                            this.$version = $version;
                            super($super_call_param$1);
                        }

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            TroubleshootingDialog.access$downloadVersion(this.this$0, this.$version, e.getProject());
                        }
                    }), null, (int)2, null);
                    if (this.$showHistoryButton) {
                        icon = AllIcons.Vcs.History;
                        Row.actionButton$default((Row)$this$row, (AnAction)((AnAction)new DumbAwareAction(this.this$0, this.$version, icon){
                            final /* synthetic */ TroubleshootingDialog this$0;
                            final /* synthetic */ Version $version;
                            {
                                this.this$0 = $receiver;
                                this.$version = $version;
                                super($super_call_param$1);
                            }

                            public void actionPerformed(@NotNull AnActionEvent e) {
                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                Project project = this.this$0.getProject();
                                CloudConfigServerCommunicator cloudConfigServerCommunicator = this.this$0.getRemoteCommunicator();
                                String string = this.$version.getFilePath();
                                JBAccountInfoService.JBAData jBAData = this.this$0.getUserData();
                                String string2 = jBAData != null ? jBAData.loginName : null;
                                Intrinsics.checkNotNull((Object)string2);
                                TroubleshootingDialog.access$showHistoryDialog(this.this$0, project, cloudConfigServerCommunicator, string, string2);
                            }
                        }), null, (int)2, null);
                    }
                    if (this.$showDeleteButton) {
                        $this$row.button(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.delete.button", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this.this$0, this.$version){
                            final /* synthetic */ TroubleshootingDialog this$0;
                            final /* synthetic */ Version $version;
                            {
                                this.this$0 = $receiver;
                                this.$version = $version;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                TroubleshootingDialog.access$deleteFile(this.this$0, this.this$0.getProject(), this.this$0.getRemoteCommunicator(), this.$version.getFilePath());
                            }
                        });
                    }
                }
            }), (int)1, null);
        }

        private final void downloadVersion(Version version, Project project) {
            File file = (File)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> TroubleshootingDialog.downloadVersion$lambda$0(version, this), SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.downloading.settings.from.server.progress.title", new Object[0]), false, project);
            if (file != null) {
                this.showFileDownloadedMessage(file, SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.successfully.downloaded.message", new Object[0]));
            } else if (Messages.showOkCancelDialog((Component)this.getContentPane(), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.error.check.log.file.for.errors", new Object[0]), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.error.download.file.failed", new Object[0]), (String)ShowLogAction.getActionName(), (String)CommonBundle.getCancelButtonText(), null) == 0) {
                ShowLogAction.showLog();
            }
        }

        private final void showFileDownloadedMessage(File file, @Nls String message) {
            if (Messages.showOkCancelDialog((Component)this.getContentPane(), (String)message, (String)"", (String)RevealFileAction.getActionName(), (String)CommonBundle.getCancelButtonText(), null) == 0) {
                RevealFileAction.openFile((File)file);
            }
        }

        private final void showHistoryDialog(Project project, CloudConfigServerCommunicator remoteCommunicator, String filePath, String loginName) {
            List history = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> TroubleshootingDialog.showHistoryDialog$lambda$2(remoteCommunicator, filePath), SettingsSyncBundle.INSTANCE.message("troubleshooting.fetching.history.progress.title", new Object[0]), false, project);
            Object[] objectArray = new Object[]{filePath};
            DialogBuilder dialogBuilder = new DialogBuilder((Component)this.getContentPane()).title(SettingsSyncBundle.INSTANCE.message("troubleshooting.settings.history.dialog.title", objectArray));
            Intrinsics.checkNotNullExpressionValue((Object)dialogBuilder, (String)"DialogBuilder(contentPan\u2026dialog.title\", filePath))");
            DialogBuilder dialogBuilder2 = dialogBuilder;
            DialogPanel historyPanel2 = (DialogPanel)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>((List<Version>)history, this){
                final /* synthetic */ List<Version> $history;
                final /* synthetic */ TroubleshootingDialog this$0;
                {
                    this.$history = $history;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Panel $this$panel) {
                    Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                    for (Version version : this.$history) {
                        TroubleshootingDialog.access$versionRow(this.this$0, $this$panel, version, false, false).layout(RowLayout.PARENT_GRID);
                    }
                }
            })).withBorder((Border)JBUI.Borders.empty((int)4, (int)10, (int)4, (int)10));
            JButton button = new JButton(SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.download.full.history.button", new Object[0]));
            button.addActionListener(arg_0 -> TroubleshootingDialog.showHistoryDialog$lambda$3(this, project, remoteCommunicator, history, loginName, arg_0));
            JBScrollPane scrollPanel = new JBScrollPane((Component)historyPanel2, 20, 30);
            BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel();
            Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"simplePanel()");
            BorderLayoutPanel mainPanel = borderLayoutPanel;
            mainPanel.add((Component)scrollPanel, (Object)"Center");
            mainPanel.add((Component)button, (Object)"South");
            dialogBuilder2.centerPanel((JComponent)mainPanel);
            dialogBuilder2.addCloseButton();
            dialogBuilder2.show();
        }

        private final void downloadFullHistory(Project project, CloudConfigServerCommunicator remoteCommunicator, List<Version> history, String loginName) {
            File compoundZip = (File)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> TroubleshootingDialog.downloadFullHistory$lambda$5(loginName, history, remoteCommunicator), SettingsSyncBundle.INSTANCE.message("troubleshooting.fetching.history.progress.title", new Object[0]), true, project);
            Intrinsics.checkNotNullExpressionValue((Object)compoundZip, (String)"compoundZip");
            this.showFileDownloadedMessage(compoundZip, SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.download.full.history.success.message", new Object[0]));
        }

        private final void deleteFile(Project project, CloudConfigServerCommunicator remoteCommunicator, String filePath) {
            int choice = Messages.showOkCancelDialog((Component)this.getContentPane(), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.delete.confirmation.message", new Object[0]), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.delete.confirmation.title", new Object[0]), (String)IdeBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), null);
            if (choice == 0) {
                try {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> TroubleshootingDialog.deleteFile$lambda$6(remoteCommunicator, filePath), SettingsSyncBundle.INSTANCE.message("troubleshooting.delete.file.from.server.progress.title", new Object[0]), false, project);
                }
                catch (Exception e) {
                    Companion.getLOG().warn("Couldn't delete " + filePath + " from server", (Throwable)e);
                    Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage(), (String)SettingsSyncBundle.INSTANCE.message("troubleshooting.dialog.delete.confirmation.title", new Object[0]));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Cell<JBLabel> copyableLabel(Row $this$copyableLabel, @NlsSafe Object text) {
            void $this$copyableLabel_u24lambda_u247;
            JBLabel jBLabel;
            JBLabel jBLabel2 = jBLabel = new JBLabel(String.valueOf(text));
            Row row = $this$copyableLabel;
            boolean bl = false;
            $this$copyableLabel_u24lambda_u247.setCopyable(true);
            return row.cell((JComponent)jBLabel);
        }

        private static final void generateFileSubTree$generateSubTreesForChildren(TroubleshootingDialog this$0, Panel $panel, TreeNode.Branch node) {
            for (TreeNode child : node.getChildren()) {
                this$0.generateFileSubTree($panel, child);
            }
        }

        private static final File downloadVersion$lambda$0(Version $version, TroubleshootingDialog this$0) {
            Intrinsics.checkNotNullParameter((Object)$version, (String)"$version");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            return SettingsSyncTroubleshootingActionKt.access$downloadToFile($version.getFilePath(), $version.getFileVersion(), this$0.remoteCommunicator);
        }

        /*
         * WARNING - void declaration
         */
        private static final List showHistoryDialog$lambda$2(CloudConfigServerCommunicator $remoteCommunicator, String $filePath) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$remoteCommunicator, (String)"$remoteCommunicator");
            Intrinsics.checkNotNullParameter((Object)$filePath, (String)"$filePath");
            Iterable $this$mapIndexed$iv = $remoteCommunicator.fetchHistory($filePath);
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                SettingsSnapshot settingsSnapshot;
                void version;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FileVersionInfo fileVersionInfo = (FileVersionInfo)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (index < 10 && StringsKt.endsWith$default((String)$filePath, (String)".zip", (boolean)false, (int)2, null)) {
                    InputStream stream2;
                    Intrinsics.checkNotNull((Object)$remoteCommunicator.downloadSnapshot($filePath, (FileVersionInfo)version));
                    settingsSnapshot = SettingsSyncTroubleshootingActionKt.access$extractSnapshotFromZipStream(stream2);
                } else {
                    settingsSnapshot = null;
                }
                SettingsSnapshot snapshot = settingsSnapshot;
                collection.add(new Version($filePath, (FileVersionInfo)version, snapshot));
            }
            return (List)destination$iv$iv;
        }

        private static final void showHistoryDialog$lambda$3(TroubleshootingDialog this$0, Project $project, CloudConfigServerCommunicator $remoteCommunicator, List $history, String $loginName, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$remoteCommunicator, (String)"$remoteCommunicator");
            Intrinsics.checkNotNullParameter((Object)$loginName, (String)"$loginName");
            Intrinsics.checkNotNullExpressionValue((Object)$history, (String)"history");
            this$0.downloadFullHistory($project, $remoteCommunicator, $history, $loginName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final File downloadFullHistory$lambda$5(String $loginName, List $history, CloudConfigServerCommunicator $remoteCommunicator) {
            Intrinsics.checkNotNullParameter((Object)$loginName, (String)"$loginName");
            Intrinsics.checkNotNullParameter((Object)$history, (String)"$history");
            Intrinsics.checkNotNullParameter((Object)$remoteCommunicator, (String)"$remoteCommunicator");
            String historyFileName = "settings-server-history-" + FileUtil.sanitizeFileName((String)$loginName) + "-" + SettingsSyncTroubleshootingActionKt.access$formatDate(new Date()) + ".zip";
            File file = FileUtil.createTempFile((String)historyFileName, null);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(historyFileName, null)");
            File zipFile = file;
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            indicator.setIndeterminate(false);
            Closeable closeable = (Closeable)new Compressor.Zip(zipFile);
            Throwable throwable = null;
            try {
                Compressor.Zip zip = (Compressor.Zip)closeable;
                boolean bl = false;
                Iterator iterator = $history.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int step = n++;
                    Version version = (Version)iterator.next();
                    indicator.checkCanceled();
                    indicator.setFraction((double)step / (double)$history.size());
                    FileVersionInfo fileVersion = version.getFileVersion();
                    InputStream stream2 = $remoteCommunicator.downloadSnapshot(version.getFilePath(), fileVersion);
                    if (stream2 != null) {
                        Pair pair = SettingsSyncTroubleshootingActionKt.access$getSnapshotFileNameAndExtension(version.getFilePath(), fileVersion);
                        String fileName = (String)pair.component1();
                        String extension = (String)pair.component2();
                        zip.addFile(fileName + extension, stream2);
                        continue;
                    }
                    Companion.getLOG().warn("Couldn't download snapshot for version made on " + fileVersion.getModifiedDate());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return zipFile;
        }

        private static final Unit deleteFile$lambda$6(CloudConfigServerCommunicator $remoteCommunicator, String $filePath) {
            Intrinsics.checkNotNullParameter((Object)$remoteCommunicator, (String)"$remoteCommunicator");
            Intrinsics.checkNotNullParameter((Object)$filePath, (String)"$filePath");
            SettingsSyncSettings.Companion.getInstance().setSyncEnabled(false);
            $remoteCommunicator.deleteFile($filePath);
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ Row access$statusRow(TroubleshootingDialog $this, Panel $receiver) {
            return $this.statusRow($receiver);
        }

        public static final /* synthetic */ Row access$serverUrlRow(TroubleshootingDialog $this, Panel $receiver) {
            return $this.serverUrlRow($receiver);
        }

        public static final /* synthetic */ Row access$loginNameRow(TroubleshootingDialog $this, Panel $receiver, JBAccountInfoService.JBAData userData) {
            return $this.loginNameRow($receiver, userData);
        }

        public static final /* synthetic */ Row access$emailRow(TroubleshootingDialog $this, Panel $receiver, JBAccountInfoService.JBAData userData) {
            return $this.emailRow($receiver, userData);
        }

        public static final /* synthetic */ void access$appInfoRow(TroubleshootingDialog $this, Panel $receiver) {
            $this.appInfoRow($receiver);
        }

        public static final /* synthetic */ void access$generateFileSubTree(TroubleshootingDialog $this, Panel panel, TreeNode node) {
            $this.generateFileSubTree(panel, node);
        }

        public static final /* synthetic */ void access$generateFileSubTree$generateSubTreesForChildren(TroubleshootingDialog this$0, Panel $panel, TreeNode.Branch node) {
            TroubleshootingDialog.generateFileSubTree$generateSubTreesForChildren(this$0, $panel, node);
        }

        public static final /* synthetic */ Cell access$copyableLabel(TroubleshootingDialog $this, Row $receiver, Object text) {
            return $this.copyableLabel($receiver, text);
        }

        public static final /* synthetic */ String access$shorten(TroubleshootingDialog $this, String $receiver) {
            return $this.shorten($receiver);
        }

        public static final /* synthetic */ void access$downloadVersion(TroubleshootingDialog $this, Version version, Project project) {
            $this.downloadVersion(version, project);
        }

        public static final /* synthetic */ void access$showHistoryDialog(TroubleshootingDialog $this, Project project, CloudConfigServerCommunicator remoteCommunicator, String filePath, String loginName) {
            $this.showHistoryDialog(project, remoteCommunicator, filePath, loginName);
        }

        public static final /* synthetic */ void access$deleteFile(TroubleshootingDialog $this, Project project, CloudConfigServerCommunicator remoteCommunicator, String filePath) {
            $this.deleteFile(project, remoteCommunicator, filePath);
        }

        public static final /* synthetic */ Row access$versionRow(TroubleshootingDialog $this, Panel $receiver, Version version, boolean showHistoryButton, boolean showDeleteButton) {
            return $this.versionRow($receiver, version, showHistoryButton, showDeleteButton);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B$\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u00c6\u0003J.\u0010\u0013\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/settingsSync/SettingsSyncTroubleshootingAction$Version;", "", "filePath", "", "Lcom/intellij/openapi/util/NlsSafe;", "fileVersion", "Lcom/jetbrains/cloudconfig/FileVersionInfo;", "snapshot", "Lcom/intellij/settingsSync/SettingsSnapshot;", "(Ljava/lang/String;Lcom/jetbrains/cloudconfig/FileVersionInfo;Lcom/intellij/settingsSync/SettingsSnapshot;)V", "getFilePath", "()Ljava/lang/String;", "getFileVersion", "()Lcom/jetbrains/cloudconfig/FileVersionInfo;", "getSnapshot", "()Lcom/intellij/settingsSync/SettingsSnapshot;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.settingsSync"})
    private static final class Version {
        @NotNull
        private final String filePath;
        @NotNull
        private final FileVersionInfo fileVersion;
        @Nullable
        private final SettingsSnapshot snapshot;

        public Version(@NotNull String filePath, @NotNull FileVersionInfo fileVersion, @Nullable SettingsSnapshot snapshot) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)fileVersion, (String)"fileVersion");
            this.filePath = filePath;
            this.fileVersion = fileVersion;
            this.snapshot = snapshot;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        @NotNull
        public final FileVersionInfo getFileVersion() {
            return this.fileVersion;
        }

        @Nullable
        public final SettingsSnapshot getSnapshot() {
            return this.snapshot;
        }

        @NotNull
        public final String component1() {
            return this.filePath;
        }

        @NotNull
        public final FileVersionInfo component2() {
            return this.fileVersion;
        }

        @Nullable
        public final SettingsSnapshot component3() {
            return this.snapshot;
        }

        @NotNull
        public final Version copy(@NotNull String filePath, @NotNull FileVersionInfo fileVersion, @Nullable SettingsSnapshot snapshot) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)fileVersion, (String)"fileVersion");
            return new Version(filePath, fileVersion, snapshot);
        }

        public static /* synthetic */ Version copy$default(Version version, String string, FileVersionInfo fileVersionInfo, SettingsSnapshot settingsSnapshot, int n, Object object) {
            if ((n & 1) != 0) {
                string = version.filePath;
            }
            if ((n & 2) != 0) {
                fileVersionInfo = version.fileVersion;
            }
            if ((n & 4) != 0) {
                settingsSnapshot = version.snapshot;
            }
            return version.copy(string, fileVersionInfo, settingsSnapshot);
        }

        @NotNull
        public String toString() {
            return "Version(filePath=" + this.filePath + ", fileVersion=" + this.fileVersion + ", snapshot=" + this.snapshot + ")";
        }

        public int hashCode() {
            int result2 = this.filePath.hashCode();
            result2 = result2 * 31 + this.fileVersion.hashCode();
            result2 = result2 * 31 + (this.snapshot == null ? 0 : this.snapshot.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Version)) {
                return false;
            }
            Version version = (Version)other;
            if (!Intrinsics.areEqual((Object)this.filePath, (Object)version.filePath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fileVersion, (Object)version.fileVersion)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.snapshot, (Object)version.snapshot);
        }
    }
}

