/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.FloatContainer;
import com.carrotsearch.hppc.ShortCollection;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortFloatAssociativeContainer;
import com.carrotsearch.hppc.ShortFloatHashMap;
import com.carrotsearch.hppc.ShortFloatMap;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.comparators.ShortComparator;
import com.carrotsearch.hppc.comparators.ShortFloatComparator;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.cursors.ShortFloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.predicates.ShortFloatPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import com.carrotsearch.hppc.procedures.ShortFloatProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationShortFloatHashMap
implements ShortFloatMap {
    public final ShortFloatHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationShortFloatHashMap(ShortFloatHashMap delegate, ShortComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationShortFloatHashMap(ShortFloatHashMap delegate, ShortFloatComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        short[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry2 = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry2++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry2 < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry2++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, ShortComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            short[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ShortFloatComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final short[] keys;
            final float[] values;
            {
                this.keys = SortedIterationShortFloatHashMap.this.delegate.keys;
                this.values = SortedIterationShortFloatHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ShortFloatCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(short key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ShortContainer container) {
        throw SortedIterationShortFloatHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        throw SortedIterationShortFloatHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ShortFloatPredicate predicate) {
        throw SortedIterationShortFloatHashMap.readOnlyException();
    }

    @Override
    public <T extends ShortFloatProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        float[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ShortFloatPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        short[] keys = this.delegate.keys;
        float[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ShortCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public FloatContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public float get(short key2) {
        return this.delegate.get(key2);
    }

    @Override
    public float getOrDefault(short key2, float defaultValue) {
        return this.delegate.getOrDefault(key2, defaultValue);
    }

    @Override
    public float put(short key2, float value) {
        throw SortedIterationShortFloatHashMap.readOnlyException();
    }

    @Override
    public int putAll(ShortFloatAssociativeContainer container) {
        throw SortedIterationShortFloatHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ShortFloatCursor> iterable) {
        throw SortedIterationShortFloatHashMap.readOnlyException();
    }

    @Override
    public float putOrAdd(short key2, float putValue, float incrementValue) {
        throw SortedIterationShortFloatHashMap.readOnlyException();
    }

    @Override
    public float addTo(short key2, float additionValue) {
        throw SortedIterationShortFloatHashMap.readOnlyException();
    }

    @Override
    public float remove(short key2) {
        throw SortedIterationShortFloatHashMap.readOnlyException();
    }

    @Override
    public int indexOf(short key2) {
        return this.delegate.indexOf(key2);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public float indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public float indexReplace(int index, float newValue) {
        throw SortedIterationShortFloatHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, short key2, float value) {
        throw SortedIterationShortFloatHashMap.readOnlyException();
    }

    @Override
    public float indexRemove(int index) {
        throw SortedIterationShortFloatHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationShortFloatHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationShortFloatHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ShortFloatCursor> {
        private final ShortFloatCursor cursor = new ShortFloatCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ShortFloatCursor fetch() {
            if (this.index < SortedIterationShortFloatHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortFloatHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationShortFloatHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationShortFloatHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ShortFloatCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final SortedIterationShortFloatHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationShortFloatHashMap.this;
        }

        @Override
        public boolean contains(short e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationShortFloatHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortFloatHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            throw SortedIterationShortFloatHashMap.readOnlyException();
        }

        @Override
        public int removeAll(short e) {
            throw SortedIterationShortFloatHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractFloatCollection {
        private final SortedIterationShortFloatHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationShortFloatHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(float value) {
            for (ShortFloatCursor c : this.owner) {
                if (Float.floatToIntBits(value) != Float.floatToIntBits(c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(float e) {
            throw SortedIterationShortFloatHashMap.readOnlyException();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            throw SortedIterationShortFloatHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationShortFloatHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationShortFloatHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected FloatCursor fetch() {
            if (this.index < SortedIterationShortFloatHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortFloatHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortFloatHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ShortCursor fetch() {
            if (this.index < SortedIterationShortFloatHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationShortFloatHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationShortFloatHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

