/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tools.StringTools;

public class ConvertToSentenceCaseFilter
extends RuleFilter {
    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        RuleMatch ruleMatch = match;
        boolean firstDone = false;
        StringBuilder replacement = new StringBuilder();
        for (int i = patternTokenPos; i < patternTokens.length; ++i) {
            if (patternTokens[i].getStartPos() < match.getFromPos() || patternTokens[i].getEndPos() > match.getToPos()) continue;
            String normalizedCase = this.normalizedCase(patternTokens[i]);
            if (i + 1 < patternTokens.length && patternTokens[i + 1].getToken().equals(".")) {
                if (normalizedCase.length() == 1) {
                    normalizedCase = normalizedCase.toUpperCase();
                } else if (normalizedCase.equals("corp")) {
                    normalizedCase = "Corp";
                }
            }
            String tokenString = patternTokens[i].getToken();
            String tokenCapitalized = StringTools.uppercaseFirstChar(normalizedCase);
            if (!firstDone & !this.isPunctuation(tokenString) && !tokenString.isEmpty()) {
                firstDone = true;
                replacement.append(tokenCapitalized);
                continue;
            }
            if (patternTokens[i].isWhitespaceBefore()) {
                replacement.append(" ");
            }
            replacement.append(normalizedCase);
        }
        ruleMatch.setSuggestedReplacement(replacement.toString());
        return ruleMatch;
    }

    private boolean isPunctuation(String s) {
        return Pattern.matches("\\p{IsPunctuation}", s);
    }

    private String normalizedCase(AnalyzedTokenReadings atr) {
        String tokenLowercase = atr.getToken().toLowerCase();
        if (atr.hasTypographicApostrophe()) {
            tokenLowercase = tokenLowercase.replaceAll("'", "\u2019");
        }
        if (tokenLowercase.equals("me")) {
            return tokenLowercase;
        }
        String tokenCapitalized = StringTools.uppercaseFirstChar(tokenLowercase);
        boolean lemmaIsCapitalized = false;
        boolean lemmaIsLowercase = false;
        for (AnalyzedToken at : atr) {
            if (at.hasNoTag() || at.getLemma() == null) {
                return tokenCapitalized;
            }
            String lemma = at.getLemma().split(" ")[0];
            lemmaIsCapitalized = lemmaIsCapitalized || StringTools.isCapitalizedWord(lemma);
            lemmaIsLowercase = lemmaIsLowercase || !StringTools.isNotAllLowercase(lemma);
        }
        if (lemmaIsLowercase) {
            return tokenLowercase;
        }
        if (lemmaIsCapitalized) {
            return tokenCapitalized;
        }
        return atr.getToken();
    }
}

