/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementType;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLBlockScalar;
import org.jetbrains.yaml.psi.YAMLScalarList;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImplKt;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarTextEvaluator;
import org.jetbrains.yaml.psi.impl.YamlScalarTextEvaluator;

public class YAMLScalarListImpl
extends YAMLBlockScalarImpl
implements YAMLScalarList,
YAMLBlockScalar {
    public YAMLScalarListImpl(@NotNull ASTNode node) {
        if (node == null) {
            YAMLScalarListImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @NotNull
    protected IElementType getContentType() {
        YAMLElementType yAMLElementType = YAMLTokenTypes.SCALAR_LIST;
        if (yAMLElementType == null) {
            YAMLScalarListImpl.$$$reportNull$$$0(1);
        }
        return yAMLElementType;
    }

    @Override
    @NotNull
    public YamlScalarTextEvaluator<YAMLScalarListImpl> getTextEvaluator() {
        return new YAMLBlockScalarTextEvaluator<YAMLScalarListImpl>(this){
            private final TokenSet NON_SPACE_VALUES;
            {
                this.NON_SPACE_VALUES = TokenSet.orSet((TokenSet[])new TokenSet[]{YAMLElementTypes.SCALAR_VALUES, YAMLElementTypes.EOL_ELEMENTS});
            }

            @Override
            @NotNull
            protected String getRangesJoiner(@NotNull CharSequence text, @NotNull List<TextRange> contentRanges2, int indexBefore) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (contentRanges2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "";
            }

            @Override
            @NotNull
            public String getTextValue(@Nullable TextRange rangeInHost) {
                Object value = super.getTextValue(rangeInHost);
                if (!StringUtil.isEmptyOrSpaces((String)value) && this.getChompingIndicator() == YAMLBlockScalarTextEvaluator.ChompingIndicator.KEEP && this.isEnding(rangeInHost)) {
                    value = (String)value + "\n";
                }
                String string = value;
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Override
            protected boolean shouldIncludeEolInRange(ASTNode child) {
                if (this.getChompingIndicator() == YAMLBlockScalarTextEvaluator.ChompingIndicator.KEEP) {
                    return true;
                }
                if (YAMLBlockScalarImplKt.isEol(child) && 1.isEolOrNull(child.getTreeNext()) && (!((Object)((Object)YAMLTokenTypes.INDENT)).equals(ObjectUtils.doIfNotNull((Object)child.getTreePrev(), ASTNode::getElementType)) || ((YAMLScalarListImpl)this.myHost).getLinesNodes().size() > 2)) {
                    return false;
                }
                ASTNode next = TreeUtil.findSibling((ASTNode)child.getTreeNext(), (TokenSet)this.NON_SPACE_VALUES);
                return !YAMLBlockScalarImplKt.isEol(next) || !1.isEolOrNull(TreeUtil.findSibling((ASTNode)next.getTreeNext(), (TokenSet)this.NON_SPACE_VALUES)) || this.getChompingIndicator() != YAMLBlockScalarTextEvaluator.ChompingIndicator.STRIP;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contentRanges";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLScalarListImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLScalarListImpl$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTextValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getRangesJoiner";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Override
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            YAMLScalarListImpl.$$$reportNull$$$0(2);
        }
        String original = this.getNode().getText();
        int commonPrefixLength = StringUtil.commonPrefixLength((CharSequence)original, (CharSequence)text);
        int commonSuffixLength = StringUtil.commonSuffixLength((CharSequence)original, (CharSequence)text);
        int indent = this.locateIndent();
        ASTNode scalarEol = this.getNode().findChildByType((IElementType)YAMLTokenTypes.SCALAR_EOL);
        if (scalarEol == null) {
            return super.updateText(text);
        }
        int eolOffsetInParent = scalarEol.getStartOffsetInParent();
        int startContent = eolOffsetInParent + indent + 1;
        if (startContent > commonPrefixLength) {
            return super.updateText(text);
        }
        String originalRowPrefix = original.substring(startContent, commonPrefixLength);
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indent);
        String prefix = originalRowPrefix.replaceAll("\n" + indentString, "\n");
        String suffix = text.substring(text.length() - commonSuffixLength).replaceAll("\n" + indentString, "\n");
        String result = prefix + text.substring(commonPrefixLength, text.length() - commonSuffixLength) + suffix;
        return super.updateText(result);
    }

    @Override
    public String toString() {
        return "YAML scalar list";
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            YAMLScalarListImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof YamlPsiElementVisitor) {
            ((YamlPsiElementVisitor)visitor).visitScalarList(this);
        } else {
            super.accept(visitor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLScalarListImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLScalarListImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

