/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.refactoring.rename;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.refactoring.PropertiesRefactoringSettings;
import com.intellij.lang.properties.xml.XmlProperty;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.usageView.UsageInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class RenamePropertyProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenamePropertyProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof IProperty || element instanceof PomTargetPsiElement && ((PomTargetPsiElement)element).getTarget() instanceof XmlProperty;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            RenamePropertyProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            RenamePropertyProcessor.$$$reportNull$$$0(2);
        }
        if (allRenames == null) {
            RenamePropertyProcessor.$$$reportNull$$$0(3);
        }
        ResourceBundle resourceBundle = Objects.requireNonNull(PropertiesImplUtil.getProperty(element)).getPropertiesFile().getResourceBundle();
        LinkedHashMap<PsiElement, String> allRenamesCopy = new LinkedHashMap<PsiElement, String>(allRenames);
        allRenames.clear();
        allRenamesCopy.forEach((key, value) -> {
            IProperty property = PropertiesImplUtil.getProperty(key);
            if (property != null) {
                List<IProperty> properties = PropertiesUtil.findAllProperties(resourceBundle, property.getUnescapedKey());
                for (IProperty toRename : properties) {
                    allRenames.put(toRename.getPsiElement(), (String)value);
                }
            }
        });
    }

    public void findCollisions(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result) {
        if (element == null) {
            RenamePropertyProcessor.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            RenamePropertyProcessor.$$$reportNull$$$0(5);
        }
        if (allRenames == null) {
            RenamePropertyProcessor.$$$reportNull$$$0(6);
        }
        if (result == null) {
            RenamePropertyProcessor.$$$reportNull$$$0(7);
        }
        allRenames.forEach((key, value) -> {
            PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(key.getContainingFile());
            if (propertiesFile == null) {
                return;
            }
            IProperty property = propertiesFile.findPropertyByKey((String)value);
            if (property == null) {
                return;
            }
            result.add((UsageInfo)new UnresolvableCollisionUsageInfo(property.getPsiElement(), (PsiElement)key, (String)value){
                final /* synthetic */ String val$value;
                {
                    this.val$value = string;
                    super(arg0, arg1);
                }

                public String getDescription() {
                    return PropertiesBundle.message("rename.hides.existing.property.conflict", this.val$value);
                }
            });
        });
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            RenamePropertyProcessor.$$$reportNull$$$0(8);
        }
        return PropertiesRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePropertyProcessor.$$$reportNull$$$0(9);
        }
        PropertiesRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/properties/refactoring/rename/RenamePropertyProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findCollisions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isToSearchInComments";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setToSearchInComments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

