/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.commands.GitTaskResultHandlerAdapter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class GitTaskResultNotificationHandler
extends GitTaskResultHandlerAdapter {
    private final Project myProject;
    private final @NlsContexts.NotificationContent String mySuccessMessage;
    private final @NlsContexts.NotificationContent String myCancelMessage;
    private final @NlsContexts.NotificationContent String myErrorMessage;
    @NonNls
    private final String myDisplayId;

    public GitTaskResultNotificationHandler(Project project, @Nullable @NonNls String displayId, @NlsContexts.NotificationContent String successMessage, @NlsContexts.NotificationContent String cancelMessage, @NlsContexts.NotificationContent String errorMessage) {
        this.myProject = project;
        this.mySuccessMessage = successMessage;
        this.myCancelMessage = cancelMessage;
        this.myErrorMessage = errorMessage;
        this.myDisplayId = displayId;
    }

    @Override
    protected void onSuccess() {
        VcsNotifier.getInstance((Project)this.myProject).notifySuccess(this.myDisplayId, "", this.mySuccessMessage);
    }

    @Override
    protected void onCancel() {
        VcsNotifier.getInstance((Project)this.myProject).notifySuccess(this.myDisplayId, "", this.myCancelMessage);
    }

    @Override
    protected void onFailure() {
        VcsNotifier.getInstance((Project)this.myProject).notifyError(this.myDisplayId, "", this.myErrorMessage);
    }
}

