/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SystemProperties;
import com.jetbrains.performancePlugin.CommandLogger;
import com.jetbrains.performancePlugin.CommandsRunner;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.PlaybackRunnerExtended;
import com.jetbrains.performancePlugin.ProjectLoaded;
import com.jetbrains.performancePlugin.ProjectLoadedKt;
import com.jetbrains.performancePlugin.commands.TakeScreenshotCommandKt;
import com.jetbrains.performancePlugin.utils.ReporterCommandAsTelemetrySpan;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\b\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u001c\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a \u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0002\u001a\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0002\u001a\u0012\u0010$\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0018\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\t\"\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006*"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "MAX_DESCRIPTION_LENGTH", "", "MUST_REPORT_TEAMCITY_TEST_FAILURE_ON_IDE_ERROR", "", "getMUST_REPORT_TEAMCITY_TEST_FAILURE_ON_IDE_ERROR$annotations", "()V", "teamCityFailedTestName", "", "getTeamCityFailedTestName", "()Ljava/lang/String;", "encodeStringForTC", "line", "getNonEmptyThrowableMessage", "throwable", "", "getTestFile", "Ljava/io/File;", "registerOnFinishRunnables", "", "future", "Ljava/util/concurrent/CompletableFuture;", "mustExitOnFailure", "reportScriptError", "errorMessage", "Lcom/intellij/diagnostic/AbstractMessage;", "reportTeamCityFailedTestAndBuildProblem", "testName", "failureMessage", "failureDetails", "runScriptFromFile", "project", "Lcom/intellij/openapi/project/Project;", "storeFailureToFile", "writeAttachmentToErrorDir", "attachment", "Lcom/intellij/openapi/diagnostic/Attachment;", "path", "Ljava/nio/file/Path;", "intellij.performanceTesting"})
public final class ProjectLoadedKt {
    private static final int MAX_DESCRIPTION_LENGTH = 7500;
    private static final boolean MUST_REPORT_TEAMCITY_TEST_FAILURE_ON_IDE_ERROR = Boolean.parseBoolean(System.getProperty("testscript.must.report.teamcity.test.failure.on.error", "true"));

    private static final Logger getLOG() {
        Logger logger = Logger.getInstance((String)"PerformancePlugin");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"PerformancePlugin\")");
        return logger;
    }

    private static /* synthetic */ void getMUST_REPORT_TEAMCITY_TEST_FAILURE_ON_IDE_ERROR$annotations() {
    }

    private static final String getTeamCityFailedTestName() {
        String string = FileUtilRt.getNameWithoutExtension((String)ProjectLoadedKt.getTestFile().getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(getTestFile().name)");
        return string;
    }

    private static final File getTestFile() {
        String string = ProjectLoaded.TEST_SCRIPT_FILE_PATH;
        Intrinsics.checkNotNull((Object)string);
        File file = new File(string);
        if (!file.isFile()) {
            Object[] objectArray = new Object[]{file.getAbsolutePath()};
            System.err.println(PerformanceTestingBundle.message("startup.noscript", objectArray));
            ApplicationManagerEx.getApplicationEx().exit(true, true, 1);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void reportScriptError(AbstractMessage errorMessage) throws IOException {
        Throwable throwable;
        Throwable throwable2 = errorMessage.getThrowable();
        Intrinsics.checkNotNullExpressionValue((Object)throwable2, (String)"errorMessage.throwable");
        Throwable cause = throwable = throwable2;
        String causeMessage = null;
        causeMessage = "";
        while (cause.getCause() != null) {
            Throwable throwable3 = cause = cause.getCause();
            Intrinsics.checkNotNull((Object)throwable3);
            causeMessage = throwable3.getMessage();
        }
        CharSequence charSequence = causeMessage;
        if ((charSequence == null || charSequence.length() == 0) && ((charSequence = (CharSequence)(causeMessage = errorMessage.getMessage())) == null || charSequence.length() == 0)) {
            String string;
            String throwableMessage = ProjectLoadedKt.getNonEmptyThrowableMessage(throwable);
            int index = StringsKt.indexOf$default((CharSequence)throwableMessage, (String)"\tat ", (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                string = throwableMessage;
            } else {
                String string2 = throwableMessage.substring(0, index);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            causeMessage = string;
        }
        Object index = new String[]{"script-errors"};
        Path scriptErrorsDir = Path.of(PathManager.getLogPath(), index);
        Files.createDirectories(scriptErrorsDir, new FileAttribute[0]);
        index = Files.walk(scriptErrorsDir, new FileVisitOption[0]);
        Throwable throwable4 = null;
        try {
            Stream stream = (Stream)index;
            boolean bl = false;
            String finalCauseMessage = causeMessage;
            boolean isDuplicated2 = stream.filter(arg_0 -> ProjectLoadedKt.reportScriptError$lambda$2$lambda$0(reportScriptError.1.isDuplicated.1.INSTANCE, arg_0)).anyMatch(arg_0 -> ProjectLoadedKt.reportScriptError$lambda$2$lambda$1((Function1)new Function1<Path, Boolean>(finalCauseMessage){
                final /* synthetic */ String $finalCauseMessage;
                {
                    this.$finalCauseMessage = $finalCauseMessage;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(Path path) {
                    try {
                        return Intrinsics.areEqual((Object)Files.readString(path), (Object)this.$finalCauseMessage);
                    }
                    catch (IOException e) {
                        ProjectLoadedKt.access$getLOG().error(e.getMessage());
                        return false;
                    }
                }
            }, arg_0));
            if (isDuplicated2) {
                return;
            }
            stream = Unit.INSTANCE;
        }
        catch (Throwable stream) {
            throwable4 = stream;
            throw stream;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)index, (Throwable)throwable4);
        }
        for (int i = 1; i < 1000; ++i) {
            Path errorDir = scriptErrorsDir.resolve("error-" + i);
            if (Files.exists(errorDir, new LinkOption[0])) continue;
            Files.createDirectories(errorDir, new FileAttribute[0]);
            Files.writeString(errorDir.resolve("message.txt"), (CharSequence)causeMessage, new OpenOption[0]);
            Files.writeString(errorDir.resolve("stacktrace.txt"), (CharSequence)errorMessage.getThrowableText(), new OpenOption[0]);
            List list = errorMessage.getAllAttachments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"errorMessage.allAttachments");
            List attachments = list;
            int n = attachments.size();
            for (int j = 0; j < n; ++j) {
                Attachment attachment = (Attachment)attachments.get(j);
                Intrinsics.checkNotNullExpressionValue((Object)attachment, (String)"attachment");
                Path path = errorDir.resolve(j + "-" + attachment.getName());
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"errorDir.resolve(\"$j-${attachment.name}\")");
                ProjectLoadedKt.writeAttachmentToErrorDir(attachment, path);
            }
            return;
        }
        ProjectLoadedKt.getLOG().error("Too many errors have been reported during script execution. See " + scriptErrorsDir);
    }

    private static final void writeAttachmentToErrorDir(Attachment attachment, Path path) {
        try {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE};
            Files.writeString(path, (CharSequence)attachment.getDisplayText(), openOptionArray);
            openOptionArray = new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE};
            Files.writeString(path, (CharSequence)System.lineSeparator(), openOptionArray);
        }
        catch (Exception e) {
            ProjectLoadedKt.getLOG().warn("Failed to write attachment `display text`", (Throwable)e);
        }
    }

    private static final String getNonEmptyThrowableMessage(Throwable throwable) {
        if (throwable.getMessage() != null) {
            String string = throwable.getMessage();
            Intrinsics.checkNotNull((Object)string);
            if (!(((CharSequence)string).length() == 0)) {
                String string2 = throwable.getMessage();
                Intrinsics.checkNotNull((Object)string2);
                return string2;
            }
        }
        String string = throwable.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"throwable.javaClass.name");
        return string;
    }

    private static final void runScriptFromFile(Project project) {
        PlaybackRunnerExtended playback = new PlaybackRunnerExtended("%include " + ProjectLoadedKt.getTestFile(), new CommandLogger(), project);
        playback.setScriptDir(ProjectLoadedKt.getTestFile().getParentFile());
        if (SystemProperties.getBooleanProperty((String)"performance.execute.script.reportEachCommandAsTelemetrySpan", (boolean)false)) {
            playback.setCommandStartStopProcessor(new ReporterCommandAsTelemetrySpan());
        }
        CompletableFuture<?> scriptCallback = playback.run();
        CommandsRunner.setActionCallback(scriptCallback);
        Intrinsics.checkNotNullExpressionValue(scriptCallback, (String)"scriptCallback");
        ProjectLoadedKt.registerOnFinishRunnables(scriptCallback, true);
    }

    private static final String encodeStringForTC(String line) {
        String string = line.substring(0, (int)Math.min(7500.0, (double)line.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"\\|", (String)"||", (boolean)false, (int)4, null), (String)"\\[", (String)"|[", (boolean)false, (int)4, null), (String)"]", (String)"|]", (boolean)false, (int)4, null), (String)"\n", (String)"|n", (boolean)false, (int)4, null), (String)"'", (String)"|'", (boolean)false, (int)4, null), (String)"\r", (String)"|r", (boolean)false, (int)4, null);
    }

    private static final void reportTeamCityFailedTestAndBuildProblem(String testName, String failureMessage, String failureDetails) {
        String generifiedTestName = ProjectLoaded.Companion.generifyErrorMessage$intellij_performanceTesting(testName);
        Object[] objectArray = new Object[]{ProjectLoadedKt.encodeStringForTC(generifiedTestName), ProjectLoadedKt.encodeStringForTC(failureMessage), ProjectLoadedKt.encodeStringForTC(failureDetails)};
        System.out.printf("##teamcity[testFailed name='%s' message='%s' details='%s']\n", objectArray);
        objectArray = new Object[]{ProjectLoadedKt.encodeStringForTC(failureMessage), ProjectLoadedKt.encodeStringForTC(generifiedTestName)};
        System.out.printf("##teamcity[buildProblem description='%s' identity='%s'] ", objectArray);
    }

    private static final void registerOnFinishRunnables(CompletableFuture<?> future, boolean mustExitOnFailure) {
        ((CompletableFuture)future.thenRun(ProjectLoadedKt::registerOnFinishRunnables$lambda$3)).exceptionally(new Function(mustExitOnFailure){
            final /* synthetic */ boolean $mustExitOnFailure;
            {
                this.$mustExitOnFailure = $mustExitOnFailure;
            }

            @Nullable
            public final Void apply(Throwable e) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> registerOnFinishRunnables.2.apply$lambda$0(e, this.$mustExitOnFailure));
                return null;
            }

            private static final void apply$lambda$0(Throwable $e, boolean $mustExitOnFailure) {
                String message = "IDE will be terminated because some errors are detected while running the startup script: " + $e;
                if (ProjectLoadedKt.access$getMUST_REPORT_TEAMCITY_TEST_FAILURE_ON_IDE_ERROR$p()) {
                    String testName = ProjectLoadedKt.access$getTeamCityFailedTestName();
                    ProjectLoadedKt.access$reportTeamCityFailedTestAndBuildProblem(testName, message, "");
                }
                if (SystemProperties.getBooleanProperty((String)"startup.performance.framework", (boolean)false)) {
                    ProjectLoadedKt.access$storeFailureToFile($e.getMessage());
                }
                ProjectLoadedKt.access$getLOG().error(message);
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                    int label;

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = TakeScreenshotCommandKt.takeScreenshotOfAllWindows("onFailure", (Continuation<? super Unit>)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                String threadDump = StringsKt.trimIndent((String)("\n            Thread dump before IDE termination:\n            " + ThreadDumper.dumpThreadsToString() + "\n            "));
                ProjectLoadedKt.access$getLOG().info(threadDump);
                if ($mustExitOnFailure) {
                    ApplicationManagerEx.getApplicationEx().exit(true, true, 1);
                }
            }
        });
    }

    private static final void storeFailureToFile(String errorMessage) {
        try {
            String string;
            Path logDir = Path.of(PathManager.getLogPath(), new String[0]);
            String ideaLogContent = Files.readString(logDir.resolve("idea.log"));
            Intrinsics.checkNotNullExpressionValue((Object)ideaLogContent, (String)"ideaLogContent");
            CharSequence charSequence = ideaLogContent;
            String string2 = errorMessage;
            Intrinsics.checkNotNull((Object)string2);
            String string3 = ideaLogContent.substring(StringsKt.indexOf$default((CharSequence)charSequence, (String)string2, (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            String substringBegin = string3;
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            String string4 = timestamp.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"timestamp.toString()");
            String string5 = string4;
            int n = 0;
            int n2 = 10;
            String string6 = string5.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String date = string6;
            int endIndex = StringsKt.indexOf$default((CharSequence)substringBegin, (String)date, (int)0, (boolean)false, (int)6, null);
            if (endIndex == -1) {
                string = substringBegin;
            } else {
                String string7 = substringBegin.substring(0, endIndex);
                string = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            String errorMessageFromLog = string;
            Path failureCause = logDir.resolve("failure_cause.txt");
            Files.writeString(failureCause, (CharSequence)errorMessageFromLog, new OpenOption[0]);
        }
        catch (Exception e) {
            ProjectLoadedKt.getLOG().error(e.getMessage());
        }
    }

    private static final boolean reportScriptError$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean reportScriptError$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void registerOnFinishRunnables$lambda$3() {
        ProjectLoadedKt.getLOG().info("Execution of the script has been finished successfully");
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return ProjectLoadedKt.getLOG();
    }

    public static final /* synthetic */ void access$runScriptFromFile(Project project) {
        ProjectLoadedKt.runScriptFromFile(project);
    }

    public static final /* synthetic */ File access$getTestFile() {
        return ProjectLoadedKt.getTestFile();
    }

    public static final /* synthetic */ void access$reportScriptError(AbstractMessage errorMessage) {
        ProjectLoadedKt.reportScriptError(errorMessage);
    }

    public static final /* synthetic */ void access$registerOnFinishRunnables(CompletableFuture future, boolean mustExitOnFailure) {
        ProjectLoadedKt.registerOnFinishRunnables(future, mustExitOnFailure);
    }

    public static final /* synthetic */ boolean access$getMUST_REPORT_TEAMCITY_TEST_FAILURE_ON_IDE_ERROR$p() {
        return MUST_REPORT_TEAMCITY_TEST_FAILURE_ON_IDE_ERROR;
    }

    public static final /* synthetic */ String access$getTeamCityFailedTestName() {
        return ProjectLoadedKt.getTeamCityFailedTestName();
    }

    public static final /* synthetic */ void access$reportTeamCityFailedTestAndBuildProblem(String testName, String failureMessage, String failureDetails) {
        ProjectLoadedKt.reportTeamCityFailedTestAndBuildProblem(testName, failureMessage, failureDetails);
    }

    public static final /* synthetic */ void access$storeFailureToFile(String errorMessage) {
        ProjectLoadedKt.storeFailureToFile(errorMessage);
    }
}

