/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.KeyCodeTypeCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceUtil;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.performancePlugin.utils.EditorUtils;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class IdeEditorKeyCommand
extends KeyCodeTypeCommand {
    public static final String PREFIX = "%pressKey";
    private String actionID;

    public IdeEditorKeyCommand(@NotNull String text, int line) {
        if (text == null) {
            IdeEditorKeyCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    public Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            IdeEditorKeyCommand.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String input = this.extractCommandArgument(PREFIX);
        switch (StringUtil.toUpperCase((String)input)) {
            case "ENTER": {
                this.actionID = "EditorEnter";
                break;
            }
            case "BACKSPACE": {
                this.actionID = "EditorBackSpace";
                break;
            }
            case "TAB": {
                this.actionID = "EditorTab";
                break;
            }
            case "ESCAPE": {
                this.actionID = "EditorEscape";
                break;
            }
            default: {
                actionCallback.reject("Unknown special character. Please use: ENTER, BACKSPACE, ESCAPE or TAB");
                Promise promise = Promises.toPromise((ActionCallback)actionCallback);
                if (promise == null) {
                    IdeEditorKeyCommand.$$$reportNull$$$0(2);
                }
                return promise;
            }
        }
        @Nullable Project project = context.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            ApplicationManager.getApplication().runWriteAction(Context.current().wrap(() -> {
                TraceUtil.runWithSpanThrows((Tracer)PerformanceTestSpan.TRACER, (String)"typing", span -> {
                    AnAction action = ActionManagerEx.getInstanceEx().getAction(this.actionID);
                    AnActionEvent actionEvent = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)EditorUtils.createEditorContext(editor));
                    ActionUtil.performDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)actionEvent, () -> CommandProcessor.getInstance().executeCommand(project, () -> action.actionPerformed(actionEvent), "", null, editor.getDocument()));
                    span.addEvent("Typing " + this.actionID);
                });
                actionCallback.setDone();
            }));
        } else {
            actionCallback.reject("Editor is not opened");
        }
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            IdeEditorKeyCommand.$$$reportNull$$$0(3);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/IdeEditorKeyCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/IdeEditorKeyCommand";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

