/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.ui.playback.commands.AlphaNumericTypeCommand;
import com.jetbrains.performancePlugin.commands.Waiter;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class ReplaceTextCommand
extends AbstractCommand {
    public static final String PREFIX = "%replaceText";
    public static final char NEWLINE = '\u32e1';

    public ReplaceTextCommand(@NotNull String command, int line) {
        if (command == null) {
            ReplaceTextCommand.$$$reportNull$$$0(0);
        }
        super(command, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            ReplaceTextCommand.$$$reportNull$$$0(1);
        }
        AsyncPromise result = new AsyncPromise();
        String text = this.getText().substring(PREFIX.length() + 1).replace('\u32e1', '\n');
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                Waiter.checkCondition(() -> AlphaNumericTypeCommand.findTarget((PlaybackContext)context) != null).await(10L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                result.setError((Throwable)e);
                return;
            }
            ApplicationManager.getApplication().invokeAndWait(() -> {
                TypingTarget target = AlphaNumericTypeCommand.findTarget((PlaybackContext)context);
                if (target instanceof EditorComponentImpl) {
                    DocumentEx document = ((EditorComponentImpl)target).getEditor().getDocument();
                    WriteCommandAction.runWriteCommandAction((Project)context.getProject(), () -> document.replaceText((CharSequence)text, document.getModificationStamp() + 1L));
                    result.setResult(null);
                } else {
                    result.setError("Cannot replace text on non-Editor component");
                }
            });
        });
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            ReplaceTextCommand.$$$reportNull$$$0(2);
        }
        return asyncPromise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/ReplaceTextCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/ReplaceTextCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

