/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.black;

import com.intellij.ide.actionsOnSave.impl.ActionsOnSaveFileDocumentManagerListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.black.BlackFormatterExecutor;
import com.jetbrains.python.black.BlackFormatterUtil;
import com.jetbrains.python.black.BlackFormattingRequest;
import com.jetbrains.python.black.BlackFormattingResponse;
import com.jetbrains.python.black.configuration.BlackFormatterConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J.\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J%\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J$\u0010\u0018\u001a\u00020\u00042\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J$\u0010\u001c\u001a\u00020\u00042\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/python/black/BlackFormatterActionOnSave;", "Lcom/intellij/ide/actionsOnSave/impl/ActionsOnSaveFileDocumentManagerListener$ActionOnSave;", "()V", "applyChanges", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/jetbrains/python/black/BlackFormatterActionOnSave$Descriptor;", "response", "Lcom/jetbrains/python/black/BlackFormattingResponse;", "formatMultipleDocuments", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "blackConfig", "Lcom/jetbrains/python/black/configuration/BlackFormatterConfiguration;", "documents", "", "Lcom/intellij/openapi/editor/Document;", "isEnabledForProject", "", "processDocuments", "", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/editor/Document;)V", "reportFailure", "title", "", "message", "reportIgnored", "Companion", "Descriptor", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nBlackFormatterActionOnSave.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlackFormatterActionOnSave.kt\ncom/jetbrains/python/black/BlackFormatterActionOnSave\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,136:1\n1603#2,9:137\n1855#2:146\n1856#2:149\n1612#2:150\n766#2:151\n857#2,2:152\n1549#2:154\n1620#2,3:155\n1#3:147\n1#3:148\n8#4:158\n*S KotlinDebug\n*F\n+ 1 BlackFormatterActionOnSave.kt\ncom/jetbrains/python/black/BlackFormatterActionOnSave\n*L\n64#1:137,9\n64#1:146\n64#1:149\n64#1:150\n65#1:151\n65#1:152,2\n66#1:154\n66#1:155,3\n64#1:148\n29#1:158\n*E\n"})
public final class BlackFormatterActionOnSave
extends ActionsOnSaveFileDocumentManagerListener.ActionOnSave {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String BLACK_ACTION_ON_SAVE_ERROR_NOTIFICATION_GROUP_ID = "Black action on save error";
    @NotNull
    public static final String BLACK_ACTION_ON_SAVE_FILE_IGNORED_NOTIFICATION_GROUP_ID = "Black action on save file ignored";

    public boolean isEnabledForProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return Registry.is((String)"black.formatter.support.enabled");
    }

    public void processDocuments(@NotNull Project project, @NotNull Document[] documents) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)documents, (String)"documents");
        BlackFormatterConfiguration blackConfig = BlackFormatterConfiguration.Companion.getBlackConfiguration(project);
        if (!blackConfig.getEnabledOnSave()) {
            return;
        }
        Sdk sdk2 = blackConfig.getSdk(project);
        if (sdk2 == null) {
            Object[] objectArray = new Object[]{project.getName()};
            LOG.warn(PyBundle.message("black.sdk.not.configured.error", objectArray));
            return;
        }
        this.formatMultipleDocuments(project, sdk2, blackConfig, CollectionsKt.toList((Iterable)ArraysKt.filterNotNull((Object[])documents)));
    }

    /*
     * WARNING - void declaration
     */
    private final void formatMultipleDocuments(Project project, Sdk sdk2, BlackFormatterConfiguration blackConfig, List<? extends Document> documents) {
        block10: {
            Object object;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Pair it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            BlackFormatterExecutor blackFormatterExecutor;
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance()");
            FileDocumentManager manager = fileDocumentManager;
            try {
                blackFormatterExecutor = new BlackFormatterExecutor(project, sdk2, blackConfig);
            }
            catch (Exception e) {
                String string = PyBundle.message("black.exception.error.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"black.exception.error.message\")");
                String string2 = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"e.localizedMessage");
                this.reportFailure(string, string2, project);
                return;
            }
            BlackFormatterExecutor executor = blackFormatterExecutor;
            Iterable e = documents;
            boolean $i$f$mapNotNull = false;
            void var10_12 = $this$mapNotNull$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Document document = (Document)element$iv$iv;
                boolean bl2 = false;
                if (manager.getFile(document) != null) {
                    VirtualFile it2;
                    boolean bl3 = false;
                    pair = TuplesKt.to((Object)document, (Object)it2);
                } else {
                    pair = null;
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Pair)element$iv$iv;
                boolean bl = false;
                Object object2 = it.getSecond();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.second");
                if (!BlackFormatterUtil.Companion.isFileApplicable((VirtualFile)object2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Document document = (Document)it.getFirst();
                Object object3 = it.getSecond();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"it.second");
                collection.add(new Descriptor(document, (VirtualFile)object3));
            }
            List descriptors = (List)destination$iv$iv;
            Object object4 = this;
            try {
                BlackFormatterActionOnSave $this$formatMultipleDocuments_u24lambda_u244 = object4;
                boolean bl = false;
                destination$iv$iv = PyBundle.message("black.formatting.with.black", new Object[0]);
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, descriptors, executor, $this$formatMultipleDocuments_u24lambda_u244, (String)destination$iv$iv){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ List<Descriptor> $descriptors;
                    final /* synthetic */ BlackFormatterExecutor $executor;
                    final /* synthetic */ BlackFormatterActionOnSave $this_runCatching;
                    {
                        this.$project = $project;
                        this.$descriptors = $descriptors;
                        this.$executor = $executor;
                        this.$this_runCatching = $receiver;
                        super($project, $super_call_param$1, true);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        void $this$forEach$iv;
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        long processedFiles = 0L;
                        indicator.setText(PyBundle.message("black.formatting.with.black", new Object[0]));
                        indicator.setIndeterminate(false);
                        Iterable iterable = this.$descriptors;
                        List<Descriptor> list = this.$descriptors;
                        BlackFormatterExecutor blackFormatterExecutor = this.$executor;
                        BlackFormatterActionOnSave blackFormatterActionOnSave = this.$this_runCatching;
                        Project project = this.$project;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Descriptor descriptor2 = (Descriptor)element$iv;
                            boolean bl = false;
                            indicator.setFraction((double)(++processedFiles) / (double)list.size());
                            Object[] objectArray = new Object[]{descriptor2.getVirtualFile().getName()};
                            indicator.setText(PyBundle.message("black.processing.file.name", objectArray));
                            String string = descriptor2.getDocument().getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.document.text");
                            BlackFormattingRequest.File request = new BlackFormattingRequest.File(string, descriptor2.getVirtualFile());
                            BlackFormattingResponse response = blackFormatterExecutor.getBlackFormattingResponse-HG0u8IE(request, BlackFormatterExecutor.Companion.getBLACK_DEFAULT_TIMEOUT-UwyO8pc());
                            if (indicator.isCanceled()) continue;
                            BlackFormatterActionOnSave.access$applyChanges(blackFormatterActionOnSave, project, descriptor2, response);
                        }
                    }
                });
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object4 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object4);
            if (throwable == null) break block10;
            Object exception = object = throwable;
            boolean bl = false;
            if (!(exception instanceof ProcessCanceledException)) {
                LOG.warn((Throwable)exception);
                String string = PyBundle.message("black.exception.error.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"black.exception.error.message\")");
                String string3 = ((Throwable)exception).getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"exception.localizedMessage");
                this.reportFailure(string, string3, project);
            }
        }
    }

    private final void applyChanges(Project project, Descriptor descriptor2, BlackFormattingResponse response) {
        BlackFormattingResponse blackFormattingResponse = response;
        if (blackFormattingResponse instanceof BlackFormattingResponse.Success) {
            if (!Intrinsics.areEqual((Object)((BlackFormattingResponse.Success)response).getFormattedText(), (Object)ReadAction.compute(() -> BlackFormatterActionOnSave.applyChanges$lambda$6(descriptor2)))) {
                WriteCommandAction.writeCommandAction((Project)project).withName(PyBundle.message("black.formatting.with.black", new Object[0])).run(() -> BlackFormatterActionOnSave.applyChanges$lambda$7(descriptor2, response));
            }
        } else if (blackFormattingResponse instanceof BlackFormattingResponse.Failure) {
            this.reportFailure(((BlackFormattingResponse.Failure)response).getTitle(), ((BlackFormattingResponse.Failure)response).getPopupMessage(), project);
        } else if (blackFormattingResponse instanceof BlackFormattingResponse.Ignored) {
            this.reportIgnored(((BlackFormattingResponse.Ignored)response).getTitle(), ((BlackFormattingResponse.Ignored)response).getDescription(), project);
        }
    }

    private final void reportFailure(@Nls String title, @Nls String message, Project project) {
        Notification notification = new Notification(BLACK_ACTION_ON_SAVE_ERROR_NOTIFICATION_GROUP_ID, title, message, NotificationType.ERROR);
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    private final void reportIgnored(@Nls String title, @Nls String message, Project project) {
        Notification notification = new Notification(BLACK_ACTION_ON_SAVE_FILE_IGNORED_NOTIFICATION_GROUP_ID, title, message, NotificationType.INFORMATION);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)PyBundle.message("black.advertising.service.dont.show.again.label", new Object[0]), () -> BlackFormatterActionOnSave.reportIgnored$lambda$8(notification, project)));
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    private static final String applyChanges$lambda$6(Descriptor $descriptor) {
        Intrinsics.checkNotNullParameter((Object)$descriptor, (String)"$descriptor");
        return $descriptor.getDocument().getText();
    }

    private static final void applyChanges$lambda$7(Descriptor $descriptor, BlackFormattingResponse $response) {
        Intrinsics.checkNotNullParameter((Object)$descriptor, (String)"$descriptor");
        Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
        $descriptor.getDocument().setText((CharSequence)((BlackFormattingResponse.Success)$response).getFormattedText());
    }

    private static final void reportIgnored$lambda$8(Notification $notification, Project $project) {
        Intrinsics.checkNotNullParameter((Object)$notification, (String)"$notification");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        $notification.setDoNotAskFor($project);
    }

    public static final /* synthetic */ void access$applyChanges(BlackFormatterActionOnSave $this, Project project, Descriptor descriptor2, BlackFormattingResponse response) {
        $this.applyChanges(project, descriptor2, response);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/black/BlackFormatterActionOnSave$Companion;", "", "()V", "BLACK_ACTION_ON_SAVE_ERROR_NOTIFICATION_GROUP_ID", "", "BLACK_ACTION_ON_SAVE_FILE_IGNORED_NOTIFICATION_GROUP_ID", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/black/BlackFormatterActionOnSave$Descriptor;", "", "document", "Lcom/intellij/openapi/editor/Document;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.python.community.impl"})
    private static final class Descriptor {
        @NotNull
        private final Document document;
        @NotNull
        private final VirtualFile virtualFile;

        public Descriptor(@NotNull Document document, @NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            this.document = document;
            this.virtualFile = virtualFile;
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        @NotNull
        public final Document component1() {
            return this.document;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.virtualFile;
        }

        @NotNull
        public final Descriptor copy(@NotNull Document document, @NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            return new Descriptor(document, virtualFile);
        }

        public static /* synthetic */ Descriptor copy$default(Descriptor descriptor2, Document document, VirtualFile virtualFile, int n, Object object) {
            if ((n & 1) != 0) {
                document = descriptor2.document;
            }
            if ((n & 2) != 0) {
                virtualFile = descriptor2.virtualFile;
            }
            return descriptor2.copy(document, virtualFile);
        }

        @NotNull
        public String toString() {
            return "Descriptor(document=" + this.document + ", virtualFile=" + this.virtualFile + ")";
        }

        public int hashCode() {
            int result2 = this.document.hashCode();
            result2 = result2 * 31 + this.virtualFile.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Descriptor)) {
                return false;
            }
            Descriptor descriptor2 = (Descriptor)other;
            if (!Intrinsics.areEqual((Object)this.document, (Object)descriptor2.document)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.virtualFile, (Object)descriptor2.virtualFile);
        }
    }
}

