/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyQuotesUtil;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyQuotedStringIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.quoted.string", new Object[0]);
        if (string == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(1);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyStringElement stringElement = PyQuotedStringIntention.findConvertibleStringElementUnderCaret(editor2, file);
        if (stringElement == null) {
            return false;
        }
        PyStringLiteralExpression stringLiteral = PyUtil.as(stringElement.getParent(), PyStringLiteralExpression.class);
        if (stringLiteral == null) {
            return false;
        }
        PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)stringLiteral, PyDocStringOwner.class);
        if (docStringOwner != null && docStringOwner.getDocStringExpression() == stringLiteral) {
            return false;
        }
        String currentQuote = stringElement.getQuote();
        if (currentQuote.equals("'")) {
            this.setText(PyPsiBundle.message("INTN.quoted.string.single.to.double", new Object[0]));
        } else {
            this.setText(PyPsiBundle.message("INTN.quoted.string.double.to.single", new Object[0]));
        }
        return true;
    }

    @Nullable
    private static PyStringElement findConvertibleStringElementUnderCaret(@NotNull Editor editor2, @NotNull PsiFile file) {
        PsiElement elementUnderCaret;
        if (editor2 == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(2);
        }
        if (file == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(3);
        }
        if ((elementUnderCaret = file.findElementAt(editor2.getCaretModel().getOffset())) == null) {
            return null;
        }
        IElementType elementType = elementUnderCaret.getNode().getElementType();
        if (!PyTokenTypes.STRING_NODES.contains(elementType) && !PyTokenTypes.FSTRING_TOKENS.contains(elementType)) {
            return null;
        }
        PyStringElement stringElement = (PyStringElement)PsiTreeUtil.getParentOfType((PsiElement)elementUnderCaret, PyStringElement.class, (boolean)false, (Class[])new Class[]{PyExpression.class});
        return stringElement != null && PyQuotesUtil.canBeConverted(stringElement, true) ? stringElement : null;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(4);
        }
        PsiElement elementUnderCaret = file.findElementAt(editor2.getCaretModel().getOffset());
        PyStringElement stringElement = (PyStringElement)PsiTreeUtil.getParentOfType((PsiElement)elementUnderCaret, PyStringElement.class, (boolean)false, (Class[])new Class[]{PyExpression.class});
        if (stringElement == null) {
            return;
        }
        PyStringLiteralExpression stringLiteral = PyUtil.as(stringElement.getParent(), PyStringLiteralExpression.class);
        if (stringLiteral == null) {
            return;
        }
        String originalQuote = stringElement.getQuote();
        boolean entireLiteralCanBeConverted = ContainerUtil.all(stringLiteral.getStringElements(), s -> s.getQuote().equals(originalQuote) && PyQuotesUtil.canBeConverted(s, true));
        if (entireLiteralCanBeConverted) {
            stringLiteral.getStringElements().forEach(PyQuotedStringIntention::convertStringElement);
        } else {
            PyQuotedStringIntention.convertStringElement(stringElement);
        }
    }

    private static void convertStringElement(@NotNull PyStringElement stringElement) {
        if (stringElement == null) {
            PyQuotedStringIntention.$$$reportNull$$$0(5);
        }
        stringElement.replace(PyQuotesUtil.createCopyWithConvertedQuotes(stringElement));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyQuotedStringIntention";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyQuotedStringIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findConvertibleStringElementUnderCaret";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertStringElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

