/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTupleAssignmentBalanceInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyTupleAssignmentBalanceInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyTupleAssignmentBalanceInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyTupleAssignmentBalanceInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        @Override
        public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            PyExpression lhsExpression = PyPsiUtils.flattenParens(node.getLeftHandSideExpression());
            PyExpression assignedValue = node.getAssignedValue();
            if (!(lhsExpression instanceof PyTupleExpression) || assignedValue == null) {
                return;
            }
            PyExpression[] targets = ((PyTupleExpression)lhsExpression).getElements();
            int targetsLength = targets.length;
            int starExpressions = Visitor.countStarExpressions(targets);
            if (starExpressions > 1) {
                this.registerProblem((PsiElement)lhsExpression, PyPsiBundle.message("INSP.tuple.assignment.balance.only.one.starred.expression.allowed.in.assignment", new Object[0]));
                return;
            }
            int valuesLength = Visitor.getActualLength(assignedValue, this.myTypeEvalContext);
            if (valuesLength == -1) {
                return;
            }
            if (targetsLength > valuesLength + starExpressions) {
                this.registerProblem((PsiElement)assignedValue, PyPsiBundle.message("INSP.tuple.assignment.balance.need.more.values.to.unpack", new Object[0]));
            } else if (starExpressions == 0 && targetsLength < valuesLength) {
                this.registerProblem((PsiElement)assignedValue, PyPsiBundle.message("INSP.tuple.assignment.balance.too.many.values.to.unpack", new Object[0]));
            }
        }

        private static int getActualLength(@NotNull PyExpression assignedValue, @NotNull TypeEvalContext context) {
            PyType assignedType;
            if (assignedValue == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (assignedValue instanceof PySequenceExpression) {
                return ((PySequenceExpression)assignedValue).getElements().length;
            }
            if (assignedValue instanceof PyStringLiteralExpression) {
                return ((PyStringLiteralExpression)assignedValue).getStringValue().length();
            }
            if (assignedValue instanceof PyNumericLiteralExpression || assignedValue instanceof PyNoneLiteralExpression) {
                return 1;
            }
            if (assignedValue instanceof PyCallExpression) {
                PyExpression firstArgument;
                PyCallExpression call = (PyCallExpression)assignedValue;
                if (call.isCalleeText("dict")) {
                    return call.getArguments().length;
                }
                if (call.isCalleeText("tuple") && (firstArgument = (PyExpression)ArrayUtil.getFirstElement((Object[])call.getArguments())) instanceof PySequenceExpression) {
                    return ((PySequenceExpression)firstArgument).getElements().length;
                }
            }
            if ((assignedType = context.getType(assignedValue)) instanceof PyTupleType) {
                return ((PyTupleType)assignedType).getElementCount();
            }
            if (assignedType instanceof PyNoneType) {
                return 1;
            }
            return -1;
        }

        private static int countStarExpressions(PyExpression @NotNull [] expressions) {
            if (expressions == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (expressions.length != 0 && !LanguageLevel.forElement((PsiElement)expressions[0]).isPython2()) {
                return (int)Arrays.stream(expressions).filter(PyStarExpression.class::isInstance).count();
            }
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignedValue";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressions";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyTupleAssignmentBalanceInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyAssignmentStatement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getActualLength";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countStarExpressions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

