/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesInspection;
import org.jetbrains.annotations.NotNull;

public class AddIgnoredIdentifierQuickFix
implements LocalQuickFix,
LowPriorityAction {
    @NotNull
    private final QualifiedName myIdentifier;
    private final boolean myIgnoreAllAttributes;

    public AddIgnoredIdentifierQuickFix(@NotNull QualifiedName identifier, boolean ignoreAllAttributes) {
        if (identifier == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(0);
        }
        this.myIdentifier = identifier;
        this.myIgnoreAllAttributes = ignoreAllAttributes;
    }

    @NotNull
    public String getName() {
        if (this.myIgnoreAllAttributes) {
            String string = PyBundle.message("QFIX.mark.all.unresolved.attributes.of.0.as.ignored", this.myIdentifier);
            if (string == null) {
                AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = PyBundle.message("QFIX.ignore.unresolved.reference.0", this.myIdentifier);
        if (string == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.ignore.unresolved.reference", new Object[0]);
        if (string == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(5);
        }
        PsiElement context = descriptor2.getPsiElement();
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, model2 -> {
            PyUnresolvedReferencesInspection inspection = (PyUnresolvedReferencesInspection)model2.getUnwrappedTool(PyUnresolvedReferencesInspection.class.getSimpleName(), context);
            Object name2 = this.myIdentifier.toString();
            if (this.myIgnoreAllAttributes) {
                name2 = (String)name2 + ".*";
            }
            assert (inspection != null);
            if (!inspection.ignoredIdentifiers.contains(name2)) {
                inspection.ignoredIdentifiers.add((String)name2);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/AddIgnoredIdentifierQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/AddIgnoredIdentifierQuickFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

