/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject;

import com.intellij.execution.ExecutionException;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGeneratorBase;
import com.intellij.util.BooleanFunction;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.newProject.PyNewProjectSettings;
import com.jetbrains.python.newProject.collector.InterpreterStatisticsInfo;
import com.jetbrains.python.newProject.collector.PythonNewProjectWizardCollector;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyPackagesNotificationPanel;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.remote.PyProjectSynchronizerProvider;
import com.jetbrains.python.remote.PySyncCheckCreateIfPossible;
import com.jetbrains.python.remote.PySyncCheckOnly;
import com.jetbrains.python.remote.PySyncDirection;
import com.jetbrains.python.sdk.PyLazySdk;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonProjectGenerator<T extends PyNewProjectSettings>
extends DirectoryProjectGeneratorBase<T> {
    public static final PyNewProjectSettings NO_SETTINGS = new PyNewProjectSettings();
    private static final Logger LOGGER = Logger.getInstance(PythonProjectGenerator.class);
    private final List<SettingsListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final boolean myAllowRemoteProjectCreation;
    @Nullable
    private MouseListener myErrorLabelMouseListener;
    protected Consumer<String> myErrorCallback;

    protected PythonProjectGenerator() {
        this(false);
    }

    protected PythonProjectGenerator(boolean allowRemoteProjectCreation) {
        this.myAllowRemoteProjectCreation = allowRemoteProjectCreation;
    }

    public final void setErrorCallback(@NotNull Consumer<String> errorCallback) {
        if (errorCallback == null) {
            PythonProjectGenerator.$$$reportNull$$$0(0);
        }
        this.myErrorCallback = errorCallback;
    }

    @Nullable
    public JComponent getSettingsPanel(File baseDir) throws ProcessCanceledException {
        return null;
    }

    @Nullable
    public JPanel extendBasePanel() throws ProcessCanceledException {
        return null;
    }

    public void checkProjectCanBeCreatedOnSdk(@NotNull Sdk sdk2, @NotNull File projectDirectory) throws PyNoProjectAllowedOnSdkException {
        if (sdk2 == null) {
            PythonProjectGenerator.$$$reportNull$$$0(1);
        }
        if (projectDirectory == null) {
            PythonProjectGenerator.$$$reportNull$$$0(2);
        }
        if (!this.myAllowRemoteProjectCreation && PythonSdkUtil.isRemote(sdk2)) {
            throw new PyNoProjectAllowedOnSdkException(PyBundle.message("python.remote.interpreter.can.t.create.project.this.type", new Object[0]));
        }
        PyProjectSynchronizer synchronizer = PyProjectSynchronizerProvider.getSynchronizer(sdk2);
        if (synchronizer == null) {
            return;
        }
        String syncError = synchronizer.checkSynchronizationAvailable(new PySyncCheckOnly(projectDirectory));
        if (syncError != null) {
            throw new PyNoProjectAllowedOnSdkException(syncError);
        }
    }

    public final void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull T settings, @NotNull Module module) {
        PyProjectSynchronizer synchronizer;
        if (project == null) {
            PythonProjectGenerator.$$$reportNull$$$0(3);
        }
        if (baseDir == null) {
            PythonProjectGenerator.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            PythonProjectGenerator.$$$reportNull$$$0(5);
        }
        if (module == null) {
            PythonProjectGenerator.$$$reportNull$$$0(6);
        }
        if (settings == NO_SETTINGS) {
            this.configureProjectNoSettings(project, baseDir, module);
            return;
        }
        Sdk sdk2 = ((PyNewProjectSettings)settings).getSdk();
        if (sdk2 instanceof PyLazySdk) {
            Sdk createdSdk = ((PyLazySdk)sdk2).create();
            ((PyNewProjectSettings)settings).setSdk(createdSdk);
            if (createdSdk != null) {
                SdkConfigurationUtil.addSdk((Sdk)createdSdk);
            }
        }
        PyProjectSynchronizer pyProjectSynchronizer = synchronizer = sdk2 != null ? PyProjectSynchronizerProvider.getSynchronizer(sdk2) : null;
        if (synchronizer != null) {
            String syncError;
            String userProvidedPath = ((PyNewProjectSettings)settings).getRemotePath();
            while ((syncError = synchronizer.checkSynchronizationAvailable(new PySyncCheckCreateIfPossible(module, userProvidedPath))) != null) {
                userProvidedPath = null;
                String message = PyBundle.message("python.new.project.synchronization.not.configured.dialog.message", syncError);
                if (Messages.showYesNoDialog((Project)project, (String)message, (String)PyBundle.message("python.new.project.synchronization.not.configured.dialog.title", new Object[0]), (Icon)AllIcons.General.WarningDialog) != 0) continue;
                break;
            }
        }
        this.configureProject(project, baseDir, settings, module, synchronizer);
        Object statisticsInfo = ((PyNewProjectSettings)settings).getInterpreterInfoForStatistics();
        if (statisticsInfo instanceof InterpreterStatisticsInfo) {
            InterpreterStatisticsInfo interpreterStatisticsInfo = (InterpreterStatisticsInfo)statisticsInfo;
            PythonNewProjectWizardCollector.Companion.logPythonNewProjectGenerated(interpreterStatisticsInfo, PyStatisticToolsKt.getVersion(((PyNewProjectSettings)settings).getSdk()), ((Object)((Object)this)).getClass());
        }
    }

    protected void configureProjectNoSettings(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Module module) {
        if (project == null) {
            PythonProjectGenerator.$$$reportNull$$$0(7);
        }
        if (baseDir == null) {
            PythonProjectGenerator.$$$reportNull$$$0(8);
        }
        if (module == null) {
            PythonProjectGenerator.$$$reportNull$$$0(9);
        }
        throw new IllegalStateException(String.format("%s does not support project creation with out of settings. See %s doc for detail", ((Object)((Object)this)).getClass(), PythonProjectGenerator.class));
    }

    protected void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull T settings, @NotNull Module module, @Nullable PyProjectSynchronizer synchronizer) {
        if (project == null) {
            PythonProjectGenerator.$$$reportNull$$$0(10);
        }
        if (baseDir == null) {
            PythonProjectGenerator.$$$reportNull$$$0(11);
        }
        if (settings == null) {
            PythonProjectGenerator.$$$reportNull$$$0(12);
        }
        if (module == null) {
            PythonProjectGenerator.$$$reportNull$$$0(13);
        }
        if (synchronizer != null) {
            synchronizer.syncProject(module, PySyncDirection.LOCAL_TO_REMOTE, null, new String[0]);
        }
    }

    public Object getProjectSettings() {
        return new PyNewProjectSettings();
    }

    public ValidationResult warningValidation(@Nullable Sdk sdk2) {
        return ValidationResult.OK;
    }

    public void addSettingsStateListener(@NotNull SettingsListener listener2) {
        if (listener2 == null) {
            PythonProjectGenerator.$$$reportNull$$$0(14);
        }
        this.myListeners.add(listener2);
    }

    public void locationChanged(@NotNull String newLocation) {
        if (newLocation == null) {
            PythonProjectGenerator.$$$reportNull$$$0(15);
        }
    }

    public void fireStateChanged() {
        for (SettingsListener listener2 : this.myListeners) {
            listener2.stateChanged();
        }
    }

    @Nullable
    public BooleanFunction<PythonProjectGenerator> beforeProjectGenerated(@Nullable Sdk sdk2) {
        return null;
    }

    public void afterProjectGenerated(@NotNull Project project) {
        if (project == null) {
            PythonProjectGenerator.$$$reportNull$$$0(16);
        }
    }

    public void addErrorLabelMouseListener(@NotNull MouseListener mouseListener) {
        if (mouseListener == null) {
            PythonProjectGenerator.$$$reportNull$$$0(17);
        }
        this.myErrorLabelMouseListener = mouseListener;
    }

    @Nullable
    public MouseListener getErrorLabelMouseListener() {
        return this.myErrorLabelMouseListener;
    }

    public void createAndAddVirtualEnv(Project project, PyNewProjectSettings settings) {
    }

    protected static void reportPackageInstallationFailure(@NotNull String frameworkName, @Nullable Pair<Sdk, ExecutionException> sdkAndException) {
        if (frameworkName == null) {
            PythonProjectGenerator.$$$reportNull$$$0(18);
        }
        PyPackageManagementService.PyPackageInstallationErrorDescription errorDescription = PythonProjectGenerator.getErrorDescription(sdkAndException, frameworkName);
        Application app = ApplicationManager.getApplication();
        app.invokeLater(() -> PyPackagesNotificationPanel.showPackageInstallationError(PyBundle.message("python.new.project.install.failed.title", frameworkName), errorDescription));
    }

    @NotNull
    private static PyPackageManagementService.PyPackageInstallationErrorDescription getErrorDescription(@Nullable Pair<Sdk, ExecutionException> sdkAndException, @NotNull String packageName) {
        ExecutionException exception;
        if (packageName == null) {
            PythonProjectGenerator.$$$reportNull$$$0(19);
        }
        PyPackageManagementService.PyPackageInstallationErrorDescription errorDescription = null;
        if (sdkAndException != null && (errorDescription = PyPackageManagementService.toErrorDescription(Collections.singletonList(exception = (ExecutionException)((Object)sdkAndException.second)), (Sdk)sdkAndException.first, packageName)) == null) {
            errorDescription = PyPackageManagementService.PyPackageInstallationErrorDescription.createFromMessage(exception.getMessage());
        }
        if (errorDescription == null) {
            errorDescription = PyPackageManagementService.PyPackageInstallationErrorDescription.createFromMessage(PyBundle.message("python.new.project.error.solution.another.sdk", new Object[0]));
        }
        PyPackageManagementService.PyPackageInstallationErrorDescription pyPackageInstallationErrorDescription = errorDescription;
        if (pyPackageInstallationErrorDescription == null) {
            PythonProjectGenerator.$$$reportNull$$$0(20);
        }
        return pyPackageInstallationErrorDescription;
    }

    public static void installFrameworkIfNeeded(@NotNull Project project, final @NotNull String frameworkName, final @NotNull String requirement, final @Nullable Sdk sdk2, final boolean forceInstallFramework, final @Nullable Runnable callback) {
        if (project == null) {
            PythonProjectGenerator.$$$reportNull$$$0(21);
        }
        if (frameworkName == null) {
            PythonProjectGenerator.$$$reportNull$$$0(22);
        }
        if (requirement == null) {
            PythonProjectGenerator.$$$reportNull$$$0(23);
        }
        if (sdk2 == null) {
            PythonProjectGenerator.reportPackageInstallationFailure(frameworkName, null);
            return;
        }
        final PyPackageManager packageManager = PyPackageManager.getInstance(sdk2);
        if (forceInstallFramework || PythonSdkUtil.isRemote(sdk2)) {
            ProgressManager.getInstance().run((Task)new Task.Modal(project, PyBundle.message("python.install.framework.ensure.installed", frameworkName), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    boolean installed = false;
                    if (!forceInstallFramework) {
                        indicator.setText(PyBundle.message("python.install.framework.checking.is.installed", frameworkName));
                        List<PyPackage> packages2 = PyPackageUtil.refreshAndGetPackagesModally(sdk2);
                        boolean bl = installed = PyPsiPackageUtil.findPackage(packages2, requirement) != null;
                    }
                    if (!installed) {
                        indicator.setText(PyBundle.message("python.install.framework.installing", frameworkName));
                        try {
                            packageManager.install(requirement);
                            packageManager.refresh();
                        }
                        catch (ExecutionException e) {
                            PythonProjectGenerator.reportPackageInstallationFailure(requirement, (Pair<Sdk, ExecutionException>)Pair.create((Object)sdk2, (Object)((Object)e)));
                        }
                    }
                }

                public void onSuccess() {
                    if (callback != null) {
                        callback.run();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/newProject/PythonProjectGenerator$1", "run"));
                }
            });
        } else if (callback != null) {
            assert (SwingUtilities.isEventDispatchThread());
            callback.run();
        }
    }

    @Nullable
    public String getPreferredEnvironmentType() {
        return null;
    }

    @Nullable
    public String getNewProjectPrefix() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorCallback";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDirectory";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLocation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseListener";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/newProject/PythonProjectGenerator";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/newProject/PythonProjectGenerator";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setErrorCallback";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkProjectCanBeCreatedOnSdk";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureProjectNoSettings";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsStateListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "locationChanged";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "afterProjectGenerated";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addErrorLabelMouseListener";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reportPackageInstallationFailure";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getErrorDescription";
                break;
            }
            case 20: {
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "installFrameworkIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 20 -> new IllegalStateException(string);
        };
    }

    public static class PyNoProjectAllowedOnSdkException
    extends Exception {
        PyNoProjectAllowedOnSdkException(@NotNull @NlsContexts.DialogMessage String reason) {
            if (reason == null) {
                PyNoProjectAllowedOnSdkException.$$$reportNull$$$0(0);
            }
            super(reason);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/jetbrains/python/newProject/PythonProjectGenerator$PyNoProjectAllowedOnSdkException", "<init>"));
        }
    }

    public static interface SettingsListener {
        public void stateChanged();
    }
}

