/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyCustomDecoratorIndexer;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFileElementType;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStubElementType;
import com.jetbrains.python.psi.impl.PyDecoratorImpl;
import com.jetbrains.python.psi.impl.stubs.PyDecoratorStubImpl;
import com.jetbrains.python.psi.stubs.PyDecoratorStub;
import com.jetbrains.python.psi.stubs.PyDecoratorStubIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDecoratorCallElementType
extends PyStubElementType<PyDecoratorStub, PyDecorator> {
    public PyDecoratorCallElementType() {
        super("DECORATOR_CALL");
    }

    @Override
    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        if (node == null) {
            PyDecoratorCallElementType.$$$reportNull$$$0(0);
        }
        return new PyDecoratorImpl(node);
    }

    public PyDecorator createPsi(@NotNull PyDecoratorStub stub) {
        if (stub == null) {
            PyDecoratorCallElementType.$$$reportNull$$$0(1);
        }
        return new PyDecoratorImpl(stub);
    }

    @NotNull
    public PyDecoratorStub createStub(@NotNull PyDecorator psi, StubElement parentStub) {
        if (psi == null) {
            PyDecoratorCallElementType.$$$reportNull$$$0(2);
        }
        PyExpression[] arguments = psi.getArguments();
        ArrayList<String> positionalArguments = new ArrayList<String>();
        HashMap<String, String> namedArguments = new HashMap<String, String>();
        for (PyExpression argument : arguments) {
            if (argument instanceof PyKeywordArgument) {
                PyKeywordArgument keywordArgument = (PyKeywordArgument)argument;
                String keyword = keywordArgument.getKeyword();
                String value = PyDecoratorCallElementType.extractLiteralValue(keywordArgument.getValueExpression());
                if (keyword == null || value == null) continue;
                namedArguments.put(keyword, value);
                continue;
            }
            String value = PyDecoratorCallElementType.extractLiteralValue(argument);
            positionalArguments.add(value);
        }
        return new PyDecoratorStubImpl(psi.getQualifiedName(), psi.hasArgumentList(), parentStub, ContainerUtil.unmodifiableOrEmptyList(positionalArguments), ContainerUtil.unmodifiableOrEmptyMap(namedArguments));
    }

    @Nullable
    private static String extractLiteralValue(PyExpression expression) {
        if (expression instanceof PyLiteralExpression) {
            PyLiteralExpression literal = (PyLiteralExpression)expression;
            String value = literal instanceof PyStringLiteralExpression ? ((PyStringLiteralExpression)literal).getStringValue() : literal.getText();
            return value;
        }
        return null;
    }

    public void serialize(@NotNull PyDecoratorStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            PyDecoratorCallElementType.$$$reportNull$$$0(3);
        }
        if (dataStream == null) {
            PyDecoratorCallElementType.$$$reportNull$$$0(4);
        }
        QualifiedName.serialize((QualifiedName)stub.getQualifiedName(), (StubOutputStream)dataStream);
        dataStream.writeBoolean(stub.hasArgumentList());
        PyDecoratorStubImpl decoratorStub = (PyDecoratorStubImpl)stub;
        PyFileElementType.writeNullableList(dataStream, decoratorStub.getPositionalArguments());
        dataStream.writeInt(decoratorStub.getKeywordArguments().size());
        for (Map.Entry<String, String> entry : decoratorStub.getKeywordArguments().entrySet()) {
            dataStream.writeName(entry.getKey());
            dataStream.writeName(entry.getValue());
        }
    }

    @Override
    public void indexStub(@NotNull PyDecoratorStub stub, @NotNull IndexSink sink) {
        QualifiedName qualifiedName;
        if (stub == null) {
            PyDecoratorCallElementType.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            PyDecoratorCallElementType.$$$reportNull$$$0(6);
        }
        if ((qualifiedName = stub.getQualifiedName()) != null) {
            sink.occurrence(PyDecoratorStubIndex.KEY, (Object)qualifiedName.toString());
            PyCustomDecoratorIndexer.EP_NAME.getExtensionList().forEach(extension -> {
                String keyForStub = extension.getKeyForStub(stub);
                if (keyForStub != null) {
                    sink.occurrence(extension.getKey(), (Object)keyForStub);
                }
            });
        }
    }

    @NotNull
    public PyDecoratorStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            PyDecoratorCallElementType.$$$reportNull$$$0(7);
        }
        QualifiedName q_name = QualifiedName.deserialize((StubInputStream)dataStream);
        boolean hasArgumentList = dataStream.readBoolean();
        List<String> positionalArguments = PyFileElementType.readNullableList(dataStream);
        int namedSize = dataStream.readInt();
        HashMap<String, String> namedArguments = null;
        if (namedSize > 0) {
            namedArguments = new HashMap<String, String>(namedSize);
            for (int i = 0; i < namedSize; ++i) {
                String key = dataStream.readNameString();
                String value = dataStream.readNameString();
                namedArguments.put(key, value);
            }
        }
        return new PyDecoratorStubImpl(q_name, hasArgumentList, parentStub, ContainerUtil.notNullize(positionalArguments), ContainerUtil.notNullize(namedArguments));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/impl/stubs/PyDecoratorCallElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createPsi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

