/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyEmptyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.IPythonBuiltinConstants;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyReferenceResolveProvider;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0015H\u0002J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0015H\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0015H\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/python/psi/resolve/PyIPythonBuiltinReferenceResolveProvider;", "Lcom/jetbrains/python/psi/resolve/PyReferenceResolveProvider;", "()V", "underscoreRegex", "Lkotlin/text/Regex;", "getMagicDottedPathString", "", "name", "getPyClassByDottedPath", "Lcom/jetbrains/python/psi/PyClass;", "dottedPath", "context", "Lcom/jetbrains/python/psi/resolve/PyQualifiedNameResolveContext;", "isAutomagicOn", "", "element", "Lcom/jetbrains/python/psi/PyQualifiedExpression;", "isJupyterFile", "Lcom/intellij/psi/PsiFile;", "isPythonFile", "needToResolve", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "resolveDisplay", "", "Lcom/jetbrains/python/psi/resolve/RatedResolveResult;", "resolveGetIPython", "resolveIn", "resolveMagics", "resolveName", "resolveOut", "intellij.python.psi.impl"})
public final class PyIPythonBuiltinReferenceResolveProvider
implements PyReferenceResolveProvider {
    @NotNull
    private final Regex underscoreRegex = new Regex("_[0-9]*");

    @Override
    @NotNull
    public List<RatedResolveResult> resolveName(@NotNull PyQualifiedExpression element, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.needToResolve(context)) {
            return CollectionsKt.emptyList();
        }
        String string = element.getReferencedName();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String name2 = string;
        CharSequence charSequence = name2;
        if (this.underscoreRegex.matches(charSequence)) {
            return this.resolveOut(element, context);
        }
        switch (name2) {
            case "display": {
                return this.resolveDisplay(element);
            }
            case "get_ipython": {
                return this.resolveGetIPython(element);
            }
            case "In": {
                return this.resolveIn(element, context);
            }
            case "Out": {
                return this.resolveOut(element, context);
            }
            case "__": {
                return this.resolveOut(element, context);
            }
            case "___": {
                return this.resolveOut(element, context);
            }
        }
        if (IPythonBuiltinConstants.INSTANCE.getMAGICS_LIST().contains(name2) && element.getParent() instanceof PyExpressionStatement && this.isAutomagicOn(element)) {
            return this.resolveMagics(element, context);
        }
        return CollectionsKt.emptyList();
    }

    private final boolean needToResolve(TypeEvalContext context) {
        PsiFile psiFile = context.getOrigin();
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        return this.isJupyterFile(psiFile2) || PlatformUtils.isDataSpell() && this.isPythonFile(psiFile2);
    }

    private final boolean isJupyterFile(PsiFile element) {
        VirtualFile virtualFile = element.getVirtualFile();
        return Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getExtension() : null), (Object)"ipynb");
    }

    private final boolean isPythonFile(PsiFile element) {
        VirtualFile virtualFile = element.getVirtualFile();
        return (virtualFile != null ? virtualFile.getFileType() : null) instanceof PythonFileType;
    }

    private final List<RatedResolveResult> resolveDisplay(PyQualifiedExpression element) {
        PyQualifiedNameResolveContext resolveContext = PyResolveImportUtil.fromFoothold((PsiElement)element);
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)"IPython.core.display_functions.display");
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"fromDottedString(IPython\u2026.DISPLAY_DOTTED_PATH_NEW)");
        PsiElement displayPsi = PyResolveImportUtil.resolveTopLevelMember(qualifiedName, resolveContext);
        if (displayPsi == null) {
            QualifiedName qualifiedName2 = QualifiedName.fromDottedString((String)"IPython.core.display.display");
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedName2, (String)"fromDottedString(IPython\u2026.DISPLAY_DOTTED_PATH_OLD)");
            displayPsi = PyResolveImportUtil.resolveTopLevelMember(qualifiedName2, resolveContext);
        }
        List<RatedResolveResult> list = ResolveResultList.to(displayPsi);
        Intrinsics.checkNotNullExpressionValue(list, (String)"to(displayPsi)");
        return list;
    }

    private final List<RatedResolveResult> resolveGetIPython(PyQualifiedExpression element) {
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)"IPython.core.getipython.get_ipython");
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"fromDottedString(IPython\u2026.GET_IPYTHON_DOTTED_PATH)");
        PsiElement getIPythonPsi = PyResolveImportUtil.resolveTopLevelMember(qualifiedName, PyResolveImportUtil.fromFoothold((PsiElement)element));
        List<RatedResolveResult> list = ResolveResultList.to(getIPythonPsi);
        Intrinsics.checkNotNullExpressionValue(list, (String)"to(getIPythonPsi)");
        return list;
    }

    private final List<RatedResolveResult> resolveIn(PyQualifiedExpression element, TypeEvalContext context) {
        PyClass pyClass = this.getPyClassByDottedPath("IPython.core.history.HistoryManager", PyResolveImportUtil.fromFoothold((PsiElement)element));
        if (pyClass == null) {
            return CollectionsKt.emptyList();
        }
        PyClass historyClass = pyClass;
        PyTargetExpression inHistDictPsi = historyClass.findClassAttribute("input_hist_parsed", false, context);
        List<RatedResolveResult> list = ResolveResultList.to(inHistDictPsi);
        Intrinsics.checkNotNullExpressionValue(list, (String)"to(inHistDictPsi)");
        return list;
    }

    private final List<RatedResolveResult> resolveOut(PyQualifiedExpression element, TypeEvalContext context) {
        PyClass pyClass = this.getPyClassByDottedPath("IPython.core.history.HistoryManager", PyResolveImportUtil.fromFoothold((PsiElement)element));
        if (pyClass == null) {
            return CollectionsKt.emptyList();
        }
        PyClass historyClass = pyClass;
        PyTargetExpression outHistDictPsi = historyClass.findClassAttribute("output_hist", false, context);
        List<RatedResolveResult> list = ResolveResultList.to(outHistDictPsi);
        Intrinsics.checkNotNullExpressionValue(list, (String)"to(outHistDictPsi)");
        return list;
    }

    private final List<RatedResolveResult> resolveMagics(PyQualifiedExpression element, TypeEvalContext context) {
        String string = element.getReferencedName();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String name2 = string;
        String string2 = this.getMagicDottedPathString(name2);
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String dottedPath = string2;
        PyClass pyClass = this.getPyClassByDottedPath(dottedPath, PyResolveImportUtil.fromFoothold((PsiElement)element));
        if (pyClass == null) {
            return CollectionsKt.emptyList();
        }
        PyClass magicsClass = pyClass;
        PyFunction magicPsi = magicsClass.findMethodByName(name2, false, context);
        List<RatedResolveResult> list = ResolveResultList.to(magicPsi);
        Intrinsics.checkNotNullExpressionValue(list, (String)"to(magicPsi)");
        return list;
    }

    private final String getMagicDottedPathString(String name2) {
        String string = name2;
        return IPythonBuiltinConstants.INSTANCE.getAUTOMAGIC_MAGICS().contains(string) ? "IPython.core.magics.auto.AutoMagics" : (IPythonBuiltinConstants.INSTANCE.getBASIC_MAGICS().contains(string) ? "IPython.core.magics.basic.BasicMagics" : (IPythonBuiltinConstants.INSTANCE.getCODE_MAGICS().contains(string) ? "IPython.core.magics.code.CodeMagics" : (IPythonBuiltinConstants.INSTANCE.getCONFIG_MAGICS().contains(string) ? "IPython.core.magics.config.ConfigMagics" : (IPythonBuiltinConstants.INSTANCE.getEXECUTION_MAGICS().contains(string) ? "IPython.core.magics.execution.ExecutionMagics" : (IPythonBuiltinConstants.INSTANCE.getEXTENSION_MAGICS().contains(string) ? "IPython.core.magics.extension.ExtensionMagics" : (IPythonBuiltinConstants.INSTANCE.getHISTORY_MAGICS().contains(string) ? "IPython.core.magics.history.HistoryMagics" : (IPythonBuiltinConstants.INSTANCE.getLOGGING_MAGICS().contains(string) ? "IPython.core.magics.logging.LoggingMagics" : (IPythonBuiltinConstants.INSTANCE.getNAMESPACE_MAGICS().contains(string) ? "IPython.core.magics.namespace.NamespaceMagics" : (IPythonBuiltinConstants.INSTANCE.getOS_MAGICS().contains(string) ? "IPython.core.magics.osm.OSMagics" : (IPythonBuiltinConstants.INSTANCE.getPACKAGING_MAGICS().contains(string) ? "IPython.core.magics.packaging.PackagingMagics" : (IPythonBuiltinConstants.INSTANCE.getPYLAB_MAGICS().contains(string) ? "IPython.core.magics.pylab.PylabMagics" : (IPythonBuiltinConstants.INSTANCE.getASYNC_MAGICS().contains(string) ? "IPython.core.magics.basic.AsyncMagics" : null))))))))))));
    }

    private final PyClass getPyClassByDottedPath(String dottedPath, PyQualifiedNameResolveContext context) {
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)dottedPath);
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"fromDottedString(dottedPath)");
        PsiElement psiElement = PyResolveImportUtil.resolveTopLevelMember(qualifiedName, context);
        return psiElement instanceof PyClass ? (PyClass)psiElement : null;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isAutomagicOn(PyQualifiedExpression element) {
        v0 = element.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"element.parent");
        previousSiblings = PsiTreeUtilKt.siblings((PsiElement)v0, (boolean)false, (boolean)false);
        for (PsiElement sib : previousSiblings) {
            if (sib instanceof PyEmptyExpression) {
                if (Intrinsics.areEqual((Object)((PyEmptyExpression)sib).getText(), (Object)"%automagic 0")) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)((PyEmptyExpression)sib).getText(), (Object)"%automagic 1")) {
                    return true;
                }
            }
            if (!(sib instanceof PyExpressionStatement) || !(((PyExpressionStatement)sib).getNextSibling() instanceof PsiWhiteSpace)) continue;
            it = ((PyExpressionStatement)sib).getChildren();
            $i$a$-let-PyIPythonBuiltinReferenceResolveProvider$isAutomagicOn$1 = false;
            if (((PsiElement[])it).length != 2) ** GOTO lbl-1000
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (ArraysKt.first((Object[])it) instanceof PyReferenceExpression && ArraysKt.last((Object[])it) instanceof PsiErrorElement && Intrinsics.areEqual((Object)((PsiElement)ArraysKt.first((Object[])it)).getText(), (Object)"automagic")) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            it = ((PyExpressionStatement)sib).getNextSibling().getNextSibling();
            $i$a$-let-PyIPythonBuiltinReferenceResolveProvider$isAutomagicOn$2 = false;
            if (!(it instanceof PyExpressionStatement)) ** GOTO lbl-1000
            v2 = ((PyExpressionStatement)it).getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it.children");
            if (ArraysKt.singleOrNull((Object[])v2) instanceof PyNumericLiteralExpression) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            if (Intrinsics.areEqual((Object)((PyExpressionStatement)sib).getNextSibling().getNextSibling().getText(), (Object)"1")) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)((PyExpressionStatement)sib).getNextSibling().getNextSibling().getText(), (Object)"0")) continue;
            return false;
        }
        return true;
    }
}

