/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyNamedTupleType
extends PyTupleType
implements PyCallableType {
    @NotNull
    public static final Set<String> NAMEDTUPLE_SPECIAL_ATTRIBUTES = ImmutableSet.of((Object)"_make", (Object)"_asdict", (Object)"_replace", (Object)"_source", (Object)"_fields", (Object)"_field_types", (Object[])new String[]{"_field_defaults"});
    @NotNull
    private final String myName;
    @NotNull
    private final LinkedHashMap<String, FieldTypeAndDefaultValue> myFields;
    private final boolean myTyped;
    @Nullable
    private final PyQualifiedNameOwner myDeclaration;

    public PyNamedTupleType(@NotNull PyClass tupleClass, @NotNull String name2, @NotNull LinkedHashMap<String, FieldTypeAndDefaultValue> fields, boolean isDefinition, boolean typed, @Nullable PyQualifiedNameOwner declaration) {
        if (tupleClass == null) {
            PyNamedTupleType.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            PyNamedTupleType.$$$reportNull$$$0(1);
        }
        if (fields == null) {
            PyNamedTupleType.$$$reportNull$$$0(2);
        }
        super(tupleClass, ContainerUtil.map(fields.values(), typeAndValue -> typeAndValue.getType()), false, isDefinition);
        this.myFields = new LinkedHashMap<String, FieldTypeAndDefaultValue>(fields);
        this.myName = name2;
        this.myTyped = typed;
        this.myDeclaration = declaration;
    }

    @Override
    @NotNull
    public PyQualifiedNameOwner getDeclarationElement() {
        PyQualifiedNameOwner pyQualifiedNameOwner = (PyQualifiedNameOwner)ObjectUtils.notNull((Object)this.myDeclaration, () -> super.getDeclarationElement());
        if (pyQualifiedNameOwner == null) {
            PyNamedTupleType.$$$reportNull$$$0(3);
        }
        return pyQualifiedNameOwner;
    }

    @Override
    public Object @NotNull [] getCompletionVariants(String completionPrefix, PsiElement location, @NotNull ProcessingContext context) {
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(4);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        Collections.addAll(result2, super.getCompletionVariants(completionPrefix, location, context));
        for (String field : this.myFields.keySet()) {
            result2.add(LookupElementBuilder.create((String)field).withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Field)));
        }
        if (completionPrefix == null) {
            Condition nameFilter = NAMEDTUPLE_SPECIAL_ATTRIBUTES::contains;
            CompletionVariantsProcessor processor2 = new CompletionVariantsProcessor(location, null, (Condition<String>)nameFilter, false, context.get(CTX_SUPPRESS_PARENTHESES) != null);
            this.myClass.processClassLevelDeclarations(processor2);
            result2.addAll(processor2.getResultList());
        }
        Object[] objectArray = ArrayUtil.toObjectArray(result2);
        if (objectArray == null) {
            PyNamedTupleType.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PyNamedTupleType.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    @Nullable
    public PyNamedTupleType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(7);
        }
        if (callSite == null) {
            PyNamedTupleType.$$$reportNull$$$0(8);
        }
        if (this.isDefinition()) {
            return this.getCallDefinitionType(callSite, context);
        }
        return null;
    }

    @Override
    @NotNull
    public PyNamedTupleType toInstance() {
        PyNamedTupleType pyNamedTupleType = this.isDefinition() ? new PyNamedTupleType(this.myClass, this.myName, this.myFields, false, this.myTyped, this.myDeclaration) : this;
        if (pyNamedTupleType == null) {
            PyNamedTupleType.$$$reportNull$$$0(9);
        }
        return pyNamedTupleType;
    }

    @Override
    @NotNull
    public PyNamedTupleType toClass() {
        PyNamedTupleType pyNamedTupleType = !this.isDefinition() ? new PyNamedTupleType(this.myClass, this.myName, this.myFields, true, this.myTyped, this.myDeclaration) : this;
        if (pyNamedTupleType == null) {
            PyNamedTupleType.$$$reportNull$$$0(10);
        }
        return pyNamedTupleType;
    }

    @Override
    public String toString() {
        return "PyNamedTupleType: " + this.myName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PyNamedTupleType type2 = (PyNamedTupleType)o;
        return Objects.equals(this.myName, type2.myName) && Objects.equals(this.myFields.keySet(), type2.myFields.keySet());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myName, this.myFields.keySet());
    }

    @Override
    @NotNull
    public Set<String> getMemberNames(boolean inherited, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(11);
        }
        Set<String> result2 = super.getMemberNames(inherited, context);
        result2.addAll(this.myFields.keySet());
        Set<String> set = result2;
        if (set == null) {
            PyNamedTupleType.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public Map<String, FieldTypeAndDefaultValue> getFields() {
        Map<String, FieldTypeAndDefaultValue> map = Collections.unmodifiableMap(this.myFields);
        if (map == null) {
            PyNamedTupleType.$$$reportNull$$$0(13);
        }
        return map;
    }

    @Override
    public boolean isCallable() {
        return this.isDefinition();
    }

    @Override
    @Nullable
    public List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(14);
        }
        return this.isCallable() ? ContainerUtil.map(this.myFields.entrySet(), field -> PyNamedTupleType.fieldToCallableParameter((String)field.getKey(), (FieldTypeAndDefaultValue)field.getValue())) : null;
    }

    public boolean isTyped() {
        return this.myTyped;
    }

    @NotNull
    public PyNamedTupleType clarifyFields(@NotNull Map<String, PyType> fieldNameToType) {
        if (fieldNameToType == null) {
            PyNamedTupleType.$$$reportNull$$$0(15);
        }
        if (!this.myTyped) {
            LinkedHashMap<String, FieldTypeAndDefaultValue> newFields = new LinkedHashMap<String, FieldTypeAndDefaultValue>(this.myFields);
            for (Map.Entry<String, PyType> entry : fieldNameToType.entrySet()) {
                String fieldName = entry.getKey();
                if (!newFields.containsKey(fieldName)) continue;
                newFields.put(fieldName, new FieldTypeAndDefaultValue(entry.getValue(), null));
            }
            return new PyNamedTupleType(this.myClass, this.myName, newFields, this.isDefinition(), false, this.myDeclaration);
        }
        PyNamedTupleType pyNamedTupleType = this;
        if (pyNamedTupleType == null) {
            PyNamedTupleType.$$$reportNull$$$0(16);
        }
        return pyNamedTupleType;
    }

    @NotNull
    private PyNamedTupleType getCallDefinitionType(@NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        List<PyExpression> arguments;
        if (callSite == null) {
            PyNamedTupleType.$$$reportNull$$$0(17);
        }
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(18);
        }
        if (!this.myTyped && (arguments = callSite.getArguments(null)).size() == this.myFields.size()) {
            HashMap<String, PyType> result2 = new HashMap<String, PyType>();
            for (Map.Entry entry : StreamEx.ofKeys(this.myFields).zipWith((Stream)StreamEx.of(arguments))) {
                String name2 = (String)entry.getKey();
                PyType type2 = context.getType((PyTypedElement)entry.getValue());
                result2.put(name2, type2);
            }
            PyNamedTupleType pyNamedTupleType = this.toInstance().clarifyFields(result2);
            if (pyNamedTupleType == null) {
                PyNamedTupleType.$$$reportNull$$$0(19);
            }
            return pyNamedTupleType;
        }
        PyNamedTupleType pyNamedTupleType = this.toInstance();
        if (pyNamedTupleType == null) {
            PyNamedTupleType.$$$reportNull$$$0(20);
        }
        return pyNamedTupleType;
    }

    @NotNull
    private static PyCallableParameter fieldToCallableParameter(@NotNull String name2, @NotNull FieldTypeAndDefaultValue typeAndDefaultValue) {
        if (name2 == null) {
            PyNamedTupleType.$$$reportNull$$$0(21);
        }
        if (typeAndDefaultValue == null) {
            PyNamedTupleType.$$$reportNull$$$0(22);
        }
        PyCallableParameter pyCallableParameter = PyCallableParameterImpl.nonPsi(name2, typeAndDefaultValue.getType(), typeAndDefaultValue.getDefaultValue());
        if (pyCallableParameter == null) {
            PyNamedTupleType.$$$reportNull$$$0(23);
        }
        return pyCallableParameter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 9, 10, 12, 13, 16, 19, 20, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tupleClass";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyNamedTupleType";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldNameToType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAndDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyNamedTupleType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionVariants";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toInstance";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toClass";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberNames";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "clarifyFields";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallDefinitionType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "fieldToCallableParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariants";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMemberNames";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "clarifyFields";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCallDefinitionType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fieldToCallableParameter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 9, 10, 12, 13, 16, 19, 20, 23 -> new IllegalStateException(string);
        };
    }

    public static class FieldTypeAndDefaultValue {
        @Nullable
        private final PyType myType;
        @Nullable
        private final PyExpression myDefaultValue;

        public FieldTypeAndDefaultValue(@Nullable PyType type2, @Nullable PyExpression defaultValue) {
            this.myType = type2;
            this.myDefaultValue = defaultValue;
        }

        @Nullable
        public PyType getType() {
            return this.myType;
        }

        @Nullable
        public PyExpression getDefaultValue() {
            return this.myDefaultValue;
        }
    }
}

