/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.changeSignature;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.PyPsiIndexUtil;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.inspections.quickfix.PyChangeSignatureQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.changeSignature.PyChangeInfo;
import com.jetbrains.python.refactoring.changeSignature.PyParameterInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyChangeSignatureUsageProcessor
implements ChangeSignatureUsageProcessor {
    public UsageInfo[] findUsages(ChangeInfo info) {
        if (info instanceof PyChangeInfo) {
            PyFunction targetFunction = ((PyChangeInfo)info).getMethod();
            List<UsageInfo> usages = PyPsiIndexUtil.findUsages((PsiNamedElement)targetFunction, true);
            if (!PyUtil.isInitOrNewMethod(targetFunction)) {
                Query<PyFunction> search = PyOverridingMethodsSearch.search(targetFunction, true);
                for (PyFunction override : search.findAll()) {
                    usages.add(new UsageInfo((PsiElement)override));
                    usages.addAll(PyPsiIndexUtil.findUsages((PsiNamedElement)override, true));
                }
            }
            return usages.toArray(UsageInfo.EMPTY_ARRAY);
        }
        return UsageInfo.EMPTY_ARRAY;
    }

    @Nullable
    public MultiMap<PsiElement, String> findConflicts(ChangeInfo info, Ref<UsageInfo[]> refUsages) {
        PyFunction function;
        PyClass clazz;
        MultiMap conflicts = new MultiMap();
        if (info instanceof PyChangeInfo && info.isNameChanged() && (clazz = (function = ((PyChangeInfo)info).getMethod()).getContainingClass()) != null && clazz.findMethodByName(info.getNewName(), true, null) != null) {
            conflicts.putValue((Object)function, (Object)RefactoringBundle.message((String)"method.0.is.already.defined.in.the.1", (Object[])new Object[]{info.getNewName(), "class " + clazz.getQualifiedName()}));
        }
        return conflicts;
    }

    public boolean processUsage(ChangeInfo changeInfo, UsageInfo usageInfo, boolean beforeMethodChange, UsageInfo[] usages) {
        if (!PyChangeSignatureUsageProcessor.isPythonUsage(usageInfo)) {
            return false;
        }
        if (!(changeInfo instanceof PyChangeInfo)) {
            return false;
        }
        if (!beforeMethodChange) {
            return false;
        }
        PsiElement element = usageInfo.getElement();
        if (changeInfo.isNameChanged()) {
            PsiElement method = changeInfo.getMethod();
            RenameUtil.doRenameGenericNamedElement((PsiElement)method, (String)changeInfo.getNewName(), (UsageInfo[])usages, null);
        }
        if (element == null) {
            return false;
        }
        PsiElement psiElement = element.getParent();
        if (psiElement instanceof PyCallExpression) {
            PyCallExpression call = (PyCallExpression)psiElement;
            if (call.getUserData(PyChangeSignatureQuickFix.CHANGE_SIGNATURE_ORIGINAL_CALL) != null) {
                return true;
            }
            PyArgumentList argumentList = call.getArgumentList();
            if (argumentList != null) {
                PyElementGenerator elementGenerator = PyElementGenerator.getInstance(element.getProject());
                StringBuilder builder = PyChangeSignatureUsageProcessor.buildSignature((PyChangeInfo)changeInfo, call);
                PyExpression newCall = call instanceof PyDecorator ? elementGenerator.createDecoratorList("@" + builder).getDecorators()[0] : elementGenerator.createExpressionFromText(LanguageLevel.forElement(element), builder.toString());
                call.replace((PsiElement)newCall);
                return true;
            }
        } else if (element instanceof PyFunction && element != changeInfo.getMethod()) {
            PyChangeSignatureUsageProcessor.processFunctionDeclaration((PyChangeInfo)changeInfo, (PyFunction)element);
        }
        return false;
    }

    @NotNull
    private static StringBuilder buildSignature(@NotNull PyChangeInfo changeInfo, @NotNull PyCallExpression call) {
        if (changeInfo == null) {
            PyChangeSignatureUsageProcessor.$$$reportNull$$$0(0);
        }
        if (call == null) {
            PyChangeSignatureUsageProcessor.$$$reportNull$$$0(1);
        }
        PyArgumentList argumentList = call.getArgumentList();
        PyExpression callee = call.getCallee();
        String name2 = callee != null ? callee.getText() : changeInfo.getNewName();
        StringBuilder builder = new StringBuilder(name2 + "(");
        if (argumentList != null) {
            List<String> params = PyChangeSignatureUsageProcessor.collectParameters(changeInfo, call);
            builder.append(StringUtil.join(params, (String)","));
        }
        builder.append(")");
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            PyChangeSignatureUsageProcessor.$$$reportNull$$$0(2);
        }
        return stringBuilder;
    }

    @NotNull
    private static List<String> collectParameters(@NotNull PyChangeInfo changeInfo, @NotNull PyCallExpression call) {
        int implicitCount;
        if (changeInfo == null) {
            PyChangeSignatureUsageProcessor.$$$reportNull$$$0(3);
        }
        if (call == null) {
            PyChangeSignatureUsageProcessor.$$$reportNull$$$0(4);
        }
        boolean keywordArgsRequired = false;
        ArrayList<String> newArguments = new ArrayList<String>();
        TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(call.getProject(), null);
        PyFunction function = changeInfo.getMethod();
        List allOrigParams = function.getParameters(typeEvalContext);
        PyCallExpression.PyArgumentsMapping mapping = PyCallExpressionHelper.mapArguments((PyCallSiteExpression)call, function, typeEvalContext);
        MultiMap oldParamIndexToArgs = MultiMap.create();
        for (Map.Entry<PyExpression, PyCallableParameter> entry : mapping.getMappedParameters().entrySet()) {
            PyCallableParameter param = entry.getValue();
            oldParamIndexToArgs.putValue((Object)allOrigParams.indexOf(param), (Object)entry.getKey());
        }
        assert (oldParamIndexToArgs.keySet().stream().allMatch(index -> index >= 0));
        List<PyParameterInfo> newParamInfos = Arrays.asList(changeInfo.getNewParameters());
        int posVarargIndex = ContainerUtil.indexOf(newParamInfos, info -> PyChangeSignatureUsageProcessor.isPositionalVarargName(info.getName()));
        int posOnlyMarkerIndex = ContainerUtil.indexOf(newParamInfos, info -> "/".equals(info.getName()));
        boolean posVarargEmpty = posVarargIndex != -1 && oldParamIndexToArgs.get((Object)newParamInfos.get(posVarargIndex).getOldIndex()).isEmpty();
        ArrayList notInsertedVariadicKeywordArgs = new ArrayList(ContainerUtil.filter((Object[])call.getArguments(), a -> a instanceof PyStarArgument && ((PyStarArgument)a).isKeyword()));
        boolean variadicKeywordArgsUsed = false;
        for (int paramIndex = implicitCount = mapping.getImplicitParameters().size(); paramIndex < newParamInfos.size(); ++paramIndex) {
            boolean defaultShouldBeInlined;
            PyParameterInfo info2 = newParamInfos.get(paramIndex);
            String paramName = info2.getName();
            boolean isKeywordVararg = PyChangeSignatureUsageProcessor.isKeywordVarargName(paramName);
            boolean isPositionalVararg = PyChangeSignatureUsageProcessor.isPositionalVarargName(paramName);
            boolean beforePositionalOnlyMarker = paramIndex < posOnlyMarkerIndex;
            boolean bl = defaultShouldBeInlined = beforePositionalOnlyMarker && ContainerUtil.exists(newParamInfos.subList(paramIndex + 1, posOnlyMarkerIndex), i -> !i.isNew() && !oldParamIndexToArgs.get((Object)i.getOldIndex()).isEmpty());
            if (paramName.equals("*")) {
                keywordArgsRequired = true;
                continue;
            }
            if (paramName.equals("/")) continue;
            String paramDefault = StringUtil.notNullize((String)info2.getDefaultValue());
            int oldIndex = info2.getOldIndex();
            if (oldIndex < 0) {
                if (info2.getDefaultInSignature() && !defaultShouldBeInlined) {
                    keywordArgsRequired = true;
                } else if (!isKeywordVararg && !isPositionalVararg) {
                    newArguments.add(PyChangeSignatureUsageProcessor.formatArgument(paramName, paramDefault, keywordArgsRequired));
                }
            } else {
                Collection existingArgs = oldParamIndexToArgs.get((Object)oldIndex);
                PyCallableParameter oldParam = (PyCallableParameter)allOrigParams.get(oldIndex);
                boolean usesValueFromVariadic = mapping.getParametersMappedToVariadicKeywordArguments().contains(oldParam);
                variadicKeywordArgsUsed |= usesValueFromVariadic;
                if (!existingArgs.isEmpty()) {
                    for (PyExpression arg : existingArgs) {
                        String argName;
                        PyExpression argValue;
                        if (arg instanceof PyKeywordArgument) {
                            argValue = ((PyKeywordArgument)arg).getValueExpression();
                            argName = StringUtil.notNullize((String)((PyKeywordArgument)arg).getKeyword());
                        } else {
                            argValue = arg;
                            argName = "";
                        }
                        notInsertedVariadicKeywordArgs.remove(argValue);
                        if (!(argName.isEmpty() || paramIndex < posVarargIndex && !posVarargEmpty || beforePositionalOnlyMarker)) {
                            keywordArgsRequired = true;
                        }
                        assert (!isPositionalVararg || !keywordArgsRequired);
                        String argValueText = argValue != null ? argValue.getText() : "";
                        String newArgumentName = isKeywordVararg ? argName : paramName;
                        newArguments.add(PyChangeSignatureUsageProcessor.formatArgument(newArgumentName, argValueText, keywordArgsRequired));
                    }
                } else if (info2.getDefaultInSignature() && !defaultShouldBeInlined) {
                    keywordArgsRequired = true;
                } else if (!(isPositionalVararg || isKeywordVararg || usesValueFromVariadic)) {
                    newArguments.add(PyChangeSignatureUsageProcessor.formatArgument(paramName, paramDefault, keywordArgsRequired));
                }
            }
            if (!isPositionalVararg) continue;
            keywordArgsRequired = true;
        }
        if (variadicKeywordArgsUsed) {
            newArguments.addAll(ContainerUtil.map(notInsertedVariadicKeywordArgs, PsiElement::getText));
        }
        ArrayList<String> arrayList = newArguments;
        if (arrayList == null) {
            PyChangeSignatureUsageProcessor.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static boolean isPositionalVarargName(@NotNull String paramName) {
        if (paramName == null) {
            PyChangeSignatureUsageProcessor.$$$reportNull$$$0(6);
        }
        return !PyChangeSignatureUsageProcessor.isKeywordVarargName(paramName) && !paramName.equals("*") && paramName.startsWith("*");
    }

    private static boolean isKeywordVarargName(@NotNull String paramName) {
        if (paramName == null) {
            PyChangeSignatureUsageProcessor.$$$reportNull$$$0(7);
        }
        return paramName.startsWith("**");
    }

    @NotNull
    private static String formatArgument(@NotNull String name2, @NotNull String value, boolean keywordArgument) {
        if (name2 == null) {
            PyChangeSignatureUsageProcessor.$$$reportNull$$$0(8);
        }
        if (value == null) {
            PyChangeSignatureUsageProcessor.$$$reportNull$$$0(9);
        }
        if (keywordArgument && !value.startsWith("*")) {
            assert (!name2.startsWith("*"));
            String string = name2 + "=" + value;
            if (string == null) {
                PyChangeSignatureUsageProcessor.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = value;
        if (string == null) {
            PyChangeSignatureUsageProcessor.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static boolean isPythonUsage(UsageInfo info) {
        PsiElement element = info.getElement();
        if (element == null) {
            return false;
        }
        return element.getLanguage() == PythonLanguage.getInstance();
    }

    public boolean processPrimaryMethod(ChangeInfo changeInfo) {
        if (changeInfo instanceof PyChangeInfo) {
            PyChangeInfo pyChangeInfo = (PyChangeInfo)changeInfo;
            if (changeInfo.getLanguage().is((Language)PythonLanguage.getInstance())) {
                PyChangeSignatureUsageProcessor.processFunctionDeclaration(pyChangeInfo, pyChangeInfo.getMethod());
                return true;
            }
        }
        return false;
    }

    private static void processFunctionDeclaration(@NotNull PyChangeInfo changeInfo, @NotNull PyFunction function) {
        if (changeInfo == null) {
            PyChangeSignatureUsageProcessor.$$$reportNull$$$0(12);
        }
        if (function == null) {
            PyChangeSignatureUsageProcessor.$$$reportNull$$$0(13);
        }
        if (changeInfo.isParameterNamesChanged()) {
            PyParameter[] oldParameters = function.getParameterList().getParameters();
            Map paramRenames = ((StreamEx)StreamEx.of((Object[])changeInfo.getNewParameters()).filter(info -> info.getOldIndex() >= 0 && info.isRenamed())).toMap(info -> oldParameters[info.getOldIndex()], info -> StringUtil.trimLeading((String)info.getName(), (char)'*').trim());
            HashMap<PyFunction, String> allRenames = new HashMap<PyFunction, String>(paramRenames);
            if (changeInfo.isNameChanged()) {
                allRenames.put(function, changeInfo.getNewName());
            }
            for (Map.Entry entry : paramRenames.entrySet()) {
                UsageInfo[] usages;
                PyParameter oldParameter = (PyParameter)entry.getKey();
                String newName = (String)entry.getValue();
                for (UsageInfo info2 : usages = RenameUtil.findUsages((PsiElement)oldParameter, (String)newName, (boolean)true, (boolean)false, allRenames)) {
                    RenameUtil.rename((UsageInfo)info2, (String)newName);
                }
            }
        }
        if (changeInfo.isParameterSetOrOrderChanged()) {
            PyChangeSignatureUsageProcessor.fixDoc(changeInfo, function);
            PyChangeSignatureUsageProcessor.updateParameterList(changeInfo, function);
        }
        if (changeInfo.isNameChanged()) {
            RenameUtil.doRenameGenericNamedElement((PsiElement)function, (String)changeInfo.getNewName(), (UsageInfo[])UsageInfo.EMPTY_ARRAY, null);
        }
    }

    private static void fixDoc(PyChangeInfo changeInfo, @NotNull PyFunction function) {
        PyStringLiteralExpression docStringExpression;
        if (function == null) {
            PyChangeSignatureUsageProcessor.$$$reportNull$$$0(14);
        }
        if ((docStringExpression = function.getDocStringExpression()) == null) {
            return;
        }
        PyParameterInfo[] parameters = changeInfo.getNewParameters();
        HashSet<String> names2 = new HashSet<String>();
        for (PyParameterInfo info : parameters) {
            names2.add(StringUtil.trimLeading((String)info.getName(), (char)'*').trim());
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)function);
        if (module == null) {
            return;
        }
        PyDocstringGenerator generator = PyDocstringGenerator.forDocStringOwner(function);
        for (PyParameter p : function.getParameterList().getParameters()) {
            String paramName = p.getName();
            if (paramName == null || names2.contains(paramName)) continue;
            generator.withoutParam(paramName);
        }
        generator.buildAndInsert();
    }

    private static void updateParameterList(PyChangeInfo changeInfo, PyFunction baseMethod) {
        PyParameterList parameterList = baseMethod.getParameterList();
        PyParameterInfo[] parameters = changeInfo.getNewParameters();
        StringBuilder builder = new StringBuilder("def foo(");
        PyStringLiteralExpression docstring = baseMethod.getDocStringExpression();
        PyParameter[] oldParameters = baseMethod.getParameterList().getParameters();
        PyElementGenerator generator = PyElementGenerator.getInstance(baseMethod.getProject());
        PyDocstringGenerator docStringGenerator = PyDocstringGenerator.forDocStringOwner(baseMethod);
        boolean newParameterInDocString = false;
        for (int i = 0; i < parameters.length; ++i) {
            String defaultValue;
            PyAnnotation annotation;
            PyParameter parameter;
            PyParameterInfo info = parameters[i];
            int oldIndex = info.getOldIndex();
            if (i != 0 && oldIndex < oldParameters.length) {
                builder.append(", ");
            }
            if (docstring != null && oldIndex < 0) {
                newParameterInDocString = true;
                docStringGenerator.withParam(info.getName());
            }
            if (oldIndex < oldParameters.length) {
                builder.append(info.getName());
            }
            if (oldIndex >= 0 && oldIndex < oldParameters.length && (parameter = oldParameters[oldIndex]) instanceof PyNamedParameter && (annotation = ((PyNamedParameter)parameter).getAnnotation()) != null) {
                builder.append(annotation.getText());
            }
            if ((defaultValue = info.getDefaultValue()) == null || !info.getDefaultInSignature() || !StringUtil.isNotEmpty((String)defaultValue)) continue;
            builder.append(" = ").append(defaultValue);
        }
        builder.append("): pass");
        if (newParameterInDocString) {
            docStringGenerator.buildAndInsert();
        }
        PyParameterList newParameterList = generator.createFromText(LanguageLevel.forElement(baseMethod), PyFunction.class, builder.toString()).getParameterList();
        parameterList.replace((PsiElement)newParameterList);
    }

    public boolean shouldPreviewUsages(ChangeInfo changeInfo, UsageInfo[] usages) {
        return false;
    }

    public boolean setupDefaultValues(ChangeInfo changeInfo, Ref<UsageInfo[]> refUsages, Project project) {
        return true;
    }

    public void registerConflictResolvers(List<? super ResolveSnapshotProvider.ResolveSnapshot> snapshots, @NotNull ResolveSnapshotProvider resolveSnapshotProvider, UsageInfo[] usages, ChangeInfo changeInfo) {
        if (resolveSnapshotProvider == null) {
            PyChangeSignatureUsageProcessor.$$$reportNull$$$0(15);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeInfo";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureUsageProcessor";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveSnapshotProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureUsageProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSignature";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParameters";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "formatArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildSignature";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectParameters";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPositionalVarargName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isKeywordVarargName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatArgument";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processFunctionDeclaration";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fixDoc";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerConflictResolvers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 10, 11 -> new IllegalStateException(string);
        };
    }
}

