/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.sdk.flavors.UnixPythonSdkFlavor;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MacPythonSdkFlavor
extends CPythonSdkFlavor<PyFlavorData.Empty> {
    private static final Logger LOGGER = Logger.getInstance(MacPythonSdkFlavor.class);

    private MacPythonSdkFlavor() {
    }

    @Override
    public boolean isApplicable() {
        return SystemInfo.isMac;
    }

    @Override
    @NotNull
    public Class<PyFlavorData.Empty> getFlavorDataClass() {
        return PyFlavorData.Empty.class;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Path> suggestLocalHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        HashSet<String> candidates = new HashSet<String>();
        MacPythonSdkFlavor.collectPythonInstallations("/Library/Frameworks/Python.framework/Versions", candidates);
        MacPythonSdkFlavor.collectPythonInstallations("/System/Library/Frameworks/Python.framework/Versions", candidates);
        MacPythonSdkFlavor.collectPythonInstallations("/usr/local/Cellar/python", candidates);
        UnixPythonSdkFlavor.collectUnixPythons("/usr/local/bin", candidates);
        if (MacPythonSdkFlavor.areCommandLineDeveloperToolsAvailable()) {
            UnixPythonSdkFlavor.collectUnixPythons("/usr/bin", candidates);
        }
        List list = ContainerUtil.map(candidates, x$0 -> Path.of(x$0, new String[0]));
        if (list == null) {
            MacPythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static void collectPythonInstallations(String pythonPath, Set<String> candidates) {
        VirtualFile rootVDir = LocalFileSystem.getInstance().findFileByPath(pythonPath);
        if (rootVDir != null) {
            if (rootVDir instanceof NewVirtualFile) {
                ((NewVirtualFile)rootVDir).markDirty();
            }
            rootVDir.refresh(true, false);
            for (VirtualFile dir : rootVDir.getChildren()) {
                VirtualFile child;
                VirtualFile binDir;
                if (!dir.isDirectory() || (binDir = dir.findChild("bin")) == null || !binDir.isDirectory() || (child = binDir.findChild("python3")) == null || child.isDirectory()) continue;
                candidates.add(child.getPath());
            }
        }
    }

    @NotNull
    public static GeneralCommandLine getXCodeSelectInstallCommand() {
        return new GeneralCommandLine(new String[]{"xcode-select", "--install"});
    }

    @NotNull
    private static GeneralCommandLine getXCodeSelectPathCommand() {
        return new GeneralCommandLine(new String[]{"xcode-select", "-p"});
    }

    public static boolean areCommandLineDeveloperToolsAvailable() {
        GeneralCommandLine commandLine = MacPythonSdkFlavor.getXCodeSelectPathCommand();
        try {
            ProcessOutput output2 = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Result of '" + commandLine.getCommandLineString() + "':\n" + output2);
            }
            return output2.getExitCode() == 0;
        }
        catch (ExecutionException e) {
            LOGGER.warn("Exception during '" + commandLine.getCommandLineString() + "'", (Throwable)e);
            return true;
        }
    }

    @Nullable
    public static ValidationInfo checkDetectedPython(@NotNull PyDetectedSdk sdk2) {
        if (sdk2 == null) {
            MacPythonSdkFlavor.$$$reportNull$$$0(1);
        }
        if (!"/usr/bin/python3".equals(sdk2.getHomePath())) {
            return null;
        }
        String progressTitle = PyBundle.message("python.cldt.checking", new Object[0]);
        if (((Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(MacPythonSdkFlavor::areCommandLineDeveloperToolsAvailable, progressTitle, true, null)).booleanValue()) {
            return null;
        }
        HtmlChunk commandChunk = HtmlChunk.text((String)MacPythonSdkFlavor.getXCodeSelectInstallCommand().getCommandLineString());
        String message = new HtmlBuilder().append(HtmlChunk.raw((String)PyBundle.message("python.cldt.required", commandChunk.code()))).toString();
        return new ValidationInfo(message).asWarning().withOKEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/MacPythonSdkFlavor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestLocalHomePaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/MacPythonSdkFlavor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkDetectedPython";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

