/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.extensions.python.PyClassExtKt;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.testing.PythonUnitTestDetectorsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005\u001a\u0016\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0011"}, d2={"isTestClass", "", "clazz", "Lcom/jetbrains/python/psi/PyClass;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "isTestElement", "element", "Lcom/intellij/psi/PsiElement;", "typeEvalContext", "isTestFile", "file", "Lcom/jetbrains/python/psi/PyFile;", "isTestFunction", "function", "Lcom/jetbrains/python/psi/PyFunction;", "isUnitTestCaseClass", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPythonUnitTestDetectors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonUnitTestDetectors.kt\ncom/jetbrains/python/testing/PythonUnitTestDetectorsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,80:1\n12744#2,2:81\n*S KotlinDebug\n*F\n+ 1 PythonUnitTestDetectors.kt\ncom/jetbrains/python/testing/PythonUnitTestDetectorsKt\n*L\n71#1:81,2\n*E\n"})
public final class PythonUnitTestDetectorsKt {
    public static final boolean isTestFunction(@NotNull PyFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        String string = function.getName();
        return string != null ? StringsKt.startsWith$default((String)string, (String)"test", (boolean)false, (int)2, null) : false;
    }

    public static final boolean isUnitTestCaseClass(@NotNull PyClass clazz, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String[] stringArray = new String[]{"unittest.TestCase", "unittest.case.TestCase"};
        return PyClassExtKt.inherits(clazz, context, stringArray);
    }

    public static final boolean isTestClass(@NotNull PyClass clazz, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (PythonUnitTestDetectorsKt.isUnitTestCaseClass(clazz, context)) {
            return true;
        }
        String string = clazz.getName();
        if (string == null) {
            return false;
        }
        String className = string;
        if (!StringsKt.startsWith$default((String)className, (String)"Test", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)className, (String)"Test", (boolean)false, (int)2, null)) {
            return false;
        }
        var $this$isTestClass_u24lambda_u240 = new Processor<PyFunction>(){
            private boolean hasTestFunction;

            public final boolean getHasTestFunction() {
                return this.hasTestFunction;
            }

            public boolean process(@NotNull PyFunction function) {
                block4: {
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        if (PythonUnitTestDetectorsKt.isTestFunction(function)) break block3;
                        String string = function.getName();
                        boolean bl = string != null ? string.equals("setUp") : false;
                        if (!bl) break block4;
                    }
                    this.hasTestFunction = true;
                    return false;
                }
                return true;
            }
        };
        boolean bl = false;
        clazz.visitMethods((Processor<? super PyFunction>)((Processor)$this$isTestClass_u24lambda_u240), true, context);
        return $this$isTestClass_u24lambda_u240.getHasTestFunction();
    }

    public static final boolean isTestFile(@NotNull PyFile file, @NotNull TypeEvalContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (file.getTopLevelClasses().stream().anyMatch(arg_0 -> PythonUnitTestDetectorsKt.isTestFile$lambda$1((Function1)new Function1<PyClass, Boolean>(context){
            final /* synthetic */ TypeEvalContext $context;
            {
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PyClass o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                return PythonUnitTestDetectorsKt.isTestClass(o, this.$context);
            }
        }, arg_0))) {
            bl = true;
        } else {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            bl = StringsKt.startsWith$default((String)string, (String)"test_", (boolean)false, (int)2, null) || file.getTopLevelFunctions().stream().anyMatch(arg_0 -> PythonUnitTestDetectorsKt.isTestFile$lambda$2(isTestFile.2.INSTANCE, arg_0));
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isTestElement(@NotNull PsiElement element, @NotNull TypeEvalContext typeEvalContext) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)typeEvalContext, (String)"typeEvalContext");
        PsiElement psiElement = element;
        if (psiElement instanceof PyFile) {
            bl = PythonUnitTestDetectorsKt.isTestFile((PyFile)element, typeEvalContext);
            return bl;
        } else {
            if (psiElement instanceof PsiDirectory) {
                String string = ((PsiDirectory)element).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.name");
                if (StringsKt.contains((CharSequence)string, (CharSequence)"test", (boolean)true)) return true;
                PsiElement[] psiElementArray = ((PsiDirectory)element).getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"element.children");
                Object[] $this$any$iv = psiElementArray;
                boolean $i$f$any = false;
                int n = 0;
                int n2 = $this$any$iv.length;
                while (n < n2) {
                    Object element$iv = $this$any$iv[n];
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (it instanceof PyFile && PythonUnitTestDetectorsKt.isTestFile((PyFile)it, typeEvalContext)) {
                        return true;
                    }
                    boolean bl3 = false;
                    if (bl3) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            if (psiElement instanceof PyFunction) {
                bl = PythonUnitTestDetectorsKt.isTestFunction((PyFunction)element);
                return bl;
            } else {
                if (!(psiElement instanceof PyClass)) return false;
                bl = PythonUnitTestDetectorsKt.isTestClass((PyClass)element, typeEvalContext);
            }
        }
        return bl;
    }

    private static final boolean isTestFile$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean isTestFile$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

