/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.protocol;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.ShortStack;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TTransport;

public class TCompactProtocol
extends TProtocol {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(EMPTY_BYTES);
    private static final long NO_LENGTH_LIMIT = -1L;
    private static final TStruct ANONYMOUS_STRUCT = new TStruct("");
    private static final TField TSTOP = new TField("", 0, 0);
    private static final byte[] ttypeToCompactType = new byte[16];
    private static final byte PROTOCOL_ID = -126;
    private static final byte VERSION = 1;
    private static final byte VERSION_MASK = 31;
    private static final byte TYPE_MASK = -32;
    private static final byte TYPE_BITS = 7;
    private static final int TYPE_SHIFT_AMOUNT = 5;
    private ShortStack lastField_ = new ShortStack(15);
    private short lastFieldId_ = 0;
    private TField booleanField_ = null;
    private Boolean boolValue_ = null;
    private final long stringLengthLimit_;
    private final long containerLengthLimit_;
    private final byte[] temp = new byte[10];

    public TCompactProtocol(TTransport transport, long stringLengthLimit, long containerLengthLimit) {
        super(transport);
        this.stringLengthLimit_ = stringLengthLimit;
        this.containerLengthLimit_ = containerLengthLimit;
    }

    @Deprecated
    public TCompactProtocol(TTransport transport, long stringLengthLimit) {
        this(transport, stringLengthLimit, -1L);
    }

    public TCompactProtocol(TTransport transport) {
        this(transport, -1L, -1L);
    }

    @Override
    public void reset() {
        this.lastField_.clear();
        this.lastFieldId_ = 0;
    }

    @Override
    public void writeMessageBegin(TMessage message) throws TException {
        this.writeByteDirect((byte)-126);
        this.writeByteDirect(1 | message.type << 5 & 0xFFFFFFE0);
        this.writeVarint32(message.seqid);
        this.writeString(message.name);
    }

    @Override
    public void writeStructBegin(TStruct struct) throws TException {
        this.lastField_.push(this.lastFieldId_);
        this.lastFieldId_ = 0;
    }

    @Override
    public void writeStructEnd() throws TException {
        this.lastFieldId_ = this.lastField_.pop();
    }

    @Override
    public void writeFieldBegin(TField field) throws TException {
        if (field.type == 2) {
            this.booleanField_ = field;
        } else {
            this.writeFieldBeginInternal(field, (byte)-1);
        }
    }

    private void writeFieldBeginInternal(TField field, byte typeOverride) throws TException {
        byte typeToWrite;
        byte by = typeToWrite = typeOverride == -1 ? this.getCompactType(field.type) : typeOverride;
        if (field.id > this.lastFieldId_ && field.id - this.lastFieldId_ <= 15) {
            this.writeByteDirect(field.id - this.lastFieldId_ << 4 | typeToWrite);
        } else {
            this.writeByteDirect(typeToWrite);
            this.writeI16(field.id);
        }
        this.lastFieldId_ = field.id;
    }

    @Override
    public void writeFieldStop() throws TException {
        this.writeByteDirect((byte)0);
    }

    @Override
    public void writeMapBegin(TMap map) throws TException {
        if (map.size == 0) {
            this.writeByteDirect(0);
        } else {
            this.writeVarint32(map.size);
            this.writeByteDirect(this.getCompactType(map.keyType) << 4 | this.getCompactType(map.valueType));
        }
    }

    @Override
    public void writeListBegin(TList list) throws TException {
        this.writeCollectionBegin(list.elemType, list.size);
    }

    @Override
    public void writeSetBegin(TSet set) throws TException {
        this.writeCollectionBegin(set.elemType, set.size);
    }

    @Override
    public void writeBool(boolean b) throws TException {
        if (this.booleanField_ != null) {
            this.writeFieldBeginInternal(this.booleanField_, b ? (byte)1 : 2);
            this.booleanField_ = null;
        } else {
            this.writeByteDirect(b ? (byte)1 : 2);
        }
    }

    @Override
    public void writeByte(byte b) throws TException {
        this.writeByteDirect(b);
    }

    @Override
    public void writeI16(short i16) throws TException {
        this.writeVarint32(this.intToZigZag(i16));
    }

    @Override
    public void writeI32(int i32) throws TException {
        this.writeVarint32(this.intToZigZag(i32));
    }

    @Override
    public void writeI64(long i64) throws TException {
        this.writeVarint64(this.longToZigzag(i64));
    }

    @Override
    public void writeDouble(double dub) throws TException {
        this.fixedLongToBytes(Double.doubleToLongBits(dub), this.temp, 0);
        this.trans_.write(this.temp, 0, 8);
    }

    @Override
    public void writeString(String str) throws TException {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        this.writeBinary(bytes, 0, bytes.length);
    }

    @Override
    public void writeBinary(ByteBuffer bin) throws TException {
        int length = bin.limit() - bin.position();
        this.writeBinary(bin.array(), bin.position() + bin.arrayOffset(), length);
    }

    private void writeBinary(byte[] buf, int offset, int length) throws TException {
        this.writeVarint32(length);
        this.trans_.write(buf, offset, length);
    }

    @Override
    public void writeMessageEnd() throws TException {
    }

    @Override
    public void writeMapEnd() throws TException {
    }

    @Override
    public void writeListEnd() throws TException {
    }

    @Override
    public void writeSetEnd() throws TException {
    }

    @Override
    public void writeFieldEnd() throws TException {
    }

    protected void writeCollectionBegin(byte elemType, int size) throws TException {
        if (size <= 14) {
            this.writeByteDirect(size << 4 | this.getCompactType(elemType));
        } else {
            this.writeByteDirect(0xF0 | this.getCompactType(elemType));
            this.writeVarint32(size);
        }
    }

    private void writeVarint32(int n) throws TException {
        int idx = 0;
        while (true) {
            if ((n & 0xFFFFFF80) == 0) break;
            this.temp[idx++] = (byte)(n & 0x7F | 0x80);
            n >>>= 7;
        }
        this.temp[idx++] = (byte)n;
        this.trans_.write(this.temp, 0, idx);
    }

    private void writeVarint64(long n) throws TException {
        int idx = 0;
        while (true) {
            if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.temp[idx++] = (byte)(n & 0x7FL | 0x80L);
            n >>>= 7;
        }
        this.temp[idx++] = (byte)n;
        this.trans_.write(this.temp, 0, idx);
    }

    private long longToZigzag(long l) {
        return l << 1 ^ l >> 63;
    }

    private int intToZigZag(int n) {
        return n << 1 ^ n >> 31;
    }

    private void fixedLongToBytes(long n, byte[] buf, int off) {
        buf[off + 0] = (byte)(n & 0xFFL);
        buf[off + 1] = (byte)(n >> 8 & 0xFFL);
        buf[off + 2] = (byte)(n >> 16 & 0xFFL);
        buf[off + 3] = (byte)(n >> 24 & 0xFFL);
        buf[off + 4] = (byte)(n >> 32 & 0xFFL);
        buf[off + 5] = (byte)(n >> 40 & 0xFFL);
        buf[off + 6] = (byte)(n >> 48 & 0xFFL);
        buf[off + 7] = (byte)(n >> 56 & 0xFFL);
    }

    private void writeByteDirect(byte b) throws TException {
        this.temp[0] = b;
        this.trans_.write(this.temp, 0, 1);
    }

    private void writeByteDirect(int n) throws TException {
        this.writeByteDirect((byte)n);
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        byte protocolId = this.readByte();
        if (protocolId != -126) {
            throw new TProtocolException("Expected protocol id " + Integer.toHexString(-126) + " but got " + Integer.toHexString(protocolId));
        }
        byte versionAndType = this.readByte();
        byte version2 = (byte)(versionAndType & 0x1F);
        if (version2 != 1) {
            throw new TProtocolException("Expected version 1 but got " + version2);
        }
        byte type2 = (byte)(versionAndType >> 5 & 7);
        int seqid = this.readVarint32();
        String messageName = this.readString();
        return new TMessage(messageName, type2, seqid);
    }

    @Override
    public TStruct readStructBegin() throws TException {
        this.lastField_.push(this.lastFieldId_);
        this.lastFieldId_ = 0;
        return ANONYMOUS_STRUCT;
    }

    @Override
    public void readStructEnd() throws TException {
        this.lastFieldId_ = this.lastField_.pop();
    }

    @Override
    public TField readFieldBegin() throws TException {
        byte type2 = this.readByte();
        if (type2 == 0) {
            return TSTOP;
        }
        short modifier = (short)((type2 & 0xF0) >> 4);
        short fieldId = modifier == 0 ? this.readI16() : (short)(this.lastFieldId_ + modifier);
        TField field = new TField("", this.getTType((byte)(type2 & 0xF)), fieldId);
        if (this.isBoolType(type2)) {
            this.boolValue_ = (byte)(type2 & 0xF) == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        this.lastFieldId_ = field.id;
        return field;
    }

    @Override
    public TMap readMapBegin() throws TException {
        int size = this.readVarint32();
        this.checkContainerReadLength(size);
        byte keyAndValueType = size == 0 ? (byte)0 : this.readByte();
        return new TMap(this.getTType((byte)(keyAndValueType >> 4)), this.getTType((byte)(keyAndValueType & 0xF)), size);
    }

    @Override
    public TList readListBegin() throws TException {
        byte size_and_type = this.readByte();
        int size = size_and_type >> 4 & 0xF;
        if (size == 15) {
            size = this.readVarint32();
        }
        this.checkContainerReadLength(size);
        byte type2 = this.getTType(size_and_type);
        return new TList(type2, size);
    }

    @Override
    public TSet readSetBegin() throws TException {
        return new TSet(this.readListBegin());
    }

    @Override
    public boolean readBool() throws TException {
        if (this.boolValue_ != null) {
            boolean result2 = this.boolValue_;
            this.boolValue_ = null;
            return result2;
        }
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() throws TException {
        byte b;
        if (this.trans_.getBytesRemainingInBuffer() > 0) {
            b = this.trans_.getBuffer()[this.trans_.getBufferPosition()];
            this.trans_.consumeBuffer(1);
        } else {
            this.trans_.readAll(this.temp, 0, 1);
            b = this.temp[0];
        }
        return b;
    }

    @Override
    public short readI16() throws TException {
        return (short)this.zigzagToInt(this.readVarint32());
    }

    @Override
    public int readI32() throws TException {
        return this.zigzagToInt(this.readVarint32());
    }

    @Override
    public long readI64() throws TException {
        return this.zigzagToLong(this.readVarint64());
    }

    @Override
    public double readDouble() throws TException {
        this.trans_.readAll(this.temp, 0, 8);
        return Double.longBitsToDouble(this.bytesToLong(this.temp));
    }

    @Override
    public String readString() throws TException {
        String str;
        int length = this.readVarint32();
        this.checkStringReadLength(length);
        if (length == 0) {
            return "";
        }
        if (this.trans_.getBytesRemainingInBuffer() >= length) {
            str = new String(this.trans_.getBuffer(), this.trans_.getBufferPosition(), length, StandardCharsets.UTF_8);
            this.trans_.consumeBuffer(length);
        } else {
            str = new String(this.readBinary(length), StandardCharsets.UTF_8);
        }
        return str;
    }

    @Override
    public ByteBuffer readBinary() throws TException {
        int length = this.readVarint32();
        this.checkStringReadLength(length);
        if (length == 0) {
            return EMPTY_BUFFER;
        }
        if (this.trans_.getBytesRemainingInBuffer() >= length) {
            ByteBuffer bb = ByteBuffer.wrap(this.trans_.getBuffer(), this.trans_.getBufferPosition(), length);
            this.trans_.consumeBuffer(length);
            return bb;
        }
        byte[] buf = new byte[length];
        this.trans_.readAll(buf, 0, length);
        return ByteBuffer.wrap(buf);
    }

    private byte[] readBinary(int length) throws TException {
        if (length == 0) {
            return EMPTY_BYTES;
        }
        byte[] buf = new byte[length];
        this.trans_.readAll(buf, 0, length);
        return buf;
    }

    private void checkStringReadLength(int length) throws TProtocolException {
        if (length < 0) {
            throw new TProtocolException(2, "Negative length: " + length);
        }
        if (this.stringLengthLimit_ != -1L && (long)length > this.stringLengthLimit_) {
            throw new TProtocolException(3, "Length exceeded max allowed: " + length);
        }
    }

    private void checkContainerReadLength(int length) throws TProtocolException {
        if (length < 0) {
            throw new TProtocolException(2, "Negative length: " + length);
        }
        if (this.containerLengthLimit_ != -1L && (long)length > this.containerLengthLimit_) {
            throw new TProtocolException(3, "Length exceeded max allowed: " + length);
        }
    }

    @Override
    public void readMessageEnd() throws TException {
    }

    @Override
    public void readFieldEnd() throws TException {
    }

    @Override
    public void readMapEnd() throws TException {
    }

    @Override
    public void readListEnd() throws TException {
    }

    @Override
    public void readSetEnd() throws TException {
    }

    private int readVarint32() throws TException {
        int result2 = 0;
        int shift = 0;
        if (this.trans_.getBytesRemainingInBuffer() >= 5) {
            byte[] buf = this.trans_.getBuffer();
            int pos = this.trans_.getBufferPosition();
            int off = 0;
            while (true) {
                byte b = buf[pos + off];
                result2 |= (b & 0x7F) << shift;
                if ((b & 0x80) != 128) break;
                shift += 7;
                ++off;
            }
            this.trans_.consumeBuffer(off + 1);
        } else {
            while (true) {
                byte b = this.readByte();
                result2 |= (b & 0x7F) << shift;
                if ((b & 0x80) != 128) break;
                shift += 7;
            }
        }
        return result2;
    }

    private long readVarint64() throws TException {
        int shift = 0;
        long result2 = 0L;
        if (this.trans_.getBytesRemainingInBuffer() >= 10) {
            byte[] buf = this.trans_.getBuffer();
            int pos = this.trans_.getBufferPosition();
            int off = 0;
            while (true) {
                byte b = buf[pos + off];
                result2 |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 128) break;
                shift += 7;
                ++off;
            }
            this.trans_.consumeBuffer(off + 1);
        } else {
            while (true) {
                byte b = this.readByte();
                result2 |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 128) break;
                shift += 7;
            }
        }
        return result2;
    }

    private int zigzagToInt(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    private long zigzagToLong(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    private long bytesToLong(byte[] bytes) {
        return ((long)bytes[7] & 0xFFL) << 56 | ((long)bytes[6] & 0xFFL) << 48 | ((long)bytes[5] & 0xFFL) << 40 | ((long)bytes[4] & 0xFFL) << 32 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[1] & 0xFFL) << 8 | (long)bytes[0] & 0xFFL;
    }

    private boolean isBoolType(byte b) {
        int lowerNibble = b & 0xF;
        return lowerNibble == 1 || lowerNibble == 2;
    }

    private byte getTType(byte type2) throws TProtocolException {
        switch ((byte)(type2 & 0xF)) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 10;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 11;
            }
            case 9: {
                return 15;
            }
            case 10: {
                return 14;
            }
            case 11: {
                return 13;
            }
            case 12: {
                return 12;
            }
        }
        throw new TProtocolException("don't know what type: " + (byte)(type2 & 0xF));
    }

    private byte getCompactType(byte ttype) {
        return ttypeToCompactType[ttype];
    }

    static {
        TCompactProtocol.ttypeToCompactType[0] = 0;
        TCompactProtocol.ttypeToCompactType[2] = 1;
        TCompactProtocol.ttypeToCompactType[3] = 3;
        TCompactProtocol.ttypeToCompactType[6] = 4;
        TCompactProtocol.ttypeToCompactType[8] = 5;
        TCompactProtocol.ttypeToCompactType[10] = 6;
        TCompactProtocol.ttypeToCompactType[4] = 7;
        TCompactProtocol.ttypeToCompactType[11] = 8;
        TCompactProtocol.ttypeToCompactType[15] = 9;
        TCompactProtocol.ttypeToCompactType[14] = 10;
        TCompactProtocol.ttypeToCompactType[13] = 11;
        TCompactProtocol.ttypeToCompactType[12] = 12;
    }

    private static class Types {
        public static final byte BOOLEAN_TRUE = 1;
        public static final byte BOOLEAN_FALSE = 2;
        public static final byte BYTE = 3;
        public static final byte I16 = 4;
        public static final byte I32 = 5;
        public static final byte I64 = 6;
        public static final byte DOUBLE = 7;
        public static final byte BINARY = 8;
        public static final byte LIST = 9;
        public static final byte SET = 10;
        public static final byte MAP = 11;
        public static final byte STRUCT = 12;

        private Types() {
        }
    }

    public static class Factory
    implements TProtocolFactory {
        private final long stringLengthLimit_;
        private final long containerLengthLimit_;

        public Factory() {
            this(-1L, -1L);
        }

        public Factory(long stringLengthLimit) {
            this(stringLengthLimit, -1L);
        }

        public Factory(long stringLengthLimit, long containerLengthLimit) {
            this.containerLengthLimit_ = containerLengthLimit;
            this.stringLengthLimit_ = stringLengthLimit;
        }

        @Override
        public TProtocol getProtocol(TTransport trans) {
            return new TCompactProtocol(trans, this.stringLengthLimit_, this.containerLengthLimit_);
        }
    }
}

