/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util.threading;

import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.threading.SingleThreadSchedulerBase;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rd/util/threading/SingleThreadScheduler;", "Lcom/jetbrains/rd/util/threading/SingleThreadSchedulerBase;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "name", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "log", "Lcom/jetbrains/rd/util/Logger;", "onException", "", "ex", "", "rd-core"})
@SourceDebugExtension(value={"SMAP\nSingleThreadScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleThreadScheduler.kt\ncom/jetbrains/rd/util/threading/SingleThreadScheduler\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n*L\n1#1,98:1\n94#2:99\n*S KotlinDebug\n*F\n+ 1 SingleThreadScheduler.kt\ncom/jetbrains/rd/util/threading/SingleThreadScheduler\n*L\n63#1:99\n*E\n"})
public final class SingleThreadScheduler
extends SingleThreadSchedulerBase {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Logger log;

    public SingleThreadScheduler(@NotNull Lifetime lifetime, final @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        super(name2);
        this.lifetime = lifetime;
        boolean $i$f$getLogger = false;
        this.log = LoggerKt.getLogger(Reflection.getOrCreateKotlinClass(SingleThreadScheduler.class));
        RLifetimeKt.plusAssign(this.lifetime, (Function0<Unit>)((Function0)new Function0<Unit>(){

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                try {
                    this.getExecutor().shutdownNow();
                    if (!this.getExecutor().awaitTermination(5L, TimeUnit.SECONDS)) {
                        void $this$log$iv$iv;
                        void $this$error$iv;
                        Logger logger = log;
                        String string2 = name2;
                        boolean $i$f$error = false;
                        void var4_5 = $this$error$iv;
                        LogLevel level$iv$iv = LogLevel.Error;
                        boolean $i$f$log = false;
                        if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                            LogLevel logLevel = level$iv$iv;
                            void var8_9 = $this$log$iv$iv;
                            boolean bl = false;
                            String string3 = "Failed to terminate " + string2 + ".";
                            var8_9.log(logLevel, string3, null);
                        }
                    }
                }
                catch (Throwable e) {
                    LoggerKt.error(log, e);
                }
            }
        }));
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @Override
    public void onException(@NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        LoggerKt.error(this.log, ex);
    }
}

