/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth.services;

import com.intellij.util.io.DigestUtil;
import java.security.MessageDigest;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/collaboration/auth/services/PkceUtils;", "", "()V", "generateCodeVerifier", "", "generateShaCodeChallenge", "codeVerifier", "encoder", "Ljava/util/Base64$Encoder;", "intellij.platform.collaborationTools.auth"})
public final class PkceUtils {
    @NotNull
    public static final PkceUtils INSTANCE = new PkceUtils();

    private PkceUtils() {
    }

    @NotNull
    public final String generateCodeVerifier() {
        return DigestUtil.randomToken();
    }

    @NotNull
    public final String generateShaCodeChallenge(@NotNull String codeVerifier, @NotNull Base64.Encoder encoder) {
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        MessageDigest messageDigest = DigestUtil.sha256();
        String string2 = codeVerifier;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] sha = messageDigest.digest(byArray);
        String string3 = encoder.encodeToString(sha);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encoder.encodeToString(sha)");
        return string3;
    }
}

