/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth.ui;

import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.ui.AccountsListModel;
import com.intellij.ui.CollectionListModel;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001b\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u001cH\u0016J\u0015\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001fR0\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u0004\u0018\u00018\u0000X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Lcom/intellij/collaboration/auth/ui/MutableAccountsListModel;", "A", "Lcom/intellij/collaboration/auth/Account;", "Cred", "Lcom/intellij/collaboration/auth/ui/AccountsListModel;", "()V", "value", "", "accounts", "getAccounts", "()Ljava/util/Set;", "setAccounts", "(Ljava/util/Set;)V", "accountsListModel", "Lcom/intellij/ui/CollectionListModel;", "getAccountsListModel", "()Lcom/intellij/ui/CollectionListModel;", "newCredentials", "", "getNewCredentials", "()Ljava/util/Map;", "selectedAccount", "getSelectedAccount", "()Lcom/intellij/collaboration/auth/Account;", "setSelectedAccount", "(Lcom/intellij/collaboration/auth/Account;)V", "Lcom/intellij/collaboration/auth/Account;", "add", "", "account", "cred", "(Lcom/intellij/collaboration/auth/Account;Ljava/lang/Object;)V", "clearNewCredentials", "notifyCredentialsChanged", "remove", "update", "intellij.platform.collaborationTools"})
public abstract class MutableAccountsListModel<A extends Account, Cred>
implements AccountsListModel<A, Cred> {
    @Nullable
    private A selectedAccount;
    @NotNull
    private final Map<A, Cred> newCredentials = new LinkedHashMap();
    @NotNull
    private final CollectionListModel<A> accountsListModel = new CollectionListModel((Object[])new Account[0]);

    @Override
    @NotNull
    public Set<A> getAccounts() {
        List list = this.getAccountsListModel().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"accountsListModel.items");
        return CollectionsKt.toSet((Iterable)list);
    }

    @Override
    public void setAccounts(@NotNull Set<? extends A> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.getAccountsListModel().removeAll();
        this.getAccountsListModel().add(CollectionsKt.toList((Iterable)value2));
    }

    @Override
    @Nullable
    public A getSelectedAccount() {
        return this.selectedAccount;
    }

    @Override
    public void setSelectedAccount(@Nullable A a) {
        this.selectedAccount = a;
    }

    @Override
    @NotNull
    public Map<A, Cred> getNewCredentials() {
        return this.newCredentials;
    }

    @Override
    @NotNull
    public CollectionListModel<A> getAccountsListModel() {
        return this.accountsListModel;
    }

    @Override
    public void clearNewCredentials() {
        this.getNewCredentials().clear();
    }

    public final void add(@NotNull A account, Cred cred) {
        Intrinsics.checkNotNullParameter(account, (String)"account");
        this.getAccountsListModel().add(account);
        this.getNewCredentials().put(account, cred);
        this.notifyCredentialsChanged(account);
    }

    public final void update(@NotNull A account, Cred cred) {
        Intrinsics.checkNotNullParameter(account, (String)"account");
        this.getNewCredentials().put(account, cred);
        this.notifyCredentialsChanged(account);
    }

    public final void remove(@NotNull A account) {
        Intrinsics.checkNotNullParameter(account, (String)"account");
        this.getAccountsListModel().remove(account);
        this.getNewCredentials().remove(account);
        this.notifyCredentialsChanged(account);
    }

    private final void notifyCredentialsChanged(A account) {
        this.getAccountsListModel().contentsChanged(account);
    }
}

