/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.RunnerType;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.StringListEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/coverage/CoverageLogger;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "Companion", "intellij.platform.coverage"})
public final class CoverageLogger
extends CounterUsagesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("coverage", 7, null, 4, null);
    @NotNull
    private static final List<String> runners;
    @NotNull
    private static final StringEventField RUNNER_NAME;
    @NotNull
    private static final StringListEventField RUNNERS;
    @NotNull
    private static final EventId3<RunnerType, Integer, Integer> START;
    @NotNull
    private static final EventId3<String, Long, Integer> REPORT_LOADING;
    @NotNull
    private static final EventId2<Long, Long> HTML;
    @NotNull
    private static final EventId3<Long, Integer, Integer> REPORT_BUILDING;
    @NotNull
    private static final BooleanEventField SHOW_ONLY_MODIFIED;
    @NotNull
    private static final BooleanEventField CAN_SHOW_ONLY_MODIFIED;
    @NotNull
    private static final BooleanEventField HIDE_FULLY_COVERED;
    @NotNull
    private static final BooleanEventField CAN_HIDE_FULLY_COVERED;
    @NotNull
    private static final VarargEventId FILTER_OPTIONS;
    @NotNull
    private static final EventId1<List<String>> IMPORT;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @JvmStatic
    public static final void logStarted(@NotNull CoverageRunner coverageRunner, boolean branchCoverage, boolean isTrackPerTestEnabled, int includePatterns, int excludePatterns) {
        Companion.logStarted(coverageRunner, branchCoverage, isTrackPerTestEnabled, includePatterns, excludePatterns);
    }

    @JvmStatic
    public static final void logReportLoading(@Nullable Project project2, @NotNull CoverageRunner coverageRunner, long timeMs, int loadedClasses) {
        Companion.logReportLoading(project2, coverageRunner, timeMs, loadedClasses);
    }

    @JvmStatic
    public static final void logHTMLReport(@Nullable Project project2, long timeMs, long generationTimeMs) {
        Companion.logHTMLReport(project2, timeMs, generationTimeMs);
    }

    @JvmStatic
    public static final void logReportBuilding(@Nullable Project project2, long timeMs, int annotatedClasses, int loadedClasses) {
        Companion.logReportBuilding(project2, timeMs, annotatedClasses, loadedClasses);
    }

    @JvmStatic
    public static final void logViewOpen(@Nullable Project project2, boolean vcsFilter, boolean canVcsFilter, boolean fullyCoveredFilter, boolean canFullyCoveredFilter) {
        Companion.logViewOpen(project2, vcsFilter, canVcsFilter, fullyCoveredFilter, canFullyCoveredFilter);
    }

    @JvmStatic
    public static final void logSuiteImport(@Nullable Project project2, @Nullable CoverageSuitesBundle suitesBundle) {
        Companion.logSuiteImport(project2, suitesBundle);
    }

    static {
        Object[] objectArray = new String[]{"idea", "jacoco", "Emma", "PhpCoverage", "utPlSqlCoverageRunner", "JestJavaScriptTestRunnerCoverage", "rcov", "DartCoverageRunner", "WipCoverageRunner", "VitestJavaScriptTestRunnerCoverage", "jacoco_xml_report", "MochaJavaScriptTestRunnerCoverage", "GoCoverage", "KarmaJavaScriptTestRunnerCoverage", "coverage.py"};
        runners = CollectionsKt.listOf((Object[])objectArray);
        RUNNER_NAME = EventFields.String((String)"runner", runners);
        RUNNERS = EventFields.StringList((String)"runners", runners);
        START = GROUP.registerEvent("started", (EventField)EventFields.Enum$default((String)"runner", RunnerType.class, null, (int)4, null), (EventField)EventFields.Int((String)"includes"), (EventField)EventFields.Int((String)"excludes"));
        REPORT_LOADING = GROUP.registerEvent("report.loaded", (EventField)RUNNER_NAME, (EventField)EventFields.DurationMs, (EventField)EventFields.Int((String)"loaded_classes"));
        HTML = GROUP.registerEvent("html.generated", (EventField)EventFields.DurationMs, (EventField)EventFields.Long((String)"generation_ms"));
        REPORT_BUILDING = GROUP.registerEvent("report.built", (EventField)EventFields.DurationMs, (EventField)EventFields.Int((String)"annotated_classes"), (EventField)EventFields.Int((String)"loaded_classes"));
        SHOW_ONLY_MODIFIED = EventFields.Boolean((String)"show_only_modified");
        CAN_SHOW_ONLY_MODIFIED = EventFields.Boolean((String)"can_show_only_modified");
        HIDE_FULLY_COVERED = EventFields.Boolean((String)"hide_fully_covered");
        CAN_HIDE_FULLY_COVERED = EventFields.Boolean((String)"can_hide_fully_covered");
        objectArray = new EventField[]{SHOW_ONLY_MODIFIED, CAN_SHOW_ONLY_MODIFIED, HIDE_FULLY_COVERED, CAN_HIDE_FULLY_COVERED};
        FILTER_OPTIONS = GROUP.registerVarargEvent("view.opened", (EventField[])objectArray);
        IMPORT = GROUP.registerEvent("report.imported", (EventField)RUNNERS);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\rH\u0007J*\u0010$\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0014H\u0007J*\u0010'\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010(\u001a\u00020)2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0014H\u0007J0\u0010*\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u0014H\u0007J\u001c\u00100\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u00101\u001a\u0004\u0018\u000102H\u0007J2\u00103\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u00104\u001a\u00020,2\u0006\u00105\u001a\u00020,2\u0006\u00106\u001a\u00020,2\u0006\u00107\u001a\u00020,H\u0007J\u0010\u00108\u001a\u00020\u00142\u0006\u00109\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/coverage/CoverageLogger$Companion;", "", "()V", "CAN_HIDE_FULLY_COVERED", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "CAN_SHOW_ONLY_MODIFIED", "FILTER_OPTIONS", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "HIDE_FULLY_COVERED", "HTML", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "IMPORT", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "", "REPORT_BUILDING", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "REPORT_LOADING", "RUNNERS", "Lcom/intellij/internal/statistic/eventLog/events/StringListEventField;", "RUNNER_NAME", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "SHOW_ONLY_MODIFIED", "START", "Lcom/intellij/coverage/RunnerType;", "runners", "logHTMLReport", "", "project", "Lcom/intellij/openapi/project/Project;", "timeMs", "generationTimeMs", "logReportBuilding", "annotatedClasses", "loadedClasses", "logReportLoading", "coverageRunner", "Lcom/intellij/coverage/CoverageRunner;", "logStarted", "branchCoverage", "", "isTrackPerTestEnabled", "includePatterns", "excludePatterns", "logSuiteImport", "suitesBundle", "Lcom/intellij/coverage/CoverageSuitesBundle;", "logViewOpen", "vcsFilter", "canVcsFilter", "fullyCoveredFilter", "canFullyCoveredFilter", "roundClasses", "classes", "intellij.platform.coverage"})
    @SourceDebugExtension(value={"SMAP\nCoverageLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageLogger.kt\ncom/intellij/coverage/CoverageLogger$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,90:1\n11335#2:91\n11670#2,3:92\n*S KotlinDebug\n*F\n+ 1 CoverageLogger.kt\ncom/intellij/coverage/CoverageLogger$Companion\n*L\n82#1:91\n82#1:92,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void logStarted(@NotNull CoverageRunner coverageRunner, boolean branchCoverage, boolean isTrackPerTestEnabled, int includePatterns, int excludePatterns) {
            RunnerType runnerType;
            Intrinsics.checkNotNullParameter((Object)coverageRunner, (String)"coverageRunner");
            switch (coverageRunner.getId()) {
                case "emma": {
                    runnerType = RunnerType.Emma;
                    break;
                }
                case "jacoco": {
                    runnerType = RunnerType.JaCoCo;
                    break;
                }
                case "idea": {
                    if (!branchCoverage) {
                        runnerType = RunnerType.IJCSampling;
                        break;
                    }
                    if (isTrackPerTestEnabled) {
                        runnerType = RunnerType.IJCTracingTestTracking;
                        break;
                    }
                    runnerType = RunnerType.IJCTracing;
                    break;
                }
                default: {
                    return;
                }
            }
            RunnerType type2 = runnerType;
            START.log((Object)type2, (Object)this.roundClasses(includePatterns), (Object)this.roundClasses(excludePatterns));
        }

        @JvmStatic
        public final void logReportLoading(@Nullable Project project2, @NotNull CoverageRunner coverageRunner, long timeMs, int loadedClasses) {
            Intrinsics.checkNotNullParameter((Object)coverageRunner, (String)"coverageRunner");
            REPORT_LOADING.log(project2, (Object)coverageRunner.getId(), (Object)timeMs, (Object)this.roundClasses(loadedClasses));
        }

        @JvmStatic
        public final void logHTMLReport(@Nullable Project project2, long timeMs, long generationTimeMs) {
            HTML.log(project2, (Object)timeMs, (Object)generationTimeMs);
        }

        @JvmStatic
        public final void logReportBuilding(@Nullable Project project2, long timeMs, int annotatedClasses, int loadedClasses) {
            REPORT_BUILDING.log(project2, (Object)timeMs, (Object)this.roundClasses(annotatedClasses), (Object)this.roundClasses(loadedClasses));
        }

        @JvmStatic
        public final void logViewOpen(@Nullable Project project2, boolean vcsFilter, boolean canVcsFilter, boolean fullyCoveredFilter, boolean canFullyCoveredFilter) {
            EventPair[] eventPairArray = new EventPair[]{SHOW_ONLY_MODIFIED.with((Object)vcsFilter), CAN_SHOW_ONLY_MODIFIED.with((Object)canVcsFilter), HIDE_FULLY_COVERED.with((Object)fullyCoveredFilter), CAN_HIDE_FULLY_COVERED.with((Object)canFullyCoveredFilter)};
            FILTER_OPTIONS.log(project2, eventPairArray);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void logSuiteImport(@Nullable Project project2, @Nullable CoverageSuitesBundle suitesBundle) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (suitesBundle == null) {
                return;
            }
            EventId1 eventId1 = IMPORT;
            CoverageSuite[] coverageSuiteArray = suitesBundle.getSuites();
            Intrinsics.checkNotNullExpressionValue((Object)coverageSuiteArray, (String)"suitesBundle.suites");
            Object[] objectArray = coverageSuiteArray;
            Project project3 = project2;
            EventId1 eventId12 = eventId1;
            boolean $i$f$map = false;
            void var5_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CoverageSuite coverageSuite = (CoverageSuite)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getRunner().getId());
            }
            collection = (List)destination$iv$iv;
            eventId12.log(project3, (Object)CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)collection)));
        }

        private final int roundClasses(int classes) {
            return StatisticsUtil.roundToPowerOfTwo((int)classes);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

