/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.AffectedPathSet;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListChangeAssigner;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListsIndexes;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.ui.ChangeListDeltaListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangeListWorker {
    private static final Logger LOG = Logger.getInstance(ChangeListWorker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final DelayedNotificator myDelayedNotificator;
    private final boolean myMainWorker;
    private boolean myChangeListsEnabled;
    private final Set<ListData> myLists;
    private ListData myDefault;
    private final Map<Change, ListData> myChangeMappings;
    private final Map<FilePath, PartialChangeTracker> myPartialChangeTrackers;
    private final ChangeListsIndexes myIdx;
    @Nullable
    private AffectedPathSet myAffectedPaths;
    @Nullable
    private Map<ListData, Set<Change>> myReadOnlyChangesCache;
    private final AtomicBoolean myReadOnlyChangesCacheInvalidated;

    public ChangeListWorker(@NotNull Project project2, @NotNull DelayedNotificator delayedNotificator) {
        if (project2 == null) {
            ChangeListWorker.$$$reportNull$$$0(0);
        }
        if (delayedNotificator == null) {
            ChangeListWorker.$$$reportNull$$$0(1);
        }
        this.myChangeListsEnabled = true;
        this.myLists = new HashSet<ListData>();
        this.myChangeMappings = new HashMap<Change, ListData>();
        this.myPartialChangeTrackers = new HashMap<FilePath, PartialChangeTracker>();
        this.myIdx = new ChangeListsIndexes();
        this.myReadOnlyChangesCache = null;
        this.myReadOnlyChangesCacheInvalidated = new AtomicBoolean(false);
        this.myProject = project2;
        this.myDelayedNotificator = delayedNotificator;
        this.myMainWorker = true;
        this.myAffectedPaths = new AffectedPathSet(Collections.emptyList());
        this.ensureDefaultListExists();
    }

    private ChangeListWorker(@NotNull ChangeListWorker worker) {
        if (worker == null) {
            ChangeListWorker.$$$reportNull$$$0(2);
        }
        this.myChangeListsEnabled = true;
        this.myLists = new HashSet<ListData>();
        this.myChangeMappings = new HashMap<Change, ListData>();
        this.myPartialChangeTrackers = new HashMap<FilePath, PartialChangeTracker>();
        this.myIdx = new ChangeListsIndexes();
        this.myReadOnlyChangesCache = null;
        this.myReadOnlyChangesCacheInvalidated = new AtomicBoolean(false);
        this.myProject = worker.myProject;
        this.myDelayedNotificator = worker.myDelayedNotificator;
        this.myChangeListsEnabled = worker.myChangeListsEnabled;
        this.myMainWorker = false;
        this.myIdx.copyFrom(worker.myIdx);
        this.myAffectedPaths = null;
        Map<ListData, ListData> listMapping = this.copyListsDataFrom(worker.myLists);
        worker.myChangeMappings.forEach((change, oldList) -> {
            ListData newList = this.notNullList((ListData)listMapping.get(oldList));
            this.myChangeMappings.put((Change)change, newList);
        });
        for (Map.Entry<FilePath, PartialChangeTracker> entry2 : worker.myPartialChangeTrackers.entrySet()) {
            this.myPartialChangeTrackers.put(entry2.getKey(), new PartialChangeTrackerDump(entry2.getValue(), this.myDefault));
        }
    }

    @NotNull
    private Map<ListData, ListData> copyListsDataFrom(@NotNull Collection<ListData> lists) {
        if (lists == null) {
            ChangeListWorker.$$$reportNull$$$0(3);
        }
        ListData oldDefault = this.myDefault;
        List oldIds = ContainerUtil.map(this.myLists, list -> list.id);
        this.myLists.clear();
        this.myDefault = null;
        HashMap<ListData, ListData> listMapping = new HashMap<ListData, ListData>();
        for (ListData oldList : lists) {
            ListData newList = new ListData(oldList);
            if (newList.isDefault && this.myDefault != null) {
                LOG.error("multiple default lists found when copy");
                newList.isDefault = false;
            }
            newList = this.putNewListData(newList);
            if (newList.isDefault) {
                this.myDefault = newList;
            }
            listMapping.put(oldList, newList);
        }
        this.ensureDefaultListExists();
        if (this.myMainWorker) {
            if (!oldDefault.id.equals(this.myDefault.id)) {
                this.fireDefaultListChanged(oldDefault.id, this.myDefault.id);
            }
            HashSet removedListIds = new HashSet(oldIds);
            for (ListData list2 : this.myLists) {
                removedListIds.remove(list2.id);
            }
            for (String listId : removedListIds) {
                this.fireChangeListRemoved(listId);
            }
        }
        this.myReadOnlyChangesCache = null;
        HashMap<ListData, ListData> hashMap = listMapping;
        if (hashMap == null) {
            ChangeListWorker.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private void ensureDefaultListExists() {
        if (this.myDefault != null) {
            return;
        }
        if (this.myLists.isEmpty()) {
            this.putNewListData(new ListData(null, LocalChangeList.getDefaultName()));
        }
        this.myDefault = this.myLists.iterator().next();
        this.myDefault.isDefault = true;
    }

    public ChangeListWorker copy() {
        return new ChangeListWorker(this);
    }

    public void registerChangeTracker(@NotNull FilePath filePath, @NotNull PartialChangeTracker tracker) {
        if (filePath == null) {
            ChangeListWorker.$$$reportNull$$$0(5);
        }
        if (tracker == null) {
            ChangeListWorker.$$$reportNull$$$0(6);
        }
        if (this.myPartialChangeTrackers.containsKey(filePath)) {
            LOG.error(String.format("Attempt to register duplicate trackers: %s; old: %s; new: %s", filePath, this.myPartialChangeTrackers.get(filePath), tracker));
            return;
        }
        this.myPartialChangeTrackers.put(filePath, tracker);
        ListData oldList = null;
        Change change = this.getChangeForAfterPath(filePath);
        if (change != null) {
            oldList = this.removeChangeMapping(change);
        }
        tracker.initChangeTracking(this.myDefault.id, ContainerUtil.map(this.myLists, list -> list.id), oldList != null ? oldList.id : null);
        List<String> oldIds = oldList != null ? Collections.singletonList(oldList.id) : Collections.emptyList();
        this.notifyChangelistsChanged(filePath, oldIds, tracker.getAffectedChangeListsIds());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[registerChangeTracker] path: %s, old list: %s", filePath, oldList != null ? oldList.id : "null"));
        }
    }

    public void unregisterChangeTracker(@NotNull FilePath filePath, @NotNull PartialChangeTracker tracker) {
        boolean trackerRemoved;
        if (filePath == null) {
            ChangeListWorker.$$$reportNull$$$0(7);
        }
        if (tracker == null) {
            ChangeListWorker.$$$reportNull$$$0(8);
        }
        if (trackerRemoved = this.myPartialChangeTrackers.remove(filePath, tracker)) {
            ListData newList = null;
            Change change = this.getChangeForAfterPath(filePath);
            if (change != null) {
                newList = this.getMainList(tracker);
                this.putChangeMapping(change, newList);
            }
            List<String> newIds = newList != null ? Collections.singletonList(newList.id) : Collections.emptyList();
            this.notifyChangelistsChanged(filePath, tracker.getAffectedChangeListsIds(), newIds);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("[unregisterChangeTracker] path: %s, new list: %s, tracker lists: %s", filePath, newList != null ? newList.id : "null", tracker.getAffectedChangeListsIds()));
            }
        } else {
            Map.Entry entry2 = (Map.Entry)ContainerUtil.find(this.myPartialChangeTrackers.entrySet(), it -> Comparing.equal((Object)((PartialChangeTracker)it.getValue()), (Object)tracker));
            if (entry2 != null) {
                LOG.error(String.format("Unregistered tracker with wrong path: tracker: %s", tracker));
                FilePath actualFilePath = (FilePath)entry2.getKey();
                this.unregisterChangeTracker(actualFilePath, tracker);
            } else {
                LOG.error(String.format("Tracker is not registered: tracker: %s", tracker));
            }
        }
    }

    @NotNull
    private ListData getMainList(@NotNull PartialChangeTracker tracker) {
        ListData list;
        List<String> changelistIds;
        if (tracker == null) {
            ChangeListWorker.$$$reportNull$$$0(9);
        }
        if ((changelistIds = tracker.getAffectedChangeListsIds()).size() == 1 && (list = this.getDataByIdVerify(changelistIds.get(0))) != null) {
            ListData listData = list;
            if (listData == null) {
                ChangeListWorker.$$$reportNull$$$0(10);
            }
            return listData;
        }
        ListData listData = this.myDefault;
        if (listData == null) {
            ChangeListWorker.$$$reportNull$$$0(11);
        }
        return listData;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            ChangeListWorker.$$$reportNull$$$0(12);
        }
        return project2;
    }

    @NotNull
    public LocalChangeList getDefaultList() {
        LocalChangeListImpl localChangeListImpl = this.toChangeList(this.myDefault);
        if (localChangeListImpl == null) {
            ChangeListWorker.$$$reportNull$$$0(13);
        }
        return localChangeListImpl;
    }

    @Nullable
    public LocalChangeList getChangeListByName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return this.toChangeList(this.getDataByName(name));
    }

    @Nullable
    public LocalChangeList getChangeListById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return this.toChangeList(this.getDataById(id));
    }

    @NotNull
    public List<LocalChangeList> getChangeLists() {
        List lists = ContainerUtil.map(this.myLists, this::toChangeList);
        List list = ContainerUtil.sorted((Collection)lists, ChangesUtil.CHANGELIST_COMPARATOR);
        if (list == null) {
            ChangeListWorker.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    List<LocalChangeListImpl> getChangeListsImpl() {
        List lists = ContainerUtil.map(this.myLists, this::toChangeList);
        List list = ContainerUtil.sorted((Collection)lists, ChangesUtil.CHANGELIST_COMPARATOR);
        if (list == null) {
            ChangeListWorker.$$$reportNull$$$0(15);
        }
        return list;
    }

    public int getChangeListsNumber() {
        return this.myLists.size();
    }

    @Nullable
    public Change getChangeForPath(@Nullable FilePath filePath) {
        if (filePath == null) {
            return null;
        }
        return this.myIdx.getChange(filePath);
    }

    @Nullable
    private Change getChangeForAfterPath(@Nullable FilePath filePath) {
        Change change = this.getChangeForPath(filePath);
        if (change == null) {
            return null;
        }
        ContentRevision after = change.getAfterRevision();
        if (after != null && after.getFile().equals(filePath)) {
            return change;
        }
        return null;
    }

    @NotNull
    public Collection<Change> getAllChanges() {
        return new ArrayList<Change>(this.myIdx.getChanges());
    }

    @NotNull
    public List<LocalChangeList> getAffectedLists(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ChangeListWorker.$$$reportNull$$$0(16);
        }
        List list = ContainerUtil.map(this.getAffectedListsData(changes), this::toChangeList);
        if (list == null) {
            ChangeListWorker.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private List<ListData> getAffectedListsData(@NotNull Collection<? extends Change> changes) {
        if (changes == null) {
            ChangeListWorker.$$$reportNull$$$0(18);
        }
        HashSet<ListData> result2 = new HashSet<ListData>();
        for (Change change : changes) {
            ListData list = this.myChangeMappings.get(change);
            if (list != null) {
                result2.add(list);
                continue;
            }
            PartialChangeTracker tracker = this.getChangeTrackerFor(change);
            if (tracker == null) continue;
            HashSet<ListData> affectedLists = this.getAffectedLists(tracker);
            if (change instanceof ChangeListChange) {
                String changeListId = ((ChangeListChange)change).getChangeListId();
                ContainerUtil.addIfNotNull(result2, (Object)((ListData)ContainerUtil.find(affectedLists, partialList -> partialList.id.equals(changeListId))));
                continue;
            }
            result2.addAll(affectedLists);
        }
        return new ArrayList<ListData>(result2);
    }

    @NotNull
    private List<Change> getChangesIn(@NotNull ListData data2) {
        if (data2 == null) {
            ChangeListWorker.$$$reportNull$$$0(19);
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Change change : this.myIdx.getChanges()) {
            ListData list = this.myChangeMappings.get(change);
            if (list != null) {
                if (list != data2) continue;
                changes.add(change);
                continue;
            }
            PartialChangeTracker tracker = this.getChangeTrackerFor(change);
            if (tracker == null || !tracker.getAffectedChangeListsIds().contains(data2.id)) continue;
            changes.add(change);
        }
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            ChangeListWorker.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @NotNull
    private Map<ListData, Set<Change>> getChangesMapping() {
        HashMap<ListData, Set<Change>> map2 = new HashMap<ListData, Set<Change>>();
        for (Change change : this.myIdx.getChanges()) {
            ListData list = this.myChangeMappings.get(change);
            if (list != null) {
                Set listChanges = map2.computeIfAbsent(list, key2 -> new HashSet());
                AbstractVcs vcs = this.myIdx.getVcsFor(change);
                if (vcs != null && vcs.arePartialChangelistsSupported()) {
                    listChanges.add(ChangeListWorker.toChangeListChange(change, list));
                    continue;
                }
                listChanges.add(change);
                continue;
            }
            PartialChangeTracker tracker = this.getChangeTrackerFor(change);
            if (tracker == null) continue;
            HashSet<ListData> lists = this.getAffectedLists(tracker);
            for (ListData partialList : lists) {
                Set listChanges = map2.computeIfAbsent(partialList, key2 -> new HashSet());
                listChanges.add(ChangeListWorker.toChangeListChange(change, partialList));
            }
        }
        HashMap<ListData, Set<Change>> hashMap = map2;
        if (hashMap == null) {
            ChangeListWorker.$$$reportNull$$$0(21);
        }
        return hashMap;
    }

    @NotNull
    public List<FilePath> getAffectedPaths() {
        return new ArrayList<FilePath>(this.myIdx.getAffectedPaths());
    }

    @NotNull
    public ThreeState haveChangesUnder(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ChangeListWorker.$$$reportNull$$$0(22);
        }
        assert (this.myMainWorker);
        if (this.myAffectedPaths == null) {
            LOG.error("Accessing non-initialized affected files set", new Throwable());
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                ChangeListWorker.$$$reportNull$$$0(23);
            }
            return threeState;
        }
        FilePath filePath = VcsUtil.getFilePath(virtualFile);
        ThreeState threeState = this.myAffectedPaths.haveChangesUnder(filePath);
        if (threeState == null) {
            ChangeListWorker.$$$reportNull$$$0(24);
        }
        return threeState;
    }

    @Nullable
    public AbstractVcs getVcsFor(@NotNull Change change) {
        if (change == null) {
            ChangeListWorker.$$$reportNull$$$0(25);
        }
        return this.myIdx.getVcsFor(change);
    }

    @Nullable
    public FileStatus getStatus(@NotNull VirtualFile file) {
        if (file == null) {
            ChangeListWorker.$$$reportNull$$$0(26);
        }
        return this.myIdx.getStatus(VcsUtil.getFilePath(file));
    }

    @Nullable
    public FileStatus getStatus(@NotNull FilePath file) {
        if (file == null) {
            ChangeListWorker.$$$reportNull$$$0(27);
        }
        return this.myIdx.getStatus(file);
    }

    @Nullable
    public String setDefaultList(@NotNull String name) {
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(28);
        }
        if (!this.assertChangeListsEnabled()) {
            return null;
        }
        ListData newDefault = this.getDataByName(name);
        if (newDefault == null || newDefault.isDefault) {
            return null;
        }
        ListData oldDefault = this.myDefault;
        this.myDefault.isDefault = false;
        newDefault.isDefault = true;
        this.myDefault = newDefault;
        this.fireDefaultListChanged(oldDefault.id, newDefault.id);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[setDefaultList %s] name: %s id: %s", this.myMainWorker ? "" : "- updater", name, newDefault.id));
        }
        return oldDefault.name;
    }

    public boolean setReadOnly(@NotNull String name, boolean value2) {
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(29);
        }
        if (!this.assertChangeListsEnabled()) {
            return false;
        }
        ListData list = this.getDataByName(name);
        if (list == null) {
            return false;
        }
        list.isReadOnly = value2;
        return true;
    }

    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        if (fromName == null) {
            ChangeListWorker.$$$reportNull$$$0(30);
        }
        if (toName == null) {
            ChangeListWorker.$$$reportNull$$$0(31);
        }
        if (!this.assertChangeListsEnabled()) {
            return false;
        }
        if (fromName.equals(toName)) {
            return false;
        }
        if (this.getDataByName(toName) != null) {
            return false;
        }
        ListData list = this.getDataByName(fromName);
        if (list == null || list.isReadOnly) {
            return false;
        }
        list.name = toName;
        return true;
    }

    @Nullable
    public String editComment(@NotNull String name, @NotNull String newComment) {
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(32);
        }
        if (newComment == null) {
            ChangeListWorker.$$$reportNull$$$0(33);
        }
        if (!this.assertChangeListsEnabled()) {
            return null;
        }
        ListData list = this.getDataByName(name);
        if (list == null) {
            return null;
        }
        String oldComment = list.comment;
        if (!Objects.equals(oldComment, newComment)) {
            list.comment = newComment;
        }
        return oldComment;
    }

    public boolean editData(@NotNull String name, @Nullable ChangeListData newData) {
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(34);
        }
        if (!this.assertChangeListsEnabled()) {
            return false;
        }
        ListData list = this.getDataByName(name);
        if (list == null) {
            return false;
        }
        list.data = newData;
        return true;
    }

    @NotNull
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String description2, @Nullable String id, @Nullable ChangeListData data2) {
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(35);
        }
        ListData listData = this.addChangeListEntry(name, description2, id, data2);
        LocalChangeListImpl localChangeListImpl = this.toChangeList(listData);
        if (localChangeListImpl == null) {
            ChangeListWorker.$$$reportNull$$$0(36);
        }
        return localChangeListImpl;
    }

    @NotNull
    private ListData addChangeListEntry(@NotNull String name, @Nullable String description2, @Nullable String id, @Nullable ChangeListData data2) {
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(37);
        }
        if (!this.assertChangeListsEnabled()) {
            ListData listData = this.myDefault;
            if (listData == null) {
                ChangeListWorker.$$$reportNull$$$0(38);
            }
            return listData;
        }
        ListData existingList = this.getDataByName(name);
        if (existingList != null) {
            LOG.error("Attempt to create duplicate changelist " + name);
            ListData listData = existingList;
            if (listData == null) {
                ChangeListWorker.$$$reportNull$$$0(39);
            }
            return listData;
        }
        ListData list = new ListData(id, name);
        list.comment = StringUtil.notNullize((String)description2);
        list.data = data2;
        list = this.putNewListData(list);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[addChangeList %s] name: %s id: %s", this.myMainWorker ? "" : "- updater", name, list.id));
        }
        ListData listData = list;
        if (listData == null) {
            ChangeListWorker.$$$reportNull$$$0(40);
        }
        return listData;
    }

    @Nullable
    public List<Change> removeChangeList(@NotNull String name) {
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(41);
        }
        if (!this.assertChangeListsEnabled()) {
            return null;
        }
        ListData removedList = this.getDataByName(name);
        if (removedList == null) {
            return null;
        }
        if (removedList.isDefault) {
            LOG.error("Cannot remove default changelist");
            return null;
        }
        ArrayList<Change> movedChanges = new ArrayList<Change>();
        this.myChangeMappings.replaceAll((change, list) -> {
            if (list == removedList) {
                movedChanges.add((Change)change);
                return this.myDefault;
            }
            return list;
        });
        this.fireChangeListRemoved(removedList.id);
        this.myReadOnlyChangesCache = null;
        this.myLists.remove(removedList);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[removeChangeList %s] name: %s id: %s", this.myMainWorker ? "" : "- updater", name, removedList.id));
        }
        return movedChanges;
    }

    @Nullable
    public MultiMap<LocalChangeList, Change> moveChangesTo(@NotNull String name, @NotNull List<? extends Change> changes) {
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(42);
        }
        if (changes == null) {
            ChangeListWorker.$$$reportNull$$$0(43);
        }
        if (!this.assertChangeListsEnabled()) {
            return MultiMap.empty();
        }
        ListData targetList = this.getDataByName(name);
        if (targetList == null) {
            return null;
        }
        MultiMap result2 = new MultiMap();
        for (Change change : changes) {
            ListData list = this.myChangeMappings.get(change);
            if (list != null) {
                if (list == targetList) continue;
                this.myChangeMappings.replace(change, targetList);
                result2.putValue((Object)list, (Object)change);
                continue;
            }
            PartialChangeTracker tracker = this.getChangeTrackerFor(change);
            if (tracker == null) continue;
            if (change instanceof ChangeListChange) {
                String fromListId = ((ChangeListChange)change).getChangeListId();
                ListData fromList = this.getDataById(fromListId);
                if (fromList == null || fromList == targetList) continue;
                tracker.moveChanges(fromList.id, targetList.id);
                result2.putValue((Object)fromList, (Object)change);
                continue;
            }
            HashSet<ListData> fromLists = this.getAffectedLists(tracker);
            fromLists.remove(targetList);
            if (fromLists.isEmpty()) continue;
            tracker.moveChangesTo(targetList.id);
            for (ListData fromList : fromLists) {
                result2.putValue((Object)fromList, (Object)change);
            }
        }
        this.myReadOnlyChangesCache = null;
        MultiMap notifications = new MultiMap();
        for (Map.Entry entry2 : result2.entrySet()) {
            notifications.put((Object)this.toChangeList((ListData)entry2.getKey()), (Collection)entry2.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[moveChangesTo %s] name: %s id: %s, changes: %s", this.myMainWorker ? "" : "- updater", targetList.name, targetList.id, changes));
        }
        return notifications;
    }

    public void notifyChangelistsChanged(@NotNull FilePath path2, @NotNull List<String> beforeChangeListsIds, @NotNull List<String> afterChangeListsIds) {
        if (path2 == null) {
            ChangeListWorker.$$$reportNull$$$0(44);
        }
        if (beforeChangeListsIds == null) {
            ChangeListWorker.$$$reportNull$$$0(45);
        }
        if (afterChangeListsIds == null) {
            ChangeListWorker.$$$reportNull$$$0(46);
        }
        this.myReadOnlyChangesCacheInvalidated.set(true);
        HashSet<String> removed2 = new HashSet<String>(beforeChangeListsIds);
        afterChangeListsIds.forEach(removed2::remove);
        HashSet<String> added2 = new HashSet<String>(afterChangeListsIds);
        beforeChangeListsIds.forEach(added2::remove);
        if (!removed2.isEmpty() || !added2.isEmpty()) {
            this.myDelayedNotificator.changeListsForFileChanged(path2, removed2, added2);
        }
    }

    public void applyChangesFromUpdate(@NotNull ChangeListWorker updatedWorker, @NotNull ChangeListDeltaListener deltaListener) {
        if (updatedWorker == null) {
            ChangeListWorker.$$$reportNull$$$0(47);
        }
        if (deltaListener == null) {
            ChangeListWorker.$$$reportNull$$$0(48);
        }
        assert (this.myMainWorker);
        assert (this.myChangeListsEnabled == updatedWorker.myChangeListsEnabled);
        HashMap<Change, ListData> oldChangeMappings = new HashMap<Change, ListData>(this.myChangeMappings);
        ChangeListWorker.notifyPathsChanged(this.myIdx, updatedWorker.myIdx, deltaListener);
        this.myIdx.copyFrom(updatedWorker.myIdx);
        this.myAffectedPaths = new AffectedPathSet(this.myIdx.getAffectedPaths());
        this.myChangeMappings.clear();
        Map<ListData, ListData> listMapping = this.copyListsDataFrom(updatedWorker.myLists);
        for (Change change : this.myIdx.getChanges()) {
            ListData oldMappedList;
            PartialChangeTracker tracker = this.getChangeTrackerFor(change);
            if (tracker != null) continue;
            ListData oldList = updatedWorker.myChangeMappings.get(change);
            ListData newList = null;
            if (oldList == null) {
                if (updatedWorker.getChangeTrackerFor(change) == null) {
                    LOG.error("Change mapping not found");
                }
            } else {
                newList = listMapping.get(oldList);
                if (newList == null) {
                    LOG.error("List mapping not found");
                }
            }
            if (newList == null && (oldMappedList = oldChangeMappings.get(change)) != null) {
                newList = this.getDataById(oldMappedList.id);
            }
            if (newList == null) {
                newList = this.myDefault;
            }
            this.myChangeMappings.put(change, newList);
        }
        this.myDelayedNotificator.allChangeListsMappingsChanged();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("[applyChangesFromUpdate] %s", this));
        }
    }

    public void setChangeListsEnabled(boolean enabled) {
        if (this.myChangeListsEnabled == enabled) {
            return;
        }
        LOG.debug("[setChangeListsEnabled] - " + enabled);
        if (enabled) {
            this.myChangeListsEnabled = true;
            this.enableChangeLists();
        } else {
            this.disableChangeLists();
            this.myChangeListsEnabled = false;
        }
        this.myDelayedNotificator.allChangeListsMappingsChanged();
        this.myDelayedNotificator.changeListAvailabilityChanged();
        LOG.debug("after [setChangeListsEnabled] - " + enabled);
    }

    private void disableChangeLists() {
        ListData fallbackList = this.getDataByName(LocalChangeList.getDefaultName());
        if (fallbackList == null) {
            fallbackList = this.putNewListData(new ListData(null, LocalChangeList.getDefaultName()));
        }
        LocalChangeList oldDefaultList = this.getDefaultList();
        String oldComment = this.editComment(fallbackList.name, "");
        boolean readOnlyChanged = this.setReadOnly(fallbackList.name, true);
        boolean dataChanged = this.editData(fallbackList.name, null);
        boolean defaultChanged = this.setDefaultList(fallbackList.name) != null;
        ArrayList<LocalChangeList> removedLists = new ArrayList<LocalChangeList>();
        for (ListData list : new ArrayList<ListData>(this.myLists)) {
            if (list.isDefault) continue;
            removedLists.add(this.getChangeListByName(list.name));
            this.removeChangeList(list.name);
        }
        LocalChangeListImpl newList = this.toChangeList(fallbackList);
        if (!StringUtil.isEmpty((String)oldComment)) {
            this.myDelayedNotificator.changeListCommentChanged(newList, oldComment);
        }
        if (readOnlyChanged) {
            this.myDelayedNotificator.changeListChanged(newList);
        }
        if (dataChanged) {
            this.myDelayedNotificator.changeListDataChanged(newList);
        }
        if (defaultChanged) {
            this.myDelayedNotificator.defaultListChanged(oldDefaultList, newList, false);
        }
        for (LocalChangeList oldList : removedLists) {
            Collection<Change> movedChanges = oldList.getChanges();
            if (!movedChanges.isEmpty()) {
                this.myDelayedNotificator.changesMoved(movedChanges, oldList, newList);
            }
            this.myDelayedNotificator.changeListRemoved(oldList);
        }
    }

    private void enableChangeLists() {
        LOG.assertTrue(this.myLists.size() == 1);
        boolean readOnlyChanged = this.setReadOnly(this.myDefault.name, false);
        LocalChangeListImpl newList = this.toChangeList(this.myDefault);
        if (readOnlyChanged) {
            this.myDelayedNotificator.changeListChanged(newList);
        }
    }

    public boolean areChangeListsEnabled() {
        return this.myChangeListsEnabled;
    }

    private boolean assertChangeListsEnabled() {
        if (this.myChangeListsEnabled) {
            return true;
        }
        LOG.error("Changelists are disabled, modification ignored", new Throwable());
        return false;
    }

    private static void notifyPathsChanged(@NotNull ChangeListsIndexes was, @NotNull ChangeListsIndexes became, @NotNull ChangeListDeltaListener deltaListener) {
        if (was == null) {
            ChangeListWorker.$$$reportNull$$$0(49);
        }
        if (became == null) {
            ChangeListWorker.$$$reportNull$$$0(50);
        }
        if (deltaListener == null) {
            ChangeListWorker.$$$reportNull$$$0(51);
        }
        HashSet toRemove = new HashSet();
        HashSet toAdd = new HashSet();
        HashSet toModify = new HashSet();
        was.getDelta(became, toRemove, toAdd, toModify);
        for (BaseRevision pair : toRemove) {
            deltaListener.removed(pair);
        }
        for (BaseRevision pair : toAdd) {
            deltaListener.added(pair);
        }
        for (BeforeAfter beforeAfter : toModify) {
            deltaListener.modified((BaseRevision)beforeAfter.getBefore(), (BaseRevision)beforeAfter.getAfter());
        }
    }

    void setChangeLists(@NotNull Collection<LocalChangeListImpl> lists) {
        if (lists == null) {
            ChangeListWorker.$$$reportNull$$$0(52);
        }
        assert (this.myMainWorker);
        if (!this.myChangeListsEnabled) {
            return;
        }
        this.myIdx.clear();
        this.myChangeMappings.clear();
        this.copyListsDataFrom(ContainerUtil.map(lists, ListData::new));
        for (LocalChangeListImpl list : lists) {
            ListData listData = this.notNullList(this.getDataByIdVerify(list.getId()));
            for (Change change : list.getChanges()) {
                if (this.myIdx.getChanges().contains(change)) continue;
                this.myIdx.changeAdded(change, null);
                PartialChangeTracker tracker = this.getChangeTrackerFor(change);
                if (tracker != null) continue;
                this.myChangeMappings.put(change, listData);
            }
        }
        this.myAffectedPaths = new AffectedPathSet(this.myIdx.getAffectedPaths());
        this.myDelayedNotificator.allChangeListsMappingsChanged();
    }

    private void fireDefaultListChanged(@NotNull String oldDefaultId, @NotNull String newDefaultId) {
        if (oldDefaultId == null) {
            ChangeListWorker.$$$reportNull$$$0(53);
        }
        if (newDefaultId == null) {
            ChangeListWorker.$$$reportNull$$$0(54);
        }
        for (PartialChangeTracker tracker : this.myPartialChangeTrackers.values()) {
            tracker.defaultListChanged(oldDefaultId, newDefaultId);
        }
    }

    private void fireChangeListRemoved(@NotNull String listId) {
        if (listId == null) {
            ChangeListWorker.$$$reportNull$$$0(55);
        }
        for (PartialChangeTracker tracker : this.myPartialChangeTrackers.values()) {
            tracker.changeListRemoved(listId);
        }
    }

    @Nullable
    private ListData removeChangeMapping(@NotNull Change change) {
        if (change == null) {
            ChangeListWorker.$$$reportNull$$$0(56);
        }
        ListData oldList = this.myChangeMappings.remove(change);
        this.myReadOnlyChangesCache = null;
        return oldList;
    }

    private void putChangeMapping(@NotNull Change change, @NotNull ListData list) {
        if (change == null) {
            ChangeListWorker.$$$reportNull$$$0(57);
        }
        if (list == null) {
            ChangeListWorker.$$$reportNull$$$0(58);
        }
        this.myChangeMappings.put(change, list);
        this.myReadOnlyChangesCache = null;
    }

    @NotNull
    private ListData putNewListData(@NotNull ListData list) {
        ListData listWithSameName;
        if (list == null) {
            ChangeListWorker.$$$reportNull$$$0(59);
        }
        if ((listWithSameName = this.getDataByName(list.name)) != null) {
            LOG.error(String.format("Attempt to create changelist with same name: %s - %s", list.name, list.id));
            ListData listData = listWithSameName;
            if (listData == null) {
                ChangeListWorker.$$$reportNull$$$0(60);
            }
            return listData;
        }
        ListData listWithSameId = this.getDataById(list.id);
        if (listWithSameId != null) {
            LOG.error(String.format("Attempt to create changelist with same id: %s - %s", list.name, list.id));
            ListData listData = listWithSameId;
            if (listData == null) {
                ChangeListWorker.$$$reportNull$$$0(61);
            }
            return listData;
        }
        this.myLists.add(list);
        ListData listData = list;
        if (listData == null) {
            ChangeListWorker.$$$reportNull$$$0(62);
        }
        return listData;
    }

    @NotNull
    private ListData notNullList(@Nullable ListData listData) {
        if (listData == null) {
            LOG.error("ListData not found");
        }
        ListData listData2 = (ListData)ObjectUtils.notNull((Object)listData, (Object)this.myDefault);
        if (listData2 == null) {
            ChangeListWorker.$$$reportNull$$$0(63);
        }
        return listData2;
    }

    @Nullable
    private ListData getDataById(@NotNull String id) {
        if (id == null) {
            ChangeListWorker.$$$reportNull$$$0(64);
        }
        return (ListData)ContainerUtil.find(this.myLists, list -> list.id.equals(id));
    }

    @Nullable
    private ListData getDataByName(@NotNull String name) {
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(65);
        }
        return (ListData)ContainerUtil.find(this.myLists, list -> list.name.equals(name));
    }

    @Nullable
    private ListData getDataByIdVerify(@NotNull String id) {
        if (id == null) {
            ChangeListWorker.$$$reportNull$$$0(66);
        }
        ListData list = this.getDataById(id);
        if (this.myMainWorker && list == null) {
            LOG.error(String.format("Unknown changelist %s", id));
        }
        return list;
    }

    @Nullable
    private PartialChangeTracker getChangeTrackerFor(@NotNull Change change) {
        if (change == null) {
            ChangeListWorker.$$$reportNull$$$0(67);
        }
        if (!this.myChangeListsEnabled) {
            return null;
        }
        if (this.myPartialChangeTrackers.isEmpty()) {
            return null;
        }
        if (!this.myIdx.getChanges().contains(change)) {
            return null;
        }
        ContentRevision revision = change.getAfterRevision();
        if (revision == null) {
            return null;
        }
        return this.myPartialChangeTrackers.get(revision.getFile());
    }

    @NotNull
    private HashSet<ListData> getAffectedLists(@NotNull PartialChangeTracker tracker) {
        if (tracker == null) {
            ChangeListWorker.$$$reportNull$$$0(68);
        }
        HashSet<ListData> data2 = new HashSet<ListData>();
        for (String listId : tracker.getAffectedChangeListsIds()) {
            ListData partialList = this.getDataById(listId);
            if (this.myMainWorker && partialList == null) {
                LOG.warn(String.format("Unknown changelist %s for file %s", listId, tracker));
                tracker.initChangeTracking(this.myDefault.id, ContainerUtil.map(this.myLists, list -> list.id), null);
            }
            data2.add(partialList != null ? partialList : this.myDefault);
        }
        HashSet<ListData> hashSet = data2;
        if (hashSet == null) {
            ChangeListWorker.$$$reportNull$$$0(69);
        }
        return hashSet;
    }

    @Contract(value="!null -> !null; null -> null")
    private LocalChangeListImpl toChangeList(@Nullable ListData data2) {
        Set<Change> cachedChanges;
        if (data2 == null) {
            return null;
        }
        if (this.myReadOnlyChangesCache == null || this.myReadOnlyChangesCacheInvalidated.get()) {
            this.myReadOnlyChangesCacheInvalidated.set(false);
            this.myReadOnlyChangesCache = this.getChangesMapping();
        }
        Set<Change> changes = (cachedChanges = this.myReadOnlyChangesCache.get(data2)) != null ? Collections.unmodifiableSet(cachedChanges) : Collections.emptySet();
        return this.buildChangeListFrom(data2).setChangesCollection(changes).build();
    }

    @Contract(value="!null -> !null; null -> null")
    private LocalChangeListImpl toLightChangeList(@Nullable ListData data2) {
        if (data2 == null) {
            return null;
        }
        return this.buildChangeListFrom(data2).build();
    }

    @NotNull
    private LocalChangeListImpl.Builder buildChangeListFrom(@NotNull ListData data2) {
        if (data2 == null) {
            ChangeListWorker.$$$reportNull$$$0(70);
        }
        LocalChangeListImpl.Builder builder2 = new LocalChangeListImpl.Builder(this.myProject, data2.name).setId(data2.id).setComment(data2.comment).setData(data2.data).setDefault(data2.isDefault).setReadOnly(data2.isReadOnly);
        if (builder2 == null) {
            ChangeListWorker.$$$reportNull$$$0(71);
        }
        return builder2;
    }

    @NotNull
    private static Change toChangeListChange(@NotNull Change change, @NotNull ListData list) {
        if (change == null) {
            ChangeListWorker.$$$reportNull$$$0(72);
        }
        if (list == null) {
            ChangeListWorker.$$$reportNull$$$0(73);
        }
        if (change.getClass() == Change.class) {
            return new ChangeListChange(change, list.name, list.id);
        }
        Change change2 = change;
        if (change2 == null) {
            ChangeListWorker.$$$reportNull$$$0(74);
        }
        return change2;
    }

    @NonNls
    public String toString() {
        String lists = StringUtil.join(this.myLists, list -> String.format("list: %s (%s) changes: %s", list.name, list.id, StringUtil.join(this.getChangesIn((ListData)list), (String)", ")), (String)"\n");
        String trackers2 = StringUtil.join(this.myPartialChangeTrackers.entrySet(), entry2 -> entry2.getKey() + " " + ((PartialChangeTracker)entry2.getValue()).getAffectedChangeListsIds(), (String)",");
        return String.format("ChangeListWorker{ default = %s, lists = {\n%s }\ntrackers = %s\n}", this.myDefault.id, lists, trackers2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 10, 11, 12, 13, 14, 15, 17, 20, 21, 23, 24, 36, 38, 39, 40, 60, 61, 62, 63, 69, 71, 74 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delayedNotificator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "worker";
                break;
            }
            case 3: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 69: 
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListWorker";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 16: 
            case 18: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 19: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 25: 
            case 56: 
            case 57: 
            case 67: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 41: 
            case 42: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newComment";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeChangeListsIds";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterChangeListsIds";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedWorker";
                break;
            }
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deltaListener";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "was";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "became";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldDefaultId";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDefaultId";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listId";
                break;
            }
            case 58: 
            case 59: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListWorker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "copyListsDataFrom";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultList";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLists";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeListsImpl";
                break;
            }
            case 17: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedLists";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesIn";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesMapping";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "haveChangesUnder";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "addChangeList";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "addChangeListEntry";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "putNewListData";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullList";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChangeListFrom";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "toChangeListChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyListsDataFrom";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 69: 
            case 71: 
            case 74: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeTracker";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unregisterChangeTracker";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMainList";
                break;
            }
            case 16: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedLists";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedListsData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getChangesIn";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "haveChangesUnder";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getVcsFor";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultList";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnly";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "editName";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "editComment";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "editData";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addChangeList";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListEntry";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeList";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "moveChangesTo";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "notifyChangelistsChanged";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "applyChangesFromUpdate";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "notifyPathsChanged";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setChangeLists";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "fireDefaultListChanged";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "fireChangeListRemoved";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeMapping";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "putChangeMapping";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "putNewListData";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getDataById";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getDataByName";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getDataByIdVerify";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getChangeTrackerFor";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "buildChangeListFrom";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "toChangeListChange";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 10, 11, 12, 13, 14, 15, 17, 20, 21, 23, 24, 36, 38, 39, 40, 60, 61, 62, 63, 69, 71, 74 -> new IllegalStateException(string2);
        };
    }

    private static class PartialChangeTrackerDump
    implements PartialChangeTracker {
        @NotNull
        private final Set<String> myChangeListsIds;
        @NotNull
        private String myDefaultId;

        PartialChangeTrackerDump(@NotNull PartialChangeTracker tracker, @NotNull ListData defaultList) {
            if (tracker == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(0);
            }
            if (defaultList == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(1);
            }
            this.myChangeListsIds = new HashSet<String>(tracker.getAffectedChangeListsIds());
            this.myDefaultId = defaultList.id;
        }

        @Override
        @NotNull
        public List<String> getAffectedChangeListsIds() {
            return new ArrayList<String>(this.myChangeListsIds);
        }

        @Override
        public void initChangeTracking(@NotNull String defaultId, @NotNull List<String> changelistsId, @Nullable String fileChangelistIds) {
            if (defaultId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(2);
            }
            if (changelistsId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(3);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void defaultListChanged(@NotNull String oldListId, @NotNull String newListId) {
            if (oldListId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(4);
            }
            if (newListId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(5);
            }
            this.myDefaultId = newListId;
        }

        @Override
        public void changeListRemoved(@NotNull String listId) {
            if (listId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(6);
            }
            this.myChangeListsIds.remove(listId);
            if (this.myChangeListsIds.isEmpty()) {
                this.myChangeListsIds.add(this.myDefaultId);
            }
        }

        @Override
        public void moveChanges(@NotNull String fromListId, @NotNull String toListId) {
            if (fromListId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(7);
            }
            if (toListId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(8);
            }
            if (this.myChangeListsIds.remove(fromListId)) {
                this.myChangeListsIds.add(toListId);
            }
        }

        @Override
        public void moveChangesTo(@NotNull String toListId) {
            if (toListId == null) {
                PartialChangeTrackerDump.$$$reportNull$$$0(9);
            }
            this.myChangeListsIds.clear();
            this.myChangeListsIds.add(toListId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changelistsId";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldListId";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newListId";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listId";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromListId";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toListId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListWorker$PartialChangeTrackerDump";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "initChangeTracking";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "defaultListChanged";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "changeListRemoved";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveChanges";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveChangesTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface PartialChangeTracker {
        @NotNull
        public List<String> getAffectedChangeListsIds();

        public void initChangeTracking(@NotNull String var1, @NotNull List<String> var2, @Nullable String var3);

        public void defaultListChanged(@NotNull String var1, @NotNull String var2);

        public void changeListRemoved(@NotNull String var1);

        public void moveChanges(@NotNull String var1, @NotNull String var2);

        public void moveChangesTo(@NotNull String var1);
    }

    private static final class ListData {
        @NotNull
        public final String id;
        @NotNull
        public String name;
        @NotNull
        public String comment;
        @Nullable
        public ChangeListData data;
        public boolean isDefault;
        public boolean isReadOnly;

        ListData(@Nullable String id, @NotNull String name) {
            if (name == null) {
                ListData.$$$reportNull$$$0(0);
            }
            this.comment = "";
            this.isDefault = false;
            this.isReadOnly = false;
            this.id = id != null ? id : LocalChangeListImpl.generateChangelistId();
            this.name = name;
        }

        ListData(@NotNull LocalChangeListImpl list) {
            if (list == null) {
                ListData.$$$reportNull$$$0(1);
            }
            this.comment = "";
            this.isDefault = false;
            this.isReadOnly = false;
            this.id = list.getId();
            this.name = list.getName();
            this.comment = list.getComment();
            this.data = list.getData();
            this.isDefault = list.isDefault();
            this.isReadOnly = list.isReadOnly();
        }

        ListData(@NotNull ListData list) {
            if (list == null) {
                ListData.$$$reportNull$$$0(2);
            }
            this.comment = "";
            this.isDefault = false;
            this.isReadOnly = false;
            this.id = list.id;
            this.name = list.name;
            this.comment = list.comment;
            this.data = list.data;
            this.isDefault = list.isDefault;
            this.isReadOnly = list.isReadOnly;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "list";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/ChangeListWorker$ListData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ChangeListUpdater
    implements ChangeListManagerGate {
        private final ChangeListWorker myWorker;
        private final Map<String, ObjectOpenHashSet<Change>> myChangesBeforeUpdateMap;
        private static final String CONFLICT_CHANGELIST_ID = "";
        private final Map<FilePath, String> myListsForPathsBeforeUpdate;
        private final Set<String> myListsToDisappear;
        private final Comparator<Change> CHANGES_AFTER_REVISION_COMPARATOR;

        public ChangeListUpdater(@NotNull ChangeListWorker worker) {
            if (worker == null) {
                ChangeListUpdater.$$$reportNull$$$0(0);
            }
            this.myChangesBeforeUpdateMap = FactoryMap.create(it -> new ObjectOpenHashSet());
            this.myListsForPathsBeforeUpdate = new HashMap<FilePath, String>();
            this.myListsToDisappear = new HashSet<String>();
            this.CHANGES_AFTER_REVISION_COMPARATOR = (o1, o2) -> {
                String s1 = o1.getAfterRevision().getFile().getPresentableUrl();
                String s2 = o2.getAfterRevision().getFile().getPresentableUrl();
                return SystemInfo.isFileSystemCaseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
            };
            this.myWorker = worker.copy();
        }

        @NotNull
        public Project getProject() {
            Project project2 = this.myWorker.getProject();
            if (project2 == null) {
                ChangeListUpdater.$$$reportNull$$$0(1);
            }
            return project2;
        }

        public void notifyStartProcessingChanges(@Nullable VcsModifiableDirtyScope scope2) {
            this.myWorker.myChangeMappings.forEach((change, list) -> {
                this.putPathBeforeUpdate(ChangesUtil.getBeforePath(change), list.id);
                this.putPathBeforeUpdate(ChangesUtil.getAfterPath(change), list.id);
                this.myChangesBeforeUpdateMap.get(list.id).add(change);
            });
            List<Change> removedChanges = this.removeChangesUnderScope(scope2);
            if (scope2 != null) {
                for (Change change2 : removedChanges) {
                    if (!change2.isMoved() && !change2.isRenamed()) continue;
                    scope2.addDirtyFile(change2.getBeforeRevision().getFile());
                    scope2.addDirtyFile(change2.getAfterRevision().getFile());
                }
            }
            for (ChangeListChangeAssigner extension : ChangeListChangeAssigner.EP_NAME.getExtensions((AreaInstance)this.myWorker.myProject)) {
                try {
                    extension.beforeChangesProcessing(scope2);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }

        private void putPathBeforeUpdate(@Nullable FilePath path2, @NotNull String listId) {
            if (listId == null) {
                ChangeListUpdater.$$$reportNull$$$0(2);
            }
            if (path2 == null) {
                return;
            }
            String oldListId = this.myListsForPathsBeforeUpdate.get(path2);
            if (CONFLICT_CHANGELIST_ID.equals(oldListId) || listId.equals(oldListId)) {
                return;
            }
            if (oldListId == null) {
                this.myListsForPathsBeforeUpdate.put(path2, listId);
            } else {
                this.myListsForPathsBeforeUpdate.put(path2, CONFLICT_CHANGELIST_ID);
            }
        }

        @Nullable
        private String guessChangeListByPaths(@NotNull Change change) {
            if (change == null) {
                ChangeListUpdater.$$$reportNull$$$0(3);
            }
            FilePath bPath = ChangesUtil.getBeforePath(change);
            FilePath aPath = ChangesUtil.getAfterPath(change);
            String bListId = this.myListsForPathsBeforeUpdate.get(bPath);
            String aListId = this.myListsForPathsBeforeUpdate.get(aPath);
            if (CONFLICT_CHANGELIST_ID.equals(bListId) || CONFLICT_CHANGELIST_ID.equals(aListId)) {
                return null;
            }
            if (bListId == null && aListId == null) {
                return null;
            }
            if (bListId == null) {
                return aListId;
            }
            if (aListId == null) {
                return bListId;
            }
            return bListId.equals(aListId) ? bListId : null;
        }

        @NotNull
        private List<Change> removeChangesUnderScope(@Nullable VcsDirtyScope scope2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Process scope: %s", scope2));
            }
            ArrayList<Change> removed2 = new ArrayList<Change>();
            for (Change change : this.myWorker.myIdx.getChanges()) {
                boolean isUnderScope;
                ContentRevision before = change.getBeforeRevision();
                ContentRevision after = change.getAfterRevision();
                boolean bl = isUnderScope = scope2 == null || before != null && scope2.belongsTo(before.getFile()) || after != null && scope2.belongsTo(after.getFile()) || ChangeListUpdater.isIgnoredChange(before, after, this.getProject());
                if (isUnderScope) {
                    removed2.add(change);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(String.format("under scope - %s, change - %s", isUnderScope, change));
            }
            for (Change change : removed2) {
                this.myWorker.myIdx.changeRemoved(change);
                this.myWorker.removeChangeMapping(change);
            }
            ArrayList<Change> arrayList = removed2;
            if (arrayList == null) {
                ChangeListUpdater.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        private static boolean isIgnoredChange(@Nullable ContentRevision before, @Nullable ContentRevision after, @NotNull Project project2) {
            if (project2 == null) {
                ChangeListUpdater.$$$reportNull$$$0(5);
            }
            return ChangeListUpdater.isIgnoredRevision(before, project2) && ChangeListUpdater.isIgnoredRevision(after, project2);
        }

        private static boolean isIgnoredRevision(@Nullable ContentRevision revision, @NotNull Project project2) {
            if (project2 == null) {
                ChangeListUpdater.$$$reportNull$$$0(6);
            }
            if (revision == null) {
                return true;
            }
            return (Boolean)ReadAction.compute(() -> {
                if (project2.isDisposed()) {
                    return false;
                }
                return ProjectLevelVcsManager.getInstance(project2).isIgnored(revision.getFile());
            });
        }

        public void notifyDoneProcessingChanges(@NotNull DelayedNotificator dispatcher, @Nullable VcsDirtyScope scope2) {
            if (dispatcher == null) {
                ChangeListUpdater.$$$reportNull$$$0(7);
            }
            ArrayList<LocalChangeListImpl> changedLists = new ArrayList<LocalChangeListImpl>();
            HashMap<LocalChangeListImpl, List> removedChanges = new HashMap<LocalChangeListImpl, List>();
            HashMap<LocalChangeListImpl, List> addedChanges = new HashMap<LocalChangeListImpl, List>();
            for (ListData listData : this.myWorker.myLists) {
                ArrayList removed2 = new ArrayList();
                ArrayList added2 = new ArrayList();
                this.doneProcessingChanges(listData, removed2, added2);
                LocalChangeListImpl changeList2 = this.myWorker.toChangeList(listData);
                if (!removed2.isEmpty() || !added2.isEmpty()) {
                    changedLists.add(changeList2);
                }
                if (!removed2.isEmpty()) {
                    removedChanges.put(changeList2, removed2);
                }
                if (added2.isEmpty()) continue;
                addedChanges.put(changeList2, added2);
            }
            removedChanges.forEach((changeList, changes) -> dispatcher.changesRemoved((Collection<? extends Change>)changes, (ChangeList)changeList));
            addedChanges.forEach((changeList, changes) -> dispatcher.changesAdded((Collection<? extends Change>)changes, (ChangeList)changeList));
            for (ChangeList changeList2 : changedLists) {
                dispatcher.changeListChanged(changeList2);
            }
            for (String string2 : this.myListsToDisappear) {
                ListData list = this.myWorker.getDataByName(string2);
                if (list == null || !this.myWorker.getChangesIn(list).isEmpty() || list.isReadOnly || list.isDefault) continue;
                this.myWorker.removeChangeList(string2);
            }
            this.myListsToDisappear.clear();
            this.myChangesBeforeUpdateMap.clear();
            this.myListsForPathsBeforeUpdate.clear();
            for (ChangeListChangeAssigner changeListChangeAssigner : ChangeListChangeAssigner.EP_NAME.getExtensions((AreaInstance)this.myWorker.myProject)) {
                try {
                    changeListChangeAssigner.markChangesProcessed(scope2);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }

        private void doneProcessingChanges(@NotNull ListData list, @NotNull List<? super Change> removedChanges, @NotNull List<? super Change> addedChanges) {
            if (list == null) {
                ChangeListUpdater.$$$reportNull$$$0(8);
            }
            if (removedChanges == null) {
                ChangeListUpdater.$$$reportNull$$$0(9);
            }
            if (addedChanges == null) {
                ChangeListUpdater.$$$reportNull$$$0(10);
            }
            ObjectOpenHashSet<Change> changesBeforeUpdate = this.myChangesBeforeUpdateMap.get(list.id);
            HashSet<Change> listChanges = new HashSet<Change>(this.myWorker.getChangesIn(list));
            for (Change newChange : listChanges) {
                Change oldChange = ChangeListUpdater.findOldChange(changesBeforeUpdate, newChange);
                if (oldChange != null) continue;
                addedChanges.add(newChange);
            }
            removedChanges.addAll((Collection<? super Change>)changesBeforeUpdate);
            removedChanges.removeAll(listChanges);
        }

        @Nullable
        private static Change findOldChange(@NotNull ObjectOpenHashSet<Change> changesBeforeUpdate, @NotNull Change newChange) {
            Change oldChange;
            if (changesBeforeUpdate == null) {
                ChangeListUpdater.$$$reportNull$$$0(11);
            }
            if (newChange == null) {
                ChangeListUpdater.$$$reportNull$$$0(12);
            }
            if ((oldChange = (Change)changesBeforeUpdate.get((Object)newChange)) != null && ChangeListUpdater.sameBeforeRevision(oldChange, newChange) && newChange.getFileStatus().equals(oldChange.getFileStatus())) {
                return oldChange;
            }
            return null;
        }

        private static boolean sameBeforeRevision(@NotNull Change change1, @NotNull Change change2) {
            if (change1 == null) {
                ChangeListUpdater.$$$reportNull$$$0(13);
            }
            if (change2 == null) {
                ChangeListUpdater.$$$reportNull$$$0(14);
            }
            ContentRevision b1 = change1.getBeforeRevision();
            ContentRevision b2 = change2.getBeforeRevision();
            if (b1 != null && b2 != null) {
                VcsRevisionNumber rn1 = b1.getRevisionNumber();
                VcsRevisionNumber rn2 = b2.getRevisionNumber();
                return rn1 != VcsRevisionNumber.NULL && rn2 != VcsRevisionNumber.NULL && b1.getClass() == b2.getClass() && rn1.compareTo(rn2) == 0;
            }
            return b1 == null && b2 == null;
        }

        public void finish() {
            this.checkForMultipleCopiesNotMove();
        }

        @NotNull
        public ChangeListWorker getUpdatedWorker() {
            ChangeListWorker changeListWorker = this.myWorker;
            if (changeListWorker == null) {
                ChangeListUpdater.$$$reportNull$$$0(15);
            }
            return changeListWorker;
        }

        private void checkForMultipleCopiesNotMove() {
            MultiMap moves = new MultiMap();
            for (Change change : this.myWorker.myIdx.getChanges()) {
                if (!change.isMoved() && !change.isRenamed()) continue;
                moves.putValue((Object)change.getBeforeRevision().getFile(), (Object)change);
            }
            for (FilePath filePath : moves.keySet()) {
                List copies = (List)moves.get((Object)filePath);
                if (copies.size() == 1) continue;
                copies.sort(this.CHANGES_AFTER_REVISION_COMPARATOR);
                for (int i = 0; i < copies.size() - 1; ++i) {
                    Change oldChange = (Change)copies.get(i);
                    Change newChange = new Change(null, oldChange.getAfterRevision());
                    AbstractVcs vcs = this.myWorker.myIdx.getVcsFor(oldChange);
                    this.myWorker.myIdx.changeRemoved(oldChange);
                    this.myWorker.myIdx.changeAdded(newChange, vcs);
                    ListData list = this.myWorker.removeChangeMapping(oldChange);
                    if (list == null) continue;
                    this.myWorker.putChangeMapping(newChange, list);
                }
            }
        }

        public void addChangeToList(@NotNull String name, @NotNull Change change, AbstractVcs vcs) {
            ListData list;
            if (name == null) {
                ChangeListUpdater.$$$reportNull$$$0(16);
            }
            if (change == null) {
                ChangeListUpdater.$$$reportNull$$$0(17);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("[addChangeToList] name: %s change: %s vcs: %s", name, ChangesUtil.getFilePath(change).getPath(), vcs == null ? null : vcs.getName()));
            }
            if ((list = this.myWorker.getDataByName(name)) != null) {
                this.addChangeToList(list, change, vcs);
            } else {
                LOG.error(String.format("Changelist not found: vcs - %s", vcs == null ? null : vcs.getName()));
                this.addChangeToCorrespondingList(change, vcs);
            }
        }

        public void addChangeToCorrespondingList(@NotNull Change change, AbstractVcs vcs) {
            if (change == null) {
                ChangeListUpdater.$$$reportNull$$$0(18);
            }
            ListData listData = this.guessListForChange(change);
            this.addChangeToList(listData, change, vcs);
        }

        @Nullable
        private ListData guessListForChange(@NotNull Change change) {
            ContentRevision revision;
            ListData list2;
            if (change == null) {
                ChangeListUpdater.$$$reportNull$$$0(19);
            }
            if (LOG.isDebugEnabled()) {
                String path2 = ChangesUtil.getFilePath(change).getPath();
                LOG.debug("[addChangeToCorrespondingList] for change " + (String)path2 + " type: " + change.getType() + " have before revision: " + (change.getBeforeRevision() != null));
            }
            for (ListData list2 : this.myWorker.myLists) {
                Set changesBeforeUpdate = (Set)this.myChangesBeforeUpdateMap.get(list2.id);
                if (!changesBeforeUpdate.contains(change)) continue;
                LOG.debug("[addChangeToCorrespondingList] matched by change: ", new Object[]{list2.name});
                return list2;
            }
            String listId = this.guessChangeListByPaths(change);
            if (listId != null && (list2 = this.myWorker.getDataById(listId)) != null) {
                LOG.debug("[addChangeToCorrespondingList] matched by paths: ", new Object[]{list2.name});
                return list2;
            }
            String assignedChangeListId = (String)ChangeListChangeAssigner.EP_NAME.computeSafeIfAny((AreaInstance)this.myWorker.myProject, assigner -> assigner.getChangeListIdFor(change, this));
            if (assignedChangeListId != null) {
                ListData list3 = this.myWorker.getDataById(assignedChangeListId);
                if (list3 != null) {
                    LOG.debug("[addChangeToCorrespondingList] added to list from assigner: ", new Object[]{list3.name});
                    return list3;
                }
                LOG.debug("[addChangeToCorrespondingList] failed to add to non-existent list from assigner: ", new Object[]{assignedChangeListId});
            }
            if ((revision = change.getAfterRevision()) != null && this.myWorker.myChangeListsEnabled && this.myWorker.myPartialChangeTrackers.get(revision.getFile()) != null) {
                LOG.debug("[addChangeToCorrespondingList] partial tracker found");
                return null;
            }
            LOG.debug("[addChangeToCorrespondingList] added to default list");
            return this.myWorker.myDefault;
        }

        private void addChangeToList(@Nullable ListData list, @NotNull Change change, AbstractVcs vcs) {
            if (change == null) {
                ChangeListUpdater.$$$reportNull$$$0(20);
            }
            if (this.myWorker.myIdx.getChanges().contains(change)) {
                LOG.warn(String.format("Multiple equal changes added: %s", change));
                return;
            }
            this.myWorker.myIdx.changeAdded(change, vcs);
            if (list != null) {
                this.myWorker.putChangeMapping(change, list);
            }
            this.myWorker.myReadOnlyChangesCache = null;
        }

        public void removeRegisteredChangeFor(@Nullable FilePath filePath) {
            Change change = this.myWorker.getChangeForPath(filePath);
            if (change == null) {
                return;
            }
            this.myWorker.myIdx.changeRemoved(change);
            this.myWorker.removeChangeMapping(change);
        }

        @Override
        @NotNull
        public List<LocalChangeList> getListsCopy() {
            List<LocalChangeList> list = this.myWorker.getChangeLists();
            if (list == null) {
                ChangeListUpdater.$$$reportNull$$$0(21);
            }
            return list;
        }

        @Override
        @Nullable
        public LocalChangeList findChangeList(@Nullable String name) {
            if (name == null) {
                return null;
            }
            ListData data2 = this.myWorker.getDataByName(name);
            if (data2 == null) {
                return null;
            }
            return this.myWorker.toLightChangeList(data2);
        }

        @Override
        @NotNull
        public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment) {
            if (name == null) {
                ChangeListUpdater.$$$reportNull$$$0(22);
            }
            ListData data2 = this.myWorker.addChangeListEntry(name, comment, null, null);
            LocalChangeListImpl localChangeListImpl = this.myWorker.toLightChangeList(data2);
            if (localChangeListImpl == null) {
                ChangeListUpdater.$$$reportNull$$$0(23);
            }
            return localChangeListImpl;
        }

        @Override
        @NotNull
        public LocalChangeList findOrCreateList(@NotNull String name, @Nullable String comment) {
            LocalChangeList list;
            if (name == null) {
                ChangeListUpdater.$$$reportNull$$$0(24);
            }
            if ((list = this.findChangeList(name)) != null) {
                LocalChangeList localChangeList = list;
                if (localChangeList == null) {
                    ChangeListUpdater.$$$reportNull$$$0(25);
                }
                return localChangeList;
            }
            LocalChangeList localChangeList = this.addChangeList(name, comment);
            if (localChangeList == null) {
                ChangeListUpdater.$$$reportNull$$$0(26);
            }
            return localChangeList;
        }

        @Override
        public void editComment(@NotNull String name, @Nullable String comment) {
            if (name == null) {
                ChangeListUpdater.$$$reportNull$$$0(27);
            }
            this.myWorker.editComment(name, StringUtil.notNullize((String)comment));
        }

        @Override
        public void editName(@NotNull String oldName, @NotNull String newName) {
            if (oldName == null) {
                ChangeListUpdater.$$$reportNull$$$0(28);
            }
            if (newName == null) {
                ChangeListUpdater.$$$reportNull$$$0(29);
            }
            this.myWorker.editName(oldName, newName);
        }

        @Override
        public void setListsToDisappear(@NotNull Collection<String> names) {
            if (names == null) {
                ChangeListUpdater.$$$reportNull$$$0(30);
            }
            this.myListsToDisappear.addAll(names);
        }

        @Override
        public FileStatus getStatus(@NotNull VirtualFile file) {
            if (file == null) {
                ChangeListUpdater.$$$reportNull$$$0(31);
            }
            return this.myWorker.getStatus(file);
        }

        @Override
        public FileStatus getStatus(@NotNull FilePath filePath) {
            if (filePath == null) {
                ChangeListUpdater.$$$reportNull$$$0(32);
            }
            return this.myWorker.getStatus(filePath);
        }

        @Override
        public void setDefaultChangeList(@NotNull String list) {
            if (list == null) {
                ChangeListUpdater.$$$reportNull$$$0(33);
            }
            this.myWorker.setDefaultList(list);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4, 15, 21, 23, 25, 26 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "worker";
                    break;
                }
                case 1: 
                case 4: 
                case 15: 
                case 21: 
                case 23: 
                case 25: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListWorker$ChangeListUpdater";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listId";
                    break;
                }
                case 3: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dispatcher";
                    break;
                }
                case 8: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "removedChanges";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "addedChanges";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesBeforeUpdate";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newChange";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change1";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change2";
                    break;
                }
                case 16: 
                case 22: 
                case 24: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldName";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListWorker$ChangeListUpdater";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "removeChangesUnderScope";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUpdatedWorker";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListsCopy";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addChangeList";
                    break;
                }
                case 25: 
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findOrCreateList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: 
                case 15: 
                case 21: 
                case 23: 
                case 25: 
                case 26: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "putPathBeforeUpdate";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "guessChangeListByPaths";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isIgnoredChange";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isIgnoredRevision";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyDoneProcessingChanges";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "doneProcessingChanges";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findOldChange";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "sameBeforeRevision";
                    break;
                }
                case 16: 
                case 17: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "addChangeToList";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "addChangeToCorrespondingList";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "guessListForChange";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "addChangeList";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "findOrCreateList";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "editComment";
                    break;
                }
                case 28: 
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "editName";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "setListsToDisappear";
                    break;
                }
                case 31: 
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatus";
                    break;
                }
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaultChangeList";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 4, 15, 21, 23, 25, 26 -> new IllegalStateException(string2);
            };
        }
    }
}

