/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffWithLocalAction
extends AnAction
implements DumbAware,
AnActionExtensionProvider {
    private final boolean myUseBeforeVersion;

    public ShowDiffWithLocalAction() {
        this(false);
        this.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
    }

    public ShowDiffWithLocalAction(boolean useBeforeVersion) {
        this.myUseBeforeVersion = useBeforeVersion;
        ActionUtil.copyFrom((AnAction)this, (String)(useBeforeVersion ? "Vcs.ShowDiffWithLocal.Before" : "Vcs.ShowDiffWithLocal"));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(1);
        }
        return e.getData(VcsDataKeys.CHANGES_SELECTION) != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(2);
        }
        if (ChangeListManager.getInstance(project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT)).isFreezedWithNotification(null)) {
            return;
        }
        ListSelection selection = (ListSelection)e.getRequiredData(VcsDataKeys.CHANGES_SELECTION);
        WithLocalRequestChain chain = new WithLocalRequestChain(project2, (ListSelection<Change>)selection, this.myUseBeforeVersion);
        DiffManager.getInstance().showDiff(project2, (DiffRequestChain)chain, DiffDialogHints.DEFAULT);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(3);
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        ListSelection selection = (ListSelection)e.getData(VcsDataKeys.CHANGES_SELECTION);
        boolean isInAir = CommittedChangesBrowserUseCase.IN_AIR.equals(e.getData(CommittedChangesBrowserUseCase.DATA_KEY));
        e.getPresentation().setEnabled(project2 != null && selection != null && !isInAir && this.canShowDiff(selection.getList()));
    }

    private boolean canShowDiff(@NotNull List<? extends Change> changes) {
        if (changes == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(4);
        }
        return ContainerUtil.exists(changes, c -> ShowDiffWithLocalAction.getChangeWithLocal(c, this.myUseBeforeVersion) != null);
    }

    @Nullable
    public static Change getChangeWithLocal(@NotNull Change c, boolean useBeforeVersion) {
        ContentRevision localRevision;
        if (c == null) {
            ShowDiffWithLocalAction.$$$reportNull$$$0(5);
        }
        ContentRevision revision = useBeforeVersion ? c.getBeforeRevision() : c.getAfterRevision();
        ContentRevision otherRevision = useBeforeVersion ? c.getAfterRevision() : c.getBeforeRevision();
        VirtualFile file = ShowDiffWithLocalAction.getLocalVirtualFileFor(revision);
        if (file == null) {
            file = ShowDiffWithLocalAction.getLocalVirtualFileFor(otherRevision);
        }
        ContentRevision contentRevision = localRevision = file != null ? CurrentContentRevision.create(VcsUtil.getFilePath(file)) : null;
        if (revision == null && localRevision == null) {
            return null;
        }
        return new Change(revision, localRevision);
    }

    @Nullable
    private static VirtualFile getLocalVirtualFileFor(@Nullable ContentRevision revision) {
        if (revision == null) {
            return null;
        }
        FilePath filePath = revision.getFile();
        if (filePath.isNonLocal() || filePath.isDirectory()) {
            return null;
        }
        return filePath.getVirtualFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/ShowDiffWithLocalAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/ShowDiffWithLocalAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canShowDiff";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChangeWithLocal";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string2);
        };
    }

    private static class WithLocalRequestChain
    extends ChangeDiffRequestChain.Async {
        private final Project myProject;
        private final ListSelection<Change> myChanges;
        private final boolean myUseBeforeVersion;

        private WithLocalRequestChain(@NotNull Project project2, @NotNull ListSelection<Change> changes, boolean useBeforeVersion) {
            if (project2 == null) {
                WithLocalRequestChain.$$$reportNull$$$0(0);
            }
            if (changes == null) {
                WithLocalRequestChain.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myChanges = changes;
            this.myUseBeforeVersion = useBeforeVersion;
        }

        @Override
        @NotNull
        protected ListSelection<? extends ChangeDiffRequestChain.Producer> loadRequestProducers() {
            ListSelection listSelection = this.myChanges.map(change -> ShowDiffWithLocalAction.getChangeWithLocal(change, this.myUseBeforeVersion)).map(change -> ChangeDiffRequestProducer.create(this.myProject, change));
            if (listSelection == null) {
                WithLocalRequestChain.$$$reportNull$$$0(2);
            }
            return listSelection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/ShowDiffWithLocalAction$WithLocalRequestChain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/ShowDiffWithLocalAction$WithLocalRequestChain";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadRequestProducers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    public static class ShowDiffBeforeWithLocalAction
    extends ShowDiffWithLocalAction {
        public ShowDiffBeforeWithLocalAction() {
            super(true);
        }
    }
}

