/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.SimpleTreeDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import java.beans.PropertyChangeEvent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0014J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/SimpleTreeDiffRequestProcessor;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "place", "", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Lcom/intellij/openapi/Disposable;)V", "iterateAllChanges", "", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "iterateSelectedChanges", "selectChange", "", "change", "updatePreviewLater", "modelUpdateInProgress", "", "wrap", "treeModelData", "Lcom/intellij/openapi/vcs/changes/ui/VcsTreeModelData;", "intellij.platform.vcs.impl"})
public final class SimpleTreeDiffRequestProcessor
extends ChangeViewDiffRequestProcessor {
    @NotNull
    private final ChangesTree tree;

    public SimpleTreeDiffRequestProcessor(@NotNull Project project2, @NotNull String place, @NotNull ChangesTree tree2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)((Object)tree2), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(project2, place);
        this.tree = tree2;
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)this));
        this.tree.addSelectionListener(() -> SimpleTreeDiffRequestProcessor._init_$lambda$0(this), (Disposable)this);
        this.tree.addPropertyChangeListener("model", arg_0 -> SimpleTreeDiffRequestProcessor._init_$lambda$1(this, arg_0));
        this.updatePreviewLater(false);
    }

    private final void updatePreviewLater(boolean modelUpdateInProgress) {
        SwingUtilities.invokeLater(() -> SimpleTreeDiffRequestProcessor.updatePreviewLater$lambda$2(this, modelUpdateInProgress));
    }

    @NotNull
    public Iterable<ChangeViewDiffRequestProcessor.Wrapper> iterateSelectedChanges() {
        VcsTreeModelData vcsTreeModelData = VcsTreeModelData.selected((JTree)((Object)this.tree));
        Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData, (String)"selected(tree)");
        return this.wrap(vcsTreeModelData);
    }

    @NotNull
    public Iterable<ChangeViewDiffRequestProcessor.Wrapper> iterateAllChanges() {
        VcsTreeModelData vcsTreeModelData = VcsTreeModelData.all((JTree)((Object)this.tree));
        Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData, (String)"all(tree)");
        return this.wrap(vcsTreeModelData);
    }

    @Override
    protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)this.tree.getRoot(), (Object)change.getUserObject());
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode node = defaultMutableTreeNode;
        TreeUtil.selectPath((JTree)((JTree)((Object)this.tree)), (TreePath)TreeUtil.getPathFromRoot((TreeNode)node), (boolean)false);
    }

    private final Iterable<ChangeViewDiffRequestProcessor.Wrapper> wrap(VcsTreeModelData treeModelData) {
        JBIterable jBIterable = treeModelData.iterateUserObjects(Change.class).map(arg_0 -> SimpleTreeDiffRequestProcessor.wrap$lambda$3(wrap.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"treeModelData.iterateUse\u2026map { ChangeWrapper(it) }");
        return (Iterable)jBIterable;
    }

    private static final void _init_$lambda$0(SimpleTreeDiffRequestProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updatePreviewLater(false);
    }

    private static final void _init_$lambda$1(SimpleTreeDiffRequestProcessor this$0, PropertyChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updatePreviewLater(false);
    }

    private static final void updatePreviewLater$lambda$2(SimpleTreeDiffRequestProcessor this$0, boolean $modelUpdateInProgress) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!this$0.isDisposed()) {
            this$0.updatePreview(this$0.getComponent().isShowing(), $modelUpdateInProgress);
        }
    }

    private static final ChangeViewDiffRequestProcessor.ChangeWrapper wrap$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChangeViewDiffRequestProcessor.ChangeWrapper)$tmp0.invoke(p0);
    }
}

