/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VirtualFileFilter;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Processor;
import com.intellij.util.StringLenComparator;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootIterator {
    private final Map<String, MyRootFilter> myOtherVcsFolders;
    private final FileIndexFacade myExcludedFileIndex;
    private final ProjectLevelVcsManager myVcsManager;
    private final Project myProject;

    public VcsRootIterator(Project project2, AbstractVcs vcs) {
        VirtualFile[] roots;
        this.myProject = project2;
        this.myVcsManager = ProjectLevelVcsManager.getInstance(project2);
        this.myOtherVcsFolders = new HashMap<String, MyRootFilter>();
        this.myExcludedFileIndex = (FileIndexFacade)project2.getService(FileIndexFacade.class);
        VcsRoot[] allRoots = this.myVcsManager.getAllVcsRoots();
        for (VirtualFile root : roots = this.myVcsManager.getRootsUnderVcs(vcs)) {
            MyRootFilter rootPresentFilter = new MyRootFilter(root, vcs.getName());
            rootPresentFilter.init(allRoots);
            this.myOtherVcsFolders.put(root.getUrl(), rootPresentFilter);
        }
    }

    public boolean acceptFolderUnderVcs(VirtualFile vcsRoot, VirtualFile file) {
        String vcsUrl = vcsRoot.getUrl();
        MyRootFilter rootFilter = this.myOtherVcsFolders.get(vcsUrl);
        if (rootFilter != null && !rootFilter.accept(file)) {
            return false;
        }
        return !VcsRootIterator.isIgnoredByVcs(this.myVcsManager, this.myProject, file);
    }

    private static boolean isIgnoredByVcs(ProjectLevelVcsManager vcsManager2, Project project2, VirtualFile file) {
        return (Boolean)ReadAction.compute(() -> project2.isDisposed() || vcsManager2.isIgnored(file));
    }

    public static void iterateVfUnderVcsRoot(Project project2, VirtualFile root, Processor<? super VirtualFile> processor2) {
        MyRootIterator rootIterator = new MyRootIterator(project2, root, null, processor2, null);
        rootIterator.iterate();
    }

    public static void iterateVcsRoot(Project project2, VirtualFile root, Processor<? super FilePath> processor2) {
        VcsRootIterator.iterateVcsRoot(project2, root, processor2, null);
    }

    public static void iterateVcsRoot(Project project2, VirtualFile root, Processor<? super FilePath> processor2, @Nullable VirtualFileFilter directoryFilter) {
        MyRootIterator rootIterator = new MyRootIterator(project2, root, processor2, null, directoryFilter);
        rootIterator.iterate();
    }

    private static final class MyRootFilter {
        private final VirtualFile myRoot;
        private final String myVcsName;
        private final List<String> myExcludedByOthers;

        private MyRootFilter(VirtualFile root, String vcsName) {
            this.myRoot = root;
            this.myVcsName = vcsName;
            this.myExcludedByOthers = new ArrayList<String>();
        }

        private void init(VcsRoot[] allRoots) {
            String ourPath = this.myRoot.getUrl();
            for (VcsRoot root : allRoots) {
                String url;
                AbstractVcs vcs = root.getVcs();
                if (vcs == null || Objects.equals(vcs.getName(), this.myVcsName) || !(url = root.getPath().getUrl()).startsWith(ourPath)) continue;
                this.myExcludedByOthers.add(url);
            }
            this.myExcludedByOthers.sort((Comparator<String>)StringLenComparator.getDescendingInstance());
        }

        public boolean accept(VirtualFile vf) {
            String url = vf.getUrl();
            for (String excludedByOtherVcs : this.myExcludedByOthers) {
                if (url.length() > excludedByOtherVcs.length()) {
                    return true;
                }
                if (!url.startsWith(excludedByOtherVcs)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class MyRootIterator {
        private final Project myProject;
        private final Processor<? super FilePath> myPathProcessor;
        private final Processor<? super VirtualFile> myFileProcessor;
        @Nullable
        private final VirtualFileFilter myDirectoryFilter;
        private final VirtualFile myRoot;
        private final MyRootFilter myRootPresentFilter;
        private final ProjectLevelVcsManager myVcsManager;

        private MyRootIterator(Project project2, VirtualFile root, @Nullable Processor<? super FilePath> pathProcessor, @Nullable Processor<? super VirtualFile> fileProcessor, @Nullable VirtualFileFilter directoryFilter) {
            this.myProject = project2;
            this.myPathProcessor = pathProcessor;
            this.myFileProcessor = fileProcessor;
            this.myDirectoryFilter = directoryFilter;
            this.myRoot = root;
            this.myVcsManager = ProjectLevelVcsManager.getInstance(project2);
            AbstractVcs vcs = this.myVcsManager.getVcsFor(root);
            MyRootFilter myRootFilter = this.myRootPresentFilter = vcs == null ? null : new MyRootFilter(root, vcs.getName());
            if (this.myRootPresentFilter != null) {
                this.myRootPresentFilter.init(this.myVcsManager.getAllVcsRoots());
            }
        }

        public void iterate() {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

                public void afterChildrenVisited(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (myDirectoryFilter != null) {
                        myDirectoryFilter.afterChildrenVisited(file);
                    }
                }

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (VcsRootIterator.isIgnoredByVcs(myVcsManager, myProject, file)) {
                        VirtualFileVisitor.Result result2 = SKIP_CHILDREN;
                        if (result2 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return result2;
                    }
                    if (myRootPresentFilter != null && !myRootPresentFilter.accept(file)) {
                        VirtualFileVisitor.Result result3 = SKIP_CHILDREN;
                        if (result3 == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return result3;
                    }
                    if (myProject.isDisposed() || !this.process(file)) {
                        VirtualFileVisitor.Result result4 = 1.skipTo((VirtualFile)myRoot);
                        if (result4 == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return result4;
                    }
                    if (myDirectoryFilter != null && file.isDirectory() && !myDirectoryFilter.shouldGoIntoDirectory(file)) {
                        VirtualFileVisitor.Result result5 = SKIP_CHILDREN;
                        if (result5 == null) {
                            1.$$$reportNull$$$0(5);
                        }
                        return result5;
                    }
                    VirtualFileVisitor.Result result6 = CONTINUE;
                    if (result6 == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    return result6;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2, 3, 4, 5, 6 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/vcs/impl/VcsRootIterator$MyRootIterator$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/vcs/impl/VcsRootIterator$MyRootIterator$1";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visitFileEx";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "afterChildrenVisited";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "visitFileEx";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            break;
                        }
                    }
                    String string2 = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string2);
                        case 2, 3, 4, 5, 6 -> new IllegalStateException(string2);
                    };
                }
            });
        }

        private boolean process(VirtualFile current) {
            if (this.myPathProcessor != null) {
                return this.myPathProcessor.process((Object)VcsUtil.getFilePath(current));
            }
            if (this.myFileProcessor != null) {
                return this.myFileProcessor.process((Object)current);
            }
            return false;
        }
    }
}

